package org.quidity.demo.mapi.offline;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

import java.net.URLEncoder;

/**
 * Created by ferdiedanzfuss on 2016/02/02.
 */
public class OfflineService {

    public interface PrepareListener {
        public void prepareCompleted(PrepareResponse response);
        public void prepareFailed(String reason);
    }

    public interface TotalTilesListener {
        public void totalTilesCompleted(TotalTilesResponse response);
        public void totalTilesFailed(String reason);
    }


    public interface StatusListener {
        public void statusCompleted(StatusResponse response);
        public void statusFailed(String reason);
    }

    public interface DownloadListener {
        public void downloadCompleted(DownloadResponse response);
        public void downloadFailed(String reason);
        public void downloadProgress(double progress);
    }

    public void prepare(PrepareRequest request, PrepareListener listener) {

        PrepareTask task = new PrepareTask(request, listener);
        task.execute();

    }

    public void totalTiles(TotalTilesRequest request, TotalTilesListener listener) {

        TotalTilesTask task = new TotalTilesTask(request, listener);
        task.execute();

    }


    public void status(StatusRequest request, StatusListener listener) {

        StatusTask task = new StatusTask(request, listener);
        task.execute();

    }

    public void download(DownloadRequest request, String savePath, DownloadListener listener) {

        DownloadTask task = new DownloadTask(request, listener, savePath);
        task.execute();

    }


    private class PrepareTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private PrepareListener listener;
        private PrepareRequest request;

        public PrepareTask(PrepareRequest request, PrepareListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(OfflineService.class.getCanonicalName(), sReq);

                //String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/contains/point?json=" + URLEncoder.encode(sReq, "UTF-8");
                String urlStr = Settings.MAPI_OFFLINE_URL + "/prepare?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(OfflineService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(OfflineService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(OfflineService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                PrepareResponse response = gson.fromJson(sRes, PrepareResponse.class);

                listener.prepareCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.prepareFailed(reason);
            }

        }
    }



    private class TotalTilesTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private TotalTilesListener listener;
        private TotalTilesRequest request;

        public TotalTilesTask(TotalTilesRequest request, TotalTilesListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(OfflineService.class.getCanonicalName(), sReq);

                //String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/contains/point?json=" + URLEncoder.encode(sReq, "UTF-8");
                String urlStr = Settings.MAPI_OFFLINE_URL + "/totaltiles?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(OfflineService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(OfflineService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(OfflineService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                TotalTilesResponse response = gson.fromJson(sRes, TotalTilesResponse.class);

                listener.totalTilesCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.totalTilesFailed(reason);
            }

        }
    }


    private class StatusTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private StatusListener listener;
        private StatusRequest request;

        public StatusTask(StatusRequest request, StatusListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(OfflineService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_OFFLINE_URL + "/status?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(OfflineService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(OfflineService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(OfflineService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                StatusResponse response = gson.fromJson(sRes, StatusResponse.class);

                listener.statusCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.statusFailed(reason);
            }

        }
    }



    private class DownloadTask extends AsyncTask<Void, Void, HttpUtilResponse> implements HttpUtil.DownloadProgressListener {

        private DownloadListener listener;
        private DownloadRequest request;
        private String savePath;

        public DownloadTask(DownloadRequest request, DownloadListener listener, String savePath) {
            this.listener = listener;
            this.request = request;
            this.savePath = savePath;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(OfflineService.class.getCanonicalName(), sReq);

                //String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/contains/point?json=" + URLEncoder.encode(sReq, "UTF-8");
                String urlStr = Settings.MAPI_OFFLINE_URL + "/download?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(OfflineService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpDownload(urlStr, savePath, DownloadTask.this);
            }
            catch(Exception e) {
                Log.e(OfflineService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                //String sRes = hres.content;
                //Log.d(AttributesService.class.getCanonicalName(), sRes);

                //Gson gson = new Gson();
                //AttachmentsResponse response = gson.fromJson(sRes, AttachmentsResponse.class);
                DownloadResponse response = new DownloadResponse();

                listener.downloadCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.downloadFailed(reason);
            }

        }

        @Override
        public void downloadProgress(double percentage) {
            //pass it on to the listener
            listener.downloadProgress(percentage);
        }
    }

}
