package org.quidity.demo.mapi;

/**
 * Created by ferdiedanzfuss on 2014/09/03.
 */
public class StatusCode {

    //200: Success (upon a successful GET, PUT, or DELETE request)
    public static final int SUCCESS = 200;

    //201: Created (upon a successful POST request)
    public static final int CREATED = 201;

    //202: Already Logged In/Out (when trying to login/logout when already logged-in/logged-out)
    public static final int ALREADY_LOGGED_IN = 202;

    //400: Resource Invalid (improperly-formatted request)
    public static final int RESOURCE_INVALID = 400;

    //401: Unauthorized (incorrect or missing authentication credentials)
    public static final int UNAUTHORIZED = 401;

    //404: Resource Not Found (requesting a non-existent user, spot, or other resource)
    public static final int RESOURCE_NOT_FOUND = 404;

    //405: Method Not Allowed (e.g., trying to POST to a URL that responds only to GET)
    public static final int METHOD_NOT_ALLOWED = 405;

    //406: Not Acceptable (server can’t satisfy the Accept header specified by the client)
    public static final int NOT_ACCEPTABLE = 406;

    //500: Application Error
    public static final int APPLICATION_ERROR = 500;

    //999: Client-side Error, thrown by app, not from server
    public static final int CLIENT_ERROR = 999;

}
