package org.quidity.demo.helper;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.OfflineMapEntry;
import org.quidity.demo.db.OfflineMapsDAO;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;
//import org.quidity.demo.mapi.auth.Workspace;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.ParametersApi;
import io.swagger.client.model.EditTemplate;
import io.swagger.client.model.EditTemplateField;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFields;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFieldsResult;
import io.swagger.client.model.OKResponseParamsLayerEditTemplates;
import io.swagger.client.model.OKResponseParamsLayerEditTemplatesResult;
import io.swagger.client.model.OKResponseParamsWorkspaceLayers;
import io.swagger.client.model.OKResponseParamsWorkspaceLayersResult;
import io.swagger.client.model.Workspace;

/**
 * Created by ferdiedanzfuss on 2014/09/03.
 */
//public class WorkspaceHelper implements
//        ParameterService.LayersListener,
//        ParameterService.EditTemplatesListener,
//        ParameterService.EditTemplateFieldsListener {
public class WorkspaceHelper {

    private static final String TAG = WorkspaceHelper.class.getCanonicalName();

    public interface WorkspaceListener {
        public void onSwitchToWorkspaceCompleted(Workspace newWorkspace);
        public void onSwitchToWorkspaceFailed(String reason);
    }


    private WorkspaceListener listener;
    private Workspace newWorkspace;

    public void switchToWorkspace(Workspace newWorkspace, WorkspaceListener listener) {
        this.listener = listener;
        this.newWorkspace = newWorkspace;

        //clear any selections
        Session.getSession().setSelectedFeatures(null);
        Session.getSession().setSelectedFeatureIndex(-1);

//        ParameterService parameterService = new ParameterService();
//        parameterService.layers(newWorkspace.getWorkspaceId(), new LayersRequest(), this);
        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            long workspaceId = newWorkspace.getWorkspaceId();
            api.workspaceLayersAsync(workspaceId, new ApiCallback<OKResponseParamsWorkspaceLayers>() {
                @Override
                public void onFailure(final ApiException e, final int statusCode, final Map<String, List<String>> responseHeaders) {
                    new Handler(Looper.getMainLooper()).post(new Runnable() {
                        @Override
                        public void run() {
                            layersFailed(e.getMessage());
                        }
                    });

                }

                @Override
                public void onSuccess(final OKResponseParamsWorkspaceLayers result, final int statusCode, final Map<String, List<String>> responseHeaders) {
                    new Handler(Looper.getMainLooper()).post(new Runnable() {
                        @Override
                        public void run() {
                            layersCompleted(result.getResult());
                        }
                    });
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            //TODO need ref to Context to show error message
        }
    }

    public void switchToOfflineWorkspace(Context context, String mapGuid) {

        OfflineMapEntry entry = OfflineMapsDAO.getEntry(context, mapGuid);
        Gson gson = new Gson();
        Session session = Session.getSession();

        Layer[] layersArr = gson.fromJson(entry.getSessionLayers(), Layer[].class);
        List<Layer> layers = Arrays.asList(layersArr);
        session.setLayers(layers);

        Workspace currentWorkspace = gson.fromJson(entry.getSessionCurrentWorkspace(), Workspace.class);
        session.setCurrentWorkspace(currentWorkspace);

        Layer currentBaseLayers = gson.fromJson(entry.getSessionCurrentBaseLayer(), Layer.class);
        session.setCurrentBaseLayer(currentBaseLayers);

        Layer currentActiveLayer = gson.fromJson(entry.getSessionCurrentActiveLayer(), Layer.class);
        session.setCurrentActiveLayer(currentActiveLayer);

        EditTemplate currentEditTemplate = gson.fromJson(entry.getSessionCurrentEditTemplate(), EditTemplate.class);
        session.setCurrentEditTemplate(currentEditTemplate);

        EditTemplateField[] EditTemplateFieldsArr = gson.fromJson(entry.getSessionCurrentEditTemplateFields(), EditTemplateField[].class);
        if (EditTemplateFieldsArr != null) {
            List<EditTemplateField> currentEditTemplateFields = Arrays.asList(EditTemplateFieldsArr);
            session.setCurrentEditTemplateFields(currentEditTemplateFields);
        }


    }


    public void layersCompleted(OKResponseParamsWorkspaceLayersResult response) {

        List<Layer> layers = response.getLayers();

        Collections.sort(layers, new Comparator<Layer>() {
            @Override
            public int compare(Layer layer1, Layer layer2) {
                Integer int2 = layer1.getLayerOrder();
                Integer int1 = layer2.getLayerOrder();
                return int1.compareTo(int2);
            }
        });

//        //remove Google layers if disabled
//        if (Settings.DISABLE_GOOGLE_LAYERS) {
//            List<Layer> layersToBeRemoved = new ArrayList<Layer>();
//            for (Layer layer : layers) {
//                if (layer.getLayerType().toLowerCase().startsWith("google")) {
//                    layersToBeRemoved.add(layer);
//                }
//            }
//            for (Layer layerToBeRemoved : layersToBeRemoved) {
//                layers.remove(layerToBeRemoved);
//            }
//        }

        //Add the None base layer
        Layer noneLayer = new Layer();
        noneLayer.setLayerCaption("None");
        noneLayer.setLayerId(-1L);
        noneLayer.setIsBaseLayer(true);
        layers.add(0, noneLayer);

        Session.getSession().setLayers(layers);
        Session.getSession().setCurrentWorkspace(newWorkspace);

        //determine default base layer
        Session.getSession().setCurrentBaseLayer(noneLayer);    //None by default
        for (Layer layer : Session.getSession().getLayers()) {

            //skip the dummy None layer
            if (layer == noneLayer) {
                continue;
            }

            Log.d(TAG, "");
            Log.d(TAG, "LayerId: " + layer.getLayerId());
            Log.d(TAG, "LayerCaption: " + layer.getLayerCaption());
            Log.d(TAG, "IsBaseLayer: " + layer.getIsBaseLayer());
            Log.d(TAG, "LayerDefault: " + layer.getLayerDefault());

            if (layer.getIsBaseLayer()) {
                //if (layer.getLayerDefault()) {
                if (layer.getVisibility()) {
                    Session.getSession().setCurrentBaseLayer(layer);
                    break;
                }
            }
        }

        //determine default active layer
        Session.getSession().setCurrentActiveLayer(null);   //None by default
        for (Layer layer : Session.getSession().getLayers()) {
            if (!layer.getIsBaseLayer()) {
                if (layer.getLayerDefault()) {
                    Session.getSession().setCurrentActiveLayer(layer);
                    break;
                }
            }
        }

        //load default edit template for active layer
        if(Session.getSession().getCurrentActiveLayer() != null) {
            getEditTemplates();
        }
        else {
            if (listener != null) {
                listener.onSwitchToWorkspaceCompleted(newWorkspace);
            }
        }

    }


    public void layersFailed(String reason) {
        if (listener != null) {
            listener.onSwitchToWorkspaceFailed(reason);
        }
    }

    private void getEditTemplates() {
        //ParameterService service = new ParameterService();
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //EditTemplatesRequest request = new EditTemplatesRequest();
        //service.editTemplates(layerId, request, this);

        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            api.layerEditTemplatesAsync(layerId, new ApiCallback<OKResponseParamsLayerEditTemplates>() {
                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplatesFailed(e.getMessage());
                }

                @Override
                public void onSuccess(OKResponseParamsLayerEditTemplates result, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplatesCompleted(result.getResult());
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            //TODO need ref to Context to show error message
        }
    }


    public void editTemplatesCompleted(OKResponseParamsLayerEditTemplatesResult response) {
        for(EditTemplate template : response.getEditTemplates()) {
            if(template.getEditTemplateDefault()) {
                Session.getSession().setCurrentEditTemplate(template);
                break;
            }
        }

        if (listener != null) {
            listener.onSwitchToWorkspaceCompleted(newWorkspace);
        }
    }


    public void editTemplatesFailed(String reason) {
        if (listener != null) {
            listener.onSwitchToWorkspaceFailed(reason);
        }
    }

    private void getEditTemplateFields() {
        //ParameterService service = new ParameterService();
        //long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        //EditTemplateFieldsRequest request = new EditTemplateFieldsRequest();
        //service.editTemplateFields(layerEditId, request, this);
        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            long editTemplateId = Session.getSession().getCurrentEditTemplate().getEditTemplateId();
            api.layerEditTemplateFieldsAsync(editTemplateId, new ApiCallback<OKResponseParamsLayerEditTemplateFields>() {
                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplateFieldsFailed(e.getMessage());
                }

                @Override
                public void onSuccess(OKResponseParamsLayerEditTemplateFields result, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplateFieldsCompleted(result.getResult());
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            //TODO get Context ref to show error message
        }

    }


    public void editTemplateFieldsCompleted(OKResponseParamsLayerEditTemplateFieldsResult response) {
        List<EditTemplateField> fields = response.getEditTemplateFields();
        Session.getSession().setCurrentEditTemplateFields(fields);
    }


    public void editTemplateFieldsFailed(String reason) {
        if (listener != null) {
            listener.onSwitchToWorkspaceFailed(reason);
        }
    }
}
