package org.quidity.demo.helper;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.util.Log;

import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AuthorizationApi;
import io.swagger.client.model.OKResponseAuthLogout;

/**
 * Created by ferdiedanzfuss on 2014/09/14.
 */
public class LogoutHelper implements ApiCallback<OKResponseAuthLogout> {

    private static final String TAG = LogoutHelper.class.getCanonicalName();
    Activity activity;

    public LogoutHelper(Activity activity) {
        this.activity = activity;
    }

    public void initiateLogoutProcess() {
        AlertDialog confirmDialog = confirmLogoutDialog();
        confirmDialog.show();
    }

    private AlertDialog confirmLogoutDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        builder.setMessage("Are you sure you want to logout and exit 1Map Mobile?");
        builder.setTitle("Confirm Logout");

        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                performLogout();
            }
        });

        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                //do nothing
            }
        });

        return builder.create();

    }

    private void performLogout() {

        if (Settings.getSettings(activity).isAutoClearAttachmentsCacheEnabled()) {
            AppUtil.clearAttachmentsCache(activity);
        }

//        AuthorizationService authorizationService = new AuthorizationService();
//        LogoutRequest request = new LogoutRequest();
//        authorizationService.logout(request, this);

        try {
            AuthorizationApi api = new AuthorizationApi(AppUtil.getApiClient());
            api.logoutUserAsync(this);
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(activity, e.getMessage());
        }

    }


//    @Override
//    public void logoutCompleted(LogoutResponse response) {
//        activity.finish();
//
//        android.os.Process.killProcess(android.os.Process.myPid());
//    }
//
//    @Override
//    public void logoutFailed(String reason) {
//        //Does not matter if logout fails
//        activity.finish();
//    }


    @Override
    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        //Does not matter if logout fails
        activity.finish();
    }

    @Override
    public void onSuccess(OKResponseAuthLogout result, int statusCode, Map<String, List<String>> responseHeaders) {

        activity.finish();

        android.os.Process.killProcess(android.os.Process.myPid());

    }

    @Override
    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

    }

    @Override
    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

    }
}
