package org.quidity.demo.helper;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.util.Log;
import android.widget.Toast;

import org.quidity.demo.Session;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.OKResponseAttachmentsUpdate;
import io.swagger.client.model.OKResponseAttributesDelete;

/**
 * Created by ferdiedanzfuss on 14/12/03.
 */
public class AttachmentHelper implements DialogInterface.OnClickListener {

    private static final String TAG = AttachmentHelper.class.getCanonicalName();
    private Activity context;
    private AlertDialog deleteDialog;
    //private long layerId;
    //private long primaryId;
    //private long attachmentId;

    private AttachmentsCollection attachment;
    private ProgressDialog progressDialog;

    private AttachmentDownloadListener downloadListener;

    public AttachmentHelper(Activity context) {
        this.context = context;
    }

    /*
    public void promptDelete(long layerId, long primaryId, long attachmentId) {
        this.layerId = layerId;
        this.primaryId = primaryId;
        this.attachmentId = attachmentId;

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle("Delete Attachment");
        builder.setMessage("Are you sure you want to delete this attachment?");
        builder.setPositiveButton("Yes", this);
        builder.setNegativeButton("Cancel", this);
        deleteDialog = builder.create();
        deleteDialog.show();
    }
    */

    public void promptDelete(AttachmentsCollection attachment) {
        this.attachment = attachment;

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle("Delete Attachment");
        builder.setMessage("Are you sure you want to delete this attachment?");
        builder.setPositiveButton("Yes", this);
        builder.setNegativeButton("Cancel", this);
        deleteDialog = builder.create();
        deleteDialog.show();
    }


    /*
    private void delete() {
        DeleteAttachmentRequest request = new DeleteAttachmentRequest();
        request.setLayerId(layerId);
        request.setPrimaryId(primaryId);
        request.setAttachmentId(attachmentId);

        AttributesService service = new AttributesService();
        service.deleteAttachment(request, this);
    }
    */

    private void delete() {

        if (!Session.getSession().isOfflineMode()) {

            progressDialog = ProgressDialog.show(context, "Deleting Attachment", "Please wait...");

//            DeleteAttachmentRequest request = new DeleteAttachmentRequest();
//            request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//            request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
//            request.setAttachmentId(attachment.getId());
//
//            AttributesService service = new AttributesService();
//            service.deleteAttachment(request, this);
            long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
            long primaryId = AppUtil.getPrimaryIdForSelectedFeature();

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                api.attributesAttachPrimaryIdDeleteAsync(layerId, primaryId, attachment.getAttachmentId(), new ApiCallback<OKResponseAttributesDelete>() {
                    @Override
                    public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        context.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                deleteAttachmentFailed(e.getMessage());
                            }
                        });
                    }

                    @Override
                    public void onSuccess(final OKResponseAttributesDelete result, int statusCode, Map<String, List<String>> responseHeaders) {
                        context.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                deleteAttachmentCompleted(result);
                            }
                        });
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(context, e.getMessage());
            }

        }
        else {
            //long rowId = attachment.getRowId();
            //TODO rowId
            long rowId = -1;
            AttachmentsDAO.deleteEntry(context, rowId);

            Toast.makeText(context, "Attachment deleted.", Toast.LENGTH_SHORT);
            context.setResult(Activity.RESULT_OK);
            context.finish();
        }
    }



    public void deleteAttachmentCompleted(OKResponseAttributesDelete response) {

        progressDialog.dismiss();

        //String message = response.getMessage();
        String message = response.getApiResponse().getMessage();

        if (message.equalsIgnoreCase("Success")) {
            Toast.makeText(context, "Attachment deleted.", Toast.LENGTH_SHORT);
            context.setResult(Activity.RESULT_OK);
            context.finish();
        }
        else {
            GuiUtil.showWarning(context, message);
        }
    }


    public void deleteAttachmentFailed(String reason) {

        progressDialog.dismiss();

        GuiUtil.showError(context, reason);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int buttonIndex) {
        if (dialogInterface == deleteDialog) {
            if (buttonIndex == AlertDialog.BUTTON_POSITIVE) {
                delete();
            }
        }
    }

    public void downloadFile(long layerId, long primaryId, long attachmentId, AttachmentDownloadListener listener) {

        this.downloadListener = listener;

        try {
            AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
            api.attributesAttachFilePrimaryIdSearchSingleAsync(layerId, primaryId, attachmentId, new ApiCallback<File>() {
                @Override
                public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    context.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            GuiUtil.showWarning(context, e.getMessage());
                        }
                    });
                }

                @Override
                public void onSuccess(final File result, int statusCode, Map<String, List<String>> responseHeaders) {
                    context.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            downloadListener.attachmentDownloadCompleted(result);
                        }
                    });
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                    Log.d(TAG, "onDownloadProgress: " + bytesRead + " of " + contentLength);
                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showError(context, e.getMessage());
        }
    }

    public interface AttachmentDownloadListener {
        public void attachmentDownloadCompleted(File file);
    }
}
