package org.quidity.demo.fragment;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.ListFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.github.filosganga.geogson.model.Feature;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;

import org.quidity.demo.R;

import org.quidity.demo.Session;
import org.quidity.demo.util.AppUtil;

import java.util.FormatFlagsConversionMismatchException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.FeatureWithoutAttachmentsProperties;

/**
 * A fragment representing a list of Items.
 * <p />
 * <p />
 * Activities containing this fragment MUST implement the callbacks
 * interface.
 */
public class FeatureInfoFragment extends ListFragment {

    public static final String FEATURE_INDEX_ARG = "FeatureIndex";

    private int featureIndex;


    /**
     * Mandatory empty constructor for the fragment manager to instantiate the
     * fragment (e.g. upon screen orientation changes).
     */
    public FeatureInfoFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.activity_feature_info, container, false);
        return view;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (getArguments() != null) {
            featureIndex = getArguments().getInt(FEATURE_INDEX_ARG);
        }

        //setContentView(R.layout.activity_feature_info);

        //List<FeatureWithAttachments> features = Session.getSession().getSelectedFeatures();
        List<Feature> features = Session.getSession().getSelectedFeatures2();
        //FeatureWithAttachments feature = features.get(featureIndex);
        Feature feature = features.get(featureIndex);
        FeatureAdapter adapter = new FeatureAdapter(getActivity(), feature.properties());
        setListAdapter(adapter);

    }

    private class FeatureAdapter extends BaseAdapter {

        //private LinkedHashMap<String, Object> properties;
        private Map<String, JsonElement> properties;
        private Context context;

        //private FeatureAdapter(Context context, Map<String, Object> properties) {
        //private FeatureAdapter(Context context, FeatureWithoutAttachmentsProperties properties) {
        private FeatureAdapter(Context context, ImmutableMap<String, JsonElement> properties) {
            this.context = context;
            //this.properties = new LinkedHashMap<String, Object>(properties);
            this.properties = new LinkedHashMap<>(properties);
            this.properties.remove("bbox");

        }

        @Override
        public int getCount() {
            return properties.size();
        }

        @Override
        public Object getItem(int i) {
            return null;
        }

        @Override
        public long getItemId(int i) {
            return 0;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            View view = convertView;

            if (view == null) {
                LayoutInflater inflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                view = inflater.inflate(R.layout.feature_info_item, null);
            }

            String key = mapKeyAtIndex(properties, position);
            String caption = AppUtil.captionForField(key);
            Object value = properties.get(key);

            TextView nameView = (TextView)view.findViewById(R.id.name);
            TextView valueView = (TextView) view.findViewById(R.id.value);

            nameView.setText(caption);
            if(value != null) {
                valueView.setText(value.toString());
            }
            else {
                valueView.setText(null);
            }

            return view;
        }

//        private String mapKeyAtIndex(Map<String, Object> map, int index) {
//            return (String)map.keySet().toArray()[index];
//        }

        private String mapKeyAtIndex(Map<String, JsonElement> map, int index) {
            return (String)map.keySet().toArray()[index];
        }

    }



}
