package org.quidity.demo.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by ferdiedanzfuss on 2016/04/19.
 */
public class OfflineUpdatesDAO {

    public static long insertEntry(Context context, OfflineUpdateEntry entry) {

        ContentValues values = new ContentValues();

        values.put(DbSchema.OfflineUpdatesTable.UPDATE_TYPE, entry.getUpdateType());
        values.put(DbSchema.OfflineUpdatesTable.REQUEST_JSON, entry.getRequestJson());
        values.put(DbSchema.OfflineUpdatesTable.OBJECT_JSON, entry.getObjectJson());
        values.put(DbSchema.OfflineUpdatesTable.LINKED_ROW_ID, entry.getLinkedRowId());

        SQLiteDatabase db = new DbHelper(context).getWritableDatabase();
        long newRowId = db.insert(DbSchema.OfflineUpdatesTable.TABLE_NAME, null, values);
        db.close();

        return newRowId;

    }


    public static List<OfflineUpdateEntry> getAllEntries(Context context) {

        List<OfflineUpdateEntry> entries = new ArrayList<OfflineUpdateEntry>();
        try {
            String[] columns = {
                    DbSchema.OfflineUpdatesTable._ID,

                    DbSchema.OfflineUpdatesTable.UPDATE_TYPE,
                    DbSchema.OfflineUpdatesTable.REQUEST_JSON,
                    DbSchema.OfflineUpdatesTable.OBJECT_JSON,
                    DbSchema.OfflineUpdatesTable.LINKED_ROW_ID
            };
            String orderBy = DbSchema.OfflineUpdatesTable._ID;

            SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
            Cursor cursor = db.query(DbSchema.OfflineUpdatesTable.TABLE_NAME, columns, null, null, null, null, orderBy);

            while (cursor.moveToNext()) {

                OfflineUpdateEntry entry = new OfflineUpdateEntry();

                entry.setUpdateType(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.UPDATE_TYPE)));
                entry.setRequestJson(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.REQUEST_JSON)));
                entry.setObjectJson(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.OBJECT_JSON)));
                entry.setLinkedRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.LINKED_ROW_ID)));

                entry.setRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable._ID)));

                entries.add(entry);
            }
            db.close();

        }
        catch (Exception e) {
            Log.e("test", e.getLocalizedMessage(), e);
        }
        return entries;


    }

    public static OfflineUpdateEntry getEntry(Context context, long rowId) {

        OfflineUpdateEntry entry = null;

        String[] columns = {
                DbSchema.OfflineUpdatesTable._ID,

                DbSchema.OfflineUpdatesTable.UPDATE_TYPE,
                DbSchema.OfflineUpdatesTable.REQUEST_JSON,
                DbSchema.OfflineUpdatesTable.OBJECT_JSON,
                DbSchema.OfflineUpdatesTable.LINKED_ROW_ID
        };

        String selection = DbSchema.OfflineUpdatesTable._ID + " = ?";
        String[] selectionArgs = {Long.toString(rowId)};

        SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
        Cursor cursor = db.query(DbSchema.OfflineUpdatesTable.TABLE_NAME, columns, selection, selectionArgs, null, null, null);

        if(cursor.moveToNext()) {

            entry = new OfflineUpdateEntry();

            entry.setUpdateType(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.UPDATE_TYPE)));
            entry.setRequestJson(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.REQUEST_JSON)));
            entry.setObjectJson(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.OBJECT_JSON)));
            entry.setLinkedRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable.LINKED_ROW_ID)));

            entry.setRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineUpdatesTable._ID)));

        }
        db.close();

        return entry;
    }


    public static void deleteEntry(Context context, long rowId) {

        SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
        String whereClause = DbSchema.OfflineUpdatesTable._ID + " = ?";
        String[] whereArgs = {Long.toString(rowId)};
        db.delete(DbSchema.OfflineUpdatesTable.TABLE_NAME, whereClause, whereArgs);

    }

    public static boolean hasOfflineUpdates(Context context) {
        List<OfflineUpdateEntry> entries = getAllEntries(context);
        return entries.size() > 0;
    }

}
