package org.quidity.demo.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import android.util.Log;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Date;

/**
 * Created by ferdiedanzfuss on 2016/02/02.
 */
public class OfflineMapsDAO {

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static long insertEntry(Context context, OfflineMapEntry entry) {

        ContentValues values = contentValuesForEntry(entry);

        SQLiteDatabase db = new DbHelper(context).getWritableDatabase();
        long newRowId = db.insert(DbSchema.OfflineMapsTable.TABLE_NAME, null, values);
        db.close();

        return newRowId;

    }


    public static void updateEntry(Context context, OfflineMapEntry entry) {

        ContentValues values = contentValuesForEntry(entry);

        SQLiteDatabase db = new DbHelper(context).getWritableDatabase();
        String whereClause = DbSchema.OfflineMapsTable.MAP_GUID + " = ?";
        String[] whereArgs = {entry.getGuid()};
        db.update(DbSchema.OfflineMapsTable.TABLE_NAME, values, whereClause, whereArgs);

        db.close();

    }

    private static ContentValues contentValuesForEntry(OfflineMapEntry entry) {
        ContentValues values = new ContentValues();

        values.put(DbSchema.OfflineMapsTable.MAP_NAME, entry.getName());
        values.put(DbSchema.OfflineMapsTable.MAP_GUID, entry.getGuid());
        values.put(DbSchema.OfflineMapsTable.BOUNDS_LEFT, entry.getBoundsleft());
        values.put(DbSchema.OfflineMapsTable.BOUNDS_RIGHT, entry.getBoundsRight());
        values.put(DbSchema.OfflineMapsTable.BOUNDS_TOP, entry.getBoundsTop());
        values.put(DbSchema.OfflineMapsTable.BOUNDS_BOTTOM, entry.getBoundsBottom());
        values.put(DbSchema.OfflineMapsTable.MAX_ZOOM, entry.getMaxZoom());
        values.put(DbSchema.OfflineMapsTable.LAYER_IDS, entry.getLayerIds());
        values.put(DbSchema.OfflineMapsTable.BASELAYER, entry.getBaseLayer());
        values.put(DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID, entry.getActiveLayoutId());

        values.put(DbSchema.OfflineMapsTable.SESSION_LAYERS, entry.getSessionLayers());
        values.put(DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE, entry.getSessionCurrentWorkspace());
        values.put(DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER, entry.getSessionCurrentBaseLayer());
        values.put(DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER, entry.getSessionCurrentActiveLayer());
        values.put(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE, entry.getSessionCurrentEditTemplate());
        values.put(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS, entry.getSessionCurrentEditTemplateFields());

        values.put(DbSchema.OfflineMapsTable.CENTER_LATITUDE, entry.getCenterLatitude());
        values.put(DbSchema.OfflineMapsTable.CENTER_LONGITUDE, entry.getCenterLongitude());

        values.put(DbSchema.OfflineMapsTable.IS_PREPARED, entry.isPrepared());
        values.put(DbSchema.OfflineMapsTable.PREPARED_DATE, sdf.format(entry.getPrepareDate()));

        return values;
    }


    public static List<OfflineMapEntry> getAllEntries(Context context) {

        List<OfflineMapEntry> entries = new ArrayList<OfflineMapEntry>();
        try {
            String[] columns = {
                    DbSchema.OfflineMapsTable._ID,

                    DbSchema.OfflineMapsTable.MAP_NAME,
                    DbSchema.OfflineMapsTable.MAP_GUID,
                    DbSchema.OfflineMapsTable.BOUNDS_LEFT,
                    DbSchema.OfflineMapsTable.BOUNDS_RIGHT,
                    DbSchema.OfflineMapsTable.BOUNDS_TOP,
                    DbSchema.OfflineMapsTable.BOUNDS_BOTTOM,
                    DbSchema.OfflineMapsTable.MAX_ZOOM,
                    DbSchema.OfflineMapsTable.LAYER_IDS,
                    DbSchema.OfflineMapsTable.BASELAYER,
                    DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID,

                    DbSchema.OfflineMapsTable.SESSION_LAYERS,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS,

                    DbSchema.OfflineMapsTable.CENTER_LATITUDE,
                    DbSchema.OfflineMapsTable.CENTER_LONGITUDE,

                    DbSchema.OfflineMapsTable.IS_PREPARED,
                    DbSchema.OfflineMapsTable.PREPARED_DATE
            };
            String orderBy = DbSchema.OfflineMapsTable.MAP_NAME;

            SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
            Cursor cursor = db.query(DbSchema.OfflineMapsTable.TABLE_NAME, columns, null, null, null, null, orderBy);

            while (cursor.moveToNext()) {

                OfflineMapEntry entry = new OfflineMapEntry();

                entry.setName(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAP_NAME)));
                entry.setGuid(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAP_GUID)));
                entry.setBoundsleft(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_LEFT)));
                entry.setBoundsRight(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_RIGHT)));
                entry.setBoundsTop(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_TOP)));
                entry.setBoundsBottom(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_BOTTOM)));
                entry.setMaxZoom(cursor.getInt(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAX_ZOOM)));
                entry.setLayerIds(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.LAYER_IDS)));
                entry.setLayerIds(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BASELAYER)));
                entry.setActiveLayoutId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID)));

                entry.setSessionLayers(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_LAYERS)));
                entry.setSessionCurrentWorkspace(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE)));
                entry.setSessionCurrentBaseLayer(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER)));
                entry.setSessionCurrentActiveLayer(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER)));
                entry.setSessionCurrentEditTemplate(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE)));
                entry.setSessionCurrentEditTemplateFields(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS)));

                entry.setCenterLatitude(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.CENTER_LATITUDE)));
                entry.setCenterLongitude(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.CENTER_LONGITUDE)));

                int iPrepared = cursor.getInt(cursor.getColumnIndex(DbSchema.OfflineMapsTable.IS_PREPARED));
                boolean bPrepared = iPrepared == 1;
                entry.setPrepared(bPrepared);

                String prepareDateStr = cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.PREPARED_DATE));
                entry.setPrepareDate(sdf.parse(prepareDateStr));

                entry.setRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineMapsTable._ID)));

                entries.add(entry);
            }
            db.close();

        } catch (Exception e) {
            Log.e("test", e.getLocalizedMessage(), e);
        }
        return entries;


    }

    public static List<OfflineMapEntry> getPreparedEntries(Context context) {
        List<OfflineMapEntry> allEntries = getAllEntries(context);
        List<OfflineMapEntry> preparedEntries = new ArrayList<OfflineMapEntry>();
        for (OfflineMapEntry entry : allEntries) {
            if (entry.isPrepared()) {
                preparedEntries.add(entry);
            }
        }
        return preparedEntries;
    }

    public static OfflineMapEntry getEntry(Context context, long rowId) {

        OfflineMapEntry entry = null;

        try {

            String[] columns = {
                    DbSchema.OfflineMapsTable._ID,

                    DbSchema.OfflineMapsTable.MAP_NAME,
                    DbSchema.OfflineMapsTable.MAP_GUID,
                    DbSchema.OfflineMapsTable.BOUNDS_LEFT,
                    DbSchema.OfflineMapsTable.BOUNDS_RIGHT,
                    DbSchema.OfflineMapsTable.BOUNDS_TOP,
                    DbSchema.OfflineMapsTable.BOUNDS_BOTTOM,
                    DbSchema.OfflineMapsTable.MAX_ZOOM,
                    DbSchema.OfflineMapsTable.LAYER_IDS,
                    DbSchema.OfflineMapsTable.BASELAYER,
                    DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID,

                    DbSchema.OfflineMapsTable.SESSION_LAYERS,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS,

                    DbSchema.OfflineMapsTable.CENTER_LATITUDE,
                    DbSchema.OfflineMapsTable.CENTER_LONGITUDE,

                    DbSchema.OfflineMapsTable.IS_PREPARED,

                    DbSchema.OfflineMapsTable.PREPARED_DATE

            };

            String selection = DbSchema.OfflineMapsTable._ID + " = ?";
            String[] selectionArgs = {Long.toString(rowId)};

            SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
            Cursor cursor = db.query(DbSchema.OfflineMapsTable.TABLE_NAME, columns, selection, selectionArgs, null, null, null);

            if (cursor.moveToNext()) {

                entry = new OfflineMapEntry();

                entry.setName(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAP_NAME)));
                entry.setGuid(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAP_GUID)));
                entry.setBoundsleft(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_LEFT)));
                entry.setBoundsRight(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_RIGHT)));
                entry.setBoundsTop(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_TOP)));
                entry.setBoundsBottom(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_BOTTOM)));
                entry.setMaxZoom(cursor.getInt(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAX_ZOOM)));
                entry.setLayerIds(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.LAYER_IDS)));
                entry.setLayerIds(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BASELAYER)));
                entry.setActiveLayoutId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID)));

                entry.setSessionLayers(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_LAYERS)));
                entry.setSessionCurrentWorkspace(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE)));
                entry.setSessionCurrentBaseLayer(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER)));
                entry.setSessionCurrentActiveLayer(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER)));
                entry.setSessionCurrentEditTemplate(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE)));
                entry.setSessionCurrentEditTemplateFields(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS)));

                entry.setCenterLatitude(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.CENTER_LATITUDE)));
                entry.setCenterLongitude(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.CENTER_LONGITUDE)));

                int iPrepared = cursor.getInt(cursor.getColumnIndex(DbSchema.OfflineMapsTable.IS_PREPARED));
                boolean bPrepared = iPrepared == 1;
                entry.setPrepared(bPrepared);

                String prepareDateStr = cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.PREPARED_DATE));
                entry.setPrepareDate(sdf.parse(prepareDateStr));

                entry.setRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineMapsTable._ID)));

            }
            db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return entry;
    }

    public static OfflineMapEntry getEntry(Context context, String mapGuid) {

        OfflineMapEntry entry = null;

        try {

            String[] columns = {
                    DbSchema.OfflineMapsTable._ID,

                    DbSchema.OfflineMapsTable.MAP_NAME,
                    DbSchema.OfflineMapsTable.MAP_GUID,
                    DbSchema.OfflineMapsTable.BOUNDS_LEFT,
                    DbSchema.OfflineMapsTable.BOUNDS_RIGHT,
                    DbSchema.OfflineMapsTable.BOUNDS_TOP,
                    DbSchema.OfflineMapsTable.BOUNDS_BOTTOM,
                    DbSchema.OfflineMapsTable.MAX_ZOOM,
                    DbSchema.OfflineMapsTable.LAYER_IDS,
                    DbSchema.OfflineMapsTable.BASELAYER,
                    DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID,

                    DbSchema.OfflineMapsTable.SESSION_LAYERS,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE,
                    DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS,

                    DbSchema.OfflineMapsTable.CENTER_LATITUDE,
                    DbSchema.OfflineMapsTable.CENTER_LONGITUDE,

                    DbSchema.OfflineMapsTable.IS_PREPARED,

                    DbSchema.OfflineMapsTable.PREPARED_DATE

            };

            String selection = DbSchema.OfflineMapsTable.MAP_GUID + " = ?";
            String[] selectionArgs = {mapGuid};

            SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
            Cursor cursor = db.query(DbSchema.OfflineMapsTable.TABLE_NAME, columns, selection, selectionArgs, null, null, null);

            if (cursor.moveToNext()) {

                entry = new OfflineMapEntry();

                entry.setName(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAP_NAME)));
                entry.setGuid(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAP_GUID)));
                entry.setBoundsleft(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_LEFT)));
                entry.setBoundsRight(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_RIGHT)));
                entry.setBoundsTop(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_TOP)));
                entry.setBoundsBottom(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BOUNDS_BOTTOM)));
                entry.setMaxZoom(cursor.getInt(cursor.getColumnIndex(DbSchema.OfflineMapsTable.MAX_ZOOM)));
                entry.setLayerIds(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.LAYER_IDS)));
                entry.setLayerIds(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.BASELAYER)));
                entry.setActiveLayoutId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID)));

                entry.setSessionLayers(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_LAYERS)));
                entry.setSessionCurrentWorkspace(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE)));
                entry.setSessionCurrentBaseLayer(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER)));
                entry.setSessionCurrentActiveLayer(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER)));
                entry.setSessionCurrentEditTemplate(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE)));
                entry.setSessionCurrentEditTemplateFields(cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS)));

                entry.setCenterLatitude(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.CENTER_LATITUDE)));
                entry.setCenterLongitude(cursor.getDouble(cursor.getColumnIndex(DbSchema.OfflineMapsTable.CENTER_LONGITUDE)));

                int iPrepared = cursor.getInt(cursor.getColumnIndex(DbSchema.OfflineMapsTable.IS_PREPARED));
                boolean bPrepared = iPrepared == 1;
                entry.setPrepared(bPrepared);

                String prepareDateStr = cursor.getString(cursor.getColumnIndex(DbSchema.OfflineMapsTable.PREPARED_DATE));
                entry.setPrepareDate(sdf.parse(prepareDateStr));

                entry.setRowId(cursor.getLong(cursor.getColumnIndex(DbSchema.OfflineMapsTable._ID)));

            }
            db.close();

        }catch (Exception e) {
            e.printStackTrace();
        }

        return entry;
    }


    public static void deleteEntry(Context context, long rowId) {

        SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
        String whereClause = DbSchema.OfflineMapsTable._ID + " = ?";
        String[] whereArgs = {Long.toString(rowId)};
        db.delete(DbSchema.OfflineMapsTable.TABLE_NAME, whereClause, whereArgs);

    }

    public static boolean hasOfflineMaps(Context context) {
        List<OfflineMapEntry> entries = OfflineMapsDAO.getAllEntries(context);
        return entries.size() > 0;
    }

}
