package org.quidity.demo.db;

import android.provider.BaseColumns;

/**
 * Created by ferdiedanzfuss on 15/08/28.
 */
public final class DbSchema {

    private DbSchema() {}

    public static abstract class AttachmentsTable implements BaseColumns {

        public static final String TABLE_NAME = "attachments";

        public static final String LAYER_ID = "layer_id";
        public static final String PRIMARY_ID = "primary_id";

        public static final String ATTACHMENT_ID = "attachment_id";
        public static final String TYPE = "type";
        public static final String HEADER = "header";
        public static final String CAPTION = "caption";
        public static final String DESCRIPTION = "description";
        public static final String BASE64_OBJECT = "base64_object";

        public static final String CREATION_DATE = "creation_date";

        public static final String UPLOADED_BY = "uploaded_by";
        public static final String UPLOAD_DATE = "upload_date";

        public static final String CAMERA_LATITUDE = "camera_latitude";
        public static final String CAMERA_LONGITUDE = "camera_longitude";
        public static final String CAMERA_ALTITUDE = "camera_altitude";
        public static final String CAMERA_ANGLE = "camera_angle";

        public static final String FILE_PATH = "file_path";

        public static final String OFFLINE_UPDATE_ROW_ID = "offline_update_row_id";
    }

    public static abstract class OfflineMapsTable implements BaseColumns {

        public static final String TABLE_NAME = "offline_maps";

        public static final String MAP_NAME = "map_name";
        public static final String MAP_GUID = "map_guid";
        public static final String BOUNDS_LEFT = "bounds_left";
        public static final String BOUNDS_RIGHT = "bounds_right";
        public static final String BOUNDS_TOP = "bounds_top";
        public static final String BOUNDS_BOTTOM = "bounds_bottom";
        public static final String MAX_ZOOM = "max_zoom";
        public static final String LAYER_IDS = "layer_ids";
        public static final String BASELAYER = "baselayer";
        public static final String ACTIVE_LAYER_ID = "active_layer_id";

        public static final String SESSION_LAYERS = "session_layers";
        public static final String SESSION_CURRENT_WORKSPACE = "session_current_workspace";
        public static final String SESSION_CURRENT_BASE_LAYER = "session_current_base_layer";
        public static final String SESSION_CURRENT_ACTIVE_LAYER = "session_current_active_layer";
        public static final String SESSION_CURRENT_EDIT_TEMPLATE = "session_current_edit_template";
        public static final String SESSION_CURRENT_EDIT_TEMPLATE_FIELDS = "session_current_edit_template_fields";

        public static final String CENTER_LATITUDE = "center_latitude";
        public static final String CENTER_LONGITUDE = "center_longitude";

        public static final String IS_PREPARED = "is_prepared";
        public static final String PREPARED_DATE = "prepare_date";

    }

    public static abstract class OfflineUpdatesTable implements BaseColumns {

        public static final String TABLE_NAME = "offline_updates";

        public static final String UPDATE_TYPE = "update_type";
        public static final String REQUEST_JSON = "request_json";
        public static final String OBJECT_JSON = "object_json";
        public static final String LINKED_ROW_ID = "linked_row_id";

    }



}
