package org.quidity.demo.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import org.quidity.demo.db.DbSchema.AttachmentsTable;

/**
 * Created by ferdiedanzfuss on 15/08/28.
 */
public class DbHelper extends SQLiteOpenHelper
{

    public static final int DATABASE_VERSION = 9;
    public static final String DATABASE_NAME = "OneMap.db";

    private static final String SQL_CREATE_ATTACHMENTS = "" +
            "CREATE TABLE " + AttachmentsTable.TABLE_NAME + " ("
            + AttachmentsTable._ID + " INTEGER PRIMARY KEY,"
            + AttachmentsTable.LAYER_ID + " INTEGER,"
            + AttachmentsTable.PRIMARY_ID + " INTEGER,"
            + AttachmentsTable.ATTACHMENT_ID + " INTEGER,"
            + AttachmentsTable.TYPE + " TEXT,"
            + AttachmentsTable.HEADER + " TEXT,"
            + AttachmentsTable.CAPTION + " TEXT,"
            + AttachmentsTable.DESCRIPTION + " TEXT,"
            + AttachmentsTable.CREATION_DATE + " TEXT,"
            + AttachmentsTable.BASE64_OBJECT + " TEXT,"
            + AttachmentsTable.UPLOADED_BY + " TEXT,"
            + AttachmentsTable.UPLOAD_DATE + " TEXT,"
            + AttachmentsTable.CAMERA_LATITUDE + " REAL,"
            + AttachmentsTable.CAMERA_LONGITUDE + " REAL,"
            + AttachmentsTable.CAMERA_ALTITUDE + " REAL,"
            + AttachmentsTable.CAMERA_ANGLE + " REAL,"
            + AttachmentsTable.FILE_PATH + " TEXT,"
            + AttachmentsTable.OFFLINE_UPDATE_ROW_ID + " INTEGER"
            + ")";

    private static final String SQL_CREATE_OFFLINE_MAPS = "" +
            "CREATE TABLE " + DbSchema.OfflineMapsTable.TABLE_NAME + " ("
            + DbSchema.OfflineMapsTable._ID + " INTEGER PRIMARY KEY,"
            + DbSchema.OfflineMapsTable.MAP_NAME + " TEXT,"
            + DbSchema.OfflineMapsTable.MAP_GUID + " TEXT,"
            + DbSchema.OfflineMapsTable.BOUNDS_LEFT + " REAL,"
            + DbSchema.OfflineMapsTable.BOUNDS_RIGHT + " REAL,"
            + DbSchema.OfflineMapsTable.BOUNDS_TOP + " REAL,"
            + DbSchema.OfflineMapsTable.BOUNDS_BOTTOM + " REAL,"
            + DbSchema.OfflineMapsTable.MAX_ZOOM + " INTEGER,"
            + DbSchema.OfflineMapsTable.LAYER_IDS + " TEXT,"
            + DbSchema.OfflineMapsTable.BASELAYER + " INTEGER,"
            + DbSchema.OfflineMapsTable.ACTIVE_LAYER_ID + " INTEGER,"
            + DbSchema.OfflineMapsTable.SESSION_LAYERS + " TEXT,"
            + DbSchema.OfflineMapsTable.SESSION_CURRENT_WORKSPACE + " TEXT,"
            + DbSchema.OfflineMapsTable.SESSION_CURRENT_BASE_LAYER + " TEXT,"
            + DbSchema.OfflineMapsTable.SESSION_CURRENT_ACTIVE_LAYER + " TEXT,"
            + DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE + " TEXT,"
            + DbSchema.OfflineMapsTable.SESSION_CURRENT_EDIT_TEMPLATE_FIELDS + " TEXT,"
            + DbSchema.OfflineMapsTable.CENTER_LATITUDE + " REAL,"
            + DbSchema.OfflineMapsTable.CENTER_LONGITUDE + " REAL,"
            + DbSchema.OfflineMapsTable.IS_PREPARED + " INTEGER,"
            + DbSchema.OfflineMapsTable.PREPARED_DATE + " TEXT"
            + ")";

    private static final String SQL_CREATE_OFFLINE_UPDATES = "" +
            "CREATE TABLE " + DbSchema.OfflineUpdatesTable.TABLE_NAME + " ("
            + DbSchema.OfflineUpdatesTable._ID + " INTEGER PRIMARY KEY,"
            + DbSchema.OfflineUpdatesTable.UPDATE_TYPE + " TEXT,"
            + DbSchema.OfflineUpdatesTable.REQUEST_JSON + " TEXT,"
            + DbSchema.OfflineUpdatesTable.OBJECT_JSON + " TEXT,"
            + DbSchema.OfflineUpdatesTable.LINKED_ROW_ID + " INTEGER"
            + ")";


    private static final String SQL_DROP_ATTACHMENTS = ""
            + "DROP TABLE IF EXISTS " + AttachmentsTable.TABLE_NAME;

    private static final String SQL_DROP_OFFLINE_MAPS = ""
            + "DROP TABLE IF EXISTS " + DbSchema.OfflineMapsTable.TABLE_NAME;

    private static final String SQL_DROP_OFFLINE_UPDATES = ""
            + "DROP TABLE IF EXISTS " + DbSchema.OfflineUpdatesTable.TABLE_NAME;

    public DbHelper(Context context) {
        super(context, DATABASE_NAME, null, DATABASE_VERSION);
    }


    @Override
    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        sqLiteDatabase.execSQL(SQL_CREATE_ATTACHMENTS);
        sqLiteDatabase.execSQL(SQL_CREATE_OFFLINE_MAPS);
        sqLiteDatabase.execSQL(SQL_CREATE_OFFLINE_UPDATES);
    }

    @Override
    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        //Drop and re-create
        sqLiteDatabase.execSQL(SQL_DROP_ATTACHMENTS);
        sqLiteDatabase.execSQL(SQL_DROP_OFFLINE_MAPS);
        sqLiteDatabase.execSQL(SQL_DROP_OFFLINE_UPDATES);

        onCreate(sqLiteDatabase);
    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        onUpgrade(db, oldVersion, newVersion);
    }
}
