package org.quidity.demo.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quidity.demo.db.DbSchema.AttachmentsTable;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.AttachmentsCollectionCameraPosition;
import io.swagger.client.model.AttachmentsCollectionUploaded;

/**
 * Created by ferdiedanzfuss on 15/08/28.
 */
public class AttachmentsDAO {

    public static long insertEntry(Context context, AttachmentEntry entry) {

        AttachmentsCollection attachment = entry.getAttachment();
        //AddAttachmentRequest request = entry.getRequest();

        ContentValues values = new ContentValues();

        values.put(AttachmentsTable.LAYER_ID, entry.getLayerId());
        values.put(AttachmentsTable.PRIMARY_ID, entry.getPrimaryId());

        values.put(AttachmentsTable.ATTACHMENT_ID, attachment.getAttachmentId());
        values.put(AttachmentsTable.TYPE, attachment.getType().toString());
        values.put(AttachmentsTable.HEADER, attachment.getHeader().toString());
        values.put(AttachmentsTable.CAPTION, attachment.getCaption());
        values.put(AttachmentsTable.DESCRIPTION, attachment.getDescription());

        //values.put(AttachmentsTable.CREATION_DATE, attachment.getCreationDate());
        String creationDate = attachment.getUploaded().getDate().toString("yyyy-MM-dd HH:mm:ss");
        values.put(AttachmentsTable.CREATION_DATE, creationDate);

        //values.put(AttachmentsTable.BASE64_OBJECT, attachment.getBase64Object());
        //TODO where do we get the data?
        String base64Object = null;
        values.put(AttachmentsTable.BASE64_OBJECT, base64Object);


        AttachmentsCollectionUploaded uploaded = attachment.getUploaded();
        if(uploaded != null) {
            values.put(AttachmentsTable.UPLOADED_BY, uploaded.getBy());
            //values.put(AttachmentsTable.UPLOAD_DATE, uploaded.getUploadDate());
            String dateStr = uploaded.getDate().toString("yyyy-MM-dd HH:mm:ss");
            values.put(AttachmentsTable.UPLOAD_DATE, dateStr);
        }

        AttachmentsCollectionCameraPosition cameraPosition = attachment.getCameraPosition();
        if(cameraPosition != null) {
            values.put(AttachmentsTable.CAMERA_LATITUDE, cameraPosition.getLatitude());
            values.put(AttachmentsTable.CAMERA_LONGITUDE, cameraPosition.getLongitude());
            values.put(AttachmentsTable.CAMERA_ALTITUDE, cameraPosition.getAltitude());
            values.put(AttachmentsTable.CAMERA_ANGLE, cameraPosition.getAngle());
        }

        values.put(AttachmentsTable.FILE_PATH, entry.getFilePath());
        values.put(AttachmentsTable.OFFLINE_UPDATE_ROW_ID, entry.getOfflineUpdateRowId());

        SQLiteDatabase db = new DbHelper(context).getWritableDatabase();
        long newRowId = db.insert(AttachmentsTable.TABLE_NAME, null, values);

        db.close();

        entry.setRowId(newRowId);

        //TODO rowId
        //entry.getAttachment().setRowId(newRowId);

        return newRowId;

    }


    public static List<AttachmentEntry> getAllEntries(Context context) {

        List<AttachmentEntry> entries = new ArrayList<AttachmentEntry>();

        String[] columns = {
                AttachmentsTable._ID,

                AttachmentsTable.LAYER_ID,
                AttachmentsTable.PRIMARY_ID,

                AttachmentsTable.ATTACHMENT_ID,
                AttachmentsTable.TYPE,
                AttachmentsTable.HEADER,
                AttachmentsTable.CAPTION,
                AttachmentsTable.DESCRIPTION,
                AttachmentsTable.CREATION_DATE,
                AttachmentsTable.BASE64_OBJECT,

                AttachmentsTable.UPLOADED_BY,
                AttachmentsTable.UPLOAD_DATE,

                AttachmentsTable.CAMERA_LATITUDE,
                AttachmentsTable.CAMERA_LONGITUDE,
                AttachmentsTable.CAMERA_ALTITUDE,
                AttachmentsTable.CAMERA_ANGLE,

                AttachmentsTable.FILE_PATH,
                AttachmentsTable.OFFLINE_UPDATE_ROW_ID
        };
        String orderBy = AttachmentsTable._ID;

        SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
        Cursor cursor = db.query(AttachmentsTable.TABLE_NAME, columns, null, null, null, null, orderBy);

        while(cursor.moveToNext()) {
            //AddAttachmentRequest request = new AddAttachmentRequest();
            AttachmentsCollection attachment = new AttachmentsCollection();

//            request.setLayerId(cursor.getLong(cursor.getColumnIndex(AttachmentsTable.LAYER_ID)));
//            request.setPrimaryId(cursor.getLong(cursor.getColumnIndex(AttachmentsTable.PRIMARY_ID)));
            long layerId = cursor.getLong(cursor.getColumnIndex(AttachmentsTable.LAYER_ID));
            long primaryId = cursor.getLong(cursor.getColumnIndex(AttachmentsTable.PRIMARY_ID));

            attachment.setAttachmentId((long)cursor.getInt(cursor.getColumnIndex(AttachmentsTable.ATTACHMENT_ID)));

            String typeStr = cursor.getString(cursor.getColumnIndex(AttachmentsTable.TYPE));
            //AttachmentsCollection.TypeEnum typeEnum = AttachmentsCollection.TypeEnum.valueOf(typeStr);
            AttachmentsCollection.TypeEnum typeEnum = AttachmentsCollection.TypeEnum.fromValue(typeStr);
            attachment.setType(typeEnum);

            //attachment.setHeader(cursor.getString(cursor.getColumnIndex(AttachmentsTable.HEADER)));
            String headerStr = cursor.getString(cursor.getColumnIndex(AttachmentsTable.HEADER));
            //AttachmentsCollection.HeaderEnum headerEnum = AttachmentsCollection.HeaderEnum.valueOf(headerStr);
            AttachmentsCollection.HeaderEnum headerEnum = AttachmentsCollection.HeaderEnum.fromValue(headerStr);
            attachment.setHeader(headerEnum);

            attachment.setCaption(cursor.getString(cursor.getColumnIndex(AttachmentsTable.CAPTION)));
            attachment.setDescription(cursor.getString(cursor.getColumnIndex(AttachmentsTable.DESCRIPTION)));
            //attachment.setCreationDate(cursor.getString(cursor.getColumnIndex(AttachmentsTable.CREATION_DATE)));

            //TODO how do we set the object data?
            //attachment.setBase64Object(cursor.getString(cursor.getColumnIndex(AttachmentsTable.BASE64_OBJECT)));

            AttachmentsCollectionUploaded uploaded = new AttachmentsCollectionUploaded();
            uploaded.setBy(cursor.getString(cursor.getColumnIndex(AttachmentsTable.UPLOADED_BY)));
            String dateStr = cursor.getString(cursor.getColumnIndex(AttachmentsTable.UPLOAD_DATE));
            DateTime dateTime = DateTime.parse(dateStr, DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss"));
            uploaded.setDate(dateTime);
            attachment.setUploaded(uploaded);

            AttachmentsCollectionCameraPosition cameraPosition = new AttachmentsCollectionCameraPosition();
            cameraPosition.setLatitude(cursor.getDouble(cursor.getColumnIndex(AttachmentsTable.CAMERA_LATITUDE)));
            cameraPosition.setLongitude(cursor.getDouble(cursor.getColumnIndex(AttachmentsTable.CAMERA_LONGITUDE)));
            cameraPosition.setAltitude(cursor.getDouble(cursor.getColumnIndex(AttachmentsTable.CAMERA_ALTITUDE)));
            cameraPosition.setAngle(cursor.getDouble(cursor.getColumnIndex(AttachmentsTable.CAMERA_ANGLE)));
            attachment.setCameraPosition(cameraPosition);

            String filePath = cursor.getString(cursor.getColumnIndex(AttachmentsTable.FILE_PATH));
            long offlineUpdateRowId = cursor.getLong(cursor.getColumnIndex(AttachmentsTable.OFFLINE_UPDATE_ROW_ID));

            AttachmentEntry entry = new AttachmentEntry(layerId, primaryId, attachment, filePath);
            entry.setOfflineUpdateRowId(offlineUpdateRowId);

            long rowId = cursor.getLong(cursor.getColumnIndex(AttachmentsTable._ID));
            entry.setRowId(rowId);

            //TODO rowId
            //attachment.setRowId(rowId);

            entries.add(entry);
        }
        db.close();

        return entries;
    }

    public static AttachmentEntry getEntryByRowId(Context context, long rowId) {

        //TODO This is the lazy way of doing it.
        List<AttachmentEntry> entries = getAllEntries(context);
        for (AttachmentEntry entry : entries) {
            if (entry.getRowId() == rowId) {
                return entry;
            }
        }

        return null;
    }

    public static void deleteEntry(Context context, long rowId) {

        SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
        String whereClause = AttachmentsTable._ID + " = ?";
        String[] whereArgs = {Long.toString(rowId)};
        db.delete(AttachmentsTable.TABLE_NAME, whereClause, whereArgs);

    }

    public static void deleteEntryById(Context context, long Id) {

        SQLiteDatabase db = new DbHelper(context).getReadableDatabase();
        String whereClause = AttachmentsTable.ATTACHMENT_ID + " = ?";
        String[] whereArgs = {Long.toString(Id)};
        db.delete(AttachmentsTable.TABLE_NAME, whereClause, whereArgs);

    }

    public static boolean hasAttachments(Context context) {
        List<AttachmentEntry> entries = AttachmentsDAO.getAllEntries(context);
        return entries.size() > 0;
    }

}
