package org.quidity.demo.activity.adapter;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.db.OfflineMapEntry;
import org.quidity.demo.db.OfflineMapsDAO;
import org.quidity.demo.util.AppUtil;

public class OfflineMapViewActivity extends Activity {

    public static final String MAP_GUID_KEY = "MapGUID";

    private WebView webView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_offline_map_view);

        AppUtil.initActivity(this);

        webView = (WebView)findViewById(R.id.webView1);

        loadMap();
    }

    private void loadMap() {

        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);

        webView.getSettings().setAllowContentAccess(true);
        //webView.getSettings().setAllowFileAccess(true);
        //webView.getSettings().setAllowFileAccessFromFileURLs(true);
        //webView.getSettings().setAllowUniversalAccessFromFileURLs(true);

        //webView.addJavascriptInterface(Session.getSession().getJavascriptInterface(this), "Android");

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                Log.d(getClass().getCanonicalName(), "Web page finished loading.");

                mapLoaded();
            }
        });

        webView.setWebChromeClient(new WebChromeClient());

        webView.loadUrl("file:///android_asset/offline_map.html");


    }

    private void mapLoaded() {

        webView.loadUrl("javascript:initMap();");

        String mapGuid = getIntent().getStringExtra(MAP_GUID_KEY);
        String tileUrl = "content://onemap.tileprovider/sdcard/offline/" + mapGuid + "/tiles/tile_{z}_{y}_{x}.jpg";
        webView.loadUrl("javascript:addOfflineLayer('" + tileUrl + "');");

        OfflineMapEntry entry = OfflineMapsDAO.getEntry(this, mapGuid);

        webView.loadUrl("javascript:setZoomLevel(" + entry.getMaxZoom() + ");");
        webView.loadUrl("javascript:moveToPoint(" + entry.getCenterLatitude() + ", " + entry.getCenterLongitude() + ");");

    }



}
