package org.quidity.demo.activity.adapter;

import com.oissela.software.multilevelexpindlistview.MultiLevelExpIndListAdapter;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by ferdiedanzfuss on 14/12/16.
 */
public class LayerGroupData implements MultiLevelExpIndListAdapter.ExpIndData, Indentable {

    private int mIndentation;
    private boolean mIsGroup;
    private int mGroupSize;

    private String name;

    private List<MultiLevelExpIndListAdapter.ExpIndData> items;

    public LayerGroupData(String name) {
        this.name = name;
        mIsGroup = true;
        items = new ArrayList<MultiLevelExpIndListAdapter.ExpIndData>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<? extends MultiLevelExpIndListAdapter.ExpIndData> getChildren() {
        return items;
    }

    @Override
    public boolean isGroup() {
        return mIsGroup;
    }

    @Override
    public void setIsGroup(boolean value) {
        mIsGroup = value;
    }

    @Override
    public void setGroupSize(int groupSize) {
        mGroupSize = groupSize;
    }

    public int getGroupSize() {
        return mGroupSize;
    }

    public void addChild(MultiLevelExpIndListAdapter.ExpIndData child) {
        items.add(child);

        Indentable indentable = (Indentable)child;
        indentable.setIndentation(getIndentation() + 1);
    }

    @Override
    public int getIndentation() {
        return mIndentation;
    }

    @Override
    public void setIndentation(int indentation) {
        mIndentation = indentation;
    }

}
