package org.quidity.demo.activity;

import android.app.ListActivity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import org.quidity.demo.Session;

import org.quidity.demo.Settings;
import org.quidity.demo.helper.WorkspaceHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.List;

import io.swagger.client.model.Layer;
import io.swagger.client.model.Workspace;


public class WorkspacesActivity extends ListActivity implements WorkspaceHelper.WorkspaceListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_workspaces);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        //ListAdapter adapter = new ArrayAdapter<Workspace>(this, android.R.layout.simple_list_item_single_choice, Session.getSession().getWorkspaces());
        ListAdapter adapter = new WorkspaceAdapter(this, Session.getSession().getWorkspaces());
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        //show current workspace as selected
        Session session = Session.getSession();
        int currentWorkspaceIndex = session.getWorkspaces().indexOf(session.getCurrentWorkspace());
        getListView().setItemChecked(currentWorkspaceIndex, true);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        //Toast.makeText(this, "Clicked on item " + position, Toast.LENGTH_LONG).show();
        Workspace selectedWorkspace = Session.getSession().getWorkspaces().get(position);
        WorkspaceHelper helper = new WorkspaceHelper();
        helper.switchToWorkspace(selectedWorkspace, this);
    }

    @Override
    public void onSwitchToWorkspaceCompleted(Workspace newWorkspace) {
        Toast.makeText(this, "Switched to workspace: " + newWorkspace.getWorkspaceName(), Toast.LENGTH_LONG).show();
        finish();   //go back to previous activity
    }

    @Override
    public void onSwitchToWorkspaceFailed(String reason) {
        GuiUtil.showError(this, "Could not switch workspaces. " + reason);
    }

    public class WorkspaceAdapter extends ArrayAdapter<Workspace> {
        public WorkspaceAdapter(Context context, List<Workspace> workspaces) {
            super(context, android.R.layout.simple_list_item_single_choice, workspaces);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            // Get the data item for this position
            Workspace workspace = getItem(position);

            // Check if an existing view is being reused, otherwise inflate the view
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(android.R.layout.simple_list_item_single_choice, parent, false);
            }

            // Lookup view for data population
            TextView tvName = (TextView) convertView.findViewById(android.R.id.text1);

            // Populate the data into the template view using the data object
            tvName.setText(workspace.getWorkspaceName());

            // Return the completed view to render on screen
            return convertView;
        }
    }

}
