package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.VideoView;

import com.github.filosganga.geogson.model.Feature;

import org.apache.commons.io.FileUtils;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseAttachments;

public class VideoAttachmentActivity extends Activity
        implements MediaPlayer.OnPreparedListener,
        MediaPlayer.OnCompletionListener,
        AttachmentHelper.AttachmentDownloadListener
{

    private static final String TAG = VideoAttachmentActivity.class.getCanonicalName();

    //private MediaPlayer mediaPlayer;
    private VideoView videoView;
    private MediaController mediaController;

    private AttachmentsCollection attachment;
    private ProgressDialog progressDialog;
    private String filePath;
    private long layerId;
    private long primaryId;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_video_attachment);

        videoView = (VideoView)findViewById(R.id.video);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }

    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onStart() {
        super.onStart();

        loadAttachment();
    }

    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getLayerId();
        Feature feature = session.getSelectedFeatures2().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getAttachmentId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            initMediaPlayer();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

//            AttachmentsRequest request = new AttachmentsRequest();
//            request.setAttachmentId(attachment.getId());
//            request.setLayerId(layer.getLayerId());
//            request.setPrimaryId(primaryId);
//
//            AttributesService service = new AttributesService();
//            service.attachments(request, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                long attachmentId = attachment.getAttachmentId();
                long layerId = layer.getLayerId();
                api.attributesAttachPrimaryIdSearchSingleAsync(layerId, primaryId, attachmentId, new ApiCallback<OKResponseAttachments>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachments result, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                        double progress = bytesRead / contentLength;
                        attachmentsDownloadProgress(progress);
                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }
    }

    private long getPrimaryId(Feature feature, String primaryField) {
        //String primaryIdStr = (String)feature.getProperties().get(primaryField);
        String primaryIdStr = feature.properties().get(primaryField).getAsString();
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }


    public void attachmentsCompleted(OKResponseAttachments response) {
        //progressDialog.dismiss();
        //initMediaPlayer();

        AttachmentHelper helper = new AttachmentHelper(this);
        helper.downloadFile(layerId, primaryId, attachment.getAttachmentId(), this);
    }

    @Override
    public void attachmentDownloadCompleted(File file) {
        try {
            File destFile = new File(filePath);
            FileUtils.copyFile(file, destFile);
        }
        catch (IOException e) {
            Log.e(TAG, e.getMessage(), e);
        }

        progressDialog.dismiss();
        initMediaPlayer();

    }

    public void attachmentsFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }


    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }

    private void initMediaPlayer() {
        try {
            videoView.setVideoPath(filePath);
            videoView.setKeepScreenOn(true);
            videoView.setOnPreparedListener(this);
            videoView.setOnCompletionListener(this);

            mediaController = new MediaController(this);
            mediaController.setAnchorView(videoView);

            videoView.setMediaController(mediaController);
        }
        catch (Exception e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }


    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        videoView.requestFocus();
        videoView.start();
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        mediaController.show();
    }

    @Override
    protected void onStop() {
        super.onStop();


    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_video_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_delete) {
            AttachmentHelper helper = new AttachmentHelper(this);
            //helper.promptDelete(layerId, primaryId, attachment.getId());
            helper.promptDelete(this.attachment);
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

}
