package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Environment;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import com.github.filosganga.geogson.model.Feature;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseAttachments;

public class TextAttachmentActivity extends Activity implements AttachmentHelper.AttachmentDownloadListener {

    private static final String TAG = TextAttachmentActivity.class.getCanonicalName();

    private TextView textField;
    private AttachmentsCollection attachment;
    private ProgressDialog progressDialog;
    private String filePath;
    private long layerId;
    private long primaryId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_text_attachment);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        textField = (TextView)findViewById(R.id.text);

        textField.requestFocus();
        //getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);

        loadAttachment();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getLayerId();
        Feature feature = session.getSelectedFeatures2().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getAttachmentId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            showAttachment();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

//            AttachmentsRequest request = new AttachmentsRequest();
//            request.setAttachmentId(attachment.getId());
//            request.setLayerId(layer.getLayerId());
//            request.setPrimaryId(primaryId);
//
//            AttributesService service = new AttributesService();
//            service.attachments(request, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                long layerId = layer.getLayerId();
                long attachmentId = attachment.getAttachmentId();
                api.attributesAttachPrimaryIdSearchSingleAsync(layer.getLayerId(), primaryId, attachmentId, new ApiCallback<OKResponseAttachments>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachments result, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                        double progress = bytesRead / contentLength;
                        attachmentsDownloadProgress(progress);
                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }

        }
    }


    private long getPrimaryId(Feature feature, String primaryField) {

        //String primaryIdStr = (String)feature.getProperties().get(primaryField);
        String primaryIdStr = feature.properties().get(primaryField).getAsString();
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }


    public void attachmentsCompleted(OKResponseAttachments response) {
//        progressDialog.dismiss();
//        showAttachment();

        AttachmentHelper helper = new AttachmentHelper(this);
        helper.downloadFile(layerId, primaryId, attachment.getAttachmentId(), this);
    }

    @Override
    public void attachmentDownloadCompleted(File file) {

        try {
            File destFile = new File(filePath);
            FileUtils.copyFile(file, destFile);
        }
        catch (IOException e) {
            Log.e(TAG, e.getMessage(), e);
        }

        progressDialog.dismiss();
        showAttachment();

    }

    public void attachmentsFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }


    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }

    private void showAttachment() {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            String str = IOUtils.toString(fis);
            fis.close();

            textField.setText(str);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_text_attachment, menu);
        return true;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_delete) {
            AttachmentHelper helper = new AttachmentHelper(this);
            //helper.promptDelete(layerId, primaryId, attachment.getId());
            helper.promptDelete(this.attachment);
            return true;
        }
        else if(id == R.id.action_edit) {
            Session.getSession().setEditMode(Session.EDIT_MODE_UPDATE);
            Intent intent = new Intent(this, EditTextAttachmentActivity.class);
            startActivity(intent);

        }

        return super.onOptionsItemSelected(item);
    }

    /*
    private void save() {

        try {
            File file = File.createTempFile("OneMap", ".txt", Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES));
            Log.d(getClass().getCanonicalName(), file.getAbsolutePath());

            FileWriter writer = new FileWriter(file, false);
            writer.write(textField.getText().toString());
            writer.flush();
            writer.close();

            finish();
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }


    }
    */


}
