package org.quidity.demo.activity;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.Toast;

import com.google.gson.Gson;

import org.joda.time.DateTime;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentEntry;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.NewAttachmentInfo;
import io.swagger.client.model.NewAttachmentUploaded;
import io.swagger.client.model.OKResponseAttachmentsAdd;

public class SyncNowActivity extends ListActivity  {

    private static final String TAG = SyncNowActivity.class.getCanonicalName();

    private final static int UPLOAD_RESULT_SUCCESS = 10;
    private final static int UPLOAD_RESULT_FAILED = 20;

    private List<AttachmentEntry> attachmentEntries;
    private ProgressDialog progressDialog;
    private BlockingQueue<Integer> resultQueue;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_upload_now);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        refreshGUI();

        if(attachmentEntries.size() > 0) {
            checkConnectivityBeforeUpload();
        }
        else {
            showEmptyMessage();
        }
    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    private void checkConnectivityBeforeUpload() {

        if(AppUtil.currentConnectionType(this) == AppUtil.CONNECTION_TYPE_WIFI) {
            uploadAll();
        }
        else {

            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setTitle("WiFi not available");
            builder.setMessage("A WiFi network is not currently available. Do you want to continue on cellular?");
            builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss();
                    uploadAll();
                }
            });
            builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    //go back
                    setResult(RESULT_OK);
                    finish();
                }
            });
            builder.create().show();

        }

    }

    private void uploadAll() {

        if (attachmentEntries.size() > 0) {

            progressDialog = new ProgressDialog(SyncNowActivity.this);
            progressDialog.setTitle("Uploading");
            progressDialog.show();

            Thread uploadThread = new Thread(new UploadWorker());
            uploadThread.start();

        }
        else {
            showEmptyMessage();
        }
    }

    private void showEmptyMessage() {
        Toast.makeText(this, "Queue is empty - Nothing to upload", Toast.LENGTH_LONG).show();
    }

    class UploadWorker implements Runnable {

        @Override
        public void run() {
            //process 1 entry at a time.
            resultQueue = new ArrayBlockingQueue<Integer>(1);

            int successCount = 0;
            int failCount = 0;
            List<AttachmentEntry> entriesToUpload = new ArrayList<AttachmentEntry>(attachmentEntries);
            int entryCount = entriesToUpload.size();

            for(int c=0;c<entryCount;c++) {
                final AttachmentEntry entry = entriesToUpload.get(c);
                final int entryNo = c+1;

                final String message = "Uploading " + entryNo + " of " + entryCount + "...";
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        progressDialog.setMessage(message);
                    }
                });

//                AttributesService service = new AttributesService();
//                service.addAttachment(entry.getRequest(), entry.getAttachment(), entry.getFilePath(), this);

                try {


                    File attachmentFile = new File(entry.getFilePath());

                    //String attachmentInfo = "{\"type\": \"image\", \"header\": \"image/jpeg\", \"uploaded\": {\"by\": \"schalk@1map.co.za\", \"date\": \"2017-09-01 13:46\"}, \"caption\": \"Some Caption\", \"description\": \"Some Description\", \"cameraPosition\": {\"latitude\": -33, \"longitude\": 19, \"altitude\": 0, \"angle\": 0}}";
                    NewAttachmentInfo info = new NewAttachmentInfo();
                    AttachmentsCollection attachment = entry.getAttachment();
                    info.setType(attachment.getType());
                    info.setHeader(attachment.getHeader());

                    NewAttachmentUploaded uploaded = new NewAttachmentUploaded();
                    uploaded.setBy(attachment.getUploaded().getBy());
                    if (attachment.getUploaded().getDate() != null) {
                        Date date = attachment.getUploaded().getDate().toDate();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                        String dateStr = sdf.format(date);

                        uploaded.setDate(dateStr);
                    }
                    info.setUploaded(uploaded);

                    info.setCaption(attachment.getCaption());
                    info.setDescription(attachment.getDescription());
                    info.setCameraPosition(attachment.getCameraPosition());

                    Gson gson = new Gson();
                    String attachmentInfoStr = gson.toJson(info);


                    AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                    api.attributesAttachAddAsync(entry.getLayerId(), entry.getPrimaryId(), attachmentInfoStr, attachmentFile, new ApiCallback<OKResponseAttachmentsAdd>() {
                        @Override
                        public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                            addAttachmentFailed(e.getMessage());
                        }

                        @Override
                        public void onSuccess(OKResponseAttachmentsAdd result, int statusCode, Map<String, List<String>> responseHeaders) {
                            addAttachmentCompleted(result);
                        }

                        @Override
                        public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                        }

                        @Override
                        public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                        }
                    });
                }
                catch (ApiException e) {
                    Log.e(TAG, e.getMessage(), e);
                    GuiUtil.showWarning(SyncNowActivity.this, e.getMessage());
                }


                try {
                    //the queue will block until we have a result
                    int result = resultQueue.take();

                    if (result ==  UPLOAD_RESULT_SUCCESS) {
                        successCount++;
                        AppUtil.deleteFile(entry.getFilePath());
                        AttachmentsDAO.deleteEntry(SyncNowActivity.this, entry.getRowId());
                        refreshGUI();
                    }
                    else {
                        failCount++;
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                Toast.makeText(SyncNowActivity.this, "Upload failed for " + entry.getAttachment().getCaption(), Toast.LENGTH_LONG).show();
                            }
                        });

                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }

            }


            //all done
            final int finalSuccessCount = successCount;
            final int finalFailCount = failCount;
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog.dismiss();

                    //Show results dialog message
                    AlertDialog.Builder builder = new AlertDialog.Builder(SyncNowActivity.this);
                    builder.setTitle("Upload Completed");
                    String message = "Success: " + finalSuccessCount + ", Failed: " + finalFailCount;
                    builder.setMessage(message);
                    builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                            dialogInterface.dismiss();
                            setResult(RESULT_OK);
                            finish();
                        }
                    });
                    builder.create().show();
                }
            });

        }


        public void addAttachmentCompleted(OKResponseAttachmentsAdd response) {
            try {
                resultQueue.put(UPLOAD_RESULT_SUCCESS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }


        public void addAttachmentFailed(String reason) {
            try {
                resultQueue.put(UPLOAD_RESULT_FAILED);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

    }

    private void refreshGUI() {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                attachmentEntries = AttachmentsDAO.getAllEntries(SyncNowActivity.this);

                ListAdapter adapter = new ArrayAdapter<AttachmentEntry>(SyncNowActivity.this, android.R.layout.simple_list_item_1, attachmentEntries);
                getListView().setAdapter(adapter);
            }
        });

    }


/*
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_upload_now, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
    */
}
