package org.quidity.demo.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.Toast;


import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;

public class SettingsActivity extends Activity {

    private Switch batchUploadSwitch;
    private Switch autoClearAttachmentsCacheSwitch;
    private Switch autoZoomSwitch;
    private Switch keepScreenOnSwitch;
    private Switch captureImageLocationSwitch;
    private EditText desiredAccuracyField;
    private Switch logLocationSwitch;
    private EditText logLocationIntervalField;
    private EditText maxImageDimensionField;
    private EditText jpegCompressionField;
    private Switch editRadiusEnabledSwitch;
    private EditText editRadiusField;
    private Button saveButton;
    private Button clearCacheButton;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        batchUploadSwitch = (Switch)findViewById(R.id.batch_upload);
        autoClearAttachmentsCacheSwitch = (Switch)findViewById(R.id.auto_clear_attachments_cache);
        autoZoomSwitch = (Switch)findViewById(R.id.auto_zoom);
        keepScreenOnSwitch = (Switch)findViewById(R.id.keep_screen_on);
        logLocationSwitch = (Switch)findViewById(R.id.log_location);
        logLocationIntervalField = (EditText)findViewById(R.id.log_location_interval);
        captureImageLocationSwitch = (Switch)findViewById(R.id.capture_image_location);
        desiredAccuracyField = (EditText)findViewById(R.id.desired_accuracy);
        maxImageDimensionField = (EditText)findViewById(R.id.max_image_dimension);
        jpegCompressionField = (EditText)findViewById(R.id.jpeg_compression);
        editRadiusEnabledSwitch = (Switch)findViewById(R.id.edit_radius_enabled);
        editRadiusField = (EditText)findViewById(R.id.edit_radius);
        saveButton = (Button)findViewById(R.id.save);
        clearCacheButton = (Button)findViewById(R.id.clear_cache);

        Settings settings = Settings.getSettings(this);
        autoClearAttachmentsCacheSwitch.setChecked(settings.isAutoClearAttachmentsCacheEnabled());
        batchUploadSwitch.setChecked(settings.isBatchUploadEnabled());
        autoZoomSwitch.setChecked(settings.isAutoZoomEnabled());
        keepScreenOnSwitch.setChecked(settings.isKeepScreenOn());

        logLocationSwitch.setChecked(settings.isLogLocation());
        String intervalStr = Integer.toString(settings.getLogLocationInterval());
        logLocationIntervalField.setText(intervalStr);

        captureImageLocationSwitch.setChecked(settings.isCaptureImageLocation());
        String accuracyStr = Integer.toString(settings.getDesiredAccuracy());
        desiredAccuracyField.setText(accuracyStr);

        String maxImageDimensionStr = Integer.toString(settings.getMaxImageDimension());
        maxImageDimensionField.setText(maxImageDimensionStr);;

        String jpegCompressionStr = Integer.toString(settings.getJpegCompression());
        jpegCompressionField.setText(jpegCompressionStr);

        editRadiusEnabledSwitch.setChecked(settings.isEditRadiusEnabled());
        String editRadiusStr = Integer.toString(settings.getEditRadius());
        editRadiusField.setText(editRadiusStr);


        clearCacheButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                promptClearCache();
            }
        });

        saveButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                save();
            }
        });


        hideKeyboard();
    }

    private void hideKeyboard() {
        /*
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager inputManager = (InputMethodManager) this.getSystemService(Context.INPUT_METHOD_SERVICE);
            inputManager.hideSoftInputFromWindow(view.getWindowToken(), InputMethodManager.HIDE_IMPLICIT_ONLY);
        }
        */

        getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void save() {

        int logLocationInterval = -1;
        try {
            logLocationInterval = Integer.parseInt(logLocationIntervalField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid log interval.");
            logLocationIntervalField.requestFocus();
            return;
        }

        if (logLocationInterval < 5) {
            GuiUtil.showWarning(this, "Log interval should be at least 5 seconds.");
            return;
        }

        int desiredAccuracy = -1;
        try {
            desiredAccuracy = Integer.parseInt(desiredAccuracyField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid desired accuracy.");
            desiredAccuracyField.requestFocus();
            return;
        }

        if (logLocationInterval < 5) {
            GuiUtil.showWarning(this, "Log interval should be at least 5 seconds.");
            return;
        }

        int maxImageDimension = -1;
        try {
            maxImageDimension = Integer.parseInt(maxImageDimensionField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid image max. width/height resolution.");
            maxImageDimensionField.requestFocus();
            return;
        }

        int jpegCompression = -1;
        try {
            jpegCompression = Integer.parseInt(jpegCompressionField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid jpeg compression.");
            maxImageDimensionField.requestFocus();
            return;
        }

        if (jpegCompression < 0 || jpegCompression > 100) {
            GuiUtil.showWarning(this, "JPEG compression should be a number between 0 and 100.");
            jpegCompressionField.requestFocus();
            return;
        }

        int editRadius = -1;
        try {
            editRadius = Integer.parseInt(editRadiusField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid edit radius.");
            editRadiusField.requestFocus();
            return;
        }


        Settings settings = Settings.getSettings(this);
        settings.setBatchUploadEnabled(batchUploadSwitch.isChecked());
        settings.setAutoClearAttachmentsCacheEnabled(autoClearAttachmentsCacheSwitch.isChecked());
        settings.setLogLocationInterval(logLocationInterval);
        settings.setAutoZoomEnabled(autoZoomSwitch.isChecked());
        settings.setKeepScreenOn(keepScreenOnSwitch.isChecked());
        settings.setLogLocation(logLocationSwitch.isChecked());
        settings.setCaptureImageLocation(captureImageLocationSwitch.isChecked());
        settings.setDesiredAccuracy(desiredAccuracy);
        settings.setMaxImageDimension(maxImageDimension);
        settings.setJpegCompression(jpegCompression);
        settings.setEditRadiusEnabled(editRadiusEnabledSwitch.isChecked());
        settings.setEditRadius(editRadius);

        Toast.makeText(this, "Settings saved.", Toast.LENGTH_SHORT).show();
        finish();
    }

    private void promptClearCache() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Clear Cache")
                .setMessage("Are you sure you want to clear the cache?")
                .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        clearCache();
                    }
                })
                .setNegativeButton("No", null);
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void clearCache() {
        AppUtil.clearAttachmentsCache(this);
        clearWebViewCache();

        Toast.makeText(this, "Cache cleared.", Toast.LENGTH_SHORT).show();
    }


    private void clearWebViewCache() {
        Log.d(getClass().getCanonicalName(), "Clearing WebView cache.");
        WebView webView = new WebView(this);
        webView.clearCache(true);
    }

}
