package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;

import io.swagger.client.model.ErfWithNADAddressesNadAddresses;
import io.swagger.client.model.Layer;
import io.swagger.client.model.NADAddress;

public class SearchResultsActivity extends ListActivity {

    List<NADAddress> items;
    List<ErfWithNADAddressesNadAddresses> erfItems;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_search_results);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


//        //deserialize items
//        String itemsStr = getIntent().getStringExtra("items");
//        Gson gson = new Gson();
//        Type itemsType = new TypeToken<List<NADAddress>>(){}.getType();
//        items = gson.fromJson(itemsStr, itemsType);

        if (Session.getSession().isSearchTypeAddress()) {
            items = Session.getSession().getNadAddresses();

            //ListAdapter adapter = new ArrayAdapter<NADAddress>(this, android.R.layout.simple_list_item_1, items);
            NADAddressAdapter adapter = new NADAddressAdapter(this, items);
            getListView().setAdapter(adapter);
        }
        else {
            erfItems = Session.getSession().getErfWithNADAddresses().getNadAddresses();

            ErfWithNADAddressesNadAddressesAdapter adapter = new ErfWithNADAddressesNadAddressesAdapter(this, erfItems);
            getListView().setAdapter(adapter);
        }

        //getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {

        Intent intent = new Intent();

        if (Session.getSession().isSearchTypeAddress()) {
            //Address Search
            NADAddress address = items.get(position);

            intent.putExtra(OpenLayersMapActivity.EXTRA_LATITUDE, (double) address.getCentLatitude());
            intent.putExtra(OpenLayersMapActivity.EXTRA_LONGITUDE, (double) address.getCentLongitude());
        }
        else {
            //Erf Search
            ErfWithNADAddressesNadAddresses address = erfItems.get(position);

            intent.putExtra(OpenLayersMapActivity.EXTRA_LATITUDE, (double) address.getCentLatitude());
            intent.putExtra(OpenLayersMapActivity.EXTRA_LONGITUDE, (double) address.getCentLongitude());
        }

        setResult(Activity.RESULT_OK, intent);
        finish();

    }

    public class NADAddressAdapter extends ArrayAdapter<NADAddress> {

        public NADAddressAdapter(Context context, List<NADAddress> addresses) {
            super(context, android.R.layout.simple_list_item_1, addresses);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            // Get the data item for this position
            NADAddress address = getItem(position);

            // Check if an existing view is being reused, otherwise inflate the view
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(android.R.layout.simple_list_item_1, parent, false);
            }

            // Lookup view for data population
            TextView tvName = (TextView) convertView.findViewById(android.R.id.text1);

            // Populate the data into the template view using the data object
            StringBuilder sb = new StringBuilder();
            sb.append(address.getStreetNo());
            sb.append(" ");
            sb.append(address.getStreetName());
            sb.append(", ");
            sb.append(address.getSuburb());
            sb.append(", ");
            sb.append(address.getCity());
            String addressStr =  sb.toString();
            tvName.setText(addressStr);

            // Return the completed view to render on screen
            return convertView;
        }
    }


    public class ErfWithNADAddressesNadAddressesAdapter extends ArrayAdapter<ErfWithNADAddressesNadAddresses> {

        public ErfWithNADAddressesNadAddressesAdapter(Context context, List<ErfWithNADAddressesNadAddresses> addresses) {
            super(context, android.R.layout.simple_list_item_1, addresses);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            // Get the data item for this position
            ErfWithNADAddressesNadAddresses address = getItem(position);

            // Check if an existing view is being reused, otherwise inflate the view
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(android.R.layout.simple_list_item_1, parent, false);
            }

            // Lookup view for data population
            TextView tvName = (TextView) convertView.findViewById(android.R.id.text1);

            // Populate the data into the template view using the data object
            StringBuilder sb = new StringBuilder();
            sb.append(address.getStreetNo());
            sb.append(" ");
            sb.append(address.getStreetName());
            sb.append(", ");
            sb.append(address.getSuburb());
            sb.append(", ");
            sb.append(address.getCity());
            String addressStr =  sb.toString();
            tvName.setText(addressStr);

            // Return the completed view to render on screen
            return convertView;
        }
    }


}
