package org.quidity.demo.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.PopupMenu;
import android.widget.Toast;

import com.github.filosganga.geogson.gson.GeometryAdapterFactory;
import com.github.filosganga.geogson.model.Feature;
import com.github.filosganga.geogson.model.Point;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Excluder;
import com.google.gson.reflect.TypeToken;

import org.json.JSONObject;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.db.OfflineMapEntry;
import org.quidity.demo.db.OfflineMapsDAO;
import org.quidity.demo.db.OfflineUpdateEntry;
import org.quidity.demo.db.OfflineUpdatesDAO;
import org.quidity.demo.helper.LogoutHelper;
import org.quidity.demo.mapi.tracking.AddTrackRequest;
import org.quidity.demo.mapi.tracking.AddTrackResponse;
import org.quidity.demo.mapi.tracking.TrackingService;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttributesAdvancedApi;
import io.swagger.client.api.AttributesBasicApi;
import io.swagger.client.api.SpatialApi;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.FeatureWithoutPropertiesAndAttachments;
import io.swagger.client.model.Field;
import io.swagger.client.model.Geometry;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseAttachmentsUpdate;
import io.swagger.client.model.OKResponseAttributesClosest;
import io.swagger.client.model.OKResponseAttributesClosestResult;
import io.swagger.client.model.OKResponseAttributesContains;
import io.swagger.client.model.OKResponseAttributesContainsResult;
import io.swagger.client.model.OKResponseAttributesDelete;
import io.swagger.client.model.OKResponseAttributesDeleteResult;
import io.swagger.client.model.OKResponseAttributesResultFields;
import io.swagger.client.model.Polygon;

public class OpenLayersMapActivity extends Activity implements SensorEventListener,
        LocationListener,
        TrackingService.AddTrackListener,
        OneMapJavascriptInterface.SaveStateListener,
        View.OnClickListener


{

    private static final String TAG = OpenLayersMapActivity.class.getCanonicalName();

    public static final String EXTRA_ACTION = "action";
    public static final String EXTRA_LATITUDE = "latitude";
    public static final String EXTRA_LONGITUDE = "longitude";
    public static final String EXTRA_CAN_NAVIGATE = "CanNavigate";
    public static final String EXTRA_OFFLINE_MAP_GUID = "OfflineMapGUID";

    public static final int ACTION_NONE = 0;
    public static final int ACTION_MOVE_TO_POINT = 10;


    private static final int REQ_BASE_LAYER = 100;
    private static final int REQ_OTHER_LAYERS = 200;
    private static final int REQ_WORKSPACE = 300;
    private static final int REQ_ACTIVE_LAYER = 400;
    private static final int REQ_SEARCH = 500;
    private static final int REQ_FEATURE_NEW = 600;
    private static final int REQ_FEATURE_EDIT = 650;
    private static final int REQ_FEATURE_INFO = 670;
    private static final int REQ_TARGET_CLICKED = 700;
    private static final int REQ_UPLOAD_NOW = 800;
    private static final int REQ_OFFLINE_MAPS = 900;

    private static final String GOOGLE_MAPS_PACKAGE = "com.google.android.apps.maps";
    private static final String GOOGLE_MAPS_ACTIVITY = "com.google.android.maps.MapsActivity";

    private static final int FOLLOW_ME_OFF = 0;
    private static final int FOLLOW_ME_ON_ROTATE_OFF = 1;
    private static final int FOLLOW_ME_ON_ROTATE_ON = 2;


    //intent data key values when returning from offline EditFeatureActivity
    public static final String RETURN_OFFLINE_EDIT_FEATURE = "RETURN_OFFLINE_EDIT_FEATURE";
    public static final String RETURN_OFFLINE_EDIT_TYPE = "RETURN_OFFLINE_EDIT_TYPE";

    //all possible offline feature edit operations
    public static final String OFFLINE_EDIT_TYPE_NEW = "NEW";
    public static final String OFFLINE_EDIT_TYPE_UPDATE = "UPDATE";
    public static final String OFFLINE_EDIT_TYPE_MOVE = "MOVE";
    public static final String OFFLINE_EDIT_TYPE_DELETE = "DELETE";


    /*
    private static final int SELECT_MODE_OFF = 0;
    private static final int SELECT_MODE_ON = 1;
    private static final int SELECT_MODE_INFO = 2;
    */

    private int followMeMode = FOLLOW_ME_OFF;
    //private int selectMode = SELECT_MODE_OFF;

    private WebView webView;
    private ImageView targetView;
    private String token;
    private String serial;
    private JSONObject jsLayers;

    //private SensorManager sensorManager;
    //private Sensor accelerometer;
    //private Sensor magnetometer;

    private float[] mGravity = new float[3];
    private float[] mGeomagnetic = new float[3];
    private float azimuth = 0f;

    private boolean rotationActive = false;
    private long lastRotationUpdate = 0;
    private boolean followMeActive = false;

    private LocationManager locationManager;

    private int currentZoomLevel;
    private Date lastLocationLogged = new Date();

    private ProgressDialog progressDialog;

    private ImageButton zoomInButton;
    private ImageButton zoomOutButton;
    private ImageButton followMeButton;
    private ImageButton layersButton;
    private ImageButton searchButton;
    //private ImageButton selectionModeButton;
    private ImageButton infoButton;
    private ImageButton attachmentsButton;
    //private ImageButton addSpatialButton;
    //private ImageButton removeSpatialButton;
    //private ImageButton editSpatialButton;
    private ImageButton editButton;
    private ImageButton dataButton;

    //result data passed back to this activity in onActivityResult
    private Intent resultData;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_open_layers_map);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        zoomInButton = (ImageButton)findViewById(R.id.zoom_in);
        zoomOutButton = (ImageButton)findViewById(R.id.zoom_out);
        followMeButton = (ImageButton)findViewById(R.id.follow_me);
        layersButton = (ImageButton)findViewById(R.id.layers);
        searchButton = (ImageButton)findViewById(R.id.search);
        //selectionModeButton = (ImageButton)findViewById(R.id.selection_mode);
        infoButton = (ImageButton)findViewById(R.id.info);
        attachmentsButton = (ImageButton)findViewById(R.id.attachments);
        //addSpatialButton = (ImageButton)findViewById(R.id.edit_spatial_add);
        //removeSpatialButton = (ImageButton)findViewById(R.id.edit_spatial_remove);
        //editSpatialButton = (ImageButton)findViewById(R.id.edit_spatial);
        editButton = (ImageButton)findViewById(R.id.edit);
        dataButton = (ImageButton)findViewById(R.id.data);

        zoomInButton.setOnClickListener(this);
        zoomOutButton.setOnClickListener(this);
        followMeButton.setOnClickListener(this);
        layersButton.setOnClickListener(this);
        searchButton.setOnClickListener(this);
        //selectionModeButton.setOnClickListener(this);
        infoButton.setOnClickListener(this);
        attachmentsButton.setOnClickListener(this);
        //addSpatialButton.setOnClickListener(this);
        //removeSpatialButton.setOnClickListener(this);
        //editSpatialButton.setOnClickListener(this);
        editButton.setOnClickListener(this);
        dataButton.setOnClickListener(this);

        //reduce transparency of the buttons
        zoomInButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        zoomOutButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        followMeButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        layersButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        searchButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        infoButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        attachmentsButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        editButton.setBackgroundColor(Color.argb(100, 255, 255, 255));
        dataButton.setBackgroundColor(Color.argb(100, 255, 255, 255));

        //sensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        //accelerometer = sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        //magnetometer = sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD);

        targetView = (ImageView)findViewById(R.id.target);
        targetView.setVisibility(View.GONE);
        targetView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onTargetClicked();
            }
        });

        locationManager = (LocationManager)getSystemService(LOCATION_SERVICE);

        updateButtons();
        updateTitle();

        loadMap();

        checkOutstandingUploads();
    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        //outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);

    }

    private void checkOutstandingUploads() {
        if(AttachmentsDAO.hasAttachments(this) && !Session.getSession().isOfflineMode()) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setTitle("Upload Attachments");
            builder.setMessage("There are attachments that have not yet been uploaded.");
            builder.setPositiveButton("Upload Now", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    uploadNow();
                }
            });
            builder.setNegativeButton("Upload Later", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    dialogInterface.dismiss();
                }
            });
            builder.create().show();
        }
    }

    private void updateTitle() {
        StringBuilder sb = new StringBuilder();
        Session session = Session.getSession();
        //String currentWorkspaceName = session.getCurrentWorkspace().getWorkspace();
        String currentWorkspaceName = session.getCurrentWorkspace().getWorkspaceName();
        sb.append(currentWorkspaceName);
        if(session.getCurrentActiveLayer() != null) {
            sb.append(" - " + session.getCurrentActiveLayer().getLayerCaption());
        }
        setTitle(sb.toString());
    }

    private boolean isFeatureSelected() {
//        return Session.getSession().getSelectedFeatures() != null
//                && Session.getSession().getSelectedFeatures().size() > 0
//                && Session.getSession().getSelectedFeatureIndex() >= 0;

        return Session.getSession().getSelectedFeatures2() != null
                && Session.getSession().getSelectedFeatures2().size() > 0
                && Session.getSession().getSelectedFeatureIndex() >= 0;

    }

    private void loadMap() {
        updateTitle();

        webView = (WebView)findViewById(R.id.webView1);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportMultipleWindows(true);
        webView.getSettings().setDomStorageEnabled(true);

        webView.getSettings().setAllowFileAccess(true);
        webView.getSettings().setAllowUniversalAccessFromFileURLs(true);
        webView.getSettings().setAllowFileAccessFromFileURLs(true);
        webView.getSettings().setAllowContentAccess(true);

        if (Session.getSession().isOfflineMode()) {
            //disable browser caching when in offline mode
            webView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
            webView.getSettings().setAppCacheEnabled(false);
            webView.clearCache(true);
        }

        webView.addJavascriptInterface(Session.getSession().getJavascriptInterface(this), "Android");

        webView.setWebViewClient(new WebViewClient() {
            @Override
            public void onLoadResource(WebView view, String url) {
//                // Notice Here.
//                view.clearHistory();
//                view.clearCache(true);
                Log.d(TAG, url);
                super.onLoadResource(view, url);
            }
            @Override
            public void onPageFinished(WebView view, String url) {
                /* view.clearHistory(); */
                super.onPageFinished(view, url);
                /* view.clearCache(true); */
                Log.d(getClass().getCanonicalName(), "Web page finished loading.");

                mapLoaded();
            }
        });

        MyWebChromeClient chromeClient = new MyWebChromeClient();
        webView.setWebChromeClient(chromeClient);

        webView.loadUrl("file:///android_asset/map.html");

    }

    class MyWebChromeClient extends WebChromeClient {
        @Override
        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            boolean handled = false;
            if (isUserGesture) {
                WebView.HitTestResult result = view.getHitTestResult();
                if(result.getType() == WebView.HitTestResult.SRC_ANCHOR_TYPE) {
                    String data = result.getExtra();

                    //open with external browser
                    Uri uri = Uri.parse(data);
                    Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                    startActivity(intent);

                    //handled = true;
                }
            }
            return handled;
        }
    }

    private void mapLoaded() {

        if (Session.getSession().isOfflineMode()) {
            showOfflineMap();
        }
        else {
            showOnlineMap();
        }

        int action = getIntent().getIntExtra(EXTRA_ACTION, ACTION_NONE);
        if (action == ACTION_MOVE_TO_POINT) {
            double latitude = getIntent().getDoubleExtra(EXTRA_LATITUDE, 0.0);
            double longitude = getIntent().getDoubleExtra(EXTRA_LONGITUDE, 0.0);

            zoomToPoint(latitude, longitude);
            showResultMarker(latitude, longitude);
        }
        else {

            OneMapJavascriptInterface jsint = Session.getSession().getJavascriptInterface(this);
            if (jsint.getCurrentZoomLevel() == 0) {
                if (!Session.getSession().isOfflineMode()) {
                    zoomToLastKnownLocation();
                }
            }
            else {
                //restore previous state
                setZoomLevel(jsint.getCurrentZoomLevel());
                zoomToPoint(jsint.getCurrentLatitude(), jsint.getCurrentLongitude());
            }

        }

        highlightSelectedFeature();

    }

    private void showOnlineMap() {

        String serial = Session.getSession().getSerial();
        String token = Session.getSession().getToken();

        webView.evaluateJavascript("initMap(" + serial + ", '" + token + "');", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
                showCurrentLayer();
                doneLoadingOnlineMap();
            }
        });
    }

    private void showOfflineMap() {

        final OpenLayersMapActivity main = this;

        final String mapGuid = getIntent().getStringExtra(EXTRA_OFFLINE_MAP_GUID);
        final OfflineMapEntry entry = OfflineMapsDAO.getEntry(main, mapGuid);

        webView.evaluateJavascript("initOfflineMap(" + entry.getMaxZoom() +");", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.

                Session.getSession().setMapGuid(mapGuid);

                //Add XYZ tile layer

                //String tileUrl = "content://onemap.tileprovider/sdcard/offline/" + mapGuid + "/tiles/tile_{z}_{y}_{x}.jpg";
                String tileUrl = "content://onemap.tileprovider" + getFilesDir() + File.separator + "offline/" + mapGuid + "/tiles/tile_{z}_{y}_{x}.jpg";;

                webView.evaluateJavascript("addOfflineLayer('" + tileUrl + "', " + entry.getMaxZoom() + ");", new ValueCallback<String>() {
                    @Override
                    public void onReceiveValue(String value) {
                        //store / process result received from executing Javascript.
                        //String fieldsFile = savePath + "/activelayer.fields";

                        //final String geoJSONUrl = "content://onemap.tileprovider/sdcard/offline/" + mapGuid + "/activelayer.geojsononly";
                        final String geoJSONUrl = "content://onemap.tileprovider" + getFilesDir() + File.separator + "offline/" + mapGuid + "/activelayer.geojsononly";

                        // String sldStr = loadSLD(mapGuid);

                        //Set initial zoom and pan

                        final Double centerLat = entry.getCenterLatitude();
                        final Double centerLon = entry.getCenterLongitude();
                        webView.evaluateJavascript("setZoomLevel(" + Settings.ZOOM_LEVEL_OFFLINE + ");", new ValueCallback<String>() {
                            @Override
                            public void onReceiveValue(String value) {
                                //store / process result received from executing Javascript.
                                webView.evaluateJavascript("moveToPoint(" + centerLat + ", " + centerLon + ");", new ValueCallback<String>() {
                                    @Override
                                    public void onReceiveValue(String value) {
                                        //store / process result received from executing Javascript.
                                        //Add GeoJSON vector layer
                                        webView.evaluateJavascript("addGeoJSONLayer('" + geoJSONUrl + "');", new ValueCallback<String>() {
                                            @Override
                                            public void onReceiveValue(String value) {
                                                //store / process result received from executing Javascript.
                                                notifyJavaScriptAboutAllOfflineFeatureChanges();
                                            }
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });

    }

    private String loadSLD(String mapGuid) {
        String result = null;

        String savePath = AppUtil.pathForOfflineMap(this, mapGuid);
        savePath = savePath.replaceAll(".zip", "");

        String sldFile = savePath + "/style.sld";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(sldFile));
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                //sb.append("\n");
            }
            result = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return result;

    }

    private void zoomToLastKnownLocation() {
        Location location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
        if (location != null) {
            Double lat = location.getLatitude();
            Double lon = location.getLongitude();
            zoomToPoint(lat, lon);
        }
        else {
            //restore previous state
            OneMapJavascriptInterface jsint = Session.getSession().getJavascriptInterface(this);
            setZoomLevel(jsint.getCurrentZoomLevel());
            zoomToPoint(jsint.getCurrentLatitude(), jsint.getCurrentLongitude());
        }
    }

    private void showCurrentLayer() {

        webView.evaluateJavascript("removeAllLayers();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
                showBaseLayer();
                showVisibleLayers();
            }
        });
    }

    private void showBaseLayer() {

        Layer layer = Session.getSession().getCurrentBaseLayer();

        if (layer.getLayerId() == -1) {  //None base layer
            return;
        }

        if (layer.getLayerType() == Layer.LayerTypeEnum.OSM) {
            webView.evaluateJavascript("addOSMLayer();", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if (layer.getLayerType() == Layer.LayerTypeEnum.NGI_AERIAL) {
            webView.evaluateJavascript("addNGILayer();", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if (layer.getLayerType() == Layer.LayerTypeEnum.TONER) {
            webView.evaluateJavascript("addTonerLayer();", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if (layer.getLayerType() == Layer.LayerTypeEnum._1MAP || layer.getLayerType() == Layer.LayerTypeEnum.WMS) {
            webView.evaluateJavascript("addWMSLayer(" + layer.getLayerId() + ", '" + layer.getAttribution() + "', " + layer.getIsBaseLayer() + ", " + layer.getMinScale() + ", " + layer.getMaxScale() + ", " + layer.getOpacity() + ", " + layer.getDrawCache() + ");", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if ((layer.getLayerType() == Layer.LayerTypeEnum.GOOGLEHYBRID) ||
                (layer.getLayerType() == Layer.LayerTypeEnum.GOOGLESATELLITE) ||
                (layer.getLayerType() == Layer.LayerTypeEnum.GOOGLESTREET)) {
            webView.evaluateJavascript("addGoogleLayer('" + layer.getLayerType() + "');", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if (layer.getLayerType() == Layer.LayerTypeEnum.BINGHYBRID) {
            webView.evaluateJavascript("addBingLayer('AerialWithLabels');", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if (layer.getLayerType() == Layer.LayerTypeEnum.BINGAERIAL) {
            webView.evaluateJavascript("addBingLayer('Aerial');", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else if (layer.getLayerType() == Layer.LayerTypeEnum.BINGROAD) {
            webView.evaluateJavascript("addBingLayer('Road');", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
        }
        else {
            Toast.makeText(this, "Layer type " +  layer.getLayerType() + " under construction.", Toast.LENGTH_SHORT).show();
        }

    }

    private void showVisibleLayers() {

        List<Layer> layers = new ArrayList<Layer>();

        //draw in reverse
        int size = Session.getSession().getLayers().size();
        for(int c=size -1;c>=0;c--) {

            Layer layer = Session.getSession().getLayers().get(c);

            if (!layer.getIsBaseLayer()) {

                if (layer.getVisibility()) {

                    if (layer.getLayerType() == Layer.LayerTypeEnum.VECTOR || layer.getLayerType() == Layer.LayerTypeEnum.RASTER) {
                        webView.evaluateJavascript("addWMSLayer(" + layer.getLayerId() + ", '" + layer.getAttribution() + "', " + layer.getIsBaseLayer() + ", " + layer.getMinScale() + ", " + layer.getMaxScale() + ", " + layer.getOpacity() + ", '" + layer.getLayerStyle() + "');", new ValueCallback<String>() {
                            @Override
                            public void onReceiveValue(String value) {
                                //store / process result received from executing Javascript.
                            }
                        });
                    } else {
                        Toast.makeText(this, "Layer type " + layer.getLayerType() + " under construction.", Toast.LENGTH_SHORT).show();
                    }

                }
            }


        }


    }

    private void zoomToPoint(double latitude, double longitude) {
        String s = "zoomToPoint(" + latitude + ", " + longitude + ");";
        webView.evaluateJavascript(s, new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void moveToPointAndShowMarker(double latitude, double longitude) {
        //Toast.makeText(this, "Zoom to " + latitude + ", " + longitude, Toast.LENGTH_SHORT).show();

        webView.evaluateJavascript("moveToPointAndShowMarker(" + latitude + ", " + longitude + ");", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void moveToPoint(double latitude, double longitude) {
        //Toast.makeText(this, "Zoom to " + latitude + ", " + longitude, Toast.LENGTH_SHORT).show();

        webView.evaluateJavascript("moveToPoint(" + latitude + ", " + longitude + ");", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void showMarker(double latitude, double longitude) {

        webView.evaluateJavascript("showMarker(" + latitude + ", " + longitude + ");", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void showResultMarker(double latitude, double longitude) {

        webView.evaluateJavascript("showResultMarker(" + latitude + ", " + longitude + ");", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }


    private void hideMarker() {

        webView.evaluateJavascript("hideMarker();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void setZoomLevel(int newZoomLevel) {

        webView.evaluateJavascript("setZoomLevel(" + newZoomLevel + ");", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

        currentZoomLevel = newZoomLevel;
    }

    private void saveState() {

        webView.evaluateJavascript("saveState();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void addVectorLayer(String geoJsonStr) {

        webView.evaluateJavascript("addVectorLayer('" + geoJsonStr + "');", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }

    private void removeVectorLayer() {

        webView.evaluateJavascript("removeVectorLayer();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.open_layers_map, menu);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem navigateItem = menu.findItem(R.id.action_navigate);
        //int action = getIntent().getIntExtra(EXTRA_ACTION, ACTION_NONE);
        //boolean canNavigate = (action == ACTION_MOVE_TO_POINT);
        boolean canNavigate = getIntent().getBooleanExtra(EXTRA_CAN_NAVIGATE, false);
        navigateItem.setEnabled(canNavigate);

        MenuItem featureInfoItem = menu.findItem(R.id.action_feature_info);
        List<FeatureWithAttachments> selectedFeatures = Session.getSession().getSelectedFeatures();
        boolean featureInfoAvailable = selectedFeatures != null;
        featureInfoItem.setEnabled(featureInfoAvailable);

        MenuItem uploadNowItem = menu.findItem(R.id.action_upload_now);
        Settings settings = Settings.getSettings(this);
        if (settings.isBatchUploadEnabled() && !Session.getSession().isOfflineMode()) {
            uploadNowItem.setVisible(true);
            if(AttachmentsDAO.hasAttachments(this)) {
                uploadNowItem.setEnabled(true);
            }
        }

        //Offline Maps option should only be enabled if we are in ONLINE mode
        MenuItem offlineMapsItem = menu.findItem(R.id.action_offline_maps);
        offlineMapsItem.setEnabled(!Session.getSession().isOfflineMode());

        return super.onPrepareOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        /*
        if (id == R.id.action_search) {
            showSearchScreen();
            return true;
        }
        */
        if(id == R.id.action_logout) {
            logout();
            return true;
        }
        else if(id == R.id.action_gps_info) {
            showGPSInfoScreen();
            return true;
        }
        else if(id == R.id.action_settings) {
            showSettingsScreen();
            return true;
        }
        else if(id == R.id.action_navigate) {
            navigate();
            return true;
        }
        else if(id == R.id.action_feature_info) {
            showFeatureInfo();
            return true;
        }
        else if (id == R.id.action_upload_now) {
            uploadNow();
            return true;
        }
        else if (id == R.id.action_offline_maps) {
            showOfflineMaps();
            return true;
        }

        /*
        else if (id == R.id.action_test_new) {
            Session.getSession().setEditMode(Session.EDIT_MODE_CREATE);

            testFeatureEdit();
            return true;
        }
        else if (id == R.id.action_test_edit) {
            Session.getSession().setEditMode(Session.EDIT_MODE_UPDATE);
            testFeatureEdit();

            //IntentIntegrator integrator = new IntentIntegrator(this);
            //integrator.initiateScan();

            return true;
        }
        else if(id == R.id.action_coordinate) {
            showCoordinateScreen();

            return true;
        }
        */

        return super.onOptionsItemSelected(item);
    }

    private void showOfflineMaps() {

        Session.getSession().getJavascriptInterface(this).setSaveStateListener(this, REQ_OFFLINE_MAPS);
        saveState();
    }

    private void uploadNow() {
        Intent intent = new Intent(this, SyncNowActivity.class);
        startActivityForResult(intent, REQ_UPLOAD_NOW);
    }


    private void showCoordinateScreen() {
        Intent intent = new Intent(this, CoordinateActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

        startActivityForResult(intent, REQ_SEARCH);
    }

    private void newFeature() {
        Session.getSession().setEditMode(Session.EDIT_MODE_CREATE);

        targetView.setVisibility(View.VISIBLE);
        Toast.makeText(this, "Pan the map to position, then tap the target to continue.", Toast.LENGTH_LONG).show();
    }


    private void onTargetClicked() {
        //register a callback listener
        Session.getSession().getJavascriptInterface(this).setSaveStateListener(this, REQ_TARGET_CLICKED);
        //will save current map centroid in JavaScriptInterface object in Session
        saveState();
        //rest of stuff will have in onSaveStateCompleted
    }

    @Override
    public void onSaveStateCompleted(int requestId) {

        //remove the listener
        Session.getSession().getJavascriptInterface(this).setSaveStateListener(null, -1);

        if (requestId == REQ_TARGET_CLICKED) {

            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    targetView.setVisibility(View.GONE);
                }
            });


            String editMode = Session.getSession().getEditMode();
            if (editMode.equalsIgnoreCase(Session.EDIT_MODE_UPDATE)) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        updateGeometry();
                    }
                });

            }
            else if (editMode.equalsIgnoreCase(Session.EDIT_MODE_CREATE)) {
                OneMapJavascriptInterface jsi = Session.getSession().getJavascriptInterface(this);
                Session.getSession().setEditMode(Session.EDIT_MODE_CREATE);
                Session.getSession().setCurrentLatitude(jsi.getCurrentLatitude());
                Session.getSession().setCurrentLongitude(jsi.getCurrentLongitude());
                Log.d(getClass().getCanonicalName(), "DB1 Target coordinates " + jsi.getCurrentLatitude() + ", " + jsi.getCurrentLongitude());

                /*
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        getEditTemplates();
                    }
                });
                */

                Intent intent = new Intent(this, FeatureEditActivity.class);
                startActivityForResult(intent, REQ_FEATURE_NEW);
            }

        }
        else if (requestId == REQ_OFFLINE_MAPS) {

            OneMapJavascriptInterface js = Session.getSession().getJavascriptInterface(this);

            Session.getSession().setCurrentLatitude(js.getCurrentLatitude());
            Session.getSession().setCurrentLongitude(js.getCurrentLongitude());

            Intent intent = new Intent(this, OfflineMapsActivity.class);
            startActivity(intent);

        }
    }

    List<Long> featuresToMove;   //contains primary Ids

    private void updateGeometry() {

        Session session = Session.getSession();
        featuresToMove = new ArrayList<Long>();

        if(session.getMoveMode().equalsIgnoreCase(Session.MOVE_MODE_CURRENT)) {
            long primaryId = AppUtil.getPrimaryIdForFeature(session.getSelectedFeatureIndex());
            featuresToMove.add(primaryId);
        }
        else if(session.getMoveMode().equalsIgnoreCase(Session.MOVE_MODE_ALL)) {
            for (int c=0;c<session.getSelectedFeatures().size();c++) {
                long primaryId = AppUtil.getPrimaryIdForFeature(c);
                featuresToMove.add(primaryId);
            }
        }

        if (featuresToMove.size() > 0) {
            progressDialog = ProgressDialog.show(this, null, "Please wait...");
            updateGeometry(featuresToMove.get(0));
        }

    }

    private void updateGeometry(long primaryId) {

        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();

//        UpdateFeatureRequest request = new UpdateFeatureRequest();
//        request.setLayerId(layerId);
//        request.setPrimaryId(primaryId);

        Geometry geometry = new Geometry();

        //TODO set type
        //geometry.setType("Point");


        OneMapJavascriptInterface jsi = Session.getSession().getJavascriptInterface(this);
        double latitude = jsi.getCurrentLatitude();
        double longitude = jsi.getCurrentLongitude();
        //TODO populate geometry
//        double[] coordinates = new double[] {longitude, latitude};
//        geometry.setCoordinates(coordinates);


        if (Session.getSession().isOfflineMode()) {

            Gson gson = new Gson();

            //TODO generate request json string
            //String requestJson = gson.toJson(request);
            String requestJson = "";
            String geometryJson = gson.toJson(geometry);

            OfflineUpdateEntry entry = new OfflineUpdateEntry();
            entry.setRequestJson(requestJson);
            entry.setObjectJson(geometryJson);
            entry.setUpdateType(OfflineUpdateEntry.UPdATE_TYPE_EDIT_GEOMETRY);
            OfflineUpdatesDAO.insertEntry(this, entry);

            //Step 2 - Update the geojson file for local viewing
            FeatureWithAttachments feature = getSelectedFeatureWithId(primaryId);

            Polygon polygon = new Polygon();
            //TODO populate polygon

            //feature.setGeometry(geometry);
            Geometry geo = new Geometry();
            //TODO
            //geo.setGeometry(polygon);
            //feature.setGeometry(geo);
            feature.setGeometry(null);

            try {
                String mapGuid = Session.getSession().getMapGuid();
                String savePath = AppUtil.pathForOfflineMap(this, mapGuid);
                savePath = savePath.replaceAll(".zip", "");

                String featuresFile = savePath + "/activelayer.geojsononly";

                JsonParser parser = new JsonParser();
                FileReader reader = new FileReader(featuresFile);
                JsonElement el = parser.parse(reader);
                reader.close();

                JsonArray oFeatures = el.getAsJsonObject().getAsJsonArray("features");
                for (JsonElement eFeature : oFeatures) {
                    JsonObject oFeature = eFeature.getAsJsonObject();
                    String oFeatureId = oFeature.get("id").getAsString();
                    if (oFeatureId.equalsIgnoreCase(feature.getId())) {
                        JsonArray aCoordinates =  oFeature.getAsJsonObject("geometry").getAsJsonArray("coordinates");
                        aCoordinates.set(0, new JsonPrimitive(longitude));
                        aCoordinates.set(1, new JsonPrimitive(latitude));
                        break;
                    }

                }

                String out = el.toString();

                FileWriter writer = new FileWriter(featuresFile);
                writer.write(out);
                writer.flush();
                writer.close();

            }
            catch (Exception e) {
                progressDialog.dismiss();
                e.printStackTrace();
            }


            updateGeometrySucceeded();
        }
        else {
//            SpatialService service = new SpatialService();
//            service.updateFeature(request, geometry, this);
            try {
                SpatialApi api = new SpatialApi(AppUtil.getApiClient());

//                FeatureWithoutPropertiesAndAttachments feature = new FeatureWithoutPropertiesAndAttachments();
//                feature.setGeometry(geometry);
//                feature.setType(FeatureWithoutPropertiesAndAttachments.TypeEnum.FEATURE);

                Feature feature = Feature.of(Point.from(longitude, latitude));
                feature.setGeometryName("the_geom");

                api.apiSpatialUpdateGeometryAsync(layerId, primaryId, feature, new ApiCallback<OKResponseAttachmentsUpdate>() {
                    @Override
                    public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                updateFeatureFailed(e.getMessage());
                            }
                        });

                    }

                    @Override
                    public void onSuccess(final OKResponseAttachmentsUpdate result, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                updateFeatureCompleted(result);
                            }
                        });

                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }
    }

    private FeatureWithAttachments getSelectedFeatureWithId(long primaryId) {
        FeatureWithAttachments resultFeature = null;
        try {

            List<FeatureWithAttachments> features = Session.getSession().getSelectedFeatures();
            for (FeatureWithAttachments feature : features) {
                //long featureId = Long.parseLong(feature.getId());
                String featureIdStr = getPrimaryIdForFeatureInLayer(feature, Session.getSession().getCurrentActiveLayer());
                long featureId = Long.parseLong(featureIdStr);
                if (featureId == primaryId) {
                    resultFeature = feature;
                    break;
                }
            }
        }
        catch(Exception e) {
            e.printStackTrace();
        }

        return resultFeature;
    }

    private String getPrimaryIdForFeatureInLayer(FeatureWithAttachments feature, Layer layer) {
        String primaryIdField = layer.getPrimaryField();
        String value = null;

        //TODO how do we get the fields?
//        for (String field : feature.getProperties().keySet()) {
//            if (field.equals(primaryIdField)) {
//                value = (String) feature.getProperties().get(field);
//                break;
//            }
//        }

        return value;
    }


    public void updateFeatureCompleted(OKResponseAttachmentsUpdate response) {

        String message = response.getApiResponse().getMessage();
        if (message.equalsIgnoreCase("OK")) {
            updateGeometrySucceeded();
        }
        else {
            GuiUtil.showError(this, message);
        }
    }

    private void updateGeometrySucceeded() {
        featuresToMove.remove(0);
        if (featuresToMove.size() > 0) {
            //update the next geometry
            updateGeometry(featuresToMove.get(0));
        }
        else {
            progressDialog.dismiss();
            Toast.makeText(this, "Location updated.", Toast.LENGTH_SHORT).show();

            Session session = Session.getSession();


            if (Session.getSession().isOfflineMode()) {
                loadMap();
                highlightSelectedFeature();
                updateButtons();
            }
            else {
                //clear current selection
                clearSelection();

                //click map at new point to select again
                OneMapJavascriptInterface jsi = Session.getSession().getJavascriptInterface(this);
                double latitude = jsi.getCurrentLatitude();
                double longitude = jsi.getCurrentLongitude();
                mapClicked(latitude, longitude);

                loadMap();
            }
        }
    }

    private void clearSelection() {
        removeVectorLayer();
        Session.getSession().setSelectedFeatureIndex(-1);
        Session.getSession().setSelectedFeatures(null);
        Session.getSession().setSelectedFeatureFields(null);
        updateButtons();
    }


    public void updateFeatureFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }

    private void editFeatureAttributes() {
        Session.getSession().setEditMode(Session.EDIT_MODE_UPDATE);

        if (Session.getSession().getSelectedFeatures2().size() == 1) {
            Intent intent = new Intent(this, FeatureEditActivity.class);
            startActivityForResult(intent, REQ_FEATURE_EDIT);
        }
        else {
            Toast.makeText(this, "Multiple objects at point. Swipe to select the feature you want to edit.", Toast.LENGTH_LONG).show();
            showFeatureInfo();
        }
    }

    /*
    private void getEditTemplates() {
        progressDialog = ProgressDialog.show(this, null, "Loading", true);
        EditTemplatesRequest request = new EditTemplatesRequest();
        ParameterService service = new ParameterService();
        long layerId = Session.getSession().getCurrentActiveLayer().getId();
        service.editTemplates(layerId, request, this);
    }

    @Override
    public void editTemplatesCompleted(EditTemplatesResponse response) {
        progressDialog.hide();
        List<EditTemplate> editTemplates = response.getEditTemplates();

        int defaultIndex = getDefaultTemplateIndex(editTemplates);
        EditTemplate defaultEditTemplate = editTemplates.get(defaultIndex);
        Session.getSession().setCurrentEditTemplate(defaultEditTemplate);

        Intent intent = new Intent(this, FeatureEditActivity.class);

        if(Session.getSession().getEditMode() == Session.EDIT_MODE_CREATE) {
            startActivityForResult(intent, REQ_FEATURE_NEW);
        }
        else {
            startActivity(intent);
        }

    }

    private int getDefaultTemplateIndex(List<EditTemplate> editTemplates) {

        int defaultIndex = 0;

        for(int index = 0;index<editTemplates.size();index++) {
            EditTemplate template = editTemplates.get(index);
            if (template.isEditDefault()) {
                defaultIndex = index;
                break;
            }
        }

        return defaultIndex;
    }

    @Override
    public void editTemplatesFailed(String reason) {
        progressDialog.hide();
        GuiUtil.showError(this, reason);
    }
    */

    private void editFeatureGeometry() {
        Session.getSession().setEditMode(Session.EDIT_MODE_UPDATE);

        try {
            Session session = Session.getSession();

            //get coordinates for the first feature
            Feature feature = session.getSelectedFeatures2().get(0);
//            ArrayList<Double> coordinates = (ArrayList<Double>) feature.getGeometry().getCoordinates();
//            double longitude = coordinates.get(0);
//            double latitude = coordinates.get(1);
            //TODO get coordicates
            if (feature.geometry() instanceof Point) {
                Point point = (Point) feature.geometry();
                double longitude = point.lon();
                double latitude = point.lat();

                zoomToPoint(latitude, longitude);
            }
            else {
                Toast.makeText(this, "Selected geometry is not a point", Toast.LENGTH_LONG);
                return;
            }
        }
        catch(Exception e) {
            e.printStackTrace();
        }

        targetView.setVisibility(View.VISIBLE);
        Toast.makeText(this, "Pan the map to reposition, then tap the target to save.", Toast.LENGTH_LONG).show();
    }

    private void deleteSelectedFeature() {
        final Session session = Session.getSession();
        if (isFeatureSelected()) {

            saveState();

            int selectedFeatureIndex = session.getSelectedFeatureIndex();
            if(selectedFeatureIndex < 0) {
                selectedFeatureIndex = 0;
            }

            Feature selectedFeature = session.getSelectedFeatures2().get(selectedFeatureIndex);

            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setTitle("Warning");
            builder.setMessage("Are you sure you want to delete the selected object?");
            builder.setNegativeButton("Cancel", null);
            builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            progressDialog = new ProgressDialog(OpenLayersMapActivity.this);
                            progressDialog.setTitle("Deleting");
                            progressDialog.setMessage("Please wait...");
                            progressDialog.show();
                        }
                    });

//                    AttributesService service = new AttributesService();
//                    DeleteAttributesRequest request = new DeleteAttributesRequest();
//                    request.setLayerId(session.getCurrentActiveLayer().getLayerId());
//                    request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
//                    service.deleteAttributes(request, OpenLayersMapActivity.this);

                    try {
                        AttributesBasicApi api = new AttributesBasicApi(AppUtil.getApiClient());
                        long layerId = session.getCurrentActiveLayer().getLayerId();
                        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
                        api.attributesPrimaryIdDeleteAsync(layerId, primaryId, new ApiCallback<OKResponseAttributesDelete>() {
                            @Override
                            public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        deleteAttributesFailed(e.getMessage());
                                    }
                                });
                            }

                            @Override
                            public void onSuccess(final OKResponseAttributesDelete result, int statusCode, Map<String, List<String>> responseHeaders) {
                                runOnUiThread(new Runnable() {
                                    @Override
                                    public void run() {
                                        deleteAttributesCompleted(result.getResult());
                                    }
                                });
                            }

                            @Override
                            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                            }

                            @Override
                            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                            }
                        });
                    }
                    catch (ApiException e) {
                        Log.e(TAG, e.getMessage(), e);
                        GuiUtil.showWarning(OpenLayersMapActivity.this, e.getMessage());
                    }
                }
            });
            builder.show();

        }
        else {
            Toast.makeText(this, "No feature selected.", Toast.LENGTH_SHORT).show();
        }
    }


    private void showFeatureInfo() {
        Session.getSession().setMoveMode(null); //reset flag

        Intent intent = new Intent(this, FeatureInfoPagerActivity.class);
        startActivityForResult(intent, REQ_FEATURE_INFO);
    }

    private void navigate() {

        double latitude = getIntent().getDoubleExtra(EXTRA_LATITUDE, 0.0);
        double longitude = getIntent().getDoubleExtra(EXTRA_LONGITUDE, 0.0);

        //Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse("google.navigation:ll=-25.808611,28.256111"));
        String urlStr = "http://maps.google.com/maps?daddr=" + latitude + "," + longitude;
        Log.d(getClass().getCanonicalName(), urlStr);
        Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(urlStr));

        boolean isGoogleMapsInstalled = AppUtil.isAppInstalled(this, GOOGLE_MAPS_PACKAGE);
        Log.d(getClass().getCanonicalName(), "isGoogleMapsInstalled: " + isGoogleMapsInstalled);
        if (isGoogleMapsInstalled) {
            intent.setClassName(GOOGLE_MAPS_PACKAGE, GOOGLE_MAPS_ACTIVITY);
        }
        startActivity(intent);
    }


    /*
    private void testCompass() {
        Intent intent = new Intent(this, CompassActivity.class);
        startActivity(intent);
    }
    */

    /*
    private void toggleFollowMe() {
        if (followMeActive) {
            stopFollowMe();
            stopRotation();
        }
        else {
            startFollowMe();
            startRotation();
        }
    }
    */

    private void startFollowMe() {

        setZoomLevel(Settings.ZOOM_LEVEL_DEFAULT);

        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 200, 0, this);

        followMeActive = true;

        if(!locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
            AppUtil.promptEnableGPS(this);
        }

    }

    private void stopFollowMe() {
        locationManager.removeUpdates(this);
        hideMarker();

        followMeActive = false;
    }

    /*
    private void toggleRotation() {
        if (rotationActive) {
            stopRotation();
        }
        else {
            startRotation();
        }
    }
    */

    private void startRotation() {
        //sensorManager.registerListener(this, accelerometer, SensorManager.SENSOR_DELAY_NORMAL);
        //sensorManager.registerListener(this, magnetometer, SensorManager.SENSOR_DELAY_NORMAL);

        rotationActive = true;

        //show marker north
        rotateMarker(0);

    }

    private void stopRotation() {
        //sensorManager.unregisterListener(this);

        //return to North at the top
        webView.evaluateJavascript("rotateTo(0);", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });

        rotationActive = false;
    }

    private void showWorkspacesScreen() {
        saveState();
        Intent intent = new Intent(this, WorkspacesActivity.class);
        startActivityForResult(intent, REQ_WORKSPACE);
    }

    private void showBaseLayersScreen() {
        saveState();
        Intent intent = new Intent(this, BaseLayerActivity.class);
        startActivityForResult(intent, REQ_BASE_LAYER);
    }

    private void showOtherLayersScreen() {
        saveState();
        //Intent intent = new Intent(this, OtherLayersExpandableActivity.class);
        Intent intent = new Intent(this, OtherLayersMultiExpandableActivity.class);
        startActivityForResult(intent, REQ_OTHER_LAYERS);
    }

    private void showActiveLayerScreen() {
        saveState();
        Intent intent = new Intent(this, ActiveLayerActivity.class);
        startActivityForResult(intent, REQ_ACTIVE_LAYER);
    }

    private void showSearchScreen(String searchType) {
        Intent intent = new Intent(this, SearchActivity.class);
        intent.putExtra("SearchType", searchType);
        //startActivity(intent);
        //intent.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);

        startActivityForResult(intent, REQ_SEARCH);
    }

    private void showGPSInfoScreen() {
        Intent intent = new Intent(this, GPSInfoActivity.class);
        startActivity(intent);
    }

    private void showSettingsScreen() {
        Intent intent = new Intent(this, SettingsActivity.class);
        startActivity(intent);
    }

    private void logout() {
        LogoutHelper helper = new LogoutHelper(this);
        helper.initiateLogoutProcess();
    }

    @Override
    public void onSensorChanged(SensorEvent event) {
        //final float alpha = 0.97f;
        final float alpha = 0.7f;
        synchronized (this) {
            if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
                mGravity[0] = alpha * mGravity[0] + (1 - alpha)
                        * event.values[0];
                mGravity[1] = alpha * mGravity[1] + (1 - alpha)
                        * event.values[1];
                mGravity[2] = alpha * mGravity[2] + (1 - alpha)
                        * event.values[2];
            }
            if (event.sensor.getType() == Sensor.TYPE_MAGNETIC_FIELD) {
                mGeomagnetic[0] = alpha * mGeomagnetic[0] + (1 - alpha)
                        * event.values[0];
                mGeomagnetic[1] = alpha * mGeomagnetic[1] + (1 - alpha)
                        * event.values[1];
                mGeomagnetic[2] = alpha * mGeomagnetic[2] + (1 - alpha)
                        * event.values[2];
            }
            float R[] = new float[9];
            float I[] = new float[9];
            boolean success = SensorManager.getRotationMatrix(R, I, mGravity,
                    mGeomagnetic);
            if (success) {
                float orientation[] = new float[3];
                SensorManager.getOrientation(R, orientation);
                //azimuth = (float) Math.toDegrees(orientation[0]); // orientation
                azimuth = orientation[0]; // orientation
                //azimuth = (azimuth + 360) % 360;

                //int roundedAzimuth = (int)Math.round(azimuth);

                long now = System.currentTimeMillis();
                //only update every 200ms
                if (now - lastRotationUpdate > 200) {
                    webView.evaluateJavascript("rotateTo(" + azimuth + ");", new ValueCallback<String>() {
                        @Override
                        public void onReceiveValue(String value) {
                            //store / process result received from executing Javascript.
                        }
                    });
                    lastRotationUpdate = now;
                }

            }

        }
    }

    public void rotate(float degrees) {
        //float radials = (degrees + 360) % 360;
        double radians = Math.toRadians(degrees);

        long now = System.currentTimeMillis();
        //only update every 200ms
        if (now - lastRotationUpdate > 200) {
            webView.evaluateJavascript("rotateTo(" + radians + ");", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
            lastRotationUpdate = now;
        }

    }

    public void rotateMarker(float degrees) {
        long now = System.currentTimeMillis();
        //only update every 200ms
        if (now - lastRotationUpdate > 200) {
            webView.evaluateJavascript("rotateMarker(" + degrees + ");", new ValueCallback<String>() {
                @Override
                public void onReceiveValue(String value) {
                    //store / process result received from executing Javascript.
                }
            });
            lastRotationUpdate = now;
        }

    }

    private void updateAddSpatialButton() {


    }


    private void updateButtons() {

        Session session = Session.getSession();

        boolean featureSelected = isFeatureSelected();

        boolean canEdit =
                featureSelected
                        && session.getCurrentActiveLayer() != null
                        && session.getCurrentActiveLayer().getCanEditAttributes()
                        && session.getCurrentEditTemplate() != null;
        boolean canAdd =
                session.getCurrentActiveLayer() != null
                        && session.getCurrentActiveLayer().getCanEditAttributes()
                        && session.getCurrentActiveLayer().getGeometryType() == Layer.GeometryTypeEnum.POINT
                        && session.getCurrentEditTemplate() != null;;
        /*
        boolean canEditSpatial =
                featureSelected
                && Session.getSession().getCurrentActiveLayer() != null
                && Session.getSession().getCurrentActiveLayer().isEditSpatial()
                && session.getCurrentActiveLayer().getGeometryType().equalsIgnoreCase("Point");
        */

        /*
        removeSpatialButton.setEnabled(featureSelected);
        removeSpatialButton.setClickable(featureSelected);

        addSpatialButton.setEnabled(canEdit);
        addSpatialButton.setClickable(canEdit);
        */
        editButton.setEnabled(canEdit || canAdd);
        //editButton.setClickable(canEdit || canAdd);

        attachmentsButton.setEnabled(featureSelected);
        //attachmentsButton.setClickable(featureSelected && canEdit);

        infoButton.setEnabled(featureSelected);
        //infoButton.setClickable(featureSelected);

        /*
        editSpatialButton.setEnabled(featureSelected && canEditSpatial);
        editSpatialButton.setClickable(featureSelected && canEditSpatial);
        */

        layersButton.setEnabled(!session.isOfflineMode());

        boolean hasActiveLayer = Session.getSession().getCurrentActiveLayer() != null;
        //dataButton.setEnabled(hasActiveLayer);
        //TODO disable data grid until fully implemented
        dataButton.setEnabled(false);

    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int i) {

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        this.resultData = data;

        invalidateOptionsMenu();

        if (requestCode == REQ_BASE_LAYER) {
            //showCurrentLayer();
            loadMap();
        }
        else if(requestCode == REQ_OTHER_LAYERS) {
            //showCurrentLayer();

            if(Session.getSession().isActiveLayerChanged()) {
                clearSelection();
                Session.getSession().setActiveLayerChanged(false);  //reset flag
            }

            updateButtons();
            loadMap();
        }
        else if (requestCode == REQ_WORKSPACE) {
            //showCurrentLayer();

            updateButtons();
            updateTitle();

            loadMap();
        }
        else if(requestCode == REQ_ACTIVE_LAYER) {
            //testFeatures();

            if(Session.getSession().isActiveLayerChanged()) {
                clearSelection();
                Session.getSession().setActiveLayerChanged(false);  //reset flag
            }


            updateButtons();
            updateTitle();
        }
        else if(requestCode == REQ_FEATURE_NEW) {

            loadMap();

            if (!Session.getSession().isOfflineMode()) {
                //select the new feature
                double latitude = Session.getSession().getCurrentLatitude();
                double longitude = Session.getSession().getCurrentLongitude();
                mapClicked(latitude, longitude);
            }
            else {
                //TODO select offline
            }

        }
        else if(requestCode == REQ_FEATURE_EDIT) {
            loadMap();
        }
        else if(requestCode == REQ_FEATURE_INFO) {
            if (resultCode == RESULT_OK) {
                if(Session.getSession().getMoveMode() != null) {
                    editFeatureGeometry();
                }
                else {
                    //feature deleted, refresh map
                    clearSelection();
                    loadMap();
                }

            }
        }
        else if(requestCode == REQ_SEARCH) {
            if(resultCode == RESULT_OK) {
                double latitude = data.getDoubleExtra(EXTRA_LATITUDE, 0.0);
                double longitude = data.getDoubleExtra(EXTRA_LONGITUDE, 0.0);

                getIntent().putExtra(EXTRA_CAN_NAVIGATE, true);
                getIntent().putExtra(EXTRA_LATITUDE, latitude);
                getIntent().putExtra(EXTRA_LONGITUDE, longitude);

                setZoomLevel(Settings.ZOOM_LEVEL_SEARCH);
                zoomToPoint(latitude, longitude);
                showResultMarker(latitude, longitude);
            }
        }
        else if(requestCode == REQ_UPLOAD_NOW) {
            //Nothing special to do
        }

        //clear election if feature not selected anymore
        if(!isFeatureSelected()) {
            removeVectorLayer();
        }

    }

    /*
    private void notifyJavaScriptAboutOfflineFeatureChanges() {

        if (this.resultData != null) {

            String editType = this.resultData.getStringExtra(RETURN_OFFLINE_EDIT_TYPE);
            String featureJson = this.resultData.getStringExtra(RETURN_OFFLINE_EDIT_FEATURE);

            if ((editType != null) && (featureJson != null)) {

                webView.evaluateJavascript("offlineFeatureChanged('" + editType + "', '" + featureJson + "');", new ValueCallback<String>() {
                    @Override
                    public void onReceiveValue(String value) {
                        //store / process result received from executing Javascript.
                    }
                });

                this.resultData = null;

            }
        }

    }
    */


    private void notifyJavaScriptAboutAllOfflineFeatureChanges() {

        List<OfflineUpdateEntry> entries = OfflineUpdatesDAO.getAllEntries(this);

        for (OfflineUpdateEntry entry : entries) {
            String editType = entry.getUpdateType();
            String featureJson = entry.getObjectJson();

            if ((editType != null) && (featureJson != null)) {

                webView.evaluateJavascript("offlineFeatureChanged('" + editType + "', '" + featureJson + "');", new ValueCallback<String>() {
                    @Override
                    public void onReceiveValue(String value) {
                        //store / process result received from executing Javascript.
                    }
                });

                this.resultData = null;

            }
        }
        doneLoadingOfflineMap();
    }

    private void doneLoadingOfflineMap() {
        webView.evaluateJavascript("doneLoadingOfflineMap();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });
    }

    private void doneLoadingOnlineMap() {
        webView.evaluateJavascript("doneLoadingOnlineMap();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });
    }

    /*
    private void testFeatures() {
        AttributesService service = new AttributesService();
        FeaturesRequest request = new FeaturesRequest();
        Session session = Session.getSession();
        request.setLayerId(session.getCurrentActiveLayer().getId());
        request.setLatitude(-25.808611);
        request.setLongitude(28.256111);

        service.features(request, this);

    }
    */


    public void featuresCompleted(OKResponseAttributesClosestResult response) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });


        //List<Feature> features = response.getItems().getFeatures();
        //List<FeatureWithAttachments> features = response.getGeomResult().getFeatures();
        List<Feature> features = response.getGeomResult().features();


        if ((features != null) && (features.size() > 0)) {
            //Note not sure if we should highlight all features or only the first feature
            //The features will all be on the same point, and there could be a lot of features
            //Session.getSession().setSelectedFeatures(features);
            Session.getSession().setSelectedFeatures2(features);
            Session.getSession().setSelectedFeatureIndex(0);    //select first feature by default

            // Session.getSession().setSelectedFeatureFields(response.getFields());
            List<Field> fields = new ArrayList<>();
            for (OKResponseAttributesResultFields resultFIeld : response.getFields()) {
                Field field = new Field();
                field.setFieldName(resultFIeld.getFieldName());
                field.setFieldCaption(resultFIeld.getFieldCaption());
            }
            Session.getSession().setSelectedFeatureFields(fields);

        }
        else {
            Session.getSession().setSelectedFeatures(null);
            Session.getSession().setSelectedFeatureIndex(-1);
            Session.getSession().setSelectedFeatureFields(null);
        }

        highlightSelectedFeature();
        updateButtons();
    }



    private void highlightSelectedFeature() {

        Session session = Session.getSession();
        if(session.getSelectedFeatures2() != null
                && session.getSelectedFeatures2().size() > 0
                && session.getSelectedFeatureIndex() >= 0) {

            //FeatureWithAttachments feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());
            Feature feature = session.getSelectedFeatures2().get(session.getSelectedFeatureIndex());

            Gson json = new GsonBuilder().registerTypeAdapterFactory(new GeometryAdapterFactory()).create();
            String geoJsonStr = json.toJson(feature);
            addVectorLayer(geoJsonStr);
        }
        else {
            removeVectorLayer();
        }

    }


    public void featuresFailed(String reason) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }


    public void deleteAttributesCompleted(OKResponseAttributesDeleteResult response) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        /*
        Session.getSession().setSelectedFeatureIndex(-1);
        Session.getSession().setSelectedFeatures(null);
        removeVectorLayer();
        */
        clearSelection();

        Toast.makeText(this, "Object deleted.", Toast.LENGTH_SHORT).show();

        //refresh the map
        loadMap();

    }


    public void deleteAttributesFailed(String reason) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }

    @Override
    public void onLocationChanged(Location location) {

        //adapt zoom level based on speed
        Settings settings = Settings.getSettings(this);
        if (settings.isAutoZoomEnabled()) {
            int zoomLevel = zoomLevelForSpeed(location.getSpeed());
            if (zoomLevel != currentZoomLevel) {
                setZoomLevel(zoomLevel);
                currentZoomLevel = zoomLevel;
                zoomToPoint(location.getLatitude(), location.getLongitude());
            }
        }

        /* moveToPoint(location.getLatitude(), location.getLongitude());
        showMarker(location.getLatitude(), location.getLongitude()); */
        moveToPointAndShowMarker(location.getLatitude(), location.getLongitude());

        if (rotationActive) {
            if (location.hasBearing()) {
                float bearing = location.getBearing();
                bearing = bearing * (-1);
                rotate(bearing);
            }
        }
        else {
            if (location.hasBearing()) {
                float bearing = location.getBearing();
                rotateMarker(bearing);
            }
        }

        if (settings.isLogLocation()) {
            Date now = new Date();
            long diff = now.getTime() - lastLocationLogged.getTime();
            long interval = settings.getLogLocationInterval() * 1000;    //convert to miliseconds
            if (diff >= interval) {
                logLocationToServer(location);
                lastLocationLogged = new Date();
            }


        }
    }

    private void logLocationToServer(Location location) {
        AddTrackRequest request = new AddTrackRequest();
        TrackingService service = new TrackingService();
        service.addTrack(request, location, this);
    }

    @Override
    public void addTrackCompleted(AddTrackResponse response) {
        if (response.getMessage().equalsIgnoreCase("Success")) {
            Log.d(getClass().getCanonicalName(), "Location logged to server.");
        }
        else {
            Log.d(getClass().getCanonicalName(), "COULD NOT LOG LOCATION TO SERVER - " + response.getMessage());
        }
    }

    @Override
    public void addTrackFailed(String reason) {
        Log.d(getClass().getCanonicalName(), "ERROR LOGGING LOCATION TO SERVER - " + reason);
    }

    private int zoomLevelForSpeed(float speedMps) {
        int zoomLevel = Settings.ZOOM_LEVEL_DEFAULT;

        float speedKmph = speedMps * 3.6f;

        if (speedKmph > Settings.SPEED_SLOW_DRIVE) {
            zoomLevel = Settings.ZOOM_LEVEL_SLOW_DRIVE;
        }
        else if (speedKmph > Settings.SPEED_FAST_DRIVE) {
            zoomLevel = Settings.ZOOM_LEVEL_FAST_DRIVE;
        }

        return zoomLevel;
    }

    public void mapClicked(double latitude, double longitude) {
        Log.d(getClass().getCanonicalName(), "Map clicked at " + latitude + ", " + longitude);

        //if (selectMode != SELECT_MODE_OFF) {

        Layer activeLayer = Session.getSession().getCurrentActiveLayer();
        if (activeLayer != null) {
            //GuiUtil.showProgress(this, "Please wait...");

            Log.d(getClass().getCanonicalName(), "Getting features at point for active layer: " + activeLayer.getLayerCaption());
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog = new ProgressDialog(OpenLayersMapActivity.this);
                    progressDialog.setMessage("Loading...");
                    progressDialog.show();
                }
            });


//            AttributesService service = new AttributesService();
//            FeaturesRequest request = new FeaturesRequest();
//            request.setLayerId(activeLayer.getLayerId());
//            request.setLatitude(latitude);
//            request.setLongitude(longitude);
//            request.setShowAttachments(true);
//            service.features(request, this);

            try {
                AttributesAdvancedApi api = new AttributesAdvancedApi(AppUtil.getApiClient());
                //float fLatitude = (float)latitude;
                //float fLongitude = (float)longitude;
                long layerId = activeLayer.getLayerId();
                Log.d(TAG, "Latitude: " + latitude);
                Log.d(TAG, "Longitude: " + longitude);
                api.attributesClosestSearchAsync(layerId, longitude, latitude, "yes", new ApiCallback<OKResponseAttributesClosest>() {
                    @Override
                    public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                featuresFailed(e.getMessage());
                            }
                        });
                    }

                    @Override
                    public void onSuccess(final OKResponseAttributesClosest result, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                featuresCompleted(result.getResult());
                            }
                        });
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }

        } else {
            Toast.makeText(this, "No Active Layer selected.", Toast.LENGTH_SHORT).show();
        }

        //}
    }


    public void mapTouchStart() {

        //turn off follow me if the user interacts with the map
        if (followMeMode != FOLLOW_ME_OFF) {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    setFollowMeMode(FOLLOW_ME_OFF);
                }
            });

        }

    }

    /*
    public void rotateControlClicked() {
        Log.d(getClass().getCanonicalName(), "***** rotateControlClicked *****");
        if(followMeMode == FOLLOW_ME_ON_ROTATE_ON) {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    setFollowMeMode(FOLLOW_ME_ON_ROTATE_OFF);
                }
            });

        }
    }
    */

    @Override
    public void onStatusChanged(String s, int i, Bundle bundle) {

    }

    @Override
    public void onProviderEnabled(String s) {

    }

    @Override
    public void onProviderDisabled(String s) {

    }

    @Override
    public void onBackPressed() {

        if (targetView.getVisibility() == View.VISIBLE) {
            targetView.setVisibility(View.GONE);
            Session.getSession().setEditMode(null);
        }
        else {
            logout();
        }


    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        stopRotation();
    }

    private void zoomIn() {
        webView.evaluateJavascript("zoomIn();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });
    }

    private void zoomOut() {
        webView.evaluateJavascript("zoomOut();", new ValueCallback<String>() {
            @Override
            public void onReceiveValue(String value) {
                //store / process result received from executing Javascript.
            }
        });
    }

    private void showLayersMenu() {

        PopupMenu popup = new PopupMenu(this, layersButton);
        popup.getMenuInflater().inflate(R.menu.menu_layers_popup, popup.getMenu());
        popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
            @Override
            public boolean onMenuItemClick(MenuItem menuItem) {

                int id = menuItem.getItemId();

                if (id == R.id.action_workspace) {
                    showWorkspacesScreen();
                    return true;
                }
                else if (id == R.id.action_base_layer) {
                    showBaseLayersScreen();
                    return true;
                }
                else if (id == R.id.action_other_layers) {
                    showOtherLayersScreen();
                    return true;
                }
                else if(id == R.id.action_active_layer) {
                    showActiveLayerScreen();
                    return true;
                }
                else if (id == R.id.action_offline_maps) {
                    showOfflineMaps();
                    return true;
                }

                return true;
            }
        });

        popup.show();

    }

    private void showEditMenu() {

        PopupMenu popup = new PopupMenu(this, editButton);
        popup.getMenuInflater().inflate(R.menu.menu_edit_popup, popup.getMenu());

        List<Feature> selectedFeatures = Session.getSession().getSelectedFeatures2();
        boolean featureInfoAvailable = selectedFeatures != null;

        Menu menu = popup.getMenu();
        MenuItem featureNewItem = menu.findItem(R.id.action_feature_new);
        boolean canAddFeature = false;
        boolean canEditFeature = false;
        boolean canEditSpatial = false;

        Layer activeLayer = Session.getSession().getCurrentActiveLayer();
        if (activeLayer != null) {

            canAddFeature = activeLayer.getCanEditAttributes()
                    && activeLayer.getGeometryType() == Layer.GeometryTypeEnum.POINT
                    && Session.getSession().getCurrentEditTemplate() != null;

            canEditFeature = activeLayer.getCanEditAttributes()
                    && Session.getSession().getCurrentEditTemplate() != null;

            canEditSpatial = activeLayer.getCanEditSpatial()
                    && activeLayer.getGeometryType() == Layer.GeometryTypeEnum.POINT;

        }
        featureNewItem.setEnabled(canAddFeature);

        MenuItem featureEditItem = menu.findItem(R.id.action_feature_edit);
        featureEditItem.setEnabled(featureInfoAvailable && canEditFeature);

        MenuItem featureDeleteItem = menu.findItem(R.id.action_feature_delete);
        featureDeleteItem.setEnabled(featureInfoAvailable && canEditSpatial);

        MenuItem featureMoveItem = menu.findItem(R.id.action_feature_move);
        featureMoveItem.setEnabled(featureInfoAvailable && canEditSpatial);

        popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
            @Override
            public boolean onMenuItemClick(MenuItem menuItem) {

                int id = menuItem.getItemId();


                if(id == R.id.action_feature_new) {
                    newFeature();

                    return true;
                }
                else if(id == R.id.action_feature_edit) {
                    editFeatureAttributes();

                    return true;
                }
                else if(id == R.id.action_feature_delete) {
                    if(Session.getSession().getSelectedFeatures2().size() > 1) {
                        Toast.makeText(OpenLayersMapActivity.this, "Multiple objects at point. Swipe to select object, then tap Delete button.", Toast.LENGTH_LONG).show();
                        showFeatureInfo();
                    }
                    else {
                        deleteSelectedFeature();
                    }

                    return true;
                }
                else if(id == R.id.action_feature_move) {
                    if(Session.getSession().getSelectedFeatures2().size() > 1) {
                        Toast.makeText(OpenLayersMapActivity.this, "Multiple objects at point. Swipe to select object, then tap Move button.", Toast.LENGTH_LONG).show();
                        showFeatureInfo();
                    }
                    else {
                        Session.getSession().setMoveMode(Session.MOVE_MODE_CURRENT);
                        editFeatureGeometry();
                    }

                    return true;
                }

                return true;
            }
        });

        popup.show();

    }

    private void showSearchMenu() {

        PopupMenu popup = new PopupMenu(this, searchButton);
        popup.getMenuInflater().inflate(R.menu.menu_search_popup, popup.getMenu());

        //disable address and erf searches when offline
        MenuItem addressSearchItem = popup.getMenu().findItem(R.id.action_search_address);
        addressSearchItem.setEnabled(!Session.getSession().isOfflineMode());

        MenuItem erfSearchItem = popup.getMenu().findItem(R.id.action_search_erf);
        erfSearchItem.setEnabled(!Session.getSession().isOfflineMode());

        popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
            @Override
            public boolean onMenuItemClick(MenuItem menuItem) {

                int id = menuItem.getItemId();

                if (id == R.id.action_search_address) {
                    showSearchScreen(SearchActivity.SEARCH_TYPE_STREET_ADDRESS);
                    return true;
                }
                else if (id == R.id.action_search_erf) {
                    showSearchScreen(SearchActivity.SEARCH_TYPE_ERF_NO);
                    return true;
                }
                else if (id == R.id.action_search_coordinate) {
                    showCoordinateScreen();
                    return true;
                }

                return true;
            }
        });

        popup.show();

    }


    private void toggleFollowMeMode() {
        int newMode = FOLLOW_ME_OFF;

        /*
        if (followMeMode == FOLLOW_ME_OFF) {
            newMode = FOLLOW_ME_ON_ROTATE_OFF;
        }
        else if(followMeMode == FOLLOW_ME_ON_ROTATE_OFF) {
            newMode = FOLLOW_ME_ON_ROTATE_ON;
        }
        else if(followMeMode == FOLLOW_ME_ON_ROTATE_ON) {
            newMode = FOLLOW_ME_OFF;
        }
        */

        if (followMeMode == FOLLOW_ME_OFF) {
            newMode = FOLLOW_ME_ON_ROTATE_OFF;
        }
        else if(followMeMode == FOLLOW_ME_ON_ROTATE_OFF) {
            newMode = FOLLOW_ME_OFF;
        }


        setFollowMeMode(newMode);
    }

    private void setFollowMeMode(int newMode) {

        if (newMode == FOLLOW_ME_OFF) {
            stopFollowMe();
            stopRotation();

            followMeButton.setImageResource(R.drawable.gps_off_dark);

            Toast.makeText(this, "Follow Me - OFF", Toast.LENGTH_LONG).show();
        }
        else if (newMode == FOLLOW_ME_ON_ROTATE_OFF) {
            startFollowMe();
            stopRotation();

            followMeButton.setImageResource(R.drawable.icons_follow_locked_v2);

            Toast.makeText(this, "Follow Me - ON", Toast.LENGTH_SHORT).show();
        }
        else if (newMode == FOLLOW_ME_ON_ROTATE_ON) {
            startFollowMe();
            startRotation();

            followMeButton.setImageResource(R.drawable.icons_follow_rotate_v2);

            Toast.makeText(this, "Follow Me & Auto Rotate - ON", Toast.LENGTH_SHORT).show();
        }

        followMeMode = newMode;
    }

    /*
    private void toggleSelectMode() {
        int newMode = SELECT_MODE_OFF;

        if (selectMode == SELECT_MODE_OFF) {
            newMode = SELECT_MODE_ON;
        } else if (selectMode == SELECT_MODE_ON) {
            newMode = SELECT_MODE_INFO;
        } else if (selectMode == SELECT_MODE_INFO) {
            newMode = SELECT_MODE_OFF;
        }


        if (newMode == SELECT_MODE_OFF) {

            selectionModeButton.setImageResource(R.drawable.icons_pan_01);

            Toast.makeText(this, "Select - OFF", Toast.LENGTH_SHORT).show();
        }
        else if (newMode == SELECT_MODE_ON) {

            selectionModeButton.setImageResource(R.drawable.icons_select_01);

            Toast.makeText(this, "Select - ON", Toast.LENGTH_SHORT).show();
        }
        else if (newMode == SELECT_MODE_INFO) {

            selectionModeButton.setImageResource(R.drawable.icons_info_01);

            Toast.makeText(this, "Select & Show Info - ON", Toast.LENGTH_SHORT).show();
        }

        selectMode = newMode;
    }
    */

    private void showAttachmentsScreen() {

        List<Feature> selectedFeatures = Session.getSession().getSelectedFeatures2();
        if (selectedFeatures != null && selectedFeatures.size() > 0) {

            if (selectedFeatures.size() == 1) {
                Session.getSession().setSelectedFeatureIndex(0);

                Intent intent = new Intent(this, AttachmentsActivity.class);
                startActivity(intent);
            }
            else {
                Toast.makeText(this, "Multiple objects at point. Swipe to select feature for attachments.", Toast.LENGTH_LONG).show();
                showFeatureInfo();
            }
        }
        else {
            Toast.makeText(this, "No object selected.", Toast.LENGTH_SHORT).show();
        }

    }

    private void showDataScreen() {

//        Intent intent = new Intent(this, DataActivity.class);
//        startActivity(intent);

    }

    @Override
    public void onClick(View view) {
        if (view == zoomInButton) {
            zoomIn();
        }
        else if(view == zoomOutButton) {
            zoomOut();
        }
        else if(view == layersButton) {
            showLayersMenu();
        }
        else if(view == searchButton) {
            showSearchMenu();
        }
        else if(view == followMeButton) {
            toggleFollowMeMode();
        }
        else if(view == infoButton) {
            showFeatureInfo();
        }
        /*
        else if(view == selectionModeButton) {
            toggleSelectMode();
        }
        else if(view == addSpatialButton) {
            newFeature();
        }
        else if(view == removeSpatialButton) {
            deleteSelectedFeature();
        }
        else if(view == editSpatialButton) {
            showEditSpatialMenu();
        }
        else if(view == editFeatureButton) {
            editFeatureAttributes();;
        }
        */
        else if(view == editButton) {
            showEditMenu();;
        }
        else if (view == attachmentsButton) {
            showAttachmentsScreen();
        }
        else if(view == dataButton) {
            showDataScreen();
        }
    }

    public void offlineFeaturesSelected(String featuresStr) {
        Gson gson = new Gson();

        //TODO implement
//        Type listType = new TypeToken<ArrayList<Feature>>(){}.getType();
//        List<Feature> features = gson.fromJson(featuresStr, listType);
//
//        Session.getSession().setSelectedFeatures(features);
//        Session.getSession().setSelectedFeatureIndex(0);

        List<Field> fields = offlineLoadActiveLayerFields();
        Session.getSession().setSelectedFeatureFields(fields);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                highlightSelectedFeature();
                updateButtons();
            }
        });


        //showFeatureInfo();
    }

    private List<Field> offlineLoadActiveLayerFields() {

        List<Field> fields = new ArrayList<Field>();

        try {
            String mapGuid = getIntent().getStringExtra(EXTRA_OFFLINE_MAP_GUID);
            String savePath = AppUtil.pathForOfflineMap(this, mapGuid);
            savePath = savePath.replaceAll(".zip", "");
            String fieldsFile = savePath + "/activelayer.fields";
            FileReader reader = new FileReader(fieldsFile);
            Gson gson = new Gson();

            Type listType = new TypeToken<ArrayList<Field>>() {
            }.getType();
            fields = new Gson().fromJson(reader, listType);

            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        return fields;
    }

}
