package org.quidity.demo.activity;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.widget.Toast;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.quidity.demo.Session;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by ferdiedanzfuss on 2014/10/02.
 */
public class OneMapJavascriptInterface implements Serializable {

    private int currentZoomLevel;
    private double currentLatitude;
    private double currentLongitude;

    private double boundsLeft;
    private double boundsRight;
    private double boundsTop;
    private double boundsBottom;

    private transient OpenLayersMapActivity mapActivity;


    private SaveStateListener saveStateListener;
    private int requestId;

    public interface SaveStateListener {
        public void onSaveStateCompleted(int requestId);
    }

    public void setSaveStateListener(SaveStateListener saveStateListener, int requestId) {
        this.saveStateListener = saveStateListener;
        this.requestId = requestId;
    }

    @android.webkit.JavascriptInterface
    public void notifySaveStateCompleted() {
        if (saveStateListener != null) {
            Thread thread = new Thread(new Runnable() {
                @Override
                public void run() {
                    saveStateListener.onSaveStateCompleted(requestId);
                }
            });
            thread.start();
        }
    }

    public OneMapJavascriptInterface(OpenLayersMapActivity mapActivity) {
        this.mapActivity = mapActivity;
    }

    public int getCurrentZoomLevel() {
        return currentZoomLevel;
    }


    @android.webkit.JavascriptInterface
    public void setCurrentZoomLevel(int currentZoomLevel) {
        this.currentZoomLevel = currentZoomLevel;
    }

    public double getCurrentLatitude() {
        return currentLatitude;
    }

    @android.webkit.JavascriptInterface
    public void setCurrentLatitude(double currentLatitude) {
        this.currentLatitude = currentLatitude;
    }

    public double getCurrentLongitude() {
        return currentLongitude;
    }

    @android.webkit.JavascriptInterface
    public void setCurrentLongitude(double currentLongitude) {
        this.currentLongitude = currentLongitude;
    }

    public double getBoundsLeft() {
        return boundsLeft;
    }

    @android.webkit.JavascriptInterface
    public void setBoundsLeft(double boundsLeft) {
        this.boundsLeft = boundsLeft;
    }

    public double getBoundsRight() {
        return boundsRight;
    }

    @android.webkit.JavascriptInterface
    public void setBoundsRight(double boundsRight) {
        this.boundsRight = boundsRight;
    }

    public double getBoundsTop() {
        return boundsTop;
    }

    @android.webkit.JavascriptInterface
    public void setBoundsTop(double boundsTop) {
        this.boundsTop = boundsTop;
    }

    public double getBoundsBottom() {
        return boundsBottom;
    }

    @android.webkit.JavascriptInterface
    public void setBoundsBottom(double boundsBottom) {
        this.boundsBottom = boundsBottom;
    }

    @android.webkit.JavascriptInterface
    public void mapClicked(double latitude, double longitude) {

        //String msg = "Map clicked at " + latitude + ", " + longitude;
        //Toast.makeText(mapActivity, msg, Toast.LENGTH_SHORT).show();

        //forward event to the map activity
        if (mapActivity != null) {
            mapActivity.mapClicked(latitude, longitude);
        }

    }

    @JavascriptInterface
    public void mapTouchStart() {
        //forward event to the map activity
        if (mapActivity != null) {
            mapActivity.mapTouchStart();
        }
    }

    @JavascriptInterface
    public void offlineFeaturesSelected(String featuresStr) {
        Log.d(getClass().getCanonicalName(), featuresStr);

        //forward event to the map activity
        if (mapActivity != null) {
            mapActivity.offlineFeaturesSelected(featuresStr);
        }

    }

    /*
    @android.webkit.JavascriptInterface
    public void rotateControlClicked() {
        //forward event to the map activity
        if (mapActivity != null) {
            mapActivity.rotateControlClicked();
        }
    }
    */

}
