package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

import com.google.android.gms.common.api.Api;
import com.google.gson.Gson;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.OfflineMapEntry;
import org.quidity.demo.db.OfflineMapsDAO;
import org.quidity.demo.mapi.offline.Bounds;
import org.quidity.demo.mapi.offline.OfflineService;
import org.quidity.demo.mapi.offline.PrepareRequest;
import org.quidity.demo.mapi.offline.PrepareResponse;
import org.quidity.demo.mapi.offline.TotalTilesRequest;
import org.quidity.demo.mapi.offline.TotalTilesResponse;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.ParametersApi;
import io.swagger.client.model.EditTemplate;
import io.swagger.client.model.EditTemplateField;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFields;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFieldsResult;
import io.swagger.client.model.OKResponseParamsLayerEditTemplates;
import io.swagger.client.model.OKResponseParamsLayerEditTemplatesResult;

public class NewOfflineMapActivity extends Activity implements
        View.OnClickListener,
        OfflineService.PrepareListener,
        OfflineService.TotalTilesListener
{

    private static final String TAG = NewOfflineMapActivity.class.getCanonicalName();

    private int[] scales = {
            524288000,
            131072000,
            65536000,
            32768000,
            16384000,
            8192000,
            4096000,
            2048000,
            1024000,
            512000,
            256000,
            128000,
            64000,
            32000,
            16000,
            8000,
            4000,
            2000,
            1000,
            500,
            250,
            125,
            63,
            31,
            16,
            8,
            4,
            2,
            1
    };

    private static final int MAX_ZOOM_LEVEL = 20;

    private EditText mapNameField;
    private Spinner maxZoomSpinner;
    private Spinner qualitySpinner;
    private Button prepareButton;
    private ProgressDialog progressDialog;
    private OfflineMapEntry entry;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_new_offline_map);

        AppUtil.initActivity(this);

        mapNameField = (EditText)findViewById(R.id.map_name);
        maxZoomSpinner = (Spinner)findViewById(R.id.max_zoom_spinner);
        qualitySpinner = (Spinner)findViewById(R.id.quality_spinner);
        prepareButton = (Button)findViewById(R.id.prepare);
        prepareButton.setOnClickListener(this);

        fillMaxZoomSpinner();
        fillQualitySpinner();
    }

    @Override
    public void onClick(View view) {
        if (view == prepareButton) {

            //Make sure we have an active layer
            Layer activeLayer = Session.getSession().getCurrentActiveLayer();
            if (activeLayer == null) {
                GuiUtil.showError(this, "No active layer selected.");
                return;
            }

            //check the number of tiles that will be generated
            checkTotalTiles();



        }
    }

    private void fillMaxZoomSpinner() {
        OneMapJavascriptInterface jsi = Session.getSession().getJavascriptInterface(null);
        int minZoom = jsi.getCurrentZoomLevel();

        List<ZoomLevelInfo> zoomLevelInfos = new ArrayList<ZoomLevelInfo>();
        for (int zoomLevel = minZoom ; zoomLevel <= MAX_ZOOM_LEVEL; zoomLevel++) {
            ZoomLevelInfo info = new ZoomLevelInfo(zoomLevel);
            zoomLevelInfos.add(info);
        }

        ArrayAdapter<ZoomLevelInfo> adapter = new ArrayAdapter<ZoomLevelInfo>(this, android.R.layout.simple_spinner_item, zoomLevelInfos);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        maxZoomSpinner.setAdapter(adapter);
        maxZoomSpinner.setSelection(zoomLevelInfos.size()-3);
    }

    private void fillQualitySpinner() {

        List<Integer> qualities = new ArrayList<Integer>();
        for (int quality = 10 ; quality <= 100; quality+=10) {
            qualities.add(quality);
        }

        ArrayAdapter<Integer> adapter = new ArrayAdapter<Integer>(this, android.R.layout.simple_spinner_item, qualities);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        qualitySpinner.setAdapter(adapter);
        qualitySpinner.setSelection(5); //60 %
    }

    private void checkTotalTiles() {

        TotalTilesRequest request = new TotalTilesRequest();

        ZoomLevelInfo zlInfo = (ZoomLevelInfo) maxZoomSpinner.getSelectedItem();
        int maxZoom = zlInfo.getLevel();

        Bounds bounds = getBounds();
        bounds.setMaxZoom(maxZoom);
        request.setBounds(bounds);

        progressDialog = ProgressDialog.show(this, null, "Counting tiles, please wait...", true);

        OfflineService service = new OfflineService();
        service.totalTiles(request, this);
    }

    private void prepareMap() {

        String mapName = mapNameField.getText().toString().trim();
        if (mapName.length() <=0) {
            Toast.makeText(this, "Please provide a name for the offline map.", Toast.LENGTH_LONG).show();
            return;
        }

        //String maxZoomStr = maxZoomLevelField.getText().toString().trim();
        //int maxZoom = Integer.parseInt(maxZoomStr);
        ZoomLevelInfo zlInfo = (ZoomLevelInfo) maxZoomSpinner.getSelectedItem();
        int maxZoom = zlInfo.getLevel();

        progressDialog = ProgressDialog.show(this, null, "Preparing map, please wait...", true);

        PrepareRequest request = new PrepareRequest();
        //request.setTileQuality(Settings.OFFLINE_TILE_QUALITY);
        int quality = (Integer)qualitySpinner.getSelectedItem();
        request.setTileQuality(quality);
        request.setTilePrefix(Settings.OFFLINE_TILE_PREFIX);
        String deviceId = AppUtil.getDeviceID(this);
        request.setDeviceId(deviceId);
        long activeLayerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        request.setActiveLayerId(activeLayerId);
        List<Long> layerIds = getLayerIds();
        request.setLayerIds(layerIds);
        String baseLayer = Session.getSession().getCurrentBaseLayer().getLayerCaption();
        request.setBaseLayer(baseLayer);
        Bounds bounds = getBounds();
        bounds.setMaxZoom(maxZoom);
        request.setBounds(bounds);

        //prepare db entry object so long, will be saved later
        entry = new OfflineMapEntry();
        entry.setName(mapName);
        entry.setActiveLayoutId(activeLayerId);
        entry.setLayerIds(getLayerIdsString());
        entry.setBaseLayer(baseLayer);
        entry.setBoundsleft(bounds.getLeft());
        entry.setBoundsRight(bounds.getRight());
        entry.setBoundsTop(bounds.getTop());
        entry.setBoundsBottom(bounds.getBottom());
        entry.setMaxZoom(maxZoom);

        Session session = Session.getSession();
        Gson gson = new Gson();
        String sessionLayers = gson.toJson(session.getLayers());
        String sessionCurrentWorkspace = gson.toJson(session.getCurrentWorkspace());
        String sessionCurrentBaseLayer = gson.toJson(session.getCurrentBaseLayer());
        String sessionCurrentActiveLayer = gson.toJson(session.getCurrentActiveLayer());
        String sessionCurrentEditTemplate = gson.toJson(session.getCurrentEditTemplate());
        String sessionCurrentEditTemplateFields = gson.toJson(session.getCurrentEditTemplateFields());

        entry.setSessionLayers(sessionLayers);
        entry.setSessionCurrentWorkspace(sessionCurrentWorkspace);
        entry.setSessionCurrentBaseLayer(sessionCurrentBaseLayer);
        entry.setSessionCurrentActiveLayer(sessionCurrentActiveLayer);
        entry.setSessionCurrentEditTemplate(sessionCurrentEditTemplate);
        entry.setSessionCurrentEditTemplateFields(sessionCurrentEditTemplateFields);

        entry.setCenterLatitude(session.getCurrentLatitude());
        entry.setCenterLongitude(session.getCurrentLongitude());

        OfflineService service = new OfflineService();
        service.prepare(request, this);
    }

    private String getLayerIdsString() {
        StringBuilder sb = new StringBuilder();
        List<Layer> layers = Session.getSession().getLayers();
        for (Layer layer : layers) {
            if (layer.getLayerId() > 0) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(layer.getLayerId());
            }
        }

        return sb.toString();
    }

    private List<Long> getLayerIds() {
        List<Long> ids = new ArrayList<Long>();
        List<Layer> layers = Session.getSession().getLayers();
        for (Layer layer : layers) {
            if ((layer.getLayerId() > 0) && (layer.getVisibility()) && (!layer.getIsBaseLayer())) {
                ids.add(layer.getLayerId());
            }
        }

        return ids;
    }


    private Bounds getBounds() {
        OneMapJavascriptInterface jsi = Session.getSession().getJavascriptInterface(null);
        Bounds bounds = new Bounds();
        bounds.setLeft(jsi.getBoundsLeft());
        bounds.setRight(jsi.getBoundsRight());
        bounds.setTop(jsi.getBoundsTop());
        bounds.setBottom(jsi.getBoundsBottom());
        bounds.setZoom(jsi.getCurrentZoomLevel() - 1);  //one level down (more zoomed out)

        return bounds;
    }

    @Override
    public void prepareCompleted(PrepareResponse response) {

        String guid = response.getGuid();
        Log.d(getClass().getCanonicalName(), guid);

        entry.setGuid(guid);
        entry.setPrepareDate(new Date());
        long rowId = OfflineMapsDAO.insertEntry(this, entry);

        progressDialog.dismiss();

        //showOfflineMapDetail(rowId);
        setResult(RESULT_OK);
        finish();
    }

    @Override
    public void prepareFailed(String reason) {
        progressDialog.dismiss();
        GuiUtil.showError(this, reason);
    }

    @Override
    public void totalTilesCompleted(TotalTilesResponse response) {
        progressDialog.dismiss();

        if (response.getTotalTiles() > Settings.MAX_TILES_TO_PREPARE) {
            String message = "You are about to generate " + response.getTotalTiles() + " tiles. The maximum allowed is " + Settings.MAX_TILES_TO_PREPARE + ". Please select a smaller area or scale and try again.";
            GuiUtil.showWarning(this, message);
            return;
        }

        //do not load the edit templates, rather use the one that the user selected
        //getEditTemplates();
        if (Session.getSession().getCurrentEditTemplate() == null) {
            //GuiUtil.showError(this, "No edit template selected.");
            //return;

            //continue with no edit template
            prepareMap();
        }
        else {
            getEditTemplateFields();
        }


    }

    @Override
    public void totalTilesFailed(String reason) {

        progressDialog.dismiss();
        GuiUtil.showError(this, reason);

    }

    /*
    private void showOfflineMapDetail(long rowId) {
        Intent intent = new Intent(this, OfflineMapDetailActivity.class);
        intent.putExtra(OfflineMapDetailActivity.ROW_ID_KEY, rowId);
        startActivity(intent);
    }
    */

    private void getEditTemplates() {
        progressDialog = ProgressDialog.show(this, null, "Loading edit templates", true);
        //EditTemplatesRequest request = new EditTemplatesRequest();
        //ParameterService service = new ParameterService();
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //service.editTemplates(layerId, request, this);
        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            api.layerEditTemplatesAsync(layerId, new ApiCallback<OKResponseParamsLayerEditTemplates>() {
                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplatesFailed(e.getMessage());
                }

                @Override
                public void onSuccess(OKResponseParamsLayerEditTemplates result, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplatesCompleted(result.getResult());
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }
    }


    public void editTemplatesCompleted(OKResponseParamsLayerEditTemplatesResult response) {

        for(EditTemplate template : response.getEditTemplates()) {
            if(template.getEditTemplateDefault()) {
                Session.getSession().setCurrentEditTemplate(template);
                break;
            }
        }

        progressDialog.dismiss();

        getEditTemplateFields();
    }


    public void editTemplatesFailed(String reason) {
        progressDialog.dismiss();
        GuiUtil.showError(this, reason);
    }

    private void getEditTemplateFields() {
        progressDialog = ProgressDialog.show(this, null, "Loading edit template fields", true);
//        ParameterService service = new ParameterService();
//        long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
//        EditTemplateFieldsRequest request = new EditTemplateFieldsRequest();
//        service.editTemplateFields(layerEditId, request, this);
        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            long editTemplateId = Session.getSession().getCurrentEditTemplate().getEditTemplateId();
            api.layerEditTemplateFieldsAsync(editTemplateId, new ApiCallback<OKResponseParamsLayerEditTemplateFields>() {
                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplateFieldsFailed(e.getMessage());
                }

                @Override
                public void onSuccess(OKResponseParamsLayerEditTemplateFields result, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplateFieldsCompleted(result.getResult());
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }
    }


    public void editTemplateFieldsCompleted(OKResponseParamsLayerEditTemplateFieldsResult response) {
        List<EditTemplateField> fields = response.getEditTemplateFields();
        Session.getSession().setCurrentEditTemplateFields(fields);

        progressDialog.dismiss();

        prepareMap();
    }


    public void editTemplateFieldsFailed(String reason) {
        progressDialog.dismiss();
        GuiUtil.showError(this, reason);
    }

    private class ZoomLevelInfo {

        private int level;

        public ZoomLevelInfo(int level) {
            this.level = level;
        }

        public int getLevel() {
            return level;
        }

        public String getDescription() {
            int scale = -1;
            String description = "Level " + level;

            try {
                scale = scales[level];
                description += "  (1:" + scale + ")";
            }
            catch (ArrayIndexOutOfBoundsException e) {
                //ignore, we do not know the scale for the specified level
            }

            return description;
        }


        @Override
        public String toString() {
            return getDescription();
        }
    }
}
