package org.quidity.demo.activity;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.crashlytics.android.answers.Answers;
import com.crashlytics.android.answers.CustomEvent;
import com.google.android.gms.analytics.Tracker;

import org.quidity.demo.OneMapApplication;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.activity.adapter.OfflineMapViewActivity;
import org.quidity.demo.db.OfflineMapEntry;
import org.quidity.demo.db.OfflineMapsDAO;
import org.quidity.demo.db.OfflineUpdatesDAO;
import org.quidity.demo.helper.OfflineUpdatesSyncHelper;
import org.quidity.demo.helper.OfflineUpdatesSyncListener;
import org.quidity.demo.helper.WorkspaceHelper;
import org.quidity.demo.mapi.offline.OfflineService;
import org.quidity.demo.mapi.offline.StatusRequest;
import org.quidity.demo.mapi.offline.StatusResponse;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.List;
import java.util.Map;
import java.util.Set;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.Configuration;
import io.swagger.client.api.AuthorizationApi;
import io.swagger.client.model.ModelApiResponse;
import io.swagger.client.model.OKResponseAuthLogin;
import io.swagger.client.model.User;
import io.swagger.client.model.Workspace;

//Github test comment - ignore
public class Login2Activity extends AppCompatActivity implements
        WorkspaceHelper.WorkspaceListener, TextWatcher, CompoundButton.OnCheckedChangeListener, OfflineUpdatesSyncListener {

    private static final String TAG = Login2Activity.class.getCanonicalName();

    private EditText usernameField;
    private EditText passwordField;
    private Button submitButton;
    private TextView registerView;
    private TextView forgotPasswordView;
    private ProgressDialog progressDialog;
    private CheckBox savePasswordField;
    private CheckBox offlineModeField;
    private Spinner offlineMapsSpinner;

    //private LoginResponse response;
    private OKResponseAuthLogin response;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login2);

        //begin new session
        Session.resetSession();

        int orientation = GuiUtil.getScreenOrientation(this);
        Session.getSession().setOrientation(orientation);

        AppUtil.initActivity(this);

        usernameField = (EditText)findViewById(R.id.username);
        passwordField = (EditText)findViewById(R.id.password);
        savePasswordField = (CheckBox)findViewById(R.id.save_password);
        submitButton = (Button)findViewById(R.id.submit_button);
        registerView = (TextView)findViewById(R.id.register);
        forgotPasswordView = (TextView)findViewById(R.id.forgot_password);

        registerView.setText(Html.fromHtml("<a href='http://www.1map.co.za/register'>Register</a>"));
        registerView.setMovementMethod(LinkMovementMethod.getInstance());

        forgotPasswordView.setText(Html.fromHtml("<a href='http://www.1map.co.za/forgot_password'>Forgot Password</a>"));
        forgotPasswordView.setMovementMethod(LinkMovementMethod.getInstance());

        Settings settings = Settings.getSettings(this);
        String username = settings.getPreviousUsername();
        usernameField.setText(username);

        boolean savePassword = settings.isSavePassword();
        savePasswordField.setChecked(savePassword);
        if (savePassword) {
            passwordField.setText(settings.getPreviousPassword());
        }

        if (username.trim().length() > 0) {
            if (passwordField.getText().toString().trim().length() == 0) {
                passwordField.requestFocus();
            }
        }
        else {
            usernameField.requestFocus();
        }

        usernameField.addTextChangedListener(this);

        submitButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                attemptLogin();
            }
        });

        if (Settings.getSettings(this).isAutoClearAttachmentsCacheEnabled()) {
            AppUtil.clearAttachmentsCache(this);
        }

        offlineModeField = (CheckBox)findViewById(R.id.offline_mode);
        offlineModeField.setChecked(settings.isPreviousOfflineMode());
        offlineModeField.setOnCheckedChangeListener(this);
        offlineMapsSpinner = (Spinner)findViewById(R.id.offline_maps);
        updateOfflineGUI();

    }


//    private boolean testNewApi() {
//
//        Thread thread = new Thread(new Runnable() {
//            @Override
//            public void run() {
//
//                try {
//                    ApiClient client = Configuration.getDefaultApiClient();
//                    client.setBasePath("https://www.1map.co.za/api/v1");
//
//                    AuthorizationApi auth = new AuthorizationApi(client);
//                    String email = "ferdie@mobilica.co.za";
//                    String password = "password";
//                    InlineResponse200 res = auth.loginUser(email, password);
//                    User user = res.getResult();
//                    String qtime = res.getApiResponse().getQtime();
//                    Log.d(TAG, "Operation took " + qtime);
//                    Log.d(TAG, "Logged in as " + user.getUserName());
//                }
//                catch (ApiException e) {
//                    Log.e(TAG, e.getMessage(), e);
//                }
//
//            }
//        });
//        thread.start();
//
//
//        return true;
//    }


    /**
     * Attempts to sign in or register the account specified by the login form.
     * If there are form errors (invalid email, missing fields, etc.), the
     * errors are presented and no actual login attempt is made.
     */
    public void attemptLogin() {

        submitButton.setEnabled(false);

        // Reset errors.
        usernameField.setError(null);
        passwordField.setError(null);

        // Store values at the time of the login attempt.
        String email = usernameField.getText().toString();
        String password = passwordField.getText().toString();

        boolean cancel = false;
        View focusView = null;


        // Check for a valid password, if the user entered one.
        if (!TextUtils.isEmpty(password) && !isPasswordValid(password)) {
            passwordField.setError(getString(R.string.error_invalid_password));
            focusView = passwordField;
            cancel = true;
        }

        // Check for a valid email address.
        if (TextUtils.isEmpty(email)) {
            usernameField.setError(getString(R.string.error_field_required));
            focusView = usernameField;
            cancel = true;
        } else if (!isEmailValid(email)) {
            usernameField.setError(getString(R.string.error_invalid_email));
            focusView = usernameField;
            cancel = true;
        }

        if (cancel) {
            // There was an error; don't attempt login and focus the first
            // form field with an error.
            submitButton.setEnabled(true);
            focusView.requestFocus();
        } else {

            if (offlineModeField.isChecked()) {
                if (offlineMapsSpinner.getSelectedItem() == null) {
                    Toast.makeText(this, "You did not select an Offline Map", Toast.LENGTH_SHORT).show();
                    submitButton.setEnabled(true);
                    return;
                }
                doOfflineLogin(email, password);
            }
            else {
                doOnlineLogin(email, password);
            }

        }
    }

    private void doOnlineLogin(String email, String password) {

        Session.getSession().setOfflineMode(false);

        // Show a progress spinner, and kick off a background task to
        // perform the user login attempt.
        showProgress(true);

        int versionCode = getVersionCode();

//        AuthorizationService authorizationService = new AuthorizationService();
//        LoginRequest req = new LoginRequest(email, password, versionCode);
//        authorizationService.login(req, this);

        try {
            AuthorizationApi auth = new AuthorizationApi(AppUtil.getApiClient());
            auth.loginUserAsync(email, password, new ApiCallback<OKResponseAuthLogin>() {
                @Override
                public void onFailure(final ApiException e, final int statusCode, final Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            onLoginFailure(e, statusCode, responseHeaders);
                        }
                    });

                }

                @Override
                public void onSuccess(final OKResponseAuthLogin result, final int statusCode, final Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            onLoginSuccess(result, statusCode, responseHeaders);
                        }
                    });

                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }



    }

    private void doOfflineLogin(String email, String password) {

        Session.getSession().setOfflineMode(true);

        Settings settings = Settings.getSettings(this);

        if (email.equalsIgnoreCase(settings.getPreviousUsername()) && password.equalsIgnoreCase(settings.getPreviousPassword())) {
            //success

            OfflineMapEntry entry = (OfflineMapEntry)offlineMapsSpinner.getSelectedItem();

            WorkspaceHelper helper = new WorkspaceHelper();
            helper.switchToOfflineWorkspace(this, entry.getGuid());

            showMapScreen(entry.getGuid());
            /*
            Intent intent = new Intent(Login2Activity.this, OfflineMapViewActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            intent.putExtra(OfflineMapViewActivity.MAP_GUID_KEY, entry.getGuid());
            startActivity(intent);
            finish();
            */
        }
        else {
            submitButton.setEnabled(true);
            Toast.makeText(this, "Invalid username or password", Toast.LENGTH_LONG).show();
        }

    }

    private int getVersionCode() {
        int versionCode = -1;
        try {
            versionCode = getPackageManager().getPackageInfo(getPackageName(), 0).versionCode;
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    private boolean isEmailValid(String email) {
        //TODO: Replace this with your own logic
        //return email.contains("@");
        return true;
    }

    private boolean isPasswordValid(String password) {
        //TODO: Replace this with your own logic
        //return password.length() > 4;
        return true;
    }

    private void showProgress(boolean show) {

        if (progressDialog == null) {
            progressDialog = new ProgressDialog(this);
            progressDialog.setIndeterminate(true);
            progressDialog.setMessage("Loading");
        }

        if (show) {
            progressDialog.show();
        }
        else {
            progressDialog.dismiss();
        }

    }

//    @Override
//    public void loginCompleted(LoginResponse response) {
//
//        this.response = response;
//
//        if (response.getMessage().contains("Your version is outdated")) {
//            showProgress(false);
//            submitButton.setEnabled(true);
//
//            AlertDialog.Builder builder = new AlertDialog.Builder(this);
//            builder.setTitle("New Version Available");
//            builder.setMessage("A new version is available. Do you want to install the latest version now?");
//            builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
//                @Override
//                public void onClick(DialogInterface dialogInterface, int i) {
//
//                    final String appPackageName = getPackageName();
//                    try {
//                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
//                    } catch (android.content.ActivityNotFoundException anfe) {
//                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + appPackageName)));
//                    }
//
//                    finish();
//                }
//            });
//            builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
//                @Override
//                public void onClick(DialogInterface dialogInterface, int i) {
//                    processResponse();
//                }
//            });
//            builder.show();
//
//            return;
//        }
//
//        processResponse();
//
//    }
//
//
//    @Override
//    public void loginFailed(String reason) {
//
//        showProgress(false);
//        submitButton.setEnabled(true);
//
//        if(reason.contains("Your version is outdated")) {
//            AlertDialog.Builder builder = new AlertDialog.Builder(this);
//            builder.setTitle("Version Not Supported");
//            builder.setMessage("Your version is not supported anymore. Please install the latest version.");
//            builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
//                @Override
//                public void onClick(DialogInterface dialogInterface, int i) {
//
//                    final String appPackageName = getPackageName();
//                    try {
//                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
//                    } catch (android.content.ActivityNotFoundException anfe) {
//                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + appPackageName)));
//                    }
//
//                    finish();
//                }
//            });
//            builder.show();
//
//            return;
//        }
//
//        if (reason.contains("Unauthorized (401)")) {
//            GuiUtil.showError(this, "Incorrect email or password. Please try again.");
//        }
//        else if(reason.contains("999")) {
//            GuiUtil.showError(this, "No Data Service.");
//        }
//        else {
//            GuiUtil.showError(this, "Could not log you in. " + reason);
//        }
//
//    }



    public void onLoginSuccess(OKResponseAuthLogin result, int statusCode, Map<String, List<String>> responseHeaders) {

        this.response = result;

        if (response.getApiResponse().getMessage().contains("Your version is outdated")) {
            showProgress(false);
            submitButton.setEnabled(true);

            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setTitle("New Version Available");
            builder.setMessage("A new version is available. Do you want to install the latest version now?");
            builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {

                    final String appPackageName = getPackageName();
                    try {
                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
                    } catch (android.content.ActivityNotFoundException anfe) {
                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + appPackageName)));
                    }

                    finish();
                }
            });
            builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {
                    processResponse();
                }
            });
            builder.show();

            return;
        }

        processResponse();
    }

    public void onLoginFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
        showProgress(false);
        submitButton.setEnabled(true);

        if(e.getMessage().contains("Your version is outdated")) {
            AlertDialog.Builder builder = new AlertDialog.Builder(this);
            builder.setTitle("Version Not Supported");
            builder.setMessage("Your version is not supported anymore. Please install the latest version.");
            builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialogInterface, int i) {

                    final String appPackageName = getPackageName();
                    try {
                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
                    } catch (android.content.ActivityNotFoundException anfe) {
                        startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("https://play.google.com/store/apps/details?id=" + appPackageName)));
                    }

                    finish();
                }
            });
            builder.show();

            return;
        }

        if (e.getMessage().contains("Unauthorized (401)")) {
            GuiUtil.showError(this, "Incorrect email or password. Please try again.");
        }
        else if(e.getMessage().contains("999")) {
            GuiUtil.showError(this, "No Data Service.");
        }
        else {
            GuiUtil.showError(this, "Could not log you in. " + e.getMessage());
        }
    }


    private void processResponse() {

        //save access token
        String token = response.getApiToken().getToken();
        Log.d(TAG, token);
        AppUtil.getApiClient().setApiKey(token);
        Session.getSession().setToken(token);

        Session.getSession().setWorkspaces(response.getResult().getWorkspaces());



        //pass user id to tracker
        //int userId = Integer.parseInt(response.getSerial()) - 1000;
        long userId = response.getResult().getUserId();
        Tracker tracker = ((OneMapApplication)getApplication()).getTracker();
        tracker.set("&uid", Long.toString(userId));

        long lSerial = userId + 1000;
        String serial = Long.toString(lSerial);
        Session.getSession().setSerial(serial);


        //remember username so we can auto populate it next time
        Settings settings = Settings.getSettings(this);
        String username = usernameField.getText().toString();
        settings.setPreviousUsername(username);

        //Save user id also, we need it to auto populate user_id edit fields
        settings.setPreviousUserId(userId);

        //save password if required
        boolean savePassword = savePasswordField.isChecked();
        settings.setSavePassword(savePassword);
        if (savePassword) {
            String password = passwordField.getText().toString();
            settings.setPreviousPassword(password);
        }
        else {
            settings.setPreviousPassword("");
        }

        List<Workspace> workspaces = response.getResult().getWorkspaces();
        if (workspaces != null && workspaces.size() > 0) {

            Workspace defaultWorkspace = workspaces.get(0);
            for (Workspace workspace : workspaces) {
                if (workspace.getDefault()) {
                    defaultWorkspace = workspace;
                    break;
                }
            }

            WorkspaceHelper helper = new WorkspaceHelper();
            helper.switchToWorkspace(defaultWorkspace, this);
        }

    }


    private List<OfflineMapEntry> offlineMapEntriess;
    private int offlineMapEntryIndex = 0;

    @Override
    public void onSwitchToWorkspaceCompleted(Workspace newWorkspace) {

        //check if there are any offline maps prepared that are ready to be download
        offlineMapEntriess = OfflineMapsDAO.getAllEntries(this);
        if (offlineMapEntriess.size() > 0) {
            offlineMapEntryIndex = 0;
            OfflineMapEntry entry = offlineMapEntriess.get(offlineMapEntryIndex);
            checkOfflineMapStatus(entry);
        }
        else {
            showProgress(false);
            showMapScreen(null);
        }



    }

    private void checkOfflineMapStatus(OfflineMapEntry entry) {

        if (entry.isPrepared()) {
            checkNextOfflineMapStatus();
            return;
        }

        OfflineService service = new OfflineService();
        StatusRequest request = new StatusRequest();
        request.setGuid(entry.getGuid());

        service.status(request, new OfflineService.StatusListener() {
            @Override
            public void statusCompleted(StatusResponse response) {

                if(response.getStatus().getStatus().trim().equalsIgnoreCase("Done")) {
                    Toast.makeText(Login2Activity.this, "There are offline maps ready to be downloaded.", Toast.LENGTH_LONG).show();
                }

                checkNextOfflineMapStatus();

            }

            @Override
            public void statusFailed(String reason) {
                //just ignore the error and continue
                checkOfflineUpdates();
            }
        });
    }

    private void checkNextOfflineMapStatus() {

        offlineMapEntryIndex++;
        if (offlineMapEntryIndex < (offlineMapEntriess.size())) {
            OfflineMapEntry nextEntry = offlineMapEntriess.get(offlineMapEntryIndex);
            checkOfflineMapStatus(nextEntry);
        }
        else {
            checkOfflineUpdates();
        }

    }

    private void checkOfflineUpdates() {

        //check if there are any offline updates that we need to sync first
        if (OfflineUpdatesDAO.hasOfflineUpdates(this)) {
            showProgress(false);

            OfflineUpdatesSyncHelper helper = new OfflineUpdatesSyncHelper(this);
            helper.startOfflineUpdatesSync(this);
        }
        else {
            showProgress(false);
            showMapScreen(null);
        }
        //***************************************************************

    }

    @Override
    public void offlineUpdatesSynCompleted() {
        showMapScreen(null);
    }

    private void showMapScreen(String offlineMapGuid) {
        Intent intent = new Intent(Login2Activity.this, OpenLayersMapActivity.class);
        //intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        if (offlineMapGuid != null) {
            intent.putExtra(OpenLayersMapActivity.EXTRA_OFFLINE_MAP_GUID, offlineMapGuid);
        }
        startActivity(intent);
        finish();

    }




    @Override
    public void onSwitchToWorkspaceFailed(String reason) {
        showProgress(false);
        submitButton.setEnabled(false);

        GuiUtil.showError(this, "Could not switch to default workspace. " + reason);
    }

    /*
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.login2, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
    */

    @Override
    public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {

    }

    @Override
    public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        //clear password field when user starts editing username
        passwordField.setText("");
    }

    @Override
    public void afterTextChanged(Editable editable) {

    }

    @Override
    public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
        if (compoundButton == offlineModeField) {
            hideKeyboard();
            updateOfflineGUI();
        }
    }

    private void updateOfflineGUI() {
        if (offlineModeField.isChecked()) {
            List<OfflineMapEntry> entries = OfflineMapsDAO.getPreparedEntries(this);
            OfflineMapsAdapter adapter = new OfflineMapsAdapter(this, entries);
            offlineMapsSpinner.setAdapter(adapter);
            offlineMapsSpinner.setVisibility(View.VISIBLE);

            if (entries.size() > 1) {
                offlineMapsSpinner.performClick();
            }
        }
        else {
            offlineMapsSpinner.setVisibility(View.GONE);
        }

    }

    private class OfflineMapsAdapter extends ArrayAdapter<OfflineMapEntry> {

        private Context context;
        private List<OfflineMapEntry> offlineMaps;

        public OfflineMapsAdapter(Context context, List<OfflineMapEntry> offlineMaps) {
            //super(context, R.layout.attachment_item);
            super(context, android.R.layout.simple_spinner_item);
            //setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            setDropDownViewResource(android.R.layout.select_dialog_singlechoice);

            this.context = context;
            this.offlineMaps = offlineMaps;
        }

        @Override
        public int getCount() {
            return offlineMaps.size();
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            View view = convertView;

            if (view == null) {
                LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                //view = inflater.inflate(R.layout.attachment_item2, parent, false);
                view = inflater.inflate(android.R.layout.simple_spinner_item, parent, false);
            }

            //ImageView iconView = (ImageView)view.findViewById(R.id.icon);
            //TextView firstLineView = (TextView)view.findViewById(R.id.firstLine);
            //TextView secondLineView = (TextView)view.findViewById(R.id.secondLine);
            TextView firstLineView = (TextView)view.findViewById(android.R.id.text1);

            OfflineMapEntry entry = offlineMaps.get(position);

            firstLineView.setText(entry.getName());
            //secondLineView.setText(entry.getGuid());
            //iconView.setImageResource(R.drawable.audio);

            return view;
        }


        @Override
        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            View view = convertView;

            if (view == null) {
                LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                //view = inflater.inflate(R.layout.attachment_item2, parent, false);
                view = inflater.inflate(android.R.layout.select_dialog_singlechoice, parent, false);
            }

            //ImageView iconView = (ImageView)view.findViewById(R.id.icon);
            //TextView firstLineView = (TextView)view.findViewById(R.id.firstLine);
            //TextView secondLineView = (TextView)view.findViewById(R.id.secondLine);
            TextView firstLineView = (TextView)view.findViewById(android.R.id.text1);

            OfflineMapEntry entry = offlineMaps.get(position);

            firstLineView.setText(entry.getName());
            //secondLineView.setText(entry.getGuid());
            //iconView.setImageResource(R.drawable.audio);

            return view;
        }


        @Override
        public OfflineMapEntry getItem(int position) {
            return offlineMaps.get(position);
        }
    }

    private void hideKeyboard() {
        // Check if no view has focus:
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

}
