package org.quidity.demo.activity;

import android.app.Activity;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;

public class GPSInfoActivity extends Activity implements LocationListener {

    private TextView latitudeView;
    private TextView longitudeView;
    private TextView altitudeView;
    private TextView accuracyView;
    private TextView speedView;
    private TextView bearingView;

    private LocationManager locationManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_gpsinfo);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        latitudeView = (TextView)findViewById(R.id.latitude);
        longitudeView = (TextView)findViewById(R.id.longitude);
        altitudeView = (TextView)findViewById(R.id.altitude);
        accuracyView = (TextView)findViewById(R.id.accuracy);
        speedView = (TextView)findViewById(R.id.speed);
        bearingView = (TextView)findViewById(R.id.bearing);

        locationManager = (LocationManager)getSystemService(LOCATION_SERVICE);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void startGPS() {
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, this);
    }

    private void stopGPS() {
        locationManager.removeUpdates(this);
    }

    @Override
    protected void onPause() {
        stopGPS();
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
        startGPS();
    }

    @Override
    public void onLocationChanged(Location location) {
        latitudeView.setText(Double.toString(location.getLatitude()));
        longitudeView.setText(Double.toString(location.getLongitude()));
        if (location.hasAltitude()) {
            altitudeView.setText(Double.toString(location.getAltitude()) + "m");
        }
        if (location.hasAccuracy()) {
            accuracyView.setText(Double.toString(location.getAccuracy()) + "m");
        }
        if (location.hasSpeed()) {
            float speedMps = location.getSpeed();
            float speedKmph = speedMps * 3.6f;
            speedView.setText(Float.toString(speedKmph) + "km/h");
        }
        if (location.hasBearing()) {
            bearingView.setText(Float.toString(location.getBearing()));
        }
    }

    @Override
    public void onStatusChanged(String s, int i, Bundle bundle) {

    }

    @Override
    public void onProviderEnabled(String s) {

    }

    @Override
    public void onProviderDisabled(String s) {

    }

}
