package org.quidity.demo.activity;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageButton;
import android.widget.PopupMenu;
import android.widget.Toast;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.fragment.FeatureInfoFragment;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttributesBasicApi;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseAttributes;
import io.swagger.client.model.OKResponseAttributesDelete;
import io.swagger.client.model.OKResponseAttributesDeleteResult;
import io.swagger.client.model.OKResponseAttributesResult;

public class FeatureInfoPagerActivity extends FragmentActivity implements
        View.OnClickListener {

    private static final String TAG = FeatureInfoPagerActivity.class.getCanonicalName();

    private ViewPager pager;
    private ProgressDialog progressDialog;
    private ImageButton editButton;
    private ImageButton attachmentsButton;
    private ImageButton moveButton;
    private ImageButton deleteButton;

    private static final int REQ_EDIT = 100;

    private boolean deleteAll = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_feature_info_pager);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        editButton = (ImageButton)findViewById(R.id.edit);
        editButton.setOnClickListener(this);

        attachmentsButton = (ImageButton)findViewById(R.id.attachments);
        attachmentsButton.setOnClickListener(this);

        moveButton = (ImageButton)findViewById(R.id.move);
        moveButton.setOnClickListener(this);

        deleteButton = (ImageButton)findViewById(R.id.delete);
        deleteButton.setOnClickListener(this);

        updateButtons();
        loadAdapter();
    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    private void loadAdapter() {
        FeaturePagerAdapter adapter = new FeaturePagerAdapter(getSupportFragmentManager());
        pager = (ViewPager)findViewById(R.id.pager);
        pager.setAdapter(adapter);

        pager.setCurrentItem(Session.getSession().getSelectedFeatureIndex());
    }

    private void updateButtons() {
        Layer activeLayer = Session.getSession().getCurrentActiveLayer();
        boolean canEdit = false;
        boolean canEditSpatial = false;
        if (activeLayer != null) {
            canEdit = activeLayer.getCanEditAttributes()
                    && Session.getSession().getCurrentEditTemplate() != null;

            canEditSpatial = activeLayer.getCanEditSpatial();
        }
        else {
            canEdit = false;
        }

        editButton.setEnabled(canEdit);
        editButton.setClickable(canEdit);

        //attachmentsButton.setEnabled(canEdit);
        //attachmentsButton.setClickable(canEdit);
        attachmentsButton.setEnabled(true);
        attachmentsButton.setClickable(true);

        moveButton.setEnabled(canEditSpatial);
        moveButton.setClickable(canEditSpatial);

        deleteButton.setEnabled(canEditSpatial);
        deleteButton.setClickable(canEditSpatial);
    }

    /*
    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem editMenu = menu.findItem(R.id.action_edit);
        MenuItem attachmentsMenu = menu.findItem(R.id.action_attachments);

        Layer activeLayer = Session.getSession().getCurrentActiveLayer();
        boolean canEdit = false;
        if (activeLayer != null) {
            canEdit = activeLayer.isEditMetadata()
                && Session.getSession().getCurrentEditTemplate() != null;
        }
        else {
            canEdit = false;
        }

        editMenu.setEnabled(canEdit);
        attachmentsMenu.setEnabled(canEdit);

        return super.onPrepareOptionsMenu(menu);
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.feature_info_pager, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.action_edit) {
            Session session = Session.getSession();
            session.setEditMode(Session.EDIT_MODE_UPDATE);
            session.setSelectedFeatureIndex(pager.getCurrentItem());

            Intent intent = new Intent(this, FeatureEditActivity.class);
            startActivityForResult(intent, REQ_EDIT);


            return true;
        }
        return super.onOptionsItemSelected(item);
    }
    */

    @Override
    public void onClick(View view) {
        Session session = Session.getSession();

        if(view == editButton) {
            session.setEditMode(Session.EDIT_MODE_UPDATE);
            session.setSelectedFeatureIndex(pager.getCurrentItem());

            Intent intent = new Intent(this, FeatureEditActivity.class);
            startActivityForResult(intent, REQ_EDIT);

        }
        else if(view == attachmentsButton) {
            session.setEditMode(Session.EDIT_MODE_UPDATE);
            session.setSelectedFeatureIndex(pager.getCurrentItem());

            Intent intent = new Intent(this, AttachmentsActivity.class);
            startActivityForResult(intent, REQ_EDIT);
        }
        else if(view == moveButton) {
            move();
        }
        else if(view == deleteButton) {
            delete();
        }
    }

    private void move() {
        Session session = Session.getSession();

        if (session.getSelectedFeatures().size() == 1) {
            moveCurrent();
        }
        else if(session.getSelectedFeatures().size() > 1) {
            showMoveOptions();
        }
    }

    private void moveCurrent() {
        Session.getSession().setSelectedFeatureIndex(pager.getCurrentItem());
        Session.getSession().setMoveMode(Session.MOVE_MODE_CURRENT);
        setResult(RESULT_OK);
        finish();
    }

    private void moveAll() {
        Session.getSession().setMoveMode(Session.MOVE_MODE_ALL);
        setResult(RESULT_OK);
        finish();
    }


    private void delete() {
        Session session = Session.getSession();

        if (session.getSelectedFeatures().size() == 1) {
            confirmDeleteFeature(0);
        }
        else if(session.getSelectedFeatures().size() > 1) {
            showDeleteOptions();
        }
    }

    private void showDeleteOptions() {
        PopupMenu popup = new PopupMenu(this, deleteButton);
        popup.getMenuInflater().inflate(R.menu.menu_delete_popup, popup.getMenu());
        popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
            @Override
            public boolean onMenuItemClick(MenuItem menuItem) {

                int id = menuItem.getItemId();

                if (id == R.id.action_delete_current) {
                    deleteAll = false;
                    confirmDeleteFeature(pager.getCurrentItem());
                    return true;
                }
                else if (id == R.id.action_delete_all) {
                    deleteAll = true;
                    confirmDeleteAll();
                    return true;
                }

                return true;
            }
        });

        popup.show();
    }

    private void showMoveOptions() {
        PopupMenu popup = new PopupMenu(this, moveButton);
        popup.getMenuInflater().inflate(R.menu.menu_move_popup, popup.getMenu());
        popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
            @Override
            public boolean onMenuItemClick(MenuItem menuItem) {

                int id = menuItem.getItemId();

                if (id == R.id.action_move_current) {
                    moveCurrent();
                    return true;
                }
                else if (id == R.id.action_move_all) {
                    moveAll();
                    return true;
                }

                return true;
            }
        });

        popup.show();
    }

    private void confirmDeleteFeature(final int featureIndex) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Confirm Delete");
        builder.setMessage("Are you sure you want to delete the current object?");
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                progressDialog = ProgressDialog.show(FeatureInfoPagerActivity.this, null, "Deleting...", true);
                deleteFeature(featureIndex);
            }
        });
        builder.setNegativeButton("Cancel", null);
        builder.show();
    }

    private void confirmDeleteAll() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Confirm Delete All");
        int featureCount = Session.getSession().getSelectedFeatures().size();
        builder.setMessage("Are you sure you want to delete " + featureCount + " objects?");
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                progressDialog = ProgressDialog.show(FeatureInfoPagerActivity.this, null, "Deleting...", true);
                deleteFeature(0);   //start by delete the first feature
            }
        });
        builder.setNegativeButton("Cancel", null);
        builder.show();
    }

    private void deleteFeature(int featureIndex) {

//        AttributesService service = new AttributesService();
//        DeleteAttributesRequest request = new DeleteAttributesRequest();
//        request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//        request.setPrimaryId(AppUtil.getPrimaryIdForFeature(featureIndex));
//        service.deleteAttributes(request, this);

        try {
            AttributesBasicApi api = new AttributesBasicApi(AppUtil.getApiClient());
            long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
            long primaryId = AppUtil.getPrimaryIdForFeature(featureIndex);
            api.attributesPrimaryIdDeleteAsync(layerId, primaryId, new ApiCallback<OKResponseAttributesDelete>() {
                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    deleteAttributesFailed(e.getMessage());
                }

                @Override
                public void onSuccess(OKResponseAttributesDelete result, int statusCode, Map<String, List<String>> responseHeaders) {
                    deleteAttributesCompleted(result.getResult());
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }

    }


    public void deleteAttributesCompleted(OKResponseAttributesDeleteResult response) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {

                boolean weAreDone = false;

                List<FeatureWithAttachments> features = Session.getSession().getSelectedFeatures();

                if (deleteAll) {
                    //remove item 0 and delete the next item if there is more remaining
                    features.remove(0);
                    if (features.size() > 0) {
                        //delete the next one
                        deleteFeature(0);
                    }
                    else {
                        weAreDone = true;
                        progressDialog.dismiss();
                        Toast.makeText(FeatureInfoPagerActivity.this, "All objects deleted.", Toast.LENGTH_SHORT).show();
                    }

                }
                else {
                    features.remove(pager.getCurrentItem());
                    weAreDone = true;
                    progressDialog.dismiss();
                    Toast.makeText(FeatureInfoPagerActivity.this, "Object deleted.", Toast.LENGTH_SHORT).show();
                }

                if(weAreDone) {

                    if(features.size() > 0) {
                        //refresh the GUI
                        loadAdapter();
                    }
                    else {
                        //close this screen
                        setResult(RESULT_OK);
                        finish();
                    }

                }

            }

        });


    }


    public void deleteAttributesFailed(String reason) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if ((requestCode == REQ_EDIT)) {
            if (resultCode == RESULT_OK) {
                //refresh
                reloadFeatureInfo();
            }
        }
    }

    private void reloadFeatureInfo() {

        if (Session.getSession().isOfflineMode()) {
            loadAdapter();
        }
        else {
            progressDialog = ProgressDialog.show(this, null, "Loading", true);

//            AttributesService service = new AttributesService();
//            AttributesByPrimaryIdRequest request = new AttributesByPrimaryIdRequest();
//            request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//            request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
//            request.setShowAttachments(true);
//            service.getAttributesByPrimaryId(request, this);

            try {
                AttributesBasicApi api = new AttributesBasicApi(AppUtil.getApiClient());
                long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
                long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
                api.attributesPrimaryIdSearchAsync(layerId, primaryId, "Yes", new ApiCallback<OKResponseAttributes>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        featuresFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttributes result, int statusCode, Map<String, List<String>> responseHeaders) {
                        featuresCompleted(result.getResult());
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }
    }


    public void featuresCompleted(OKResponseAttributesResult response) {
        progressDialog.dismiss();

        //Session.getSession().setSelectedFeatures(response.getItems().getFeatures());
        //Session.getSession().setSelectedFeatureIndex(0);


        try {
            Session session = Session.getSession();

            //update the selected feature
            FeatureWithAttachments currentFeature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());
            //Assumption: this method returns only one feature
            FeatureWithAttachments updateFeature = response.getGeomResult().getFeatures().get(0);
            currentFeature = updateFeature;

            loadAdapter();
        }
        catch(Exception e) {
            e.printStackTrace();
        }

    }


    public void featuresFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }

    private class FeaturePagerAdapter extends FragmentStatePagerAdapter {



        private FeaturePagerAdapter(FragmentManager fm) {
            super(fm);

        }

        @Override
        public Fragment getItem(int i) {
            Fragment fragment = new FeatureInfoFragment();

            //set feature index
            Bundle args = new Bundle();
            args.putInt(FeatureInfoFragment.FEATURE_INDEX_ARG, i);
            fragment.setArguments(args);

            return fragment;
        }

        @Override
        public int getCount() {
            return Session.getSession().getSelectedFeatures2().size();
        }

        @Override
        public CharSequence getPageTitle(int position) {
            return "Feature " + (position + 1);
        }
    }
}
