package org.quidity.demo.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.app.TimePickerDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.renderscript.Script;
import android.support.design.widget.TextInputLayout;
import android.support.v7.app.AppCompatActivity;
import android.text.InputFilter;
import android.text.InputType;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

import com.github.filosganga.geogson.model.Feature;
import com.github.filosganga.geogson.model.Point;
import com.google.android.gms.drive.internal.GetDriveIdFromUniqueIdentifierRequest;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonPrimitive;
import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.json.JSONException;
import org.json.JSONObject;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.OfflineUpdateEntry;
import org.quidity.demo.db.OfflineUpdatesDAO;
import org.quidity.demo.helper.FieldHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;


import java.io.FileWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.FileReader;
import java.lang.reflect.Type;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttributesBasicApi;
import io.swagger.client.api.ParametersApi;
import io.swagger.client.api.SpatialApi;
import io.swagger.client.model.AttributesCollection;
import io.swagger.client.model.EditTemplateField;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureBasicProperties;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.FeatureWithoutAttachmentsProperties;
import io.swagger.client.model.FeatureWithoutPropertiesAndAttachments;
import io.swagger.client.model.Field;
import io.swagger.client.model.Geometry;
import io.swagger.client.model.OKResponseAttachmentsUpdate;
import io.swagger.client.model.OKResponseAttributesAdd;
import io.swagger.client.model.OKResponseAttributesUpdate;
import io.swagger.client.model.OKResponseAttributesUpdateResult;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFields;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFieldsResult;
import io.swagger.client.model.Point2D;
import io.swagger.client.model.Polygon;



public class FeatureEditActivity extends AppCompatActivity
        implements
        DatePickerDialog.OnDateSetListener,
        TimePickerDialog.OnTimeSetListener,
        View.OnClickListener
{

    private static String TAG = FeatureEditActivity.class.getCanonicalName();

    private static final long LOCATION_TIMEOUT = 15;    //seconds

    private static final int REQUEST_PICK_COLOR = 100;
    private static final int REQ_EDIT_TEMPLATE = 200;
    private static List<FieldHelper> fieldHelpers;
    private List<EditTemplateField> fields;
    private ViewGroup formLayout;
    private Feature feature;
    private boolean isUpdateMode;
    private SimpleDateFormat sdfGeoDate;    //date format for Geoserver
    private SimpleDateFormat sdfGeoDateTime;    //date format for Geoserver
    private SimpleDateFormat sdfGeoDateTimeZone;  //date format for Geoserver with timezone
    private SimpleDateFormat sdfAppDate;   //date format used by this app for display purposes
    private SimpleDateFormat sdfAppDateTime;   //date format used by this app for display purposes
    //private Map<String, View> viewMap;
    private TextView currentTextView;
    private FieldHelper currentFieldHelper;     //the field that is currently being edited
    private Button cancelButton;
    private Button saveButton;
    private ProgressDialog progressDialog;

    private LocationManager locationManager;
    private final CountDownLatch locationLatch = new CountDownLatch(1);
    private Location location;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_feature_edit);

        AppUtil.initActivity(this);

//        //restore session state
//        if (savedInstanceState != null) {
//            Session savedSession = (Session) savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        formLayout = (ViewGroup) findViewById(R.id.form_layout);

        cancelButton = (Button) findViewById(R.id.cancel);
        cancelButton.setOnClickListener(this);
        saveButton = (Button) findViewById(R.id.save);
        saveButton.setOnClickListener(this);

        sdfGeoDate = new SimpleDateFormat("yyyy-MM-dd");
        sdfGeoDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
        sdfGeoDateTimeZone = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ");
        sdfAppDate = new SimpleDateFormat("yyyy/MM/dd");
        sdfAppDateTime = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

        isUpdateMode = Session.getSession().getEditMode().equalsIgnoreCase(Session.EDIT_MODE_UPDATE);
        if (isUpdateMode) {
            setTitle("Edit Object");

            int featureIndex = Session.getSession().getSelectedFeatureIndex();
            feature = Session.getSession().getSelectedFeatures2().get(featureIndex);

        } else {
            setTitle("New Object");
//            feature = new FeatureWithAttachments();
//            //feature.setType("Feature");
//            feature.setType(FeatureWithAttachments.TypeEnum.FEATURE);
//            feature.setGeometryName("the_geom");
//            feature.setId(createOfflineTempFeatureId());
            double longitude = Session.getSession().getCurrentLongitude();
            double latitude = Session.getSession().getCurrentLatitude();
            feature = Feature.of(Point.from(longitude, latitude));
            String id = createOfflineTempFeatureId();
            feature = feature.withId(id);
        }

        if (Session.getSession().isOfflineMode()) {
            fields = Session.getSession().getCurrentEditTemplateFields();
            createForm();
        } else {
            getEditTemplateFields();
        }



    }

    private void checkEditRadius() {


        if (Settings.getSettings(FeatureEditActivity.this).isEditRadiusEnabled()) {

            progressDialog = ProgressDialog.show(this, "Edit Radius Check", "Confirming if you are close enough", true);

            HandlerThread locationThread = new HandlerThread("Location");
            locationThread.start();

            Handler locationHandler = new Handler(locationThread.getLooper());
            locationHandler.post(new Runnable() {
                @Override
                public void run() {

                    boolean isValid = false;

                    locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
                    //NOTE we ask for a single GPS location update, hopefully we get a good one.
                    //An alternative strategy would be to get continues updates until we find one accurate enough
                    locationManager.requestSingleUpdate(LocationManager.GPS_PROVIDER, new LocationListener() {
                        @Override
                        public void onLocationChanged(Location location) {
                            Log.d(TAG, "onLocationChanged - accuracy: " + location.getAccuracy());
                            FeatureEditActivity.this.location = location;
                            locationLatch.countDown();
                        }

                        @Override
                        public void onStatusChanged(String s, int i, Bundle bundle) {
                            Log.d(TAG, "onStatusChanged - " + s + ", " + i);
                        }

                        @Override
                        public void onProviderEnabled(String s) {
                            Log.d(TAG, "onProviderEnabled - " + s);
                        }

                        @Override
                        public void onProviderDisabled(String s) {
                            Log.d(TAG, "onProviderDisabled - " + s);
                        }
                    }, null);

                    try {
                        if (locationLatch.await(LOCATION_TIMEOUT, TimeUnit.SECONDS)) {

                            progressDialog.dismiss();

                            if (location != null) {

                                Session session = Session.getSession();
                                int featureIndex = session.getSelectedFeatureIndex();
                                FeatureWithAttachments feature = session.getSelectedFeatures().get(featureIndex);

                                //TODO the check should be for a point, not a polygon
                                //TODO
//                                if (feature.getGeometry().getGeometry().getType() == Polygon.TypeEnum.POLYGON) {

//                                    ArrayList<Double> coordinates = (ArrayList<Double>) feature.getGeometry().getCoordinates();
//                                    double longitude = coordinates.get(0);
//                                    double latitude = coordinates.get(1);
                                    //List<List<Point2D>> coords = feature.getGeometry().getGeometry().getCoordinates();
                                    //Point2D point = coords.get(0).get(0);
//                                    Point2D point = feature.getGeometry().getGeometry().getCoordinates();
//                                    double longitude = point.get(0);
//                                    double latitude = point.get(1);
                                Point point = (Point) feature.getGeometry();
                                double latitude = point.lat();
                                double longitude = point.lon();

                                    Location featureLocation = new Location(LocationManager.GPS_PROVIDER);
                                    featureLocation.setLatitude(latitude);
                                    featureLocation.setLongitude(longitude);

                                    double distance = location.distanceTo(featureLocation);
                                    Log.d(TAG, "Distance to feature: " + distance + "m");

                                    int editRadius = Settings.getSettings(FeatureEditActivity.this).getEditRadius();
                                    Log.d(TAG, "Edit radius: " + editRadius);

                                    isValid = distance <= editRadius;

//                                }
//                                else {
//                                    //Other feature types not supported at this stage, so just continue
//                                    isValid = true;
//                                }

                            }

                            if (!isValid) {
                                Toast.makeText(FeatureEditActivity.this, "Not close enough to edit point", Toast.LENGTH_SHORT).show();
                                finish();
                                return;
                            }

                        }
                        else {

                            progressDialog.dismiss();

                            isValid = false;
                            GuiUtil.showWarning(FeatureEditActivity.this, "Could not determine your location. Timeout expired.");
                        }

                    }
                    catch (Exception e) {
                        progressDialog.dismiss();

                        isValid = false;
                        Log.e(TAG, e.getMessage(), e);
                    }



                }
            });


        }

    }




    private String createOfflineTempFeatureId() {
        //TODO improve, maybe generate a GUID
        String id = "offline:" + System.currentTimeMillis();
        return id;
    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    private void getEditTemplateFields() {
//        ParameterService service = new ParameterService();
//        long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
//        EditTemplateFieldsRequest request = new EditTemplateFieldsRequest();
//        service.editTemplateFields(layerEditId, request, this);
        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            long editTemplateId = Session.getSession().getCurrentEditTemplate().getEditTemplateId();
            api.layerEditTemplateFieldsAsync(editTemplateId, new ApiCallback<OKResponseParamsLayerEditTemplateFields>() {
                @Override
                public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            editTemplateFieldsFailed(e.getMessage());
                        }
                    });

                }

                @Override
                public void onSuccess(final OKResponseParamsLayerEditTemplateFields result, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            editTemplateFieldsCompleted(result.getResult());
                        }
                    });

                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.d(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }
    }


    public void editTemplateFieldsCompleted(OKResponseParamsLayerEditTemplateFieldsResult response) {
        fields = response.getEditTemplateFields();

        createForm();
    }


    public void editTemplateFieldsFailed(String reason) {
        GuiUtil.showError(this, reason);
    }


    private void createForm() {
        formLayout.removeAllViews();

        //viewMap = new HashMap<String, View>();
        fieldHelpers = new ArrayList<FieldHelper>();

        for (final EditTemplateField fieldItem : fields) {

            Field field = fieldItem.getEditTemplateFieldField();


            //skip this field if it is not visible

            //if (!field.isVisible()) {
            if (!field.getVisible()) {
                continue;
            }

            final FieldHelper fieldHelper = new FieldHelper();
            fieldHelper.setTemplateField(fieldItem);


            if (isTextField(field) || isNumericField(field) || isDecimalField(field) || isMoneyField(field) || isCharacterField(field)) {

                if (fieldItem.getLookupValues() != null && fieldItem.getLookupValues().length() > 0) {

                    TextView labelView = new TextView(this);
                    labelView.setText(field.getFieldCaption() + ":");
                    formLayout.addView(labelView);


                    Spinner spinner = createSpinner(fieldItem);

                    //set default value
                    selectSpinnerValue(spinner, fieldItem.getDefaultValue());

                    //set current value
                    if (isUpdateMode) {
                        selectSpinnerValue(spinner, getValueForField(fieldItem));
                    }

                    spinner.setEnabled(field.getEditable());

                    formLayout.addView(spinner);
                    fieldHelper.setValueView(spinner);
                } else {

                    TextInputLayout inputLayout = new TextInputLayout(this);
                    formLayout.addView(inputLayout);


                    EditText valueView = new EditText(this);

                    //valueView.setHint("Enter value");
                    valueView.setHint(field.getFieldCaption());

                    //set default value
                    String defaultValue = fieldItem.getDefaultValue();
                    if (fieldItem.getDefaultValue() != null) {
                        defaultValue = defaultValue.replaceAll(",", ".");   //replace commas with dots
                        valueView.setText(defaultValue);
                    }

                    //set current value
                    if (isUpdateMode) {
                        String value = getValueForField(fieldItem);
                        if (value != null && isMoneyField(field)) {
                            value = value.replaceAll(",", ".");                 //replace commas with dots
                            value = value.replaceAll("R", "");
                            value = value.replaceAll(" ", "");
                        }
                        valueView.setText(value);
                    }

                    //set correct input method (keyboard)
                    if (isTextField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_NORMAL);
                    } else if (isNumericField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_VARIATION_NORMAL);
                    } else if (isDecimalField(field) || isMoneyField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL);
                    } else if (isCharacterField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_NORMAL);
                    }

                    //limit number of characters
                    int maxLen = field.getFieldSize();
                    if (isCharacterField(field)) {
                        maxLen = 1;
                    }
                    if (maxLen > 0) {
                        InputFilter[] inputFilters = new InputFilter[1];
                        inputFilters[0] = new InputFilter.LengthFilter(maxLen);
                        valueView.setFilters(inputFilters);
                    }

                    valueView.setEnabled(field.getEditable());

                    //formLayout.addView(valueView);
                    inputLayout.addView(valueView);

                    //viewMap.put(field.getFieldName(), valueView);
                    fieldHelper.setValueView(valueView);
                }

            } else if (isBooleanField(field)) {

                TextView labelView = new TextView(this);
                labelView.setText(field.getFieldCaption() + ":");
                formLayout.addView(labelView);


                CheckBox cb = new CheckBox(this);

                //set default value
                cb.setChecked(boolFromStr(fieldItem.getDefaultValue()));

                //set current value
                if (isUpdateMode) {
                    cb.setChecked(boolFromStr(getValueForField(fieldItem)));
                }

                cb.setEnabled(field.getEditable());

                formLayout.addView(cb);
                //viewMap.put(field.getFieldName(), cb);
                fieldHelper.setValueView(cb);
            } else if (isBarcodeField(field)) {

                TextView labelView = new TextView(this);
                labelView.setText(field.getFieldCaption() + ":");
                formLayout.addView(labelView);



                TextView valueView = new TextView(this);

                Button scanButton = new Button(this);
                scanButton.setText("Scan");
                scanButton.setEnabled(field.getEditable());
                scanButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;

                        IntentIntegrator scanIntegrator = new IntentIntegrator(FeatureEditActivity.this);
                        scanIntegrator.initiateScan();
                    }
                });

                //set default value
                valueView.setText(fieldItem.getDefaultValue());

                //set current value
                if (isUpdateMode) {
                    valueView.setText(getValueForField(fieldItem));
                }


                formLayout.addView(valueView);
                formLayout.addView(scanButton);

                //viewMap.put(field.getFieldName(), cb);
                fieldHelper.setValueView(valueView);

            } else if (isColorField(field)) {

                TextView labelView = new TextView(this);
                labelView.setText(field.getFieldCaption() + ":");
                formLayout.addView(labelView);



                Button button = new Button(this);
                button.setText("Choose Color");
                button.setEnabled(field.getEditable());

                TextView colorView = new TextView(this);
                colorView.setPadding(20, 20, 20, 20);
                colorView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                fieldHelper.setValueView(colorView);

                if (isUpdateMode) {
                    String currentHexColor = getValueForField(fieldItem);
                    fieldHelper.setStringValue(currentHexColor);
                    updateDisplay(fieldHelper);
                }

                button.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;

                        String hexColor = fieldHelper.getStringValue();
                        int intColor = 0;
                        if (hexColor != null && hexColor.length() >= 6) {
                            try {
                                intColor = Color.parseColor(hexColor);
                            } catch (IllegalArgumentException e) {
                                //could not parse
                            }
                        }

                        Intent intent = new Intent(FeatureEditActivity.this, ColorPickerActivity.class);
                        if (isUpdateMode) {
                            intent.putExtra(ColorPickerActivity.CURRENT_COLOR, intColor);
                        }
                        startActivityForResult(intent, REQUEST_PICK_COLOR);
                    }
                });

                formLayout.addView(colorView);
                formLayout.addView(button);

            } else if (isDateField(field)) {

                TextView labelView = new TextView(this);
                labelView.setText(field.getFieldCaption() + ":");
                formLayout.addView(labelView);


                /*
                LinearLayout layout = new LinearLayout(this);
                layout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                layout.setOrientation(LinearLayout.HORIZONTAL);
                */
                final TextView valueView = new TextView(this);
                //set default value
                valueView.setText(parseAndFormatDate(fieldItem.getDefaultValue(), false));
                if (isUpdateMode) {
                    valueView.setText(parseAndFormatDate(getValueForField(fieldItem), false));
                }
                formLayout.addView(valueView);
                //viewMap.put(field.getFieldName(), valueView);
                fieldHelper.setValueView(valueView);

                Button editButton = new Button(this);
                editButton.setText("Choose Date");
                editButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentTextView = valueView;
                        currentFieldHelper = fieldHelper;
                        Date date = parseAppDate(valueView.getText().toString());
                        Calendar cal = Calendar.getInstance();
                        if (date != null) {
                            cal.setTime(date);
                        }
                        int year = cal.get(Calendar.YEAR);
                        int month = cal.get(Calendar.MONTH);
                        int day = cal.get(Calendar.DAY_OF_MONTH);
                        DatePickerDialog dialog = new DatePickerDialog(FeatureEditActivity.this, FeatureEditActivity.this, year, month, day);
                        dialog.show();
                    }
                });
                editButton.setEnabled(field.getEditable());
                formLayout.addView(editButton);

                //formLayout.addView(layout);
            } else if (isDateTimeField(field)) {

                TextView labelView = new TextView(this);
                labelView.setText(field.getFieldCaption() + ":");
                formLayout.addView(labelView);


                LinearLayout buttonLayout = new LinearLayout(this);
                buttonLayout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                buttonLayout.setOrientation(LinearLayout.HORIZONTAL);

                final TextView valueView = new TextView(this);
                valueView.setText(parseAndFormatDate(fieldItem.getDefaultValue(), true));
                if (isUpdateMode) {
                    valueView.setText(parseAndFormatDate(getValueForField(fieldItem), true));
                }
                formLayout.addView(valueView);
                //viewMap.put(field.getFieldName(), valueView);
                fieldHelper.setValueView(valueView);

                Button editDateButton = new Button(this);
                editDateButton.setText("Choose Date");
                editDateButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;
                        Date date = parseAppDateTime(valueView.getText().toString());
                        Calendar cal = Calendar.getInstance();
                        if (date != null) {
                            cal.setTime(date);
                        }
                        int year = cal.get(Calendar.YEAR);
                        int month = cal.get(Calendar.MONTH);
                        int day = cal.get(Calendar.DAY_OF_MONTH);
                        DatePickerDialog dialog = new DatePickerDialog(FeatureEditActivity.this, FeatureEditActivity.this, year, month, day);
                        dialog.show();
                    }
                });
                editDateButton.setEnabled(field.getEditable());
                buttonLayout.addView(editDateButton);

                Button editTimeButton = new Button(this);
                editTimeButton.setText("Choose Time");
                editTimeButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;
                        Date date = parseAppDateTime(valueView.getText().toString());
                        Calendar cal = Calendar.getInstance();
                        if (date != null) {
                            cal.setTime(date);
                        }
                        int hour = cal.get(Calendar.HOUR_OF_DAY);
                        int minute = cal.get(Calendar.MINUTE);

                        TimePickerDialog dialog = new TimePickerDialog(FeatureEditActivity.this, FeatureEditActivity.this, hour, minute, true);
                        dialog.show();
                    }
                });
                editTimeButton.setEnabled(field.getEditable());
                buttonLayout.addView(editTimeButton);

                formLayout.addView(buttonLayout);
            }

            //add some whitespace between fields
            View space = new View(this);
            space.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, 20));
            formLayout.addView(space);

            fieldHelpers.add(fieldHelper);
        }

        checkEditRadius();
    }

    private String parseAndFormatDate(String dateStr, boolean dateAndTime) {
        String formatted = null;

        Date date = parseGeoDate(dateStr);

        if (date != null) {
            if (dateAndTime) {
                formatted = sdfAppDateTime.format(date);
            } else {
                formatted = sdfAppDate.format(date);
            }

        }

        return formatted;
    }

    private Date parseAppDate(String dateStr) {
        Date date = null;
        try {
            date = sdfAppDate.parse(dateStr);
        } catch (ParseException pe) {

        }
        return date;
    }

    private Date parseAppDateTime(String dateStr) {
        Date date = null;
        try {
            date = sdfAppDateTime.parse(dateStr);
        } catch (ParseException pe) {

        }
        return date;
    }


    private Date parseGeoDate(String dateStr) {
        Date date = null;

        if (dateStr != null && dateStr.trim().length() > 0) {
            try {
                date = sdfGeoDateTimeZone.parse(dateStr);
            } catch (ParseException pe) {

            }

            if (date == null) {
                try {
                    date = sdfGeoDateTime.parse(dateStr);
                } catch (ParseException pe) {

                }
            }

            if (date == null) {
                try {
                    date = sdfGeoDate.parse(dateStr);
                } catch (ParseException pe) {

                }
            }
        }

        return date;
    }

    private void selectSpinnerValue(Spinner spinner, String value) {
        int position = -1;
        for (int c = 0; c < spinner.getCount(); c++) {
            String itemValue = (String) spinner.getItemAtPosition(c);
            if (itemValue.equalsIgnoreCase(value)) {
                position = c;
                break;
            }
        }

        if (position != -1) {
            spinner.setSelection(position);
        }
    }

    private boolean boolFromStr(String value) {
        return (value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
    }


    private String getValueForField(EditTemplateField field) {
        //return (String) feature.getProperties().get(field.getEditTemplateFieldField().getFieldName());
        return feature.properties().get(field.getEditTemplateFieldField().getFieldName()).getAsString();
    }

    @Override
    public void onDateSet(DatePicker datePicker, int year, int monthOfYear, int dayOfMonth) {

        int currentHourOfDay = 0;
        int currentMinute = 0;
        Date currentDate = currentFieldHelper.getDateValue();
        if (currentDate != null) {
            Calendar currentCal = Calendar.getInstance();
            currentCal.setTime(currentDate);
            currentHourOfDay = currentCal.get(Calendar.HOUR_OF_DAY);
            currentMinute = currentCal.get(Calendar.MINUTE);
        }

        Calendar newCal = Calendar.getInstance();
        newCal.set(year, monthOfYear, dayOfMonth, currentHourOfDay, currentMinute, 0);
        Date newDate = newCal.getTime();
        currentFieldHelper.setDateValue(newDate);

        updateDisplay(currentFieldHelper);
    }

    @Override
    public void onTimeSet(TimePicker timePicker, int hourOfDay, int minute) {

        int currentYear = 0;
        int currentMonthOfYear = 0;
        int currentDayOfMonth = 0;
        Date currentDate = currentFieldHelper.getDateValue();
        if (currentDate != null) {
            Calendar currentCal = Calendar.getInstance();
            currentCal.setTime(currentDate);
            currentYear = currentCal.get(Calendar.YEAR);
            currentMonthOfYear = currentCal.get(Calendar.MONTH);
            currentDayOfMonth = currentCal.get(Calendar.DAY_OF_MONTH);
        }

        Calendar newCal = Calendar.getInstance();
        newCal.set(currentYear, currentMonthOfYear, currentDayOfMonth, hourOfDay, minute, 0);
        Date newDate = newCal.getTime();
        currentFieldHelper.setDateValue(newDate);

        updateDisplay(currentFieldHelper);
    }

    private void updateDisplay(FieldHelper helper) {
        String formattedValue = null;

        EditTemplateField templateField = helper.getTemplateField();
        if (isDateField(templateField.getEditTemplateFieldField())) {
            formattedValue = sdfAppDate.format(helper.getDateValue());

            TextView textView = (TextView) helper.getValueView();
            textView.setText(formattedValue);
        } else if (isDateTimeField(templateField.getEditTemplateFieldField())) {
            formattedValue = sdfAppDateTime.format(helper.getDateValue());

            TextView textView = (TextView) helper.getValueView();
            textView.setText(formattedValue);
        } else if (isColorField(templateField.getEditTemplateFieldField())) {
            String hexColor = helper.getStringValue();
            try {
                int intColor = Color.parseColor(hexColor);

                TextView colorView = (TextView) helper.getValueView();
                colorView.setBackgroundColor(intColor);
                colorView.setText(hexColor);
            } catch (Exception e) {
                //could not parse color, ignore
                Log.e(getClass().getCanonicalName(), e.getLocalizedMessage(), e);
            }

        }

    }

    private boolean isTextField(Field field) {
//        return field.getFieldType().equalsIgnoreCase("string") ||
//                field.getFieldType().equalsIgnoreCase("java.lang.String");
        return field.getFieldType() == Field.FieldTypeEnum.STRING;

    }

    private boolean isCharacterField(Field field) {
//        return field.getFieldType().equalsIgnoreCase("character") ||
//                field.getFieldType().equalsIgnoreCase("char") ||
//                field.getFieldType().equalsIgnoreCase("java.lang.Character");

        return field.getFieldType() == Field.FieldTypeEnum.BPCHAR;
    }


    private boolean isBarcodeField(Field field) {
//        return field.getFieldType().toLowerCase().startsWith("barcode") ||
//                field.getFieldType().toLowerCase().startsWith("qrcode");
        return field.getFieldType() == Field.FieldTypeEnum.BARCODE;
    }

    private boolean isNumericField(Field field) {
//        return field.getFieldType().equalsIgnoreCase("int") ||
//                field.getFieldType().equalsIgnoreCase("integer") ||
//                field.getFieldType().equalsIgnoreCase("short") ||
//                field.getFieldType().equalsIgnoreCase("long") ||
//                field.getFieldType().equalsIgnoreCase("java.lang.Integer") ||
//                field.getFieldType().equalsIgnoreCase("java.lang.Long");

        return field.getFieldType() == Field.FieldTypeEnum.INT2 ||
                field.getFieldType() == Field.FieldTypeEnum.LONG;
    }

    private boolean isDecimalField(Field field) {
        return field.getFieldType() == Field.FieldTypeEnum.DOUBLE;
    }

    private boolean isMoneyField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("money");
        return field.getFieldType() == Field.FieldTypeEnum.MONEY;
    }


    private boolean isBooleanField(Field field) {
//        return field.getFieldType().equalsIgnoreCase("boolean") ||
//                field.getFieldType().equalsIgnoreCase("bool") ||
//                field.getFieldType().equalsIgnoreCase("java.lang.Boolean");

        return field.getFieldType() == Field.FieldTypeEnum.BOOLEAN;
    }

    private boolean isColorField(Field field) {
        return field.getFieldType() == Field.FieldTypeEnum.COLOR;
    }

    private boolean isDateField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("date");
        return field.getFieldType() == Field.FieldTypeEnum.DATE;
    }

    private boolean isDateTimeField(Field field) {
//        return field.getFieldType().equalsIgnoreCase("dateTime") ||
//                field.getFieldType().equalsIgnoreCase("timestamp");
        return field.getFieldType() == Field.FieldTypeEnum.TIMESTAMP;
    }

    private boolean isPhotoField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("photo");
        return field.getFieldType() == Field.FieldTypeEnum.PHOTO;
    }

    private boolean isGPSLatitudeField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("gps_lat");
        return field.getFieldType() == Field.FieldTypeEnum.GPS_LAT;
    }

    private boolean isGPSLongitudeField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("gps_lon");
        return field.getFieldType() == Field.FieldTypeEnum.GPS_LON;
    }

    private boolean isGPSPrecisionField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("gps_prec");
        return field.getFieldType() == Field.FieldTypeEnum.GPS_PREC;
    }

    private boolean isUserEmailField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("user_email");
        return field.getFieldType() == Field.FieldTypeEnum.USER_EMAIL;
    }

    private boolean isUserIdField(Field field) {
        //return field.getFieldType().equalsIgnoreCase("user_id");
        //return field.getFieldType() == Field.FieldTypeEnum.DEVICE_ID;
        return false;
    }



    private Spinner createSpinner(EditTemplateField field) {
        Spinner spinner = new Spinner(this);

        String[] items = field.getLookupValues().split(",");

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_dropdown_item_1line, android.R.id.text1);
        //requires API level 11
        //adapter.addAll(items);
        for (String item : items) {
            adapter.add(item);
        }
        spinner.setAdapter(adapter);

        return spinner;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.feature_edit, menu);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem attachmentsItem = menu.findItem(R.id.action_attachments);

        attachmentsItem.setEnabled(isUpdateMode);

        return super.onPrepareOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.action_attachments) {
            showAttachments();
            return true;
        } else if (id == R.id.action_save) {
            save();
            return true;
        } else if (id == R.id.action_edit_template) {
            chooseEditTemplate();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void chooseEditTemplate() {
        Intent intent = new Intent(this, EditTemplateActivity.class);
        startActivityForResult(intent, REQ_EDIT_TEMPLATE);
    }

    @Override
    public void onClick(View view) {
        if (view == saveButton) {
            save();
        } else if (view == cancelButton) {
            cancel();
        }
    }

    private void showAttachments() {
        Intent intent = new Intent(this, AttachmentsActivity.class);
        startActivity(intent);
    }

    private void save() {

        progressDialog = ProgressDialog.show(this, "Saving", "Please wait...", true);

        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {

                if (fillFeatureValuesAndValidate()) {

                    if (isUpdateMode) {
                        updateExistingFeature();
                    } else {
                        saveNewFeature();
                    }
                }

            }
        });
        thread.start();

    }

    private void cancel() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Warning");
        builder.setMessage("Are you sure you want to continue without saving?");
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                finish();
            }
        });
        builder.setNegativeButton("No", null);
        builder.show();
    }

    @Override
    public void onBackPressed() {
        cancel();
    }

    private boolean fillFeatureValuesAndValidate() {
        boolean isValid = true;
        //Map<String, Object> properties = feature.getProperties();
        //FeatureWithoutAttachmentsProperties properties = feature.getProperties();
        Map<String, JsonElement> properties = new HashMap<>();

//        if (properties == null) {
//            //properties = new HashMap<String, Object>();
//            feature.setProperties(properties);
//        }

        for (FieldHelper helper : fieldHelpers) {
            EditTemplateField field = helper.getTemplateField();
            String fieldName = field.getEditTemplateFieldField().getFieldName();

            //View view = viewMap.get(fieldName);
            View view = helper.getValueView();

            String value = null;

            if (isDateField(field.getEditTemplateFieldField())) {
                Date date = helper.getDateValue();
                if (date != null) {
                    value = sdfGeoDate.format(date);
                }
            } else if (isDateTimeField(field.getEditTemplateFieldField())) {
                Date date = helper.getDateValue();
                if (date != null) {
                    value = sdfGeoDateTime.format(date);
                }
            } else if (isMoneyField(field.getEditTemplateFieldField())) {
                value = ((TextView) view).getText().toString();
                value = value.replaceAll("\\.", ",");         //replace dots with commas
            } else if (isBooleanField(field.getEditTemplateFieldField())) {
                CheckBox checkBox = (CheckBox) view;
                value = checkBox.isChecked() ? "t" : "f";
            } else if (isUserEmailField(field.getEditTemplateFieldField())) {
                String email = Settings.getSettings(this).getPreviousUsername();
                value = email;
            } else if (isUserIdField(field.getEditTemplateFieldField())) {
                long userId = Settings.getSettings(this).getPreviousUserId();
                value = Long.toString(userId);
            } else if (view instanceof TextView) {
                value = ((TextView) view).getText().toString();
            } else if (view instanceof EditText) {
                value = ((EditText) view).getText().toString();
            } else if (view instanceof Spinner) {
                value = (String) ((Spinner) view).getSelectedItem();
            } else {
                Log.d(getClass().getCanonicalName(), "Unsupported view type " + view.getClass().getCanonicalName());
            }

            //validate required fields
            boolean hasValue = value != null && value.trim().length() > 0;
            if (!field.getNillable() && !hasValue) {
                GuiUtil.showWarning(this, "Please provide a value for " + field.getEditTemplateFieldField().getFieldCaption());
                isValid = false;
            }

            properties.put(fieldName, new JsonPrimitive(value));

        }

        feature = feature.withProperties(ImmutableMap.copyOf(properties));

        return isValid;
    }

    private void saveNewFeature() {
        if (Session.getSession().isOfflineMode()) {
            saveNewFeatureOffline();
        } else {
            saveNewFeatureOnline();
        }
    }

    private void saveNewFeatureOnline() {

        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        //long layerEditId = -1;  //NOT USED ANYMORE

//        AddAttributesRequest request = new AddAttributesRequest();
//        request.setLayerId(layerId);
//        request.setEditId(layerEditId);
//
//        AttributesService service = new AttributesService();
//        service.addAttributes(request, feature, this);

        try {
            AttributesBasicApi api = new AttributesBasicApi(AppUtil.getApiClient());

            FeatureBasic featureBasic = new FeatureBasic();
            featureBasic.setProperties(feature.properties());

            featureBasic.setProperties(feature.properties());

            api.attributesPrimaryIdAddAsync(layerId, featureBasic, new ApiCallback<OKResponseAttributesAdd>() {
                @Override
                public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            addAttributesFailed(e.getMessage());
                        }
                    });
                }

                @Override
                public void onSuccess(final OKResponseAttributesAdd result, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            addAttributesCompleted(result);
                        }
                    });
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }
    }

    private void saveNewFeatureOffline() {

        //step 1 - save to db for later upload
        //AddAttributesRequest request = new AddAttributesRequest();
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        long layerEditId = -1;  //NOT USED ANYMORE
        //request.setLayerId(layerId);
        //request.setEditId(layerEditId);

        //TODO how do we serialize this
//        Gson gson = new Gson();
//        String requestJson = gson.toJson(request, AddAttributesRequest.class);
//        String featureJson = gson.toJson(feature, Feature.class);
        String requestJson = null;
        String featureJson = null;

        OfflineUpdateEntry entry = new OfflineUpdateEntry();
        entry.setUpdateType(OfflineUpdateEntry.UPdATE_TYPE_ADD_FEATURE);
        entry.setRequestJson(requestJson);
        entry.setObjectJson(featureJson);
        long featureRowId = OfflineUpdatesDAO.insertEntry(this, entry);


        //needed in case the user edits this entry before syncing
        //feature.setRowId(featureRowId);

        //TODO how do we set the property
        //feature.getProperties().put("offline_row_id", Long.toString(featureRowId));

        //also update geometry
        //TODO request
//        UpdateFeatureRequest geoRequest = new UpdateFeatureRequest();
//        geoRequest.setLayerId(layerId);

        //we will update the primary id later during the sync process
        //geoRequest.setPrimaryId(primaryId);

        Geometry geometry = new Geometry();

        //TODO set type
        //geometry.setType("Point");

        double longitude = Session.getSession().getCurrentLongitude();
        double latitude = Session.getSession().getCurrentLatitude();
//        double[] coordinates = new double[]{longitude, latitude};
//        geometry.setCoordinates(coordinates);

        Polygon polygon = new Polygon();
        //polygon.setType(Polygon.TypeEnum.POLYGON);
        //TODO populate coordinates
        List<List<Point2D>> coordinates = null;
        polygon.setCoordinates(coordinates);
        //TODO
        //geometry.setGeometry(polygon);

//        String geoRequestStr = gson.toJson(geoRequest);
//        String geometryStr = gson.toJson(geometry);
        //TODO populate
        String geoRequestStr = null;
        String geometryStr = null;

        OfflineUpdateEntry geoEntry = new OfflineUpdateEntry();
        geoEntry.setUpdateType(OfflineUpdateEntry.UPdATE_TYPE_EDIT_GEOMETRY);
        geoEntry.setRequestJson(geoRequestStr);
        geoEntry.setObjectJson(geometryStr);
        geoEntry.setLinkedRowId(featureRowId);
        OfflineUpdatesDAO.insertEntry(this, geoEntry);


        //Step 2 - Notify JavaScript about the change
        //TODO populate geometry
        //feature.setGeometry(geometry);

        //TODO populate
        //String featureJsonForJavsScript = gson.toJson(feature, Feature.class);
        String featureJsonForJavsScript = null;
        final Intent returnData = new Intent();
        returnData.putExtra(OpenLayersMapActivity.RETURN_OFFLINE_EDIT_FEATURE, featureJsonForJavsScript);
        returnData.putExtra(OpenLayersMapActivity.RETURN_OFFLINE_EDIT_TYPE, OpenLayersMapActivity.OFFLINE_EDIT_TYPE_NEW);


        //TODO Not sure if we still need this step?
        //Step 3 - Update the geojson file for local viewing
        try {
            String mapGuid = Session.getSession().getMapGuid();
            String savePath = AppUtil.pathForOfflineMap(this, mapGuid);
            savePath = savePath.replaceAll(".zip", "");

            String featuresFile = savePath + "/activelayer.geojsononly";

            JsonParser parser = new JsonParser();
            FileReader reader = new FileReader(featuresFile);
            JsonElement el = parser.parse(reader);
            reader.close();

            JsonArray oFeatures = el.getAsJsonObject().getAsJsonArray("features");

            //feature.setGeometry(geometry);

            //TODO populate
            //String featureStr = gson.toJson(feature);
            String featureStr = null;
            JsonElement featureEl = parser.parse(featureStr);
            oFeatures.add(featureEl);

            String out = el.toString();

            FileWriter writer = new FileWriter(featuresFile);
            writer.write(out);
            writer.flush();
            writer.close();

            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog.hide();
                    Toast.makeText(FeatureEditActivity.this, "New object added to offline updates queue.", Toast.LENGTH_SHORT).show();
                    setResult(RESULT_OK, returnData);
                    finish();
                }
            });
        }
        catch (Exception e) {
            hideProgressOnMainThread();
            e.printStackTrace();
        }

    }

    private void updateExistingFeature() {
        if (Session.getSession().isOfflineMode()) {
            updateExistingFeatureOffline();
        } else {
            updateExistingFeatureOnline();
        }
    }

    private void updateExistingFeatureOnline() {

        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        long layerEditId = -1;
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();

//        EditAttributesRequest request = new EditAttributesRequest();
//        request.setLayerId(layerId);
//        request.setEditId(layerEditId);
//        request.setPrimaryId(primaryId);
//
//        AttributesService service = new AttributesService();
//        service.editAttributes(request, feature, this);

        try {
            AttributesBasicApi api = new AttributesBasicApi(AppUtil.getApiClient());

            FeatureBasic featureBasic = new FeatureBasic();
            featureBasic.setProperties(feature.properties());

            api.attributesPrimaryIdEditAsync(layerId, primaryId, featureBasic, new ApiCallback<OKResponseAttributesUpdate>() {
                @Override
                public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            editAttributesFailed(e.getMessage());
                        }
                    });
                }

                @Override
                public void onSuccess(final OKResponseAttributesUpdate result, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            editAttributesCompleted(result.getResult());
                        }
                    });
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (Exception e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }
    }

    private void updateExistingFeatureOffline() {

        //Step 1 - Queue offline changes in the db for later uploading
        //EditAttributesRequest request = new EditAttributesRequest();
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        long layerEditId = -1;
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
//        request.setLayerId(layerId);
//        request.setEditId(layerEditId);
//        request.setPrimaryId(primaryId);

//        Gson gson = new Gson();
//        String requestJson = gson.toJson(request, EditAttributesRequest.class);
//        String featureJson = gson.toJson(feature, Feature.class);
        //TODO populate
        String requestJson = null;
        String featureJson = null;

        OfflineUpdateEntry offlineUpdateEntry = new OfflineUpdateEntry();
        offlineUpdateEntry.setUpdateType(OfflineUpdateEntry.UPdATE_TYPE_EDIT_FEATURE);
        offlineUpdateEntry.setRequestJson(requestJson);
        offlineUpdateEntry.setObjectJson(featureJson);

        if (primaryId == 0) {
            //we are editing a feature that was created offline and not yet synced (does not yet have a primary id)
            //primaryId will be updated during the sync process

            //offlineUpdateEntry.setLinkedRowId(feature.getRowId());

            //String offlineRowIdStr = (String)feature.getProperties().get("offline_row_id");
            //TODO populate
            String offlineRowIdStr = null;

            long offlineRowId = Long.parseLong(offlineRowIdStr);
            offlineUpdateEntry.setLinkedRowId(offlineRowId);
        }

        OfflineUpdatesDAO.insertEntry(this, offlineUpdateEntry);

        Log.d(getClass().getCanonicalName(), "Existing feature changes saved to Offline Updates queue");


        //Step 2 - Notify JavaScript about the change
        //String featureJsonForJavsScript = gson.toJson(feature, Feature.class);
        //TODO populate
        String featureJsonForJavsScript = null;

        final Intent returnData = new Intent();
        returnData.putExtra(OpenLayersMapActivity.RETURN_OFFLINE_EDIT_FEATURE, featureJsonForJavsScript);
        returnData.putExtra(OpenLayersMapActivity.RETURN_OFFLINE_EDIT_TYPE, OpenLayersMapActivity.OFFLINE_EDIT_TYPE_UPDATE);


        //TODO not sure if we still need this step?
        //Step 3 - Update the geojson file for local viewing
        List<FeatureWithAttachments> features = new ArrayList<FeatureWithAttachments>();
        List<Field> fields = new ArrayList<Field>();

        try {
//            String mapGuid = Session.getSession().getMapGuid();
//            String savePath = AppUtil.pathForOfflineMap(this, mapGuid);
//            savePath = savePath.replaceAll(".zip", "");
//
//            String featuresFile = savePath + "/activelayer.geojsononly";
//
//            JsonParser parser = new JsonParser();
//            FileReader reader = new FileReader(featuresFile);
//            JsonElement el = parser.parse(reader);
//            reader.close();
//
//            JsonArray oFeatures = el.getAsJsonObject().getAsJsonArray("features");
//            String geoJsonOnlyStr = oFeatures.toString();
//            JsonObject oItems = el.getAsJsonObject();
//            oItems.remove("features");
//
//            //FileReader featuresReader = new FileReader(featuresFile);
//
//            //Type featuresListType = new TypeToken<ArrayList<Feature>>() {}.getType();
//            //features = new Gson().fromJson(geoJsonOnlyStr, featuresListType);
//            //TODO populate features
//
//            for (int k = 0;k<features.size();k++) {
//                String featureId = feature.id().get();
//                if (features.get(k).getId().compareTo(featureId) == 0){
//                    features.get(k).setProperties(feature.getProperties());
//                    break;
//                }
//            }
//
//            String featuresJson = new Gson().toJson(features);
//            //oItems.addProperty("features", featuresJson);
//
//            JsonElement featuresEl = parser.parse(featuresJson);
//            oItems.add("features", featuresEl);
//
//
//            //Fix Json formatting from string issue caused by addProperty method
//            //String out = oItems.toString().replace("\\","").replace(":\"[", ":[").replace("]\"}","]}");
//            String out = oItems.toString();
//
//            FileWriter writer = new FileWriter(featuresFile);
//            writer.write(out);
//            writer.flush();
//            writer.close();

            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog.hide();
                    Toast.makeText(FeatureEditActivity.this, "Object updated successfully.", Toast.LENGTH_SHORT).show();
                    setResult(RESULT_OK, returnData);
                    finish();
                }
            });
        }
        catch (Exception e) {
            hideProgressOnMainThread();
            e.printStackTrace();
        }
    }

    private void saveGeometry(long primaryId) {

        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();

//        UpdateFeatureRequest request = new UpdateFeatureRequest();
//        request.setLayerId(layerId);
//        request.setPrimaryId(primaryId);

//        Geometry geometry = new Geometry();
//        geometry.setType("Point");
//        double longitude = Session.getSession().getCurrentLongitude();
//        double latitude = Session.getSession().getCurrentLatitude();
//        Log.d(getClass().getCanonicalName(), "DB1 Saving geometry " + latitude + ", " + longitude + " from primary id " + primaryId);
//        double[] coordinates = new double[]{longitude, latitude};
//        geometry.setCoordinates(coordinates);

//        SpatialService service = new SpatialService();
//        service.updateFeature(request, geometry, this);

        try {
            SpatialApi api = new SpatialApi(AppUtil.getApiClient());

//            FeatureWithoutPropertiesAndAttachments feature = new FeatureWithoutPropertiesAndAttachments();
//            feature.setGeometry(geometry);
//            feature.setType(FeatureWithoutPropertiesAndAttachments.TypeEnum.FEATURE);

            feature.setGeometryName("the_geom");

            api.apiSpatialUpdateGeometryAsync(layerId, primaryId, feature, new ApiCallback<OKResponseAttachmentsUpdate>() {
                @Override
                public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            updateFeatureFailed(e.getMessage());
                        }
                    });
                }

                @Override
                public void onSuccess(final OKResponseAttachmentsUpdate result, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            updateFeatureCompleted(result);
                        }
                    });
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }

    }


    public void addAttributesCompleted(OKResponseAttributesAdd response) {
        hideProgressOnMainThread();

        String message = response.getApiResponse().getMessage();
        if (message.equalsIgnoreCase("OK")) {
            //long primaryId = response.getPrimaryId();
            long primaryId = response.getResult().getPrimaryId();
            Log.d(getClass().getCanonicalName(), "DB1 new primary id from attr resp: " + primaryId);
            saveGeometry(primaryId);
        } else {
            Toast.makeText(this, message, Toast.LENGTH_LONG).show();
        }
    }


    public void addAttributesFailed(String reason) {
        hideProgressOnMainThread();

        GuiUtil.showError(this, reason);
    }


    public void editAttributesCompleted(OKResponseAttributesUpdateResult response) {
        hideProgressOnMainThread();

        if (response.getMessage().equalsIgnoreCase("OK")) {
            Toast.makeText(this, "Object updated successfully.", Toast.LENGTH_SHORT).show();
            setResult(RESULT_OK);
            finish();
        } else {
            Toast.makeText(this, response.getMessage(), Toast.LENGTH_LONG).show();
        }

    }

    public void editAttributesFailed(String reason) {
        hideProgressOnMainThread();

        GuiUtil.showError(this, reason);
    }


    public void updateFeatureCompleted(OKResponseAttachmentsUpdate response) {
        hideProgressOnMainThread();

        String message = response.getApiResponse().getMessage();
        if (message.equalsIgnoreCase("OK")) {
            Toast.makeText(this, "New object created successfully.", Toast.LENGTH_SHORT).show();
            finish();
        } else {
            Toast.makeText(this, message, Toast.LENGTH_LONG).show();
        }

    }


    public void updateFeatureFailed(String reason) {
        hideProgressOnMainThread();

        GuiUtil.showError(this, reason);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (requestCode == REQUEST_PICK_COLOR && resultCode == RESULT_OK) {
            int intColor = data.getIntExtra(ColorPickerActivity.SELECTED_COLOR, 0);
            String hexColor = null;
            if (intColor != 0) {
                hexColor = String.format("#%06X", (0xFFFFFF & intColor));
                Log.d(getClass().getCanonicalName(), "intColor " + "hexColor " + hexColor);
            }

            currentFieldHelper.setStringValue(hexColor);
            updateDisplay(currentFieldHelper);
        } else if (requestCode == REQ_EDIT_TEMPLATE) {
            if (resultCode == RESULT_OK) {
                if (Session.getSession().isOfflineMode()) {
                    fields = Session.getSession().getCurrentEditTemplateFields();
                    createForm();
                } else {
                    getEditTemplateFields();
                }
            }
        } else {
            //check if this is a barcode scan result
            IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, data);
            if (scanResult != null) {
                String barcode = scanResult.getContents();
                currentFieldHelper.setStringValue(barcode);

                TextView valueView = (TextView) currentFieldHelper.getValueView();
                valueView.setText(barcode);
            }
        }


    }

    private void hideProgressOnMainThread() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.hide();
            }
        });
    }

}




