package org.quidity.demo.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.RotateAnimation;
import android.webkit.MimeTypeMap;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.VideoView;

import com.google.android.gms.common.api.Api;
import com.google.android.gms.maps.LocationSource;

import org.joda.time.DateTime;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentEntry;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.AttachmentsCollectionUploaded;
import io.swagger.client.model.OKResponseAttachmentsAdd;

public class EditVideoAttachmentActivity extends Activity implements
        View.OnClickListener {

    private static final String TAG = EditVideoAttachmentActivity.class.getCanonicalName();

    public static final String EXTRA_FILE_PATH = "FILE_PATH";

    private EditText captionField;
    private EditText descriptionField;
    private VideoView videoView;
    private Button saveButton;

    private String filePath;
    private boolean attachmentLoaded;

    private ProgressDialog progressDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_video_attachment);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        filePath = getIntent().getStringExtra(EXTRA_FILE_PATH);

        captionField = (EditText)findViewById(R.id.caption);
        descriptionField = (EditText)findViewById(R.id.description);
        videoView = (VideoView)findViewById(R.id.video);
        saveButton = (Button)findViewById(R.id.save);
        saveButton.setOnClickListener(this);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    @Override
    protected void onResume() {

        super.onResume();
    }

    @Override
    protected void onPause() {

        super.onPause();
    }



    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);

        //we do it here because all views are now initialized and have correct sizes
        if (!attachmentLoaded) {
            //flag to ensure this happens only once
            attachmentLoaded = true;

            loadAttachment();
        }
    }



    private void loadAttachment() {

        videoView.setVideoPath(filePath);

        MediaController controller = new MediaController(this);
        controller.setAnchorView(videoView);
        videoView.setMediaController(controller);
        videoView.seekTo(1);
    }


    private void validateAndSave() {
        String caption = captionField.getText().toString().trim();

        if (caption.trim().length() == 0) {
            /*
            GuiUtil.showWarning(this, "Please enter a caption.");
            captionField.requestFocus();
            return;
            */

            captionField.setText("Video");
        }

        //everything seems valid, continue to save
        save();
    }

    private void save() {

        String caption = captionField.getText().toString().trim();
        String description = descriptionField.getText().toString().trim();

        AttachmentsCollection params = new AttachmentsCollection();
        params.setType(AttachmentsCollection.TypeEnum.VIDEO);

        String extension = filePath.substring(filePath.lastIndexOf(".")+1);
//        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
//        params.setHeader(mimeType);
        AttachmentsCollection.HeaderEnum headerEnum = AppUtil.getHeaderForExtension(extension);
        params.setHeader(headerEnum);

        params.setCaption(caption);
        if(description.length() > 0) {
            params.setDescription(description);
        }

//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");
//        String creationDate = sdf.format(new Date());
//        params.setCreationDate(creationDate);
        AttachmentsCollectionUploaded uploaded = new AttachmentsCollectionUploaded();
        uploaded.setDate(DateTime.now());
        params.setUploaded(uploaded);

//        AddAttachmentRequest request = new AddAttachmentRequest();
//        request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//        request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();

        if(Settings.getSettings(this).isBatchUploadEnabled() || Session.getSession().isOfflineMode()) {
            //save into db for later upload
            AttachmentEntry entry = new AttachmentEntry(layerId, primaryId, params, filePath);
            AttachmentsDAO.insertEntry(this, entry);

            Toast.makeText(this, "Added to upload queue.", Toast.LENGTH_LONG).show();

            setResult(RESULT_OK);
            finish();
        }
        else {
            //upload now
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog = new ProgressDialog(EditVideoAttachmentActivity.this);
                    progressDialog.setTitle("Uploading");
                    progressDialog.setMessage("Please wait...");
                    progressDialog.show();
                }
            });

//            AttributesService service = new AttributesService();
//            service.addAttachment(request, params, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                AttachmentsCollection attachment = new AttachmentsCollection();
                //TODO fill attachment
                api.attributesAttachAddAsync(layerId, primaryId, null, null, new ApiCallback<OKResponseAttachmentsAdd>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachmentsAdd result, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }

    }



    public void addAttachmentCompleted(OKResponseAttachmentsAdd response) {
        AppUtil.deleteFile(filePath);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        String message = response.getApiResponse().getMessage();
        Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
        setResult(RESULT_OK);
        finish();
    }


    public void addAttachmentFailed(String reason) {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_edit_image_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_save) {
            validateAndSave();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onClick(View view) {
        if(view == saveButton) {
            validateAndSave();
        }
    }
}
