package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.github.filosganga.geogson.model.Feature;

import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentEntry;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.AttachmentsCollectionUploaded;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseAttachments;
import io.swagger.client.model.OKResponseAttachmentsAdd;

public class EditTextAttachmentActivity extends Activity implements
        View.OnClickListener
{

    private static final String TAG = EditTextAttachmentActivity.class.getCanonicalName();

    private EditText captionField;
    private EditText descriptionField;
    private EditText textField;
    private Button saveButton;
    private AttachmentsCollection attachment;
    private ProgressDialog progressDialog;
    private String filePath;
    private long layerId;
    private long primaryId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_text_attachment);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        captionField = (EditText)findViewById(R.id.caption);
        descriptionField = (EditText)findViewById(R.id.description);
        textField = (EditText)findViewById(R.id.text);
        saveButton = (Button)findViewById(R.id.save);
        saveButton.setOnClickListener(this);

        captionField.requestFocus();
        //getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);

        if (Session.getSession().getEditMode().equalsIgnoreCase(Session.EDIT_MODE_UPDATE)) {
            loadAttachment();
        }
    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getLayerId();
        Feature feature = session.getSelectedFeatures2().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        long primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getAttachmentId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            showAttachment();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

//            AttachmentsRequest request = new AttachmentsRequest();
//            request.setAttachmentId(attachment.getId());
//            request.setLayerId(layer.getLayerId());
//            request.setPrimaryId(primaryId);
//
//            AttributesService service = new AttributesService();
//            service.attachments(request, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                api.attributesAttachPrimaryIdSearchSingleAsync(layerId, primaryId, attachment.getAttachmentId(), new ApiCallback<OKResponseAttachments>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachments result, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
                        double progress = bytesRead / contentLength;
                        attachmentsDownloadProgress(progress);
                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }
    }

    private long getPrimaryId(Feature feature, String primaryField) {
        String primaryIdStr = feature.properties().get(primaryField).getAsString();
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }


    public void attachmentsCompleted(OKResponseAttachments response) {
        progressDialog.dismiss();

        showAttachment();
    }



    public void attachmentsFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }


    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }

    private void showAttachment() {
        captionField.setText(attachment.getCaption());
        descriptionField.setText(attachment.getDescription());

        try {

            FileInputStream fis = new FileInputStream(filePath);
            String str = IOUtils.toString(fis);
            fis.close();

            textField.setText(str);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_edit_text_attachment, menu);
        return true;
    }


    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_save) {
            save();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    /*
    private void save() {

        try {
            File file = File.createTempFile("OneMap", ".txt", Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES));
            Log.d(getClass().getCanonicalName(), file.getAbsolutePath());

            FileWriter writer = new FileWriter(file, false);
            writer.write(textField.getText().toString());
            writer.flush();
            writer.close();

            finish();
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }


    }
    */

    private void save() {

        String caption = captionField.getText().toString().trim();
        String description = descriptionField.getText().toString().trim();
        String text = textField.getText().toString().trim();

        if (caption.trim().length() == 0) {
            /*
            GuiUtil.showWarning(this, "Please enter a caption.");
            captionField.requestFocus();
            return;
            */
            captionField.setText("Text");
        }

        if (text.trim().length() == 0) {
            GuiUtil.showWarning(this, "Please enter text.");
            textField.requestFocus();
            return;
        }

        //create new file if this is a new attachment
        if (Session.getSession().getEditMode().equalsIgnoreCase(Session.EDIT_MODE_CREATE)) {
            try {
                filePath = createTextFile().getAbsolutePath();
            }
            catch (IOException e) {
                GuiUtil.showError(this, e.getMessage());
                return;
            }
        }

        //save text to file
        try {
            FileWriter writer = new FileWriter(filePath, false);
            writer.write(textField.getText().toString());
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getMessage());
            return;
        }

        AttachmentsCollection params = new AttachmentsCollection();
        params.setType(AttachmentsCollection.TypeEnum.TEXT);

        String extension = filePath.substring(filePath.lastIndexOf(".")+1);
//        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
//        params.setHeader(mimeType);
        AttachmentsCollection.HeaderEnum headerEnum = AppUtil.getHeaderForExtension(extension);
        params.setHeader(headerEnum);

        params.setCaption(caption);
        if(description.length() > 0) {
            params.setDescription(description);
        }

//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");
//        String creationDate = sdf.format(new Date());
//        params.setCreationDate(creationDate);
        AttachmentsCollectionUploaded uploaded = new AttachmentsCollectionUploaded();
        uploaded.setDate(DateTime.now());
        params.setUploaded(uploaded);


//        AddAttachmentRequest request = new AddAttachmentRequest();
//        request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//        request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();

        if(Settings.getSettings(this).isBatchUploadEnabled() || Session.getSession().isOfflineMode()) {
            //save into db for later upload
            AttachmentEntry entry = new AttachmentEntry(layerId, primaryId, params, filePath);
            AttachmentsDAO.insertEntry(this, entry);

            Toast.makeText(this, "Added to upload queue.", Toast.LENGTH_LONG).show();

            setResult(RESULT_OK);
            finish();
        }
        else {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog = new ProgressDialog(EditTextAttachmentActivity.this);
                    progressDialog.setTitle("Uploading");
                    progressDialog.setMessage("Please wait...");
                    progressDialog.show();
                }
            });


//            AttributesService service = new AttributesService();
//            service.addAttachment(request, params, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                api.attributesAttachAddAsync(layerId, primaryId, null, null, new ApiCallback<OKResponseAttachmentsAdd>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachmentsAdd result, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }


    }

    private File createTextFile() throws IOException {
        // Create a text file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String textFileName = "OM_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_PICTURES);
        boolean created = storageDir.mkdirs();    //Directory is not guarenteed to exist
        File file = File.createTempFile(
                textFileName,  /* prefix */
                ".txt",         /* suffix */
                storageDir      /* directory */
        );

        return file;
    }


    public void addAttachmentCompleted(OKResponseAttachmentsAdd response) {
        deleteFile(filePath);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        String message = response.getApiResponse().getMessage();
        Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
        setResult(RESULT_OK);
        finish();
    }


    public void addAttachmentFailed(String reason) {


        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }

    @Override
    public void onClick(View view) {
        if(view == saveButton) {
            save();
        }
    }
}
