package org.quidity.demo.activity;

import android.app.ListActivity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.ParametersApi;
import io.swagger.client.model.EditTemplate;
import io.swagger.client.model.EditTemplateField;
import io.swagger.client.model.NADAddress;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFields;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFieldsResult;
import io.swagger.client.model.OKResponseParamsLayerEditTemplates;
import io.swagger.client.model.OKResponseParamsLayerEditTemplatesResult;

//public class EditTemplateActivity extends ListActivity implements
//        ParameterService.EditTemplatesListener,
//        ParameterService.EditTemplateFieldsListener,
//        View.OnClickListener {
public class EditTemplateActivity extends ListActivity implements
        View.OnClickListener {

    private static final String TAG = EditTemplateActivity.class.getCanonicalName();

    private List<EditTemplate> editTemplates;
    private List<EditTemplateField> fields;
    private ProgressDialog progressDialog;
    private Button doneButton;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_template);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        doneButton = (Button)findViewById(R.id.done);
        doneButton.setOnClickListener(this);

        getEditTemplates();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void getEditTemplates() {
        progressDialog = ProgressDialog.show(this, null, "Loading", true);
        //EditTemplatesRequest request = new EditTemplatesRequest();
        //ParameterService service = new ParameterService();
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        //service.editTemplates(layerId, request, this);

        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            api.layerEditTemplatesAsync(layerId, new ApiCallback<OKResponseParamsLayerEditTemplates>() {
                @Override
                public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            editTemplateFieldsFailed(e.getMessage());
                        }
                    });

                }

                @Override
                public void onSuccess(final OKResponseParamsLayerEditTemplates result, int statusCode, Map<String, List<String>> responseHeaders) {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            editTemplatesCompleted(result.getResult());
                        }
                    });

                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }
    }


    public void editTemplatesCompleted(OKResponseParamsLayerEditTemplatesResult response) {
        progressDialog.dismiss();
        editTemplates = response.getEditTemplates();

        EditTemplate dummy = new EditTemplate();
        dummy.setEditTemplateDescription("NONE");
        dummy.setEditTemplateCaption("NONE");
        dummy.setEditTemplateDefault(false);
        editTemplates.add(0, dummy);

        //ListAdapter adapter = new ArrayAdapter<EditTemplate>(this, android.R.layout.simple_list_item_single_choice, editTemplates);
        EditTemplateAdapter adapter = new EditTemplateAdapter(this, editTemplates);
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        EditTemplate currentTemplate = Session.getSession().getCurrentEditTemplate();
        if (currentTemplate == null) {
            int defaultIndex = getDefaultTemplateIndex();

            getListView().setItemChecked(defaultIndex, true);

            //set current template in session, in case user press back
            if (defaultIndex == 0) {
                Session.getSession().setCurrentEditTemplate(null);
            }
            else {
                EditTemplate defaultTemplate = editTemplates.get(defaultIndex);
                Session.getSession().setCurrentEditTemplate(defaultTemplate);
            }
        }
        else {
            int listViewIndex = indexForTemplate(currentTemplate);
            if (listViewIndex < 0) {
                listViewIndex = 0;
            }
            getListView().setItemChecked(listViewIndex, true);
        }

        if (Session.getSession().getCurrentEditTemplate() == null) {
            Session.getSession().setCurrentEditTemplateFields(null);
        }
        else {
            getEditTemplateFields();
        }

        updateButtons();
    }


    public void editTemplatesFailed(String reason) {
        progressDialog.dismiss();
        GuiUtil.showError(this, reason);
    }

    private void getEditTemplateFields() {
        //ParameterService service = new ParameterService();
        //long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        //EditTemplateFieldsRequest request = new EditTemplateFieldsRequest();
        //service.editTemplateFields(layerEditId, request, this);

        long editTemplateId = Session.getSession().getCurrentEditTemplate().getEditTemplateId();

        try {
            ParametersApi api = new ParametersApi(AppUtil.getApiClient());
            api.layerEditTemplateFieldsAsync(editTemplateId, new ApiCallback<OKResponseParamsLayerEditTemplateFields>() {
                @Override
                public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplateFieldsFailed(e.getMessage());
                }

                @Override
                public void onSuccess(OKResponseParamsLayerEditTemplateFields result, int statusCode, Map<String, List<String>> responseHeaders) {
                    editTemplateFieldsCompleted(result.getResult());
                }

                @Override
                public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                }

                @Override
                public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                }
            });
        }
        catch (ApiException e) {
            Log.e(TAG, e.getMessage(), e);
            GuiUtil.showWarning(this, e.getMessage());
        }

    }


    public void editTemplateFieldsCompleted(OKResponseParamsLayerEditTemplateFieldsResult response) {
        fields = response.getEditTemplateFields();
        Session.getSession().setCurrentEditTemplateFields(fields);
    }


    public void editTemplateFieldsFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    private int indexForTemplate(EditTemplate template) {
        int index = -1;
        for (int c = 0;c<editTemplates.size();c++) {
            EditTemplate t = editTemplates.get(c);
            //if (t.getLayerEditId() == template.getLayerEditId()) {
            if (t.getEditTemplateId() == template.getEditTemplateId()) {
                index = c;
            }
        }
        return index;
    }

    private int getDefaultTemplateIndex() {

        int defaultIndex = 0;   //NONE dummy by default

        for (int index = 0; index < editTemplates.size(); index++) {
            EditTemplate template = editTemplates.get(index);
            //if (template.isEditDefault()) {
            if (template.getEditTemplateDefault()) {
                defaultIndex = index;
                break;
            }
        }

        return defaultIndex;
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        updateButtons();
    }

    private void updateButtons() {
        int position = getListView().getCheckedItemPosition();

        if (position <= 0) {
            //NONE dummy item selected
            doneButton.setEnabled(true);
        }
        else {
            doneButton.setEnabled(true);
        }

    }

    @Override
    public void onClick(View view) {
        if(view == doneButton) {
            int position = getListView().getCheckedItemPosition();

            if(position == 0) {
                Session.getSession().setCurrentEditTemplate(null);
            }
            else {
                EditTemplate selectedTemplate = editTemplates.get(position);
                Session.getSession().setCurrentEditTemplate(selectedTemplate);
            }

            setResult(RESULT_OK);
            finish();
        }
    }

    public class EditTemplateAdapter extends ArrayAdapter<EditTemplate> {

        public EditTemplateAdapter(Context context, List<EditTemplate> templates) {
            super(context, android.R.layout.simple_list_item_single_choice, templates);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            // Get the data item for this position
            EditTemplate template = getItem(position);

            // Check if an existing view is being reused, otherwise inflate the view
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(android.R.layout.simple_list_item_single_choice, parent, false);
            }

            // Lookup view for data population
            TextView tvName = (TextView) convertView.findViewById(android.R.id.text1);

            // Populate the data into the template view using the data object
            tvName.setText(template.getEditTemplateCaption());

            // Return the completed view to render on screen
            return convertView;
        }
    }

}
