package org.quidity.demo.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.RotateAnimation;
import android.webkit.MimeTypeMap;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.gms.maps.LocationSource;

import org.joda.time.DateTime;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentEntry;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.AttachmentsCollectionCameraPosition;
import io.swagger.client.model.AttachmentsCollectionUploaded;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.OKResponseAttachmentsAdd;
import io.swagger.client.model.Point2D;

public class EditImageAttachmentActivity extends Activity implements
        LocationListener, View.OnClickListener {

    private static final String TAG = EditImageAttachmentActivity.class.getCanonicalName();
    public static final String EXTRA_FILE_PATH = "FILE_PATH";

    private EditText captionField;
    private EditText descriptionField;
    private TextView accuracyField;
    private ImageView imageView;
    private Button saveButton;

    private String filePath;
    private boolean attachmentLoaded;

    private LocationManager locationManager;
    private Location location;

    private ProgressDialog progressDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_image_attachment);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        filePath = getIntent().getStringExtra(EXTRA_FILE_PATH);

        captionField = (EditText)findViewById(R.id.caption);
        descriptionField = (EditText)findViewById(R.id.description);
        accuracyField = (TextView)findViewById(R.id.accuracy);
        imageView = (ImageView)findViewById(R.id.image);
        saveButton = (Button)findViewById(R.id.save);
        saveButton.setOnClickListener(this);

        locationManager = (LocationManager)getSystemService(LOCATION_SERVICE);

        if (Settings.getSettings(this).isCaptureImageLocation()) {
            accuracyField.setVisibility(View.VISIBLE);
            locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, this);

            if(!locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                AppUtil.promptEnableGPS(this);
            }
        }
        else {
            accuracyField.setVisibility(View.GONE);
        }

    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    @Override
    protected void onResume() {

        super.onResume();
    }

    @Override
    protected void onPause() {

        super.onPause();
    }



    @Override
    public void onLocationChanged(Location location) {
        this.location = location;

        if (location.hasAccuracy()) {
            String status = "Location Accuracy: " + Math.round(location.getAccuracy()) + "m";
            accuracyField.setText(status);
        }
        else {
            accuracyField.setText("Location Accuracy: Unknown");
        }
    }

    @Override
    public void onStatusChanged(String s, int i, Bundle bundle) {

    }

    @Override
    public void onProviderEnabled(String s) {

    }

    @Override
    public void onProviderDisabled(String s) {

    }




    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);

        //we do it here because all views are now initialized and have correct sizes
        if (!attachmentLoaded) {
            //flag to ensure this happens only once
            attachmentLoaded = true;

            loadAttachment();
        }
    }



    private void loadAttachment() {
        Bitmap bitmap = GuiUtil.decodeSampledBitmapFromFile(filePath, imageView.getWidth(), imageView.getHeight());
        //bitmap = GuiUtil.downscaleIfTooLargeForTexture(bitmap);
        imageView.setImageBitmap(bitmap);
    }


    private void validateAndSave() {
        String caption = captionField.getText().toString().trim();

        if (caption.trim().length() == 0) {
            /*
            GuiUtil.showWarning(this, "Please enter a caption.");
            captionField.requestFocus();
            return;
            */
            captionField.setText("Photo");
        }

        if (Settings.getSettings(this).isCaptureImageLocation()) {
            locationManager.removeUpdates(this);

            if (location == null) {

                AlertDialog.Builder builder = new AlertDialog.Builder(this);
                builder.setTitle("Warning");
                builder.setMessage("Location not available. Do you want to continue anyway?");
                builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        save();
                    }
                });
                builder.setNegativeButton("No", null);
                builder.show();

                return;
            }

            if (location.hasAccuracy()) {
                int desiredAccuracy = Settings.getSettings(this).getDesiredAccuracy();
                int gpsAccuracy = Math.round(location.getAccuracy());
                if (gpsAccuracy > desiredAccuracy) {

                    AlertDialog.Builder builder = new AlertDialog.Builder(this);
                    builder.setTitle("Warning");
                    builder.setMessage("Current location accuracy of " + gpsAccuracy + "m is not accurate enough. Should be at least " + desiredAccuracy + "m. Do you want to continue anyway?");
                    builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialogInterface, int i) {
                            save();
                        }
                    });
                    builder.setNegativeButton("No", null);
                    builder.show();


                    //GuiUtil.showWarning(this, "Location not accurate enough. Should be at least " + desiredAccuracy + "m.");
                    return;
                }
            }
        }

        //everything seems valid, continue to save
        save();
    }

    private void save() {

        String caption = captionField.getText().toString().trim();
        String description = descriptionField.getText().toString().trim();

        AttachmentsCollection params = new AttachmentsCollection();
        params.setType(AttachmentsCollection.TypeEnum.IMAGE);

        String extension = filePath.substring(filePath.lastIndexOf(".")+1);
        //String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        //params.setHeader(mimeType);
        AttachmentsCollection.HeaderEnum headerEnum = AppUtil.getHeaderForExtension(extension);
        params.setHeader(headerEnum);

//        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");
//        String creationDate = sdf.format(new Date());
//        params.setCreationDate(creationDate);
        AttachmentsCollectionUploaded uploaded = new AttachmentsCollectionUploaded();
        uploaded.setDate(DateTime.now());
        params.setUploaded(uploaded);

        params.setCaption(caption);
        if(description.length() > 0) {
            params.setDescription(description);
        }


        if (Settings.getSettings(this).isCaptureImageLocation()) {
            locationManager.removeUpdates(this);

            if (location != null && location.hasAccuracy()) {

                AttachmentsCollectionCameraPosition position = new AttachmentsCollectionCameraPosition();
                position.setLatitude(location.getLatitude());
                position.setLongitude(location.getLongitude());
                if (location.hasAltitude()) {
                    position.setAltitude(location.getAltitude());
                }

                double angle = calculateAngle();
                position.setAngle(angle);

                params.setCameraPosition(position);
            }
        }

//        AddAttachmentRequest request = new AddAttachmentRequest();
//        request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
//        request.setPrimaryId(primaryId);
        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();

        if(Settings.getSettings(this).isBatchUploadEnabled() || Session.getSession().isOfflineMode()) {
            //save into db for later upload
            //AttachmentEntry entry = new AttachmentEntry(request, params, filePath);
            AttachmentEntry entry = new AttachmentEntry(layerId, primaryId, params, filePath);

            if (Session.getSession().isOfflineMode()) {
                Session session = Session.getSession();
                FeatureWithAttachments feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());

                //TODO implement
                //String featureRowIdStr = (String) feature.getProperties().get("offline_row_id");
                String featureRowIdStr = "-1";

                if (featureRowIdStr != null) {
                    long featureRowId = Long.parseLong(featureRowIdStr);
                    entry.setOfflineUpdateRowId(featureRowId);
                }
            }

            AttachmentsDAO.insertEntry(this, entry);

            Toast.makeText(this, "Added to upload queue.", Toast.LENGTH_LONG).show();

            setResult(RESULT_OK);
            finish();
        }
        else {
            //upload now
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog = new ProgressDialog(EditImageAttachmentActivity.this);
                    progressDialog.setTitle("Uploading");
                    progressDialog.setMessage("Please wait...");
                    progressDialog.show();
                }
            });

//            AttributesService service = new AttributesService();
//            service.addAttachment(request, params, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                AttachmentsCollection attachment = new AttachmentsCollection();
                //TODO fill attachment detail
                api.attributesAttachAddAsync(layerId, primaryId, null, null, new ApiCallback<OKResponseAttachmentsAdd>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachmentsAdd result, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }

    }

    /**
     * Calculate angle between current location and feature location
     * @return
     */
    private double calculateAngle() {
        double angle = 0.0;
        try {
            Session session = Session.getSession();
            FeatureWithAttachments feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());
//            List<Double> featureCoords = (List<Double>)feature.getGeometry().getCoordinates();
//            double featureLongitude = featureCoords.get(0);
//            double featureLatitude = featureCoords.get(1);

            //List<List<Point2D>> geometry = feature.getGeometry().getGeometry().getCoordinates();
            //Point2D point = geometry.get(0).get(0);
            //TODO
//            Point2D point = feature.getGeometry().getGeometry().getCoordinates();
//            double featureLongitude = point.get(0);
//            double featureLatitude = point.get(1);


            Location featureLocation = new Location(LocationManager.GPS_PROVIDER);
            float bearing = location.bearingTo(featureLocation);
            angle = (double)bearing;
        }
        catch (Exception e) {
            Log.e(getClass().getCanonicalName(), e.getLocalizedMessage(), e);
        }

        return angle;
    }


    public void addAttachmentCompleted(OKResponseAttachmentsAdd response) {

        AppUtil.deleteFile(filePath);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        String message = response.getApiResponse().getMessage();
        Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
        setResult(RESULT_OK);
        finish();
    }


    public void addAttachmentFailed(String reason) {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_edit_image_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_save) {
            validateAndSave();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onClick(View view) {
        if(view == saveButton) {
            validateAndSave();
        }
    }
}
