package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.MimeTypeMap;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.MediaController;
import android.widget.Toast;

import org.joda.time.DateTime;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentEntry;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.AttachmentsCollectionUploaded;
import io.swagger.client.model.OKResponseAttachmentsAdd;

public class EditAudioAttachmentActivity extends Activity
        implements View.OnClickListener,
        MediaPlayer.OnCompletionListener,
        MediaPlayer.OnPreparedListener {

    private static final String TAG = EditAudioAttachmentActivity.class.getCanonicalName();
    private static final int PLAY_IMAGE = R.drawable.play_selector;
    private static final int PAUSE_IMAGE = R.drawable.play_selector;  //TODO change

    private MediaRecorder recorder;
    private MediaPlayer player;

    private EditText captionField;
    private EditText descriptionField;

    private ImageButton recordButton;
    private ImageButton stopButton;
    private ImageButton playPauseButton;

    private Button saveButton;

    private String filePath;
    private AttachmentsCollection attachment;
    private ProgressDialog progressDialog;
    private boolean playerFinished;
    private long layerId;
    private long primaryId;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_edit_audio_attachment);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        captionField = (EditText)findViewById(R.id.caption);
        descriptionField = (EditText)findViewById(R.id.description);

        recordButton = (ImageButton)findViewById(R.id.record);
        recordButton.setOnClickListener(this);

        stopButton = (ImageButton)findViewById(R.id.stop);
        stopButton.setOnClickListener(this);

        playPauseButton = (ImageButton)findViewById(R.id.play_pause);
        playPauseButton.setOnClickListener(this);

        recordButton.setEnabled(true);
        stopButton.setEnabled(false);
        playPauseButton.setEnabled(false);

        saveButton = (Button)findViewById(R.id.save);
        saveButton.setOnClickListener(this);

        saveButton.setEnabled(false);

        //loadAttachment();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    /*
    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getId();
        Feature feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            initPlayer();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

            AttachmentsRequest request = new AttachmentsRequest();
            request.setAttachmentId(attachment.getId());
            request.setLayerId(layer.getId());
            request.setPrimaryId(primaryId);

            AttributesService service = new AttributesService();
            service.attachments(request, filePath, this);
        }
    }


    private long getPrimaryId(Feature feature, String primaryField) {
        String primaryIdStr = (String)feature.getProperties().get(primaryField);
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }

    @Override
    public void attachmentsCompleted(AttachmentsResponse response) {
        progressDialog.hide();

        initPlayer();
    }


    @Override
    public void attachmentsFailed(String reason) {
        progressDialog.hide();

        GuiUtil.showError(this, reason);
    }

    @Override
    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }
    */


    private void createRecorder() throws IOException{
        recorder = new MediaRecorder();
        recorder.setAudioSource(MediaRecorder.AudioSource.MIC);
        recorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
        recorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
        filePath = createAudioFile().getAbsolutePath();
        recorder.setOutputFile(filePath);
    }


    private File createAudioFile() throws IOException {
        // Create a text file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String textFileName = "OM_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_PICTURES);
        File file = File.createTempFile(
                textFileName,  /* prefix */
                ".3gpp",         /* suffix */
                storageDir      /* directory */
        );

        return file;
    }


    @Override
    public void onClick(View view) {
        if (view == recordButton) {
            startRecording();
        }
        if(view == stopButton) {
            stop();
        }
        else if(view == playPauseButton) {
            playOrPause();
        }
        else if(view == saveButton) {
            save();
        }
    }


    private void startRecording() {
        try {
            createRecorder();
            recorder.prepare();;
            recorder.start();

            recordButton.setEnabled(false);
            stopButton.setEnabled(true);
            playPauseButton.setEnabled(false);
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }

    }

    private void stopRecording() {
        recorder.stop();
        recorder.release();

        initPlayer();

        recordButton.setEnabled(true);
        stopButton.setEnabled(false);
        playPauseButton.setEnabled(true);
        saveButton.setEnabled(true);
    }

    private void initPlayer() {
        try {
            player = new MediaPlayer();
            player.setDataSource(filePath);
            player.setOnPreparedListener(this);
            player.setOnCompletionListener(this);
            player.prepareAsync();
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }

    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        player.start();

        stopButton.setEnabled(true);
        playPauseButton.setEnabled(true);
        playPauseButton.setImageResource(PAUSE_IMAGE);
    }


    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        playerFinished = true;
        player.stop();

        stopButton.setEnabled(false);
        playPauseButton.setImageResource(PLAY_IMAGE);
    }

    private void stop() {

        stopRecording();
    }

    private void playOrPause() {

        if (player.isPlaying()) {
            player.pause();
            playPauseButton.setImageResource(PLAY_IMAGE);
        }
        else {
            if (playerFinished) {
                player.prepareAsync();
            }
            else {
                player.start();

                stopButton.setEnabled(true);
                playPauseButton.setImageResource(PAUSE_IMAGE);
            }
        }
    }



    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_edit_audio_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_save) {
            save();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    private void save() {

        String caption = captionField.getText().toString().trim();
        String description = descriptionField.getText().toString().trim();

        if (caption.trim().length() == 0) {
            /*
            GuiUtil.showWarning(this, "Please enter a caption.");
            captionField.requestFocus();
            return;
            */
            caption = "Audio";
            captionField.setText(caption);
        }

        AttachmentsCollection params = new AttachmentsCollection();
        params.setType(AttachmentsCollection.TypeEnum.AUDIO);

        String extension = filePath.substring(filePath.lastIndexOf(".")+1);
        //String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        //params.setHeader(mimeType);
        AttachmentsCollection.HeaderEnum header = AppUtil.getHeaderForExtension(extension);
        params.setHeader(header);


        params.setCaption(caption);
        if(description.length() > 0) {
            params.setDescription(description);
        }

        //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");

        //String creationDate = sdf.format(new Date());
        //params.setCreationDate(creationDate);
        //DateTime createDate = DateTime.now();
        AttachmentsCollectionUploaded uploaded = new AttachmentsCollectionUploaded();
        uploaded.setDate(DateTime.now());
        params.setUploaded(uploaded);

//        AddAttachmentRequest request = new AddAttachmentRequest();
//        request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//        request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());

        long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();

        if(Settings.getSettings(this).isBatchUploadEnabled() || Session.getSession().isOfflineMode()) {
            //save into db for later upload
            //AttachmentEntry entry = new AttachmentEntry(request, params, filePath);
            AttachmentEntry entry = new AttachmentEntry(layerId, primaryId, params, filePath);
            AttachmentsDAO.insertEntry(this, entry);

            Toast.makeText(this, "Added to upload queue.", Toast.LENGTH_LONG).show();

            setResult(RESULT_OK);
            finish();
        }
        else {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    progressDialog = new ProgressDialog(EditAudioAttachmentActivity.this);
                    progressDialog.setTitle("Uploading");
                    progressDialog.setMessage("Please wait...");
                    progressDialog.show();
                }
            });

//            AttributesService service = new AttributesService();
//            service.addAttachment(request, params, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                api.attributesAttachAddAsync(layerId, primaryId, null, null, new ApiCallback<OKResponseAttachmentsAdd>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachmentsAdd result, int statusCode, Map<String, List<String>> responseHeaders) {
                        addAttachmentCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }


    }


    public void addAttachmentCompleted(OKResponseAttachmentsAdd response) {
        AppUtil.deleteFile(filePath);
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        String message = response.getApiResponse().getMessage();
        Toast.makeText(this, message, Toast.LENGTH_SHORT).show();
        setResult(RESULT_OK);
        finish();
    }


    public void addAttachmentFailed(String reason) {

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.dismiss();
            }
        });

        GuiUtil.showError(this, reason);
    }



}
