package org.quidity.demo.activity;

import android.app.Activity;
import android.content.Intent;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

public class CoordinateActivity extends Activity {

    private Spinner formatSpinner;
    private ViewGroup ddLayout;
    private ViewGroup dmsLayout;

    private EditText longitudeField;
    private EditText latitudeField;

    private Spinner northSouthSpinner;
    private EditText longDegreesField;
    private EditText longMinutesField;
    private EditText longSecondsField;

    private Spinner eastWestSpinner;
    private EditText latDegreesField;
    private EditText latMinutesField;
    private EditText latSecondsField;

    private Button goButton;

    private static final int FORMAT_DD_INDEX = 0;
    private static final int FORMAT_DMS_INDEX = 1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_coordinate);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        formatSpinner = (Spinner)findViewById(R.id.format);
        ddLayout = (ViewGroup)findViewById(R.id.dd_layout);
        dmsLayout = (ViewGroup)findViewById(R.id.dms_layout);

        longitudeField = (EditText)findViewById(R.id.longitude);
        latitudeField = (EditText)findViewById(R.id.latitude);

        northSouthSpinner = (Spinner)findViewById(R.id.north_south);
        longDegreesField = (EditText)findViewById(R.id.long_degrees);
        longMinutesField = (EditText)findViewById(R.id.long_minutes);
        longSecondsField = (EditText)findViewById(R.id.long_seconds);

        eastWestSpinner = (Spinner)findViewById(R.id.east_west);
        latDegreesField = (EditText)findViewById(R.id.lat_degrees);
        latMinutesField = (EditText)findViewById(R.id.lat_minutes);
        latSecondsField = (EditText)findViewById(R.id.lat_seconds);

        goButton = (Button)findViewById(R.id.go);

        formatSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                formatChanged();
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });

        goButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToCoordinate();
            }
        });

        formatChanged();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void formatChanged() {

        int formatIndex = formatSpinner.getSelectedItemPosition();

        if (formatIndex == FORMAT_DD_INDEX) {
            //Decimal Degrees
            ddLayout.setVisibility(View.VISIBLE);
            dmsLayout.setVisibility(View.GONE);
        }
        else if (formatIndex == FORMAT_DMS_INDEX) {
            //Degrees Minutes Seconds
            ddLayout.setVisibility(View.GONE);
            dmsLayout.setVisibility(View.VISIBLE);
        }

    }

    private void goToCoordinate() {
        Intent intent = new Intent(this, OpenLayersMapActivity.class);

        double longitude = Double.MAX_VALUE;
        double latitude = Double.MAX_VALUE;

        int formatIndex = formatSpinner.getSelectedItemPosition();
        try {
            if (formatIndex == FORMAT_DD_INDEX) {

                longitude = Double.parseDouble(longitudeField.getText().toString());
                latitude = Double.parseDouble(latitudeField.getText().toString());

            } else if (formatIndex == FORMAT_DMS_INDEX) {

                //convert dms to dd
                int latSign = northSouthSpinner.getSelectedItemPosition() == 0 ? 1 : -1;
                int latDegrees = Integer.parseInt(latDegreesField.getText().toString());
                int latMinutes = Integer.parseInt(latMinutesField.getText().toString());
                int latSeconds = Integer.parseInt(latSecondsField.getText().toString());
                latitude = (double)latSign * AppUtil.dms2dd(latDegrees, latMinutes, latSeconds);

                int longSign = eastWestSpinner.getSelectedItemPosition() == 0 ? 1 : -1;
                int longDegrees = Integer.parseInt(longDegreesField.getText().toString());
                int longMinutes = Integer.parseInt(longMinutesField.getText().toString());
                int longSeconds = Integer.parseInt(longSecondsField.getText().toString());
                longitude = (double)longSign * AppUtil.dms2dd(longDegrees, longMinutes, longSeconds);
            }
        }
        catch (Exception e) {
            Log.e(getClass().getCanonicalName(), e.getLocalizedMessage(), e);
        }


        //TODO more validation to see if coordinate falls within valid ranges
        if (latitude == Double.MAX_VALUE || longitude == Double.MAX_VALUE) {
            GuiUtil.showWarning(this, "Invalid coordinate.");
            return;
        }

        intent.putExtra(OpenLayersMapActivity.EXTRA_LATITUDE, latitude);
        intent.putExtra(OpenLayersMapActivity.EXTRA_LONGITUDE, longitude);

        setResult(Activity.RESULT_OK, intent);
        finish();
    }

}
