package org.quidity.demo.activity;

import android.app.ListActivity;
import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import org.quidity.demo.Session;

import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;

import io.swagger.client.model.Layer;


public class BaseLayerActivity extends ListActivity {

    private List<Layer> baseLayers;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        determineBaseLayers();

        //ListAdapter adapter = new ArrayAdapter<Layer>(this, android.R.layout.simple_list_item_single_choice, baseLayers);
        ListAdapter adapter = new MyLayerAdapter(this, baseLayers);
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        Session session = Session.getSession();
        //int currentBaseLayerIndex = session.getLayers().indexOf(session.getCurrentBaseLayer());
        int currentBaseLayerIndex = baseLayers.indexOf(session.getCurrentBaseLayer());
        getListView().setItemChecked(currentBaseLayerIndex, true);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void determineBaseLayers() {
        baseLayers = new ArrayList<Layer>();

        for(Layer layer : Session.getSession().getLayers()) {
            if (layer.getIsBaseLayer()) {
                baseLayers.add(layer);
            }
        }
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        Layer selectedLayer = baseLayers.get(position);

        Session.getSession().setCurrentBaseLayer(selectedLayer);
        finish();
    }

    public class MyLayerAdapter extends ArrayAdapter<Layer> {
        public MyLayerAdapter(Context context, List<Layer> users) {
            super(context, android.R.layout.simple_list_item_single_choice, users);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            // Get the data item for this position
            Layer layer = getItem(position);

            // Check if an existing view is being reused, otherwise inflate the view
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(android.R.layout.simple_list_item_single_choice, parent, false);
            }

            // Lookup view for data population
            TextView tvName = (TextView) convertView.findViewById(android.R.id.text1);

            // Populate the data into the template view using the data object
            tvName.setText(layer.getLayerCaption());

            // Return the completed view to render on screen
            return convertView;
        }
    }

}
