package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Environment;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.MediaController;

import com.github.filosganga.geogson.model.Feature;

import org.apache.commons.io.FileUtils;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.Layer;
import io.swagger.client.model.OKResponseAttachments;

public class AudioAttachmentActivity extends Activity
        implements View.OnClickListener,
        MediaPlayer.OnCompletionListener,
        MediaPlayer.OnPreparedListener,
        AttachmentHelper.AttachmentDownloadListener {

    private static final String TAG = AudioAttachmentActivity.class.getCanonicalName();
    private static final int PLAY_IMAGE = R.drawable.play_selector;
    private static final int PAUSE_IMAGE = R.drawable.play_selector;  //TODO change


    //private MediaRecorder recorder;
    private MediaPlayer player;

    //private ImageButton recordButton;
    private ImageButton stopButton;
    private ImageButton playPauseButton;

    private String filePath;
    private AttachmentsCollection attachment;
    private ProgressDialog progressDialog;
    private boolean playerFinished;
    private long layerId;
    private long primaryId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_audio_attachment);

        AppUtil.initActivity(this);

        //restore session state
        if(savedInstanceState != null) {
            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
            Session.restore(savedSession);
            //Session.restoreSessionState();
        }


        //recordButton = (ImageButton)findViewById(R.id.record);
        //recordButton.setOnClickListener(this);

        stopButton = (ImageButton)findViewById(R.id.stop);
        stopButton.setOnClickListener(this);

        playPauseButton = (ImageButton)findViewById(R.id.play_pause);
        playPauseButton.setOnClickListener(this);

        //recordButton.setEnabled(false);
        stopButton.setEnabled(false);
        playPauseButton.setEnabled(false);

        loadAttachment();
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);
    }

    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getLayerId();
        Feature feature = session.getSelectedFeatures2().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getAttachmentId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            initPlayer();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

//            AttachmentsRequest request = new AttachmentsRequest();
//            request.setAttachmentId(attachment.getId());
//            request.setLayerId(layer.getLayerId());
//            request.setPrimaryId(primaryId);
//
//            AttributesService service = new AttributesService();
//            service.attachments(request, filePath, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                long layerId = layer.getLayerId();
                long attachmentId = attachment.getAttachmentId();

                api.attributesAttachPrimaryIdSearchSingleAsync(layerId, primaryId, attachmentId, new ApiCallback<OKResponseAttachments>() {
                    @Override
                    public void onFailure(ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsFailed(e.getMessage());
                    }

                    @Override
                    public void onSuccess(OKResponseAttachments result, int statusCode, Map<String, List<String>> responseHeaders) {
                        attachmentsCompleted(result);
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }
    }

    private long getPrimaryId(Feature feature, String primaryField) {
        //String primaryIdStr = (String)feature.getProperties().get(primaryField);
        String primaryIdStr = feature.properties().get(primaryField).getAsString();
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }

    public void attachmentsCompleted(OKResponseAttachments response) {
//        progressDialog.dismiss();
//        initPlayer();

        AttachmentHelper helper = new AttachmentHelper(this);
        helper.downloadFile(layerId, primaryId, attachment.getAttachmentId(), this);
    }

    @Override
    public void attachmentDownloadCompleted(File file) {

        try {
            File destFile = new File(filePath);
            FileUtils.copyFile(file, destFile);
        }
        catch (IOException e) {
            Log.e(TAG, e.getMessage(), e);
        }

        progressDialog.dismiss();
        initPlayer();

    }

    public void attachmentsFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }


    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }

    /*
    private void createRecorder() {
        recorder = new MediaRecorder();
        recorder.setAudioSource(MediaRecorder.AudioSource.MIC);
        recorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
        recorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
        filePath = createTempFile();
        recorder.setOutputFile(filePath);
    }

    private String createTempFile() {
        File file = null;
        try {
            File storageDir = Environment.getExternalStoragePublicDirectory(
                    Environment.DIRECTORY_PODCASTS);
            file = File.createTempFile(
                    "OneMap",
                    ".3gpp",
                    storageDir
            );
        }
        catch(IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }
        return file.getAbsolutePath();
    }
    */

    @Override
    public void onClick(View view) {
        //if (view == recordButton) {
            //startRecording();
        //}
        if(view == stopButton) {
            stop();
        }
        else if(view == playPauseButton) {
            playOrPause();
        }
    }

    /*
    private void startRecording() {
        try {
            createRecorder();
            recorder.prepare();;
            recorder.start();

            startButton.setEnabled(false);
            stopButton.setEnabled(true);
            playButton.setEnabled(false);
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }

    }

    private void stopRecording() {
        recorder.stop();
        recorder.release();

        startButton.setEnabled(true);
        stopButton.setEnabled(false);
        playButton.setEnabled(true);
    }
*/
    private void initPlayer() {
        try {
            player = new MediaPlayer();
            player.setDataSource(filePath);
            player.setOnPreparedListener(this);
            player.setOnCompletionListener(this);
            player.prepareAsync();
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }

    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        player.start();

        stopButton.setEnabled(true);
        playPauseButton.setEnabled(true);
        playPauseButton.setImageResource(PAUSE_IMAGE);
    }


    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        playerFinished = true;
        player.stop();

        stopButton.setEnabled(false);
        playPauseButton.setImageResource(PLAY_IMAGE);
    }

    private void stop() {

        player.stop();

        stopButton.setEnabled(false);
        playPauseButton.setImageResource(PLAY_IMAGE);
    }

    private void playOrPause() {

        if (player.isPlaying()) {
            player.pause();
            playPauseButton.setImageResource(PLAY_IMAGE);
        }
        else {
            if (playerFinished) {
                player.prepareAsync();
            }
            else {
                player.start();

                stopButton.setEnabled(true);
                playPauseButton.setImageResource(PAUSE_IMAGE);
            }
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_image_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_delete) {
            AttachmentHelper helper = new AttachmentHelper(this);
            //helper.promptDelete(layerId, primaryId, attachment.getId());
            helper.promptDelete(this.attachment);
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

}
