package org.quidity.demo.activity;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupMenu;
import android.widget.TextView;
import android.widget.Toast;

import com.github.filosganga.geogson.model.Feature;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.db.AttachmentEntry;
import org.quidity.demo.db.AttachmentsDAO;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiException;
import io.swagger.client.api.AttachmentsApi;
import io.swagger.client.api.AttributesBasicApi;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.ModelApiResponse;
import io.swagger.client.model.OKResponseAttachmentsUpdate;
import io.swagger.client.model.OKResponseAttributes;
import io.swagger.client.model.OKResponseAttributesDelete;
import io.swagger.client.model.OKResponseAttributesResult;
import io.swagger.client.model.OKResponseAttributesResultFields;

public class AttachmentsActivity extends ListActivity implements
        AdapterView.OnItemClickListener,
        AdapterView.OnItemLongClickListener,
        View.OnClickListener
         {

    private static String TAG = AttachmentsActivity.class.getCanonicalName();

    private static final String SOURCE_IMAGE_NEW = "New Image";
    //private static final String SOURCE_IMAGE_EXISTING = "Existing Image";
    private static final String SOURCE_TEXT_NEW = "New Text";
    private static final String SOURCE_AUDIO_NEW = "New Audio";
    //private static final String SOURCE_AUDIO_EXISTING = "Existing Audio";
    private static final String SOURCE_VIDEO_NEW = "New Video";
    //private static final String SOURCE_VIDEO_EXISTING = "Existing Video";

    private static final int REQUEST_IMAGE_NEW = 100;
    //private static final int REQUEST_IMAGE_EXISTING = 200;
    private static final int REQUEST_TEXT_NEW = 300;
    private static final int REQUEST_AUDIO_NEW = 400;
    //private static final int REQUEST_AUDIO_EXISTING = 500;
    private static final int REQUEST_VIDEO_NEW = 600;
    //private static final int REQUEST_VIDEO_EXISTING = 700;

    private static final int REQUEST_VIEW = 800;
    private static final int REQUEST_UPLOAD = 900;
    private static final int REQUEST_UPLOAD_NOW = 1000;

    private static final String STATE_CURRENT_PHOTO_PATH = "CurrentPhotoPath";
    private static final String STATE_CURRENT_VIDEO_PATH = "CurrentVideoPath";

    private Feature feature;
    private String mCurrentPhotoPath;
    private String mCurrentVideoPath;
    private String[] sources;

    private ImageButton addImageButton;
    private ImageButton addVideoButton;
    private ImageButton addAudioButton;
    private ImageButton addTextButton;

    private ProgressDialog progressDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_attachments);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }


        addImageButton = (ImageButton)findViewById(R.id.add_image);
        addVideoButton = (ImageButton)findViewById(R.id.add_video);
        addAudioButton = (ImageButton)findViewById(R.id.add_audio);
        addTextButton = (ImageButton)findViewById(R.id.add_text);

        addImageButton.setOnClickListener(this);
        addVideoButton.setOnClickListener(this);
        addAudioButton.setOnClickListener(this);
        addTextButton.setOnClickListener(this);

        Session session = Session.getSession();

        //boolean canEdit = session.getCurrentActiveLayer().isEditMetadata();
        boolean canEdit = session.getCurrentActiveLayer().getCanEditAttributes();
        if(!canEdit) {
            addImageButton.setVisibility(View.GONE);
            addVideoButton.setVisibility(View.GONE);
            addAudioButton.setVisibility(View.GONE);
            addTextButton.setVisibility(View.GONE);
        }

        feature = session.getSelectedFeatures2().get(session.getSelectedFeatureIndex());

        /*
        List<Attachment> featureAttachments = feature.getAttachments();
        if (featureAttachments != null && featureAttachments.size() > 0) {
            ListAdapter adapter = new AttachmentAdapter(this, featureAttachments);
            getListView().setAdapter(adapter);
        }
        */

        getListView().setOnItemClickListener(this);
        getListView().setOnItemLongClickListener(this);

        //if (Session.getSession().isOfflineMode()) {
            refreshAttachments();
        //}
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {

        outState.putString(STATE_CURRENT_PHOTO_PATH, mCurrentPhotoPath);
        outState.putString(STATE_CURRENT_VIDEO_PATH, mCurrentVideoPath);
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
        //Session.saveSessionState();
        super.onSaveInstanceState(outState);

    }

    @Override
    protected void onRestoreInstanceState(Bundle state) {
        super.onRestoreInstanceState(state);

        mCurrentPhotoPath = state.getString(STATE_CURRENT_PHOTO_PATH);
        mCurrentVideoPath = state.getString(STATE_CURRENT_VIDEO_PATH);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {

        Session.getSession().setSelectedAttachmentIndex(position);
        AttachmentsCollection attachment = feature.getAttachments().get(position);

        if (attachment.getType() == AttachmentsCollection.TypeEnum.AUDIO) {
            Intent intent = new Intent(this, AudioAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }
        else if (attachment.getType() == AttachmentsCollection.TypeEnum.IMAGE) {
            Intent intent = new Intent(this, ImageAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }
        if (attachment.getType() == AttachmentsCollection.TypeEnum.VIDEO) {
            Intent intent = new Intent(this, VideoAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }
        if (attachment.getType() == AttachmentsCollection.TypeEnum.TEXT) {
            Intent intent = new Intent(this, TextAttachmentActivity.class);
            startActivityForResult(intent, REQUEST_VIEW);
        }

    }

    @Override
    public boolean onItemLongClick(final AdapterView<?> adapterView, View view, final int postition, long l) {

        //boolean canEdit = Session.getSession().getCurrentActiveLayer().isEditMetadata();
        boolean canEdit = Session.getSession().getCurrentActiveLayer().getCanEditAttributes();

        if (canEdit) {

            PopupMenu popup = new PopupMenu(this, view);
            popup.getMenuInflater().inflate(R.menu.menu_attachments_item_popup, popup.getMenu());

            popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener() {
                @Override
                public boolean onMenuItemClick(MenuItem menuItem) {
                    if (menuItem.getItemId() == R.id.action_attachment_delete) {
                        AttachmentsCollection attachment = (AttachmentsCollection) adapterView.getItemAtPosition(postition);
                        promptDelete(attachment);
                        return true;
                    }

                    return false;
                }
            });

            popup.show();

            return true;
        }
        else {
            return false;
        }
    }

    private void promptDelete(final AttachmentsCollection attachment) {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Delete Attachment");
        builder.setMessage("Are you sure you want to delete attachment '" + attachment.getCaption() + "'?");
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                delete(attachment);
            }
        });
        builder.setNegativeButton("No", null);

        builder.show();
    }

    private void delete(AttachmentsCollection attachment) {

        if (!Session.getSession().isOfflineMode()) {
            progressDialog = ProgressDialog.show(this, "Deleting Attachment", "Please wait...");
//            AttributesService service = new AttributesService();
//            DeleteAttachmentRequest request = new DeleteAttachmentRequest();
//            request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//            request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
//            request.setAttachmentId(attachment.getId());
//
//            service.deleteAttachment(request, this);

            try {
                AttachmentsApi api = new AttachmentsApi(AppUtil.getApiClient());
                long layerid = Session.getSession().getCurrentActiveLayer().getLayerId();
                long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
                long attachmentId = attachment.getAttachmentId();
                api.attributesAttachPrimaryIdDeleteAsync(layerid, primaryId, attachmentId, new ApiCallback<OKResponseAttributesDelete>() {
                    @Override
                    public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                deleteAttachmentFailed(e.getMessage());
                            }
                        });
                    }

                    @Override
                    public void onSuccess(final OKResponseAttributesDelete result, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                deleteAttachmentCompleted(result);
                            }
                        });
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }

        }
        else {
            //TODO how to get rowId?
            long rowId = 0;
            //AttachmentsDAO.deleteEntry(this, attachment.getRowId());
            AttachmentsDAO.deleteEntry(this, rowId);

            refreshAttachments();
        }
    }


    public void deleteAttachmentCompleted(OKResponseAttributesDelete response) {
        progressDialog.dismiss();

        Toast.makeText(this, "Attachment deleted.", Toast.LENGTH_SHORT).show();
        refreshAttachments();
    }


    public void deleteAttachmentFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }

        @Override
    public void onClick(View view) {
        if(view == addImageButton) {
            addImage();
        }
        else if(view == addVideoButton) {
            addVideo();
        }
        else if(view == addAudioButton) {
            addAudio();
        }
        else if(view == addTextButton) {
            addText();
        }

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.attachments, menu);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {

        MenuItem uploadNowItem = menu.findItem(R.id.action_upload_now);
        Settings settings = Settings.getSettings(this);
        if (settings.isBatchUploadEnabled() && !Session.getSession().isOfflineMode()) {
            uploadNowItem.setVisible(true);
            if(AttachmentsDAO.hasAttachments(this)) {
                uploadNowItem.setEnabled(true);
            }
        }

        MenuItem addAttachmentItem = menu.findItem(R.id.action_attachment_add);
        boolean canEdit = Session.getSession().getCurrentActiveLayer().getCanEditAttributes();
        addAttachmentItem.setEnabled(canEdit);

        return super.onPrepareOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_attachment_add) {
            addAttachment();
            return true;
        }
        else if (id == R.id.action_upload_now) {
            uploadNow();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void uploadNow() {
        Intent intent = new Intent(this, SyncNowActivity.class);
        startActivityForResult(intent, REQUEST_UPLOAD_NOW);
    }

    private void addAttachment() {

        List<String> sourcesList = new ArrayList<String>();

        if (getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA_ANY)) {
            sourcesList.add(SOURCE_IMAGE_NEW);
        }
        //sourcesList.add(SOURCE_IMAGE_EXISTING);
        sourcesList.add(SOURCE_TEXT_NEW);
        sourcesList.add(SOURCE_AUDIO_NEW);
        //sourcesList.add(SOURCE_AUDIO_EXISTING);
        if (getPackageManager().hasSystemFeature(PackageManager.FEATURE_CAMERA_ANY)) {
            sourcesList.add(SOURCE_VIDEO_NEW);
        }
        //sourcesList.add(SOURCE_VIDEO_EXISTING);

        sources = new String[sourcesList.size()];
        sourcesList.toArray(sources);

        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Attach What?");
        builder.setItems(sources, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                //Toast.makeText(AttachmentsActivity.this, "You selected " + sources[i], Toast.LENGTH_LONG).show();

                String source = sources[i];
                if (source.equals(SOURCE_IMAGE_NEW)) {
                    addImage();
                }
                /*
                else if (source.equals(SOURCE_IMAGE_EXISTING)) {
                    Intent intent = new Intent(Intent.ACTION_PICK, MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
                    if (intent.resolveActivity(getPackageManager()) != null) {
                        startActivityForResult(intent, REQUEST_IMAGE_EXISTING);
                    }
                }
                */
                else if (source.equals(SOURCE_TEXT_NEW)) {
                    addText();
                }
                else if (source.equals(SOURCE_AUDIO_NEW)) {
                    addAudio();
                }
                /*
                else if (source.equals(SOURCE_AUDIO_EXISTING)) {
                    Intent intent = new Intent(Intent.ACTION_PICK, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
                    if (intent.resolveActivity(getPackageManager()) != null) {
                        startActivityForResult(intent, REQUEST_AUDIO_EXISTING);
                    }
                }
                */
                else if (source.equals(SOURCE_VIDEO_NEW)) {
                    addVideo();
                }
                /*
                else if (source.equals(SOURCE_VIDEO_EXISTING)) {
                    Intent intent = new Intent(Intent.ACTION_PICK, MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
                    if (intent.resolveActivity(getPackageManager()) != null) {
                        startActivityForResult(intent, REQUEST_VIDEO_EXISTING);
                    }
                }
                */
            }
        });
        AlertDialog dialog = builder.create();
        dialog.show();

    }

    private void addImage() {
        dispatchTakePictureIntent();
    }

    private void addVideo() {
        dispatchTakeVideoIntent();
    }

    private void addAudio() {
        Intent intent = new Intent(AttachmentsActivity.this, EditAudioAttachmentActivity.class);
        startActivityForResult(intent, REQUEST_AUDIO_NEW);

    }

    private void addText() {
        Session.getSession().setEditMode(Session.EDIT_MODE_CREATE);
        Intent intent = new Intent(AttachmentsActivity.this, EditTextAttachmentActivity.class);
        startActivityForResult(intent, REQUEST_TEXT_NEW);

    }

    private File createImageFile() throws IOException {
        // Create an image file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "OM_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_PICTURES);
        File image = File.createTempFile(
                imageFileName,  /* prefix */
                ".jpg",         /* suffix */
                storageDir      /* directory */
        );

        return image;
    }

    private File createVideoFile() throws IOException {
        // Create a video file name
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String videoFileName = "OM_" + timeStamp + "_";
        File storageDir = Environment.getExternalStoragePublicDirectory(
                Environment.DIRECTORY_MOVIES);
        File video = File.createTempFile(
                videoFileName,  /* prefix */
                ".mp4",         /* suffix */
                storageDir      /* directory */
        );

        return video;
    }

    private void dispatchTakePictureIntent() {
        Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        // Ensure that there's a camera activity to handle the intent
        if (takePictureIntent.resolveActivity(getPackageManager()) != null) {
            // Create the File where the photo should go
            File photoFile = null;
            try {
                photoFile = createImageFile();
            } catch (IOException ex) {
                GuiUtil.showError(this, ex.getLocalizedMessage());

            }
            // Continue only if the File was successfully created
            if (photoFile != null) {
                mCurrentPhotoPath = photoFile.getAbsolutePath();    //save for later use
                takePictureIntent.putExtra(MediaStore.EXTRA_OUTPUT,
                        Uri.fromFile(photoFile));
                startActivityForResult(takePictureIntent, REQUEST_IMAGE_NEW);
            }
        }
    }

    private void dispatchTakeVideoIntent() {
        Intent takeVideoIntent = new Intent(MediaStore.ACTION_VIDEO_CAPTURE);
        if (takeVideoIntent.resolveActivity(getPackageManager()) != null) {
            // Create the File where the photo should go
            File videoFile = null;
            try {
                videoFile = createVideoFile();
            } catch (IOException ex) {
                GuiUtil.showError(this, ex.getLocalizedMessage());

            }
            // Continue only if the File was successfully created
            if (videoFile != null) {
                mCurrentVideoPath = videoFile.getAbsolutePath();    //save for later use
                takeVideoIntent.putExtra(MediaStore.EXTRA_OUTPUT,
                        Uri.fromFile(videoFile));

                startActivityForResult(takeVideoIntent, REQUEST_VIDEO_NEW);
            }
        }
    }

    private void galleryAddPic() {
        Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);
        File f = new File(mCurrentPhotoPath);
        Uri contentUri = Uri.fromFile(f);
        mediaScanIntent.setData(contentUri);
        this.sendBroadcast(mediaScanIntent);
    }

    //scale image while decoding so that it does not waste memory
    /*
    private void setPic() {
        // Get the dimensions of the View
        int targetW = mImageView.getWidth();
        int targetH = mImageView.getHeight();

        // Get the dimensions of the bitmap
        BitmapFactory.Options bmOptions = new BitmapFactory.Options();
        bmOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(mCurrentPhotoPath, bmOptions);
        int photoW = bmOptions.outWidth;
        int photoH = bmOptions.outHeight;

        // Determine how much to scale down the image
        int scaleFactor = Math.min(photoW/targetW, photoH/targetH);

        // Decode the image file into a Bitmap sized to fill the View
        bmOptions.inJustDecodeBounds = false;
        bmOptions.inSampleSize = scaleFactor;
        bmOptions.inPurgeable = true;

        Bitmap bitmap = BitmapFactory.decodeFile(mCurrentPhotoPath, bmOptions);
        mImageView.setImageBitmap(bitmap);
    }
    */

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {

        invalidateOptionsMenu();

        if (requestCode == REQUEST_IMAGE_NEW) {
            if (resultCode == RESULT_OK) {

                progressDialog = ProgressDialog.show(AttachmentsActivity.this, "Processing", "Please wait...", true);

                /*
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        progressDialog = ProgressDialog.show(AttachmentsActivity.this, "Processing", "Please wait...", true);
                        try {
                            Thread.sleep(2000);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }

                    }
                });
                */


                Thread thread = new Thread(new Runnable() {
                    @Override
                    public void run() {
                        Bitmap bitmap = BitmapFactory.decodeFile(mCurrentPhotoPath);
                        bitmap = GuiUtil.downscaleIfTooLarge(bitmap, Settings.getSettings(AttachmentsActivity.this).getMaxImageDimension());
                        bitmap = GuiUtil.fixRotationForCameraImage(AttachmentsActivity.this, mCurrentPhotoPath, bitmap);
                        GuiUtil.saveBitmapToJpeg(AttachmentsActivity.this, bitmap, mCurrentPhotoPath);
                        bitmap = null;

                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                progressDialog.hide();
                                Intent editIntent = new Intent(AttachmentsActivity.this, EditImageAttachmentActivity.class);
                                editIntent.putExtra(EditImageAttachmentActivity.EXTRA_FILE_PATH, mCurrentPhotoPath);
                                startActivityForResult(editIntent, REQUEST_UPLOAD);
                            }
                        });
                    }
                });
                thread.start();

            }
        }
        else if(requestCode == REQUEST_VIDEO_NEW) {
            if (resultCode == RESULT_OK) {
                //Uri videoUri = intent.getData();
                Intent editIntent = new Intent(this, EditVideoAttachmentActivity.class);
                editIntent.putExtra(EditVideoAttachmentActivity.EXTRA_FILE_PATH, mCurrentVideoPath);
                startActivityForResult(editIntent, REQUEST_UPLOAD);
            }
        }
        else {
            refreshAttachments();
        }
        /*
        else if (requestCode == REQUEST_VIEW
                || requestCode == REQUEST_UPLOAD
                || requestCode == REQUEST_TEXT_NEW
                || requestCode == REQUEST_AUDIO_NEW) {
            if (resultCode == RESULT_OK) {
                refreshAttachments();
            }
        }
        else if (requestCode == REQUEST_UPLOAD_NOW) {
            refreshAttachments();
        }
        */
    }

    private void refreshAttachments() {


        if (Session.getSession().isOfflineMode()) {
            List<AttachmentsCollection> attachmentList = getPendingAttachments();
            feature.setAttachments(attachmentList);

            ListAdapter adapter = new AttachmentAdapter(this, attachmentList);
            getListView().setAdapter(adapter);
        }
        else {
            progressDialog = ProgressDialog.show(this, null, "Please wait...", true);

//            AttributesByPrimaryIdRequest request = new AttributesByPrimaryIdRequest();
//            request.setShowAttachments(true);
//            request.setLayerId(Session.getSession().getCurrentActiveLayer().getLayerId());
//            request.setPrimaryId(AppUtil.getPrimaryIdForSelectedFeature());
//
//            AttributesService service = new AttributesService();
//            service.getAttributesByPrimaryId(request, this);

            try {
                AttributesBasicApi api = new AttributesBasicApi(AppUtil.getApiClient());
                long layerId = Session.getSession().getCurrentActiveLayer().getLayerId();
                long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
                api.attributesPrimaryIdSearchAsync(layerId, primaryId, "yes", new ApiCallback<OKResponseAttributes>() {
                    @Override
                    public void onFailure(final ApiException e, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                featuresFailed(e.getMessage());
                            }
                        });
                    }

                    @Override
                    public void onSuccess(final OKResponseAttributes result, int statusCode, Map<String, List<String>> responseHeaders) {
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                featuresCompleted(result.getResult());
                            }
                        });
                    }

                    @Override
                    public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {

                    }

                    @Override
                    public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {

                    }
                });
            }
            catch (ApiException e) {
                Log.e(TAG, e.getMessage(), e);
                GuiUtil.showWarning(this, e.getMessage());
            }
        }
    }

    //get attachments that have not yet been uploaded
    private List<AttachmentsCollection> getPendingAttachments() {
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
        List<AttachmentEntry> attachmentEntries = AttachmentsDAO.getAllEntries(this);
        List<AttachmentsCollection> attachmentList = new ArrayList<AttachmentsCollection>();
        for (AttachmentEntry attachmentEntry : attachmentEntries) {
            //only add attachments for the current feature (primary id)

            if (attachmentEntry.getPrimaryId() == primaryId) {
                attachmentList.add(attachmentEntry.getAttachment());
            }
        }
        return attachmentList;
    }


    public void featuresCompleted(OKResponseAttributesResult response) {
        progressDialog.dismiss();

        try {
            //List<AttachmentsCollection> liveAttachments = response.getItems().getFeatures().get(0).getAttachments();
            List<AttachmentsCollection> liveAttachments = response.getGeomResult().getFeatures().get(0).getAttachments();
            List<AttachmentsCollection> pendingAttachments = getPendingAttachments();

            List<AttachmentsCollection> allAttachments = new ArrayList<AttachmentsCollection>();
            allAttachments.addAll(liveAttachments);
            allAttachments.addAll(pendingAttachments);

            feature.setAttachments(allAttachments);

            ListAdapter adapter = new AttachmentAdapter(this, allAttachments);
            getListView().setAdapter(adapter);
        }
        catch (Exception e) {
            GuiUtil.showError(this, "Could not refresh attachments. " + e.getLocalizedMessage());
        }

    }


    public void featuresFailed(String reason) {
        progressDialog.dismiss();

        GuiUtil.showError(this, reason);
    }

    private class AttachmentAdapter extends ArrayAdapter<AttachmentsCollection> {

        private Context context;
        private List<AttachmentsCollection> attachments;

        public AttachmentAdapter(Context context, List<AttachmentsCollection> attachments) {
            super(context, R.layout.attachment_item);

            this.context = context;
            this.attachments = attachments;
        }

        @Override
        public int getCount() {
            return attachments.size();
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {

            View view = convertView;

            if (view == null) {
                LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                view = inflater.inflate(R.layout.attachment_item2, parent, false);
            }

            ImageView iconView = (ImageView)view.findViewById(R.id.icon);
            TextView firstLineView = (TextView)view.findViewById(R.id.firstLine);
            TextView secondLineView = (TextView)view.findViewById(R.id.secondLine);

            AttachmentsCollection attachment = attachments.get(position);

            firstLineView.setText(attachment.getCaption());
            secondLineView.setText(attachment.getDescription());

            if (attachment.getType() != null) {
                if (attachment.getType() == AttachmentsCollection.TypeEnum.AUDIO) {
                    iconView.setImageResource(R.drawable.audio);
                } else if (attachment.getType() == AttachmentsCollection.TypeEnum.VIDEO) {
                    iconView.setImageResource(R.drawable.video);
                } else if (attachment.getType() == AttachmentsCollection.TypeEnum.IMAGE) {
                    iconView.setImageResource(R.drawable.camera);
                } else if (attachment.getType() == AttachmentsCollection.TypeEnum.TEXT) {
                    iconView.setImageResource(R.drawable.docs);
                } else {
                    Toast.makeText(AttachmentsActivity.this, "Unknown file type " + attachment.getType(), Toast.LENGTH_SHORT).show();
                }
            }

            return view;
        }

        @Override
        public AttachmentsCollection getItem(int position) {
            return attachments.get(position);
        }
    }
}
