package org.quidity.demo.activity;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.util.AppUtil;

import java.util.ArrayList;
import java.util.List;

import io.swagger.client.model.Layer;

public class ActiveLayerActivity extends ListActivity implements View.OnClickListener {

    private List<Layer> selectableLayers;
    private Button nextButton;

    private static final int REQ_EDIT_TEMPLATE = 100;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_active_layer);

        AppUtil.initActivity(this);

//        //restore session state
//        if(savedInstanceState != null) {
//            Session savedSession = (Session)savedInstanceState.getSerializable(Settings.SESSION_KEY);
//            Session.restore(savedSession);
//            //Session.restoreSessionState();
//        }

        nextButton = (Button)findViewById(R.id.next);
        nextButton.setOnClickListener(this);

        determineSelectableLayers();

        //ListAdapter adapter = new ArrayAdapter<Layer>(this, android.R.layout.simple_list_item_single_choice, selectableLayers);
        ListAdapter adapter = new MyLayerAdapter(this, selectableLayers);
        getListView().setAdapter(adapter);


        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        Session session = Session.getSession();
        int currentActiveLayerIndex = selectableLayers.indexOf(session.getCurrentActiveLayer());
        if(currentActiveLayerIndex < 0) {
            currentActiveLayerIndex = 0;
        }
        getListView().setItemChecked(currentActiveLayerIndex, true);

        updateButtons();
    }

//    @Override
//    protected void onSaveInstanceState(Bundle outState) {
//        outState.putSerializable(Settings.SESSION_KEY, Session.getSession());
//        //Session.saveSessionState();
//        super.onSaveInstanceState(outState);
//    }

    private void determineSelectableLayers() {
        selectableLayers = new ArrayList<Layer>();

        Layer dummyLayer = new Layer();
        dummyLayer.setLayerCaption("NONE");
        selectableLayers.add(dummyLayer);

        for(Layer layer : Session.getSession().getLayers()) {
            if (!layer.getIsBaseLayer()) {
                if (layer.getVisibility()) {
                    //if (layer.getLayerType().toLowerCase().equalsIgnoreCase("vector")) {
                    if (layer.getLayerType() == Layer.LayerTypeEnum.VECTOR) {
                        selectableLayers.add(layer);
                    }
                }
            }
        }
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        updateButtons();
    }

    @Override
    public void onClick(View view) {

        if (view == nextButton) {
            int position = getListView().getCheckedItemPosition();

            if (position == 0) {
                //NONE selected
                Session.getSession().setCurrentActiveLayer(null);

                setResult(RESULT_OK);
                finish();
            }
            else {
                Layer selectedLayer = selectableLayers.get(position);

                if(selectedLayer != Session.getSession().getCurrentActiveLayer()) {
                    Session.getSession().setCurrentActiveLayer(selectedLayer);

                    //clear any selections
                    Session.getSession().setSelectedFeatureIndex(-1);
                    Session.getSession().setSelectedFeatures(null);

                    //clear previous edit template
                    Session.getSession().setCurrentEditTemplate(null);
                }

                Intent intent = new Intent(this, EditTemplateActivity.class);
                startActivityForResult(intent, REQ_EDIT_TEMPLATE);

            }
        }

    }

    private void updateButtons() {
        int selectedIndex = getListView().getCheckedItemPosition();
        if (selectedIndex <= 0) {
            nextButton.setText("Done");
        }
        else {
            nextButton.setText("Next >");
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if(requestCode == REQ_EDIT_TEMPLATE) {
            if (resultCode == RESULT_OK) {
                //go back where we came from
                setResult(RESULT_OK);
                finish();
            }
        }
    }

    public class MyLayerAdapter extends ArrayAdapter<Layer> {
        public MyLayerAdapter(Context context, List<Layer> users) {
            super(context, android.R.layout.simple_list_item_single_choice, users);
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            // Get the data item for this position
            Layer layer = getItem(position);

            // Check if an existing view is being reused, otherwise inflate the view
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(android.R.layout.simple_list_item_single_choice, parent, false);
            }

            // Lookup view for data population
            TextView tvName = (TextView) convertView.findViewById(android.R.id.text1);

            // Populate the data into the template view using the data object
            tvName.setText(layer.getLayerCaption());

            // Return the completed view to render on screen
            return convertView;
        }
    }

}
