package org.quidity.demo;

import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class Settings {

    public static final String SESSION_KEY = "Session";

    //public static final String MAPI_BASE_URL = "http://www.1map.co.za/mobile";
    public static final String MAPI_BASE_URL = "https://www.1map.co.za/mobile";
    public static final String MAPI_AUTH_URL = MAPI_BASE_URL + "/auth";
    public static final String MAPI_PARAMS_URL = MAPI_BASE_URL + "/params";
    public static final String MAPI_ATTRIBUTES_URL = MAPI_BASE_URL + "/attributes";
    public static final String MAPI_SPATIAL_URL = MAPI_BASE_URL + "/spatial";
    public static final String MAPI_TRACKING_URL = MAPI_BASE_URL + "/tracking";
    public static final String MAPI_OFFLINE_URL = MAPI_BASE_URL + "/offline";

    public static final String API_BASE_URL = "https://www.1map.co.za/api/v1";

    public static final int SPEED_SLOW_DRIVE = 20;
    public static final int SPEED_FAST_DRIVE = 90;

    public static final int ZOOM_LEVEL_DEFAULT = 17;        //when standing still or walking
    public static final int ZOOM_LEVEL_SLOW_DRIVE = 16;
    public static final int ZOOM_LEVEL_FAST_DRIVE = 15;
    public static final int ZOOM_LEVEL_SEARCH = 17;         //zoom level for search results
    public static final int ZOOM_LEVEL_OFFLINE = 17;        //default zoom level for offline maps

    public static final boolean DISABLE_GOOGLE_LAYERS = true;

    public static final String OFFLINE_TILE_PREFIX = "tile_";
    public static final int OFFLINE_TILE_QUALITY = 60;          //jpeg compression percentage

    public static final int MAX_TILES_TO_PREPARE = 5000;


    //public static final int MAX_IMAGE_DIMENSION = 1600;     //max image resolution (width or height)
    //public static final int JPEG_COMPRESSION = 70;          //percentage compression to use with JPEG images

    private static Settings settings;
    public static final String PREFERENCES_NAME = "1Map";
    private static final String BATCH_UPLOAD_KEY = "BatchUpload";
    private static final String AUTO_CLEAR_ATTACHMENTS_CACHE_KEY = "AutoClearAttachmentsCache";
    private static final String AUTO_ZOOM_KEY = "AutoZoom";
    private static final String KEEP_SCREEN_ON_KEY = "KeepScreenOn";
    private static final String PREVIOUS_USERNAME_KEY = "PreviousUsername";
    private static final String PREVIOUS_USER_ID_KEY = "PreviousUserID";
    private static final String PREVIOUS_PASSWORD_KEY = "PreviousPassword";
    private static final String PREVIOUS_OFFLINE_MODE_KEY = "PreviousOfflineMode";
    private static final String PREVIOUS_OFFLINE_MAP_KEY = "PreviousOfflineMap";
    private static final String SAVE_PASSWORD_KEY = "SavePassword";
    private static final String LOG_LOCATION_KEY = "LogLocation";
    private static final String LOG_LOCATION_INTERVAL_KEY = "LogLocationInterval";
    private static final String CAPTURE_IMAGE_LOCATION_KEY = "CaptureImageLocation";
    private static final String DESIRED_ACCURACY_KEY = "DesiredAccuracy";
    private static final String MAX_IMAGE_DIMENSION = "MaxImageDimension";
    private static final String JPEG_COMPRESSION = "JpegCompression";
    private static final String EDIT_RADIUS_ENABLED_KEY = "EditRadiusEnabled";
    private static final String EDIT_RADIUS_KEY = "EditRadius";

    private SharedPreferences preferences;
    private boolean batchUploadEnabled;
    private boolean autoClearAttachmentsCacheEnabled;
    private boolean autoZoomEnabled;
    private boolean keepScreenOn;
    private boolean logLocation;
    private int logLocationInterval;
    private boolean captureImageLocation;
    private int desiredAccuracy;
    private int maxImageDimension;
    private int jpegCompression;
    private boolean editRadiusEnabled;
    private int editRadius;

    private String previousUsername;
    private long previousUserId;
    private String previousPassword;
    private boolean previousOfflineMode;
    private String previousOfflineMap;
    private boolean savePassword;


    //private String savedSessionJSON;

    private Settings() {
        //singleton
    }

    public static Settings getSettings(Context context) {
        if (settings == null) {
            settings = new Settings();
            settings.loadSettings(context);
        }
        return settings;
    }

    private void loadSettings(Context context) {
        preferences = context.getSharedPreferences(PREFERENCES_NAME, Context.MODE_PRIVATE);
        this.batchUploadEnabled = preferences.getBoolean(BATCH_UPLOAD_KEY, true);
        this.autoClearAttachmentsCacheEnabled = preferences.getBoolean(AUTO_CLEAR_ATTACHMENTS_CACHE_KEY, true);
        this.autoZoomEnabled = preferences.getBoolean(AUTO_ZOOM_KEY, true);
        this.keepScreenOn = preferences.getBoolean(KEEP_SCREEN_ON_KEY, true);
        this.logLocation = preferences.getBoolean(LOG_LOCATION_KEY, false);
        this.logLocationInterval = preferences.getInt(LOG_LOCATION_INTERVAL_KEY, 10);
        this.captureImageLocation = preferences.getBoolean(CAPTURE_IMAGE_LOCATION_KEY, true);
        this.desiredAccuracy = preferences.getInt(DESIRED_ACCURACY_KEY, 10);
        this.previousUsername = preferences.getString(PREVIOUS_USERNAME_KEY, "");
        this.previousUserId = preferences.getLong(PREVIOUS_USER_ID_KEY, -1);
        this.previousPassword = preferences.getString(PREVIOUS_PASSWORD_KEY, "");
        this.savePassword = preferences.getBoolean(SAVE_PASSWORD_KEY, false);
        this.maxImageDimension = preferences.getInt(MAX_IMAGE_DIMENSION, 1600);
        this.jpegCompression = preferences.getInt(JPEG_COMPRESSION, 70);
        this.previousOfflineMode = preferences.getBoolean(PREVIOUS_OFFLINE_MODE_KEY, false);
        this.previousOfflineMap = preferences.getString(PREVIOUS_OFFLINE_MAP_KEY, null);
        this.editRadiusEnabled = preferences.getBoolean(EDIT_RADIUS_ENABLED_KEY, false);
        this.editRadius = preferences.getInt(EDIT_RADIUS_KEY, 50);
    }

    public int getMaxImageDimension() {
        return maxImageDimension;
    }

    public void setMaxImageDimension(int maxImageDimension) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(MAX_IMAGE_DIMENSION, maxImageDimension);
        editor.commit();

        this.maxImageDimension = maxImageDimension;
    }

    public int getJpegCompression() {
        return jpegCompression;
    }

    public void setJpegCompression(int jpegCompression) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(JPEG_COMPRESSION, jpegCompression);
        editor.commit();

        this.jpegCompression = jpegCompression;
    }

    public boolean isBatchUploadEnabled() {
        return batchUploadEnabled;
    }

    public void setBatchUploadEnabled(boolean batchUploadEnabled) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(BATCH_UPLOAD_KEY, batchUploadEnabled);
        editor.commit();

        this.batchUploadEnabled = batchUploadEnabled;

    }

    public boolean isAutoClearAttachmentsCacheEnabled() {
        return autoClearAttachmentsCacheEnabled;
    }

    public void setAutoClearAttachmentsCacheEnabled(boolean autoClearAttachmentsCacheEnabled) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(AUTO_CLEAR_ATTACHMENTS_CACHE_KEY, autoClearAttachmentsCacheEnabled);
        editor.commit();

        this.autoClearAttachmentsCacheEnabled = autoClearAttachmentsCacheEnabled;
    }

    public boolean isAutoZoomEnabled() {
        return autoZoomEnabled;
    }

    public void setAutoZoomEnabled(boolean autoZoomEnabled) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(AUTO_ZOOM_KEY, autoZoomEnabled);
        editor.commit();

        this.autoZoomEnabled = autoZoomEnabled;
    }

    public boolean isKeepScreenOn() {
        return keepScreenOn;
    }

    public void setKeepScreenOn(boolean keepScreenOn) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(KEEP_SCREEN_ON_KEY, keepScreenOn);
        editor.commit();

        this.keepScreenOn = keepScreenOn;

    }

    public boolean isLogLocation() {
        return logLocation;
    }

    public void setLogLocation(boolean logLocation) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(LOG_LOCATION_KEY, logLocation);
        editor.commit();

        this.logLocation = logLocation;
    }

    public int getLogLocationInterval() {
        return logLocationInterval;
    }

    public void setLogLocationInterval(int logLocationInterval) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(LOG_LOCATION_INTERVAL_KEY, logLocationInterval);
        editor.commit();

        this.logLocationInterval = logLocationInterval;
    }

    public boolean isCaptureImageLocation() {
        return captureImageLocation;
    }

    public void setCaptureImageLocation(boolean captureImageLocation) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(CAPTURE_IMAGE_LOCATION_KEY, captureImageLocation);
        editor.commit();

        this.captureImageLocation = captureImageLocation;
    }

    public int getDesiredAccuracy() {
        return desiredAccuracy;
    }

    public void setDesiredAccuracy(int desiredAccuracy) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(DESIRED_ACCURACY_KEY, desiredAccuracy);
        editor.commit();

        this.desiredAccuracy = desiredAccuracy;
    }


    public long getPreviousUserId() {
        return previousUserId;
    }

    public void setPreviousUserId(long previousUserId) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putLong(PREVIOUS_USER_ID_KEY, previousUserId);
        editor.commit();

        this.previousUserId = previousUserId;
    }

    public String getPreviousUsername() {
        return previousUsername;
    }

    public void setPreviousUsername(String previousUsername) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(PREVIOUS_USERNAME_KEY, previousUsername);
        editor.commit();

        this.previousUsername = previousUsername;
    }


    public String getPreviousPassword() {
        return previousPassword;
    }

    public void setPreviousPassword(String previousPassword) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(PREVIOUS_PASSWORD_KEY, previousPassword);
        editor.commit();

        this.previousPassword = previousPassword;
    }

    public boolean isSavePassword() {
        return savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(SAVE_PASSWORD_KEY, savePassword);
        editor.commit();

        this.savePassword = savePassword;
    }

    public boolean isPreviousOfflineMode() {
        return previousOfflineMode;
    }

    public void setPreviousOfflineMode(boolean previousOfflineMode) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(PREVIOUS_OFFLINE_MODE_KEY, previousOfflineMode);
        editor.commit();

        this.previousOfflineMode = previousOfflineMode;

    }

    public String getPreviousOfflineMap() {
        return previousOfflineMap;
    }

    public void setPreviousOfflineMap(String previousOfflineMap) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(PREVIOUS_OFFLINE_MAP_KEY, previousOfflineMap);
        editor.commit();

        this.previousOfflineMap = previousOfflineMap;

    }

    public boolean isEditRadiusEnabled() {
        return editRadiusEnabled;
    }

    public void setEditRadiusEnabled(boolean editRadiusEnabled) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean(EDIT_RADIUS_ENABLED_KEY, editRadiusEnabled);
        editor.commit();

        this.editRadiusEnabled = editRadiusEnabled;

    }

    public int getEditRadius() {
        return editRadius;
    }

    public void setEditRadius(int editRadius) {
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(EDIT_RADIUS_KEY, editRadius);
        editor.commit();

        this.editRadius = editRadius;

    }
}
