package org.quidity.demo;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;

import com.github.filosganga.geogson.model.Feature;
import com.google.gson.Gson;

import java.io.Serializable;
import java.util.List;

import org.quidity.demo.activity.OneMapJavascriptInterface;
import org.quidity.demo.activity.OpenLayersMapActivity;

import io.swagger.client.model.EditTemplate;
import io.swagger.client.model.EditTemplateField;
import io.swagger.client.model.ErfWithNADAddresses;
import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.FeatureWithAttachments;
import io.swagger.client.model.Field;
import io.swagger.client.model.Layer;
import io.swagger.client.model.NADAddress;
import io.swagger.client.model.Workspace;


/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class Session implements Serializable {

    public static final String EDIT_MODE_CREATE = "CREATE";
    public static final String EDIT_MODE_UPDATE = "UPDATE";

    public static final String MOVE_MODE_CURRENT = "CURRENT";
    public static final String MOVE_MODE_ALL = "ALL";

    /*
    public enum AppMode {
        ONLINE,
        OFFLINE
    }
    */

    private String mapGuid;
    private String token;
    private String serial;
    private List<Workspace> workspaces;
    private List<Layer> layers;
    private Workspace currentWorkspace;
    private Layer currentBaseLayer;
    private Layer currentActiveLayer;
    private boolean activeLayerChanged;
    private OneMapJavascriptInterface javascriptInterface;
    private int orientation;
    private List<FeatureWithAttachments> selectedFeatures;
    private List<Feature> selectedFeatures2;
    private int selectedFeatureIndex;
    private EditTemplate currentEditTemplate;
    private List<EditTemplateField> currentEditTemplateFields;
    private String editMode;
    private String moveMode;
    private int selectedAttachmentIndex;
    private double currentLatitude;
    private double currentLongitude;
    private Layer selectedLayer;
    private List<Field> selectedFeatureFields;

    private boolean searchTypeAddress;
    private List<NADAddress> nadAddresses;
    private ErfWithNADAddresses erfWithNADAddresses;

    //private AppMode appMode = AppMode.ONLINE;
    private boolean offlineMode = false;

    private static Session session;

    private Session() {
        //singleton
    }

    public static synchronized Session getSession() {

            if (session == null) {
                Log.d(Session.class.getCanonicalName(), "--- CREATING NEW SESSION INSTANCE ---");
                session = new Session();

                /*
                //try to restore saved session
                try {
                    session = Paper.get(Settings.SESSION_KEY);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }

                //create new object if there is no persistent session
                if (session == null) {
                    session = new Session();
                }
                */
            }
            return session;

    }


    public static synchronized void resetSession() {

        /*
            try {
                Paper.delete(Settings.SESSION_KEY);
            } catch (Exception e) {
                e.printStackTrace();
            }
        */
        session = null;

    }

    public static void restore(Session restoredSession) {
        System.out.println("--- Restoring session state ---");

        session = restoredSession;
    }



    /*
    public static synchronized void saveSessionState() {

            try {
                Paper.put(Settings.SESSION_KEY, session);
            } catch (Exception e) {
                e.printStackTrace();
            }

    }
    */

    /*
    public static synchronized void restoreSessionState() {


            try {
                session = Paper.get(Settings.SESSION_KEY);
            } catch (Exception e) {
                e.printStackTrace();
            }

    }
    */


    public OneMapJavascriptInterface getJavascriptInterface(OpenLayersMapActivity mapActivity) {
        if (javascriptInterface == null) {
            javascriptInterface = new OneMapJavascriptInterface(mapActivity);
        }
        return javascriptInterface;
    }


    public String getMapGuid() {
        return mapGuid;
    }

    public void setMapGuid(String mapGuid) {
        this.mapGuid = mapGuid;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getSerial() {
        return serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public List<Workspace> getWorkspaces() {
        return workspaces;
    }

    public void setWorkspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
    }

    public List<Layer> getLayers() {
        return layers;
    }

    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    public Workspace getCurrentWorkspace() {
        return currentWorkspace;
    }

    public void setCurrentWorkspace(Workspace currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }

    public Layer getCurrentBaseLayer() {
        return currentBaseLayer;
    }

    public void setCurrentBaseLayer(Layer currentBaseLayer) {
        this.currentBaseLayer = currentBaseLayer;
    }

    public Layer getCurrentActiveLayer() {
        return currentActiveLayer;
    }

    public void setCurrentActiveLayer(Layer newActiveLayer) {

        activeLayerChanged = currentActiveLayer != newActiveLayer;

        this.currentActiveLayer = newActiveLayer;
    }

    public int getOrientation() {
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public List<FeatureWithAttachments> getSelectedFeatures() {
        return selectedFeatures;
    }

    public void setSelectedFeatures(List<FeatureWithAttachments> selectedFeatures) {
        this.selectedFeatures = selectedFeatures;
    }

    public EditTemplate getCurrentEditTemplate() {
        return currentEditTemplate;
    }

    public void setCurrentEditTemplate(EditTemplate currentEditTemplate) {
        this.currentEditTemplate = currentEditTemplate;
    }

    public List<EditTemplateField> getCurrentEditTemplateFields() {
        return currentEditTemplateFields;
    }

    public void setCurrentEditTemplateFields(List<EditTemplateField> currentEditTemplateFields) {
        this.currentEditTemplateFields = currentEditTemplateFields;
    }



    public int getSelectedFeatureIndex() {
        return selectedFeatureIndex;
    }

    public void setSelectedFeatureIndex(int selectedFeatureIndex) {
        this.selectedFeatureIndex = selectedFeatureIndex;
    }

    public String getEditMode() {
        return editMode;
    }

    public void setEditMode(String editMode) {
        this.editMode = editMode;
    }

    public int getSelectedAttachmentIndex() {
        return selectedAttachmentIndex;
    }

    public void setSelectedAttachmentIndex(int selectedAttachmentIndex) {
        this.selectedAttachmentIndex = selectedAttachmentIndex;
    }

    public double getCurrentLongitude() {
        return currentLongitude;
    }

    public void setCurrentLongitude(double currentLongitude) {
        this.currentLongitude = currentLongitude;
    }

    public double getCurrentLatitude() {
        return currentLatitude;
    }

    public void setCurrentLatitude(double currentLatitude) {
        this.currentLatitude = currentLatitude;
    }

    public Layer getSelectedLayer() {
        return selectedLayer;
    }

    public void setSelectedLayer(Layer selectedLayer) {
        this.selectedLayer = selectedLayer;
    }

    public List<Field> getSelectedFeatureFields() {
        return selectedFeatureFields;
    }

    public void setSelectedFeatureFields(List<Field> selectedFeatureFields) {
        this.selectedFeatureFields = selectedFeatureFields;
    }

    public String getMoveMode() {
        return moveMode;
    }

    public void setMoveMode(String moveMode) {
        this.moveMode = moveMode;
    }

    public boolean isActiveLayerChanged() {
        return activeLayerChanged;
    }

    public void setActiveLayerChanged(boolean activeLayerChanged) {
        this.activeLayerChanged = activeLayerChanged;
    }

    /*
    public AppMode getAppMode() {
        return appMode;
    }

    public void setAppMode(AppMode appMode) {
        this.appMode = appMode;
    }
    */

    public boolean isOfflineMode() {
        return offlineMode;
    }

    public void setOfflineMode(boolean offlineMode) {
        this.offlineMode = offlineMode;
    }

    public List<NADAddress> getNadAddresses() {
        return nadAddresses;
    }

    public void setNadAddresses(List<NADAddress> nadAddresses) {
        this.nadAddresses = nadAddresses;
    }

    public boolean isSearchTypeAddress() {
        return searchTypeAddress;
    }

    public void setSearchTypeAddress(boolean searchTypeAddress) {
        this.searchTypeAddress = searchTypeAddress;
    }

    public ErfWithNADAddresses getErfWithNADAddresses() {
        return erfWithNADAddresses;
    }

    public void setErfWithNADAddresses(ErfWithNADAddresses erfWithNADAddresses) {
        this.erfWithNADAddresses = erfWithNADAddresses;
    }

    public List<Feature> getSelectedFeatures2() {
        return selectedFeatures2;
    }

    public void setSelectedFeatures2(List<Feature> selectedFeatures2) {
        this.selectedFeatures2 = selectedFeatures2;
    }
}
