package org.quidity.demo;

import android.app.Application;
import android.support.multidex.MultiDexApplication;
import android.support.v4.*;
import android.util.Log;

import com.crashlytics.android.Crashlytics;
import com.crashlytics.android.core.CrashlyticsCore;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.Tracker;

import io.fabric.sdk.android.Fabric;
import java.util.HashMap;



/**
 * Created by ferdiedanzfuss on 14/11/21.
 */
public class OneMapApplication extends MultiDexApplication {

    private Tracker mTracker;
    //private Session session;


    @Override
    public void onCreate() {
        super.onCreate();

        //init Crashlytics - disable for debug builds
        //boolean isDebugMode = BuildConfig.DEBUG;
        boolean isDebugMode = false;
        Log.d(OneMapApplication.class.getCanonicalName(), "Crashlytics isDebugMode: " + isDebugMode);
        CrashlyticsCore core = new CrashlyticsCore.Builder().disabled(isDebugMode).build();
        Crashlytics crashlytics = new Crashlytics.Builder().core(core).build();
        Fabric.with(this, crashlytics);


        Log.d(OneMapApplication.class.getCanonicalName(), "--- APPLICATION CREATED ---");

        //Paper.init(this);
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        Log.d(OneMapApplication.class.getCanonicalName(), "--- APPLICATION LOW MEMORY ---");
    }

    //This method is never called - useless
    /*
    @Override
    public void onTerminate() {
        super.onTerminate();
        Log.d(OneMapApplication.class.getCanonicalName(), "--- APPLICATION TERMINATE ---");
    }
    */

    public synchronized Tracker getTracker() {
        if (mTracker == null) {

            GoogleAnalytics analytics = GoogleAnalytics.getInstance(this);
            mTracker = analytics.newTracker(R.xml.app_tracker);

            mTracker.enableAdvertisingIdCollection(true);
        }
        return mTracker;
    }

    /*
    public synchronized Session getSession() {
        return session;
    }
    */
}
