/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Info regarding the selected workspace
 */
@ApiModel(description = "Info regarding the selected workspace")

public class Workspace {
  @SerializedName("workspaceId")
  private Long workspaceId = null;

  @SerializedName("workspaceName")
  private String workspaceName = null;

  @SerializedName("default")
  private Boolean _default = null;

  @SerializedName("private")
  private Boolean _private = null;

  public Workspace workspaceId(Long workspaceId) {
    this.workspaceId = workspaceId;
    return this;
  }

   /**
   * Workspace unique 1map id number - Primary Key
   * @return workspaceId
  **/
  @ApiModelProperty(value = "Workspace unique 1map id number - Primary Key")
  public Long getWorkspaceId() {
    return workspaceId;
  }

  public void setWorkspaceId(Long workspaceId) {
    this.workspaceId = workspaceId;
  }

  public Workspace workspaceName(String workspaceName) {
    this.workspaceName = workspaceName;
    return this;
  }

   /**
   * Workspace Caption/Name
   * @return workspaceName
  **/
  @ApiModelProperty(value = "Workspace Caption/Name")
  public String getWorkspaceName() {
    return workspaceName;
  }

  public void setWorkspaceName(String workspaceName) {
    this.workspaceName = workspaceName;
  }

  public Workspace _default(Boolean _default) {
    this._default = _default;
    return this;
  }

   /**
   * Indicate if this is the default workspace
   * @return _default
  **/
  @ApiModelProperty(value = "Indicate if this is the default workspace")
  public Boolean getDefault() {
    return _default;
  }

  public void setDefault(Boolean _default) {
    this._default = _default;
  }

  public Workspace _private(Boolean _private) {
    this._private = _private;
    return this;
  }

   /**
   * Indicate if the workspace is private or not
   * @return _private
  **/
  @ApiModelProperty(value = "Indicate if the workspace is private or not")
  public Boolean getPrivate() {
    return _private;
  }

  public void setPrivate(Boolean _private) {
    this._private = _private;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Workspace workspace = (Workspace) o;
    return Objects.equals(this.workspaceId, workspace.workspaceId) &&
        Objects.equals(this.workspaceName, workspace.workspaceName) &&
        Objects.equals(this._default, workspace._default) &&
        Objects.equals(this._private, workspace._private);
  }

  @Override
  public int hashCode() {
    return Objects.hash(workspaceId, workspaceName, _default, _private);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Workspace {\n");
    
    sb.append("    workspaceId: ").append(toIndentedString(workspaceId)).append("\n");
    sb.append("    workspaceName: ").append(toIndentedString(workspaceName)).append("\n");
    sb.append("    _default: ").append(toIndentedString(_default)).append("\n");
    sb.append("    _private: ").append(toIndentedString(_private)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

