/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Account;
import io.swagger.client.model.Role;
import io.swagger.client.model.Workspace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Info regarding the selected user
 */
@ApiModel(description = "Info regarding the selected user")

public class User {
  @SerializedName("userId")
  private Long userId = null;

  @SerializedName("userName")
  private String userName = null;

  @SerializedName("firstName")
  private String firstName = null;

  @SerializedName("lastName")
  private String lastName = null;

  @SerializedName("email")
  private String email = null;

  @SerializedName("subscription")
  private String subscription = null;

  @SerializedName("account")
  private Account account = null;

  @SerializedName("roles")
  private List<Role> roles = null;

  @SerializedName("workspaces")
  private List<Workspace> workspaces = null;

  public User userId(Long userId) {
    this.userId = userId;
    return this;
  }

   /**
   * User&#39;s unique 1map id number - Primary Key
   * @return userId
  **/
  @ApiModelProperty(value = "User's unique 1map id number - Primary Key")
  public Long getUserId() {
    return userId;
  }

  public void setUserId(Long userId) {
    this.userId = userId;
  }

  public User userName(String userName) {
    this.userName = userName;
    return this;
  }

   /**
   * Username
   * @return userName
  **/
  @ApiModelProperty(value = "Username")
  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }

  public User firstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

   /**
   * User&#39;s first name
   * @return firstName
  **/
  @ApiModelProperty(value = "User's first name")
  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public User lastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

   /**
   * User&#39;s surname
   * @return lastName
  **/
  @ApiModelProperty(value = "User's surname")
  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }

  public User email(String email) {
    this.email = email;
    return this;
  }

   /**
   * User&#39;s registered email address
   * @return email
  **/
  @ApiModelProperty(value = "User's registered email address")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public User subscription(String subscription) {
    this.subscription = subscription;
    return this;
  }

   /**
   * User Subscription - lite, pro, pro_trial, premium, premium_trial, enterprise, enterprise_trial, accademic
   * @return subscription
  **/
  @ApiModelProperty(value = "User Subscription - lite, pro, pro_trial, premium, premium_trial, enterprise, enterprise_trial, accademic")
  public String getSubscription() {
    return subscription;
  }

  public void setSubscription(String subscription) {
    this.subscription = subscription;
  }

  public User account(Account account) {
    this.account = account;
    return this;
  }

   /**
   * Get account
   * @return account
  **/
  @ApiModelProperty(value = "")
  public Account getAccount() {
    return account;
  }

  public void setAccount(Account account) {
    this.account = account;
  }

  public User roles(List<Role> roles) {
    this.roles = roles;
    return this;
  }

  public User addRolesItem(Role rolesItem) {
    if (this.roles == null) {
      this.roles = new ArrayList<Role>();
    }
    this.roles.add(rolesItem);
    return this;
  }

   /**
   * List of all roles the user belongs to
   * @return roles
  **/
  @ApiModelProperty(value = "List of all roles the user belongs to")
  public List<Role> getRoles() {
    return roles;
  }

  public void setRoles(List<Role> roles) {
    this.roles = roles;
  }

  public User workspaces(List<Workspace> workspaces) {
    this.workspaces = workspaces;
    return this;
  }

  public User addWorkspacesItem(Workspace workspacesItem) {
    if (this.workspaces == null) {
      this.workspaces = new ArrayList<Workspace>();
    }
    this.workspaces.add(workspacesItem);
    return this;
  }

   /**
   * List of all available workspaces for the user
   * @return workspaces
  **/
  @ApiModelProperty(value = "List of all available workspaces for the user")
  public List<Workspace> getWorkspaces() {
    return workspaces;
  }

  public void setWorkspaces(List<Workspace> workspaces) {
    this.workspaces = workspaces;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    User user = (User) o;
    return Objects.equals(this.userId, user.userId) &&
        Objects.equals(this.userName, user.userName) &&
        Objects.equals(this.firstName, user.firstName) &&
        Objects.equals(this.lastName, user.lastName) &&
        Objects.equals(this.email, user.email) &&
        Objects.equals(this.subscription, user.subscription) &&
        Objects.equals(this.account, user.account) &&
        Objects.equals(this.roles, user.roles) &&
        Objects.equals(this.workspaces, user.workspaces);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userId, userName, firstName, lastName, email, subscription, account, roles, workspaces);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class User {\n");
    
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    subscription: ").append(toIndentedString(subscription)).append("\n");
    sb.append("    account: ").append(toIndentedString(account)).append("\n");
    sb.append("    roles: ").append(toIndentedString(roles)).append("\n");
    sb.append("    workspaces: ").append(toIndentedString(workspaces)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

