/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Result Information
 */
@ApiModel(description = "Result Information")

public class ResultInfo {
  @SerializedName("startItemIndex")
  private Long startItemIndex = null;

  @SerializedName("endItemIndex")
  private Long endItemIndex = null;

  @SerializedName("currentPage")
  private Long currentPage = null;

  @SerializedName("totalPages")
  private Long totalPages = null;

  @SerializedName("pageLength")
  private Long pageLength = null;

  @SerializedName("totalResults")
  private Long totalResults = null;

  public ResultInfo startItemIndex(Long startItemIndex) {
    this.startItemIndex = startItemIndex;
    return this;
  }

   /**
   * Index of first item in result
   * @return startItemIndex
  **/
  @ApiModelProperty(value = "Index of first item in result")
  public Long getStartItemIndex() {
    return startItemIndex;
  }

  public void setStartItemIndex(Long startItemIndex) {
    this.startItemIndex = startItemIndex;
  }

  public ResultInfo endItemIndex(Long endItemIndex) {
    this.endItemIndex = endItemIndex;
    return this;
  }

   /**
   * Index of last item in result
   * @return endItemIndex
  **/
  @ApiModelProperty(value = "Index of last item in result")
  public Long getEndItemIndex() {
    return endItemIndex;
  }

  public void setEndItemIndex(Long endItemIndex) {
    this.endItemIndex = endItemIndex;
  }

  public ResultInfo currentPage(Long currentPage) {
    this.currentPage = currentPage;
    return this;
  }

   /**
   * Current page number
   * @return currentPage
  **/
  @ApiModelProperty(value = "Current page number")
  public Long getCurrentPage() {
    return currentPage;
  }

  public void setCurrentPage(Long currentPage) {
    this.currentPage = currentPage;
  }

  public ResultInfo totalPages(Long totalPages) {
    this.totalPages = totalPages;
    return this;
  }

   /**
   * Number of Total Pages
   * @return totalPages
  **/
  @ApiModelProperty(value = "Number of Total Pages")
  public Long getTotalPages() {
    return totalPages;
  }

  public void setTotalPages(Long totalPages) {
    this.totalPages = totalPages;
  }

  public ResultInfo pageLength(Long pageLength) {
    this.pageLength = pageLength;
    return this;
  }

   /**
   * Number of Records per Page
   * @return pageLength
  **/
  @ApiModelProperty(value = "Number of Records per Page")
  public Long getPageLength() {
    return pageLength;
  }

  public void setPageLength(Long pageLength) {
    this.pageLength = pageLength;
  }

  public ResultInfo totalResults(Long totalResults) {
    this.totalResults = totalResults;
    return this;
  }

   /**
   * Number of Records for all Pages
   * @return totalResults
  **/
  @ApiModelProperty(value = "Number of Records for all Pages")
  public Long getTotalResults() {
    return totalResults;
  }

  public void setTotalResults(Long totalResults) {
    this.totalResults = totalResults;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResultInfo resultInfo = (ResultInfo) o;
    return Objects.equals(this.startItemIndex, resultInfo.startItemIndex) &&
        Objects.equals(this.endItemIndex, resultInfo.endItemIndex) &&
        Objects.equals(this.currentPage, resultInfo.currentPage) &&
        Objects.equals(this.totalPages, resultInfo.totalPages) &&
        Objects.equals(this.pageLength, resultInfo.pageLength) &&
        Objects.equals(this.totalResults, resultInfo.totalResults);
  }

  @Override
  public int hashCode() {
    return Objects.hash(startItemIndex, endItemIndex, currentPage, totalPages, pageLength, totalResults);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResultInfo {\n");
    
    sb.append("    startItemIndex: ").append(toIndentedString(startItemIndex)).append("\n");
    sb.append("    endItemIndex: ").append(toIndentedString(endItemIndex)).append("\n");
    sb.append("    currentPage: ").append(toIndentedString(currentPage)).append("\n");
    sb.append("    totalPages: ").append(toIndentedString(totalPages)).append("\n");
    sb.append("    pageLength: ").append(toIndentedString(pageLength)).append("\n");
    sb.append("    totalResults: ").append(toIndentedString(totalResults)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

