/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.EditTemplate;
import io.swagger.client.model.Layer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * OKResponseParamsLayerEditTemplatesResult
 */

public class OKResponseParamsLayerEditTemplatesResult {
  @SerializedName("layer")
  private Layer layer = null;

  @SerializedName("editTemplates")
  private List<EditTemplate> editTemplates = null;

  public OKResponseParamsLayerEditTemplatesResult layer(Layer layer) {
    this.layer = layer;
    return this;
  }

   /**
   * Get layer
   * @return layer
  **/
  @ApiModelProperty(value = "")
  public Layer getLayer() {
    return layer;
  }

  public void setLayer(Layer layer) {
    this.layer = layer;
  }

  public OKResponseParamsLayerEditTemplatesResult editTemplates(List<EditTemplate> editTemplates) {
    this.editTemplates = editTemplates;
    return this;
  }

  public OKResponseParamsLayerEditTemplatesResult addEditTemplatesItem(EditTemplate editTemplatesItem) {
    if (this.editTemplates == null) {
      this.editTemplates = new ArrayList<EditTemplate>();
    }
    this.editTemplates.add(editTemplatesItem);
    return this;
  }

   /**
   * List of all edit templates for the selected layer.  This can be an array with a single edit template or multiple edit templates, depending on the editTemplateId parameter passed.
   * @return editTemplates
  **/
  @ApiModelProperty(value = "List of all edit templates for the selected layer.  This can be an array with a single edit template or multiple edit templates, depending on the editTemplateId parameter passed.")
  public List<EditTemplate> getEditTemplates() {
    return editTemplates;
  }

  public void setEditTemplates(List<EditTemplate> editTemplates) {
    this.editTemplates = editTemplates;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OKResponseParamsLayerEditTemplatesResult okResponseParamsLayerEditTemplatesResult = (OKResponseParamsLayerEditTemplatesResult) o;
    return Objects.equals(this.layer, okResponseParamsLayerEditTemplatesResult.layer) &&
        Objects.equals(this.editTemplates, okResponseParamsLayerEditTemplatesResult.editTemplates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(layer, editTemplates);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OKResponseParamsLayerEditTemplatesResult {\n");
    
    sb.append("    layer: ").append(toIndentedString(layer)).append("\n");
    sb.append("    editTemplates: ").append(toIndentedString(editTemplates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

