/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.NADAddress;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * OKResponseAddressIntersectResult
 */

public class OKResponseAddressIntersectResult {
  @SerializedName("nadAddresses")
  private List<NADAddress> nadAddresses = null;

  public OKResponseAddressIntersectResult nadAddresses(List<NADAddress> nadAddresses) {
    this.nadAddresses = nadAddresses;
    return this;
  }

  public OKResponseAddressIntersectResult addNadAddressesItem(NADAddress nadAddressesItem) {
    if (this.nadAddresses == null) {
      this.nadAddresses = new ArrayList<NADAddress>();
    }
    this.nadAddresses.add(nadAddressesItem);
    return this;
  }

   /**
   * List of Street addresses from the 1map NAD that intersects given area (polygon).
   * @return nadAddresses
  **/
  @ApiModelProperty(value = "List of Street addresses from the 1map NAD that intersects given area (polygon).")
  public List<NADAddress> getNadAddresses() {
    return nadAddresses;
  }

  public void setNadAddresses(List<NADAddress> nadAddresses) {
    this.nadAddresses = nadAddresses;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OKResponseAddressIntersectResult okResponseAddressIntersectResult = (OKResponseAddressIntersectResult) o;
    return Objects.equals(this.nadAddresses, okResponseAddressIntersectResult.nadAddresses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nadAddresses);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OKResponseAddressIntersectResult {\n");
    
    sb.append("    nadAddresses: ").append(toIndentedString(nadAddresses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

