/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Polygon;
import java.io.IOException;
import org.joda.time.DateTime;

/**
 * Info regarding the selected NAD Address
 */
@ApiModel(description = "Info regarding the selected NAD Address")

public class NADAddress {
  @SerializedName("nadId")
  private Long nadId = null;

  @SerializedName("ervenId")
  private Long ervenId = null;

  @SerializedName("ervenLinesId")
  private Long ervenLinesId = null;

  @SerializedName("ssId")
  private Long ssId = null;

  @SerializedName("addressType")
  private String addressType = null;

  @SerializedName("source")
  private String source = null;

  @SerializedName("latitude")
  private Double latitude = null;

  @SerializedName("longitude")
  private Double longitude = null;

  @SerializedName("centLatitude")
  private Double centLatitude = null;

  @SerializedName("centLongitude")
  private Double centLongitude = null;

  @SerializedName("buildingNo")
  private String buildingNo = null;

  @SerializedName("buildingName")
  private String buildingName = null;

  @SerializedName("sectionalSchemeUnit")
  private String sectionalSchemeUnit = null;

  @SerializedName("sectionalSchemeName")
  private String sectionalSchemeName = null;

  @SerializedName("streetNo")
  private String streetNo = null;

  @SerializedName("streetName")
  private String streetName = null;

  @SerializedName("suburb")
  private String suburb = null;

  @SerializedName("city")
  private String city = null;

  @SerializedName("postalCode")
  private String postalCode = null;

  @SerializedName("provinceCode")
  private String provinceCode = null;

  @SerializedName("municipalCode")
  private String municipalCode = null;

  @SerializedName("vdNumber")
  private String vdNumber = null;

  @SerializedName("allotmentNo")
  private String allotmentNo = null;

  @SerializedName("standNo")
  private String standNo = null;

  @SerializedName("portionNo")
  private String portionNo = null;

  @SerializedName("lisKey")
  private String lisKey = null;

  @SerializedName("erfArea")
  private Double erfArea = null;

  @SerializedName("sgOfficeNo")
  private Integer sgOfficeNo = null;

  @SerializedName("sgOffice")
  private String sgOffice = null;

  @SerializedName("addressLabel")
  private String addressLabel = null;

  @SerializedName("erfLabel")
  private String erfLabel = null;

  @SerializedName("modifiedDate")
  private DateTime modifiedDate = null;

  @SerializedName("feature")
  private Polygon feature = null;

  public NADAddress nadId(Long nadId) {
    this.nadId = nadId;
    return this;
  }

   /**
   * The 1map NAD Primary Key
   * @return nadId
  **/
  @ApiModelProperty(value = "The 1map NAD Primary Key")
  public Long getNadId() {
    return nadId;
  }

  public void setNadId(Long nadId) {
    this.nadId = nadId;
  }

  public NADAddress ervenId(Long ervenId) {
    this.ervenId = ervenId;
    return this;
  }

   /**
   * The 1map Erven Primary Key
   * @return ervenId
  **/
  @ApiModelProperty(value = "The 1map Erven Primary Key")
  public Long getErvenId() {
    return ervenId;
  }

  public void setErvenId(Long ervenId) {
    this.ervenId = ervenId;
  }

  public NADAddress ervenLinesId(Long ervenLinesId) {
    this.ervenLinesId = ervenLinesId;
    return this;
  }

   /**
   * The 1map Erven Lines Primary Key
   * @return ervenLinesId
  **/
  @ApiModelProperty(value = "The 1map Erven Lines Primary Key")
  public Long getErvenLinesId() {
    return ervenLinesId;
  }

  public void setErvenLinesId(Long ervenLinesId) {
    this.ervenLinesId = ervenLinesId;
  }

  public NADAddress ssId(Long ssId) {
    this.ssId = ssId;
    return this;
  }

   /**
   * The 1map Sectional Scheme Unit Primary Key
   * @return ssId
  **/
  @ApiModelProperty(value = "The 1map Sectional Scheme Unit Primary Key")
  public Long getSsId() {
    return ssId;
  }

  public void setSsId(Long ssId) {
    this.ssId = ssId;
  }

  public NADAddress addressType(String addressType) {
    this.addressType = addressType;
    return this;
  }

   /**
   * Type of address, STREET NO, ERF NO, etc.
   * @return addressType
  **/
  @ApiModelProperty(value = "Type of address, STREET NO, ERF NO, etc.")
  public String getAddressType() {
    return addressType;
  }

  public void setAddressType(String addressType) {
    this.addressType = addressType;
  }

  public NADAddress source(String source) {
    this.source = source;
    return this;
  }

   /**
   * Source showing where the NAD Address originated from
   * @return source
  **/
  @ApiModelProperty(value = "Source showing where the NAD Address originated from")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public NADAddress latitude(Double latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude of Address
   * @return latitude
  **/
  @ApiModelProperty(value = "Latitude of Address")
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public NADAddress longitude(Double longitude) {
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude of Address
   * @return longitude
  **/
  @ApiModelProperty(value = "Longitude of Address")
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public NADAddress centLatitude(Double centLatitude) {
    this.centLatitude = centLatitude;
    return this;
  }

   /**
   * Latitude of the Parent Parcel/Erf Centroid
   * @return centLatitude
  **/
  @ApiModelProperty(value = "Latitude of the Parent Parcel/Erf Centroid")
  public Double getCentLatitude() {
    return centLatitude;
  }

  public void setCentLatitude(Double centLatitude) {
    this.centLatitude = centLatitude;
  }

  public NADAddress centLongitude(Double centLongitude) {
    this.centLongitude = centLongitude;
    return this;
  }

   /**
   * Longitude of the Parent Parcel/Erf Centroid
   * @return centLongitude
  **/
  @ApiModelProperty(value = "Longitude of the Parent Parcel/Erf Centroid")
  public Double getCentLongitude() {
    return centLongitude;
  }

  public void setCentLongitude(Double centLongitude) {
    this.centLongitude = centLongitude;
  }

  public NADAddress buildingNo(String buildingNo) {
    this.buildingNo = buildingNo;
    return this;
  }

   /**
   * Building Number
   * @return buildingNo
  **/
  @ApiModelProperty(value = "Building Number")
  public String getBuildingNo() {
    return buildingNo;
  }

  public void setBuildingNo(String buildingNo) {
    this.buildingNo = buildingNo;
  }

  public NADAddress buildingName(String buildingName) {
    this.buildingName = buildingName;
    return this;
  }

   /**
   * Building Name
   * @return buildingName
  **/
  @ApiModelProperty(value = "Building Name")
  public String getBuildingName() {
    return buildingName;
  }

  public void setBuildingName(String buildingName) {
    this.buildingName = buildingName;
  }

  public NADAddress sectionalSchemeUnit(String sectionalSchemeUnit) {
    this.sectionalSchemeUnit = sectionalSchemeUnit;
    return this;
  }

   /**
   * Sectional Scheme Unit No
   * @return sectionalSchemeUnit
  **/
  @ApiModelProperty(value = "Sectional Scheme Unit No")
  public String getSectionalSchemeUnit() {
    return sectionalSchemeUnit;
  }

  public void setSectionalSchemeUnit(String sectionalSchemeUnit) {
    this.sectionalSchemeUnit = sectionalSchemeUnit;
  }

  public NADAddress sectionalSchemeName(String sectionalSchemeName) {
    this.sectionalSchemeName = sectionalSchemeName;
    return this;
  }

   /**
   * Sectional Scheme Name
   * @return sectionalSchemeName
  **/
  @ApiModelProperty(value = "Sectional Scheme Name")
  public String getSectionalSchemeName() {
    return sectionalSchemeName;
  }

  public void setSectionalSchemeName(String sectionalSchemeName) {
    this.sectionalSchemeName = sectionalSchemeName;
  }

  public NADAddress streetNo(String streetNo) {
    this.streetNo = streetNo;
    return this;
  }

   /**
   * Street Number
   * @return streetNo
  **/
  @ApiModelProperty(value = "Street Number")
  public String getStreetNo() {
    return streetNo;
  }

  public void setStreetNo(String streetNo) {
    this.streetNo = streetNo;
  }

  public NADAddress streetName(String streetName) {
    this.streetName = streetName;
    return this;
  }

   /**
   * Street Name
   * @return streetName
  **/
  @ApiModelProperty(value = "Street Name")
  public String getStreetName() {
    return streetName;
  }

  public void setStreetName(String streetName) {
    this.streetName = streetName;
  }

  public NADAddress suburb(String suburb) {
    this.suburb = suburb;
    return this;
  }

   /**
   * Suburb
   * @return suburb
  **/
  @ApiModelProperty(value = "Suburb")
  public String getSuburb() {
    return suburb;
  }

  public void setSuburb(String suburb) {
    this.suburb = suburb;
  }

  public NADAddress city(String city) {
    this.city = city;
    return this;
  }

   /**
   * Town/City
   * @return city
  **/
  @ApiModelProperty(value = "Town/City")
  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  public NADAddress postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal Code
   * @return postalCode
  **/
  @ApiModelProperty(value = "Postal Code")
  public String getPostalCode() {
    return postalCode;
  }

  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }

  public NADAddress provinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
    return this;
  }

   /**
   * Province Code/Abbreviation
   * @return provinceCode
  **/
  @ApiModelProperty(value = "Province Code/Abbreviation")
  public String getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
  }

  public NADAddress municipalCode(String municipalCode) {
    this.municipalCode = municipalCode;
    return this;
  }

   /**
   * Municipal Code/Abbreviation
   * @return municipalCode
  **/
  @ApiModelProperty(value = "Municipal Code/Abbreviation")
  public String getMunicipalCode() {
    return municipalCode;
  }

  public void setMunicipalCode(String municipalCode) {
    this.municipalCode = municipalCode;
  }

  public NADAddress vdNumber(String vdNumber) {
    this.vdNumber = vdNumber;
    return this;
  }

   /**
   * VD Number
   * @return vdNumber
  **/
  @ApiModelProperty(value = "VD Number")
  public String getVdNumber() {
    return vdNumber;
  }

  public void setVdNumber(String vdNumber) {
    this.vdNumber = vdNumber;
  }

  public NADAddress allotmentNo(String allotmentNo) {
    this.allotmentNo = allotmentNo;
    return this;
  }

   /**
   * SG Allotment Number
   * @return allotmentNo
  **/
  @ApiModelProperty(value = "SG Allotment Number")
  public String getAllotmentNo() {
    return allotmentNo;
  }

  public void setAllotmentNo(String allotmentNo) {
    this.allotmentNo = allotmentNo;
  }

  public NADAddress standNo(String standNo) {
    this.standNo = standNo;
    return this;
  }

   /**
   * SG Stand Number
   * @return standNo
  **/
  @ApiModelProperty(value = "SG Stand Number")
  public String getStandNo() {
    return standNo;
  }

  public void setStandNo(String standNo) {
    this.standNo = standNo;
  }

  public NADAddress portionNo(String portionNo) {
    this.portionNo = portionNo;
    return this;
  }

   /**
   * SG Portion Number
   * @return portionNo
  **/
  @ApiModelProperty(value = "SG Portion Number")
  public String getPortionNo() {
    return portionNo;
  }

  public void setPortionNo(String portionNo) {
    this.portionNo = portionNo;
  }

  public NADAddress lisKey(String lisKey) {
    this.lisKey = lisKey;
    return this;
  }

   /**
   * LIS Key
   * @return lisKey
  **/
  @ApiModelProperty(value = "LIS Key")
  public String getLisKey() {
    return lisKey;
  }

  public void setLisKey(String lisKey) {
    this.lisKey = lisKey;
  }

  public NADAddress erfArea(Double erfArea) {
    this.erfArea = erfArea;
    return this;
  }

   /**
   * Area of the Parent Parcel/Erf measured in square meters
   * @return erfArea
  **/
  @ApiModelProperty(value = "Area of the Parent Parcel/Erf measured in square meters")
  public Double getErfArea() {
    return erfArea;
  }

  public void setErfArea(Double erfArea) {
    this.erfArea = erfArea;
  }

  public NADAddress sgOfficeNo(Integer sgOfficeNo) {
    this.sgOfficeNo = sgOfficeNo;
    return this;
  }

   /**
   * SG office Number (Used for SG Diagrams)
   * @return sgOfficeNo
  **/
  @ApiModelProperty(value = "SG office Number (Used for SG Diagrams)")
  public Integer getSgOfficeNo() {
    return sgOfficeNo;
  }

  public void setSgOfficeNo(Integer sgOfficeNo) {
    this.sgOfficeNo = sgOfficeNo;
  }

  public NADAddress sgOffice(String sgOffice) {
    this.sgOffice = sgOffice;
    return this;
  }

   /**
   * SG Office (Used for SG Diagrams)
   * @return sgOffice
  **/
  @ApiModelProperty(value = "SG Office (Used for SG Diagrams)")
  public String getSgOffice() {
    return sgOffice;
  }

  public void setSgOffice(String sgOffice) {
    this.sgOffice = sgOffice;
  }

  public NADAddress addressLabel(String addressLabel) {
    this.addressLabel = addressLabel;
    return this;
  }

   /**
   * Address Label, formated in html, for used in popups
   * @return addressLabel
  **/
  @ApiModelProperty(value = "Address Label, formated in html, for used in popups")
  public String getAddressLabel() {
    return addressLabel;
  }

  public void setAddressLabel(String addressLabel) {
    this.addressLabel = addressLabel;
  }

  public NADAddress erfLabel(String erfLabel) {
    this.erfLabel = erfLabel;
    return this;
  }

   /**
   * Parent Parcel/Erf Label, formated in html, for used in popups
   * @return erfLabel
  **/
  @ApiModelProperty(value = "Parent Parcel/Erf Label, formated in html, for used in popups")
  public String getErfLabel() {
    return erfLabel;
  }

  public void setErfLabel(String erfLabel) {
    this.erfLabel = erfLabel;
  }

  public NADAddress modifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

   /**
   * Date last modified
   * @return modifiedDate
  **/
  @ApiModelProperty(value = "Date last modified")
  public DateTime getModifiedDate() {
    return modifiedDate;
  }

  public void setModifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
  }

  public NADAddress feature(Polygon feature) {
    this.feature = feature;
    return this;
  }

   /**
   * Parent Parcel/Erf Geometry
   * @return feature
  **/
  @ApiModelProperty(value = "Parent Parcel/Erf Geometry")
  public Polygon getFeature() {
    return feature;
  }

  public void setFeature(Polygon feature) {
    this.feature = feature;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    NADAddress naDAddress = (NADAddress) o;
    return Objects.equals(this.nadId, naDAddress.nadId) &&
        Objects.equals(this.ervenId, naDAddress.ervenId) &&
        Objects.equals(this.ervenLinesId, naDAddress.ervenLinesId) &&
        Objects.equals(this.ssId, naDAddress.ssId) &&
        Objects.equals(this.addressType, naDAddress.addressType) &&
        Objects.equals(this.source, naDAddress.source) &&
        Objects.equals(this.latitude, naDAddress.latitude) &&
        Objects.equals(this.longitude, naDAddress.longitude) &&
        Objects.equals(this.centLatitude, naDAddress.centLatitude) &&
        Objects.equals(this.centLongitude, naDAddress.centLongitude) &&
        Objects.equals(this.buildingNo, naDAddress.buildingNo) &&
        Objects.equals(this.buildingName, naDAddress.buildingName) &&
        Objects.equals(this.sectionalSchemeUnit, naDAddress.sectionalSchemeUnit) &&
        Objects.equals(this.sectionalSchemeName, naDAddress.sectionalSchemeName) &&
        Objects.equals(this.streetNo, naDAddress.streetNo) &&
        Objects.equals(this.streetName, naDAddress.streetName) &&
        Objects.equals(this.suburb, naDAddress.suburb) &&
        Objects.equals(this.city, naDAddress.city) &&
        Objects.equals(this.postalCode, naDAddress.postalCode) &&
        Objects.equals(this.provinceCode, naDAddress.provinceCode) &&
        Objects.equals(this.municipalCode, naDAddress.municipalCode) &&
        Objects.equals(this.vdNumber, naDAddress.vdNumber) &&
        Objects.equals(this.allotmentNo, naDAddress.allotmentNo) &&
        Objects.equals(this.standNo, naDAddress.standNo) &&
        Objects.equals(this.portionNo, naDAddress.portionNo) &&
        Objects.equals(this.lisKey, naDAddress.lisKey) &&
        Objects.equals(this.erfArea, naDAddress.erfArea) &&
        Objects.equals(this.sgOfficeNo, naDAddress.sgOfficeNo) &&
        Objects.equals(this.sgOffice, naDAddress.sgOffice) &&
        Objects.equals(this.addressLabel, naDAddress.addressLabel) &&
        Objects.equals(this.erfLabel, naDAddress.erfLabel) &&
        Objects.equals(this.modifiedDate, naDAddress.modifiedDate) &&
        Objects.equals(this.feature, naDAddress.feature);
  }

  @Override
  public int hashCode() {
    return Objects.hash(nadId, ervenId, ervenLinesId, ssId, addressType, source, latitude, longitude, centLatitude, centLongitude, buildingNo, buildingName, sectionalSchemeUnit, sectionalSchemeName, streetNo, streetName, suburb, city, postalCode, provinceCode, municipalCode, vdNumber, allotmentNo, standNo, portionNo, lisKey, erfArea, sgOfficeNo, sgOffice, addressLabel, erfLabel, modifiedDate, feature);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class NADAddress {\n");
    
    sb.append("    nadId: ").append(toIndentedString(nadId)).append("\n");
    sb.append("    ervenId: ").append(toIndentedString(ervenId)).append("\n");
    sb.append("    ervenLinesId: ").append(toIndentedString(ervenLinesId)).append("\n");
    sb.append("    ssId: ").append(toIndentedString(ssId)).append("\n");
    sb.append("    addressType: ").append(toIndentedString(addressType)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    centLatitude: ").append(toIndentedString(centLatitude)).append("\n");
    sb.append("    centLongitude: ").append(toIndentedString(centLongitude)).append("\n");
    sb.append("    buildingNo: ").append(toIndentedString(buildingNo)).append("\n");
    sb.append("    buildingName: ").append(toIndentedString(buildingName)).append("\n");
    sb.append("    sectionalSchemeUnit: ").append(toIndentedString(sectionalSchemeUnit)).append("\n");
    sb.append("    sectionalSchemeName: ").append(toIndentedString(sectionalSchemeName)).append("\n");
    sb.append("    streetNo: ").append(toIndentedString(streetNo)).append("\n");
    sb.append("    streetName: ").append(toIndentedString(streetName)).append("\n");
    sb.append("    suburb: ").append(toIndentedString(suburb)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    provinceCode: ").append(toIndentedString(provinceCode)).append("\n");
    sb.append("    municipalCode: ").append(toIndentedString(municipalCode)).append("\n");
    sb.append("    vdNumber: ").append(toIndentedString(vdNumber)).append("\n");
    sb.append("    allotmentNo: ").append(toIndentedString(allotmentNo)).append("\n");
    sb.append("    standNo: ").append(toIndentedString(standNo)).append("\n");
    sb.append("    portionNo: ").append(toIndentedString(portionNo)).append("\n");
    sb.append("    lisKey: ").append(toIndentedString(lisKey)).append("\n");
    sb.append("    erfArea: ").append(toIndentedString(erfArea)).append("\n");
    sb.append("    sgOfficeNo: ").append(toIndentedString(sgOfficeNo)).append("\n");
    sb.append("    sgOffice: ").append(toIndentedString(sgOffice)).append("\n");
    sb.append("    addressLabel: ").append(toIndentedString(addressLabel)).append("\n");
    sb.append("    erfLabel: ").append(toIndentedString(erfLabel)).append("\n");
    sb.append("    modifiedDate: ").append(toIndentedString(modifiedDate)).append("\n");
    sb.append("    feature: ").append(toIndentedString(feature)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

