/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Info regarding the selected layer
 */
@ApiModel(description = "Info regarding the selected layer")

public class Layer {
  @SerializedName("layerId")
  private Long layerId = null;

  /**
   * Layer Type - (vector or raster &#x3D; Basic Layers, Rest &#x3D; Base Layers)
   */
  @JsonAdapter(LayerTypeEnum.Adapter.class)
  public enum LayerTypeEnum {
    OSM("osm"),
    
    NGI_AERIAL("ngi_aerial"),
    
    TONER("toner"),
    
    _1MAP("1map"),
    
    WMS("wms"),
    
    GOOGLESTREET("googlestreet"),
    
    GOOGLESATELLITE("googlesatellite"),
    
    GOOGLEHYBRID("googlehybrid"),
    
    BINGHYBRID("binghybrid"),
    
    BINGAERIAL("bingaerial"),
    
    BINGROAD("bingroad"),
    
    RASTER("raster"),
    
    VECTOR("vector");

    private String value;

    LayerTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LayerTypeEnum fromValue(String text) {
      for (LayerTypeEnum b : LayerTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<LayerTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LayerTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LayerTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return LayerTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("layerType")
  private LayerTypeEnum layerType = null;

  @SerializedName("layerCaption")
  private String layerCaption = null;

  @SerializedName("layerDescription")
  private String layerDescription = null;

  @SerializedName("primaryField")
  private String primaryField = null;

  @SerializedName("searchCaption")
  private String searchCaption = null;

  @SerializedName("isBaseLayer")
  private Boolean isBaseLayer = null;

  @SerializedName("visibility")
  private Boolean visibility = null;

  @SerializedName("opacity")
  private Double opacity = null;

  @SerializedName("minScale")
  private Integer minScale = null;

  @SerializedName("maxScale")
  private Integer maxScale = null;

  @SerializedName("layerOrder")
  private Integer layerOrder = null;

  @SerializedName("layerGroup")
  private String layerGroup = null;

  @SerializedName("drawCache")
  private Boolean drawCache = null;

  @SerializedName("layerStyle")
  private String layerStyle = null;

  /**
   * Specifies the type of geometry - (If layerType &#x3D; vector then one of Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, Geometry else If layerType &#x3D; raster then Raster.
   */
  @JsonAdapter(GeometryTypeEnum.Adapter.class)
  public enum GeometryTypeEnum {
    POINT("Point"),
    
    MULTIPOINT("MultiPoint"),
    
    LINESTRING("LineString"),
    
    MULTILINESTRING("MultiLineString"),
    
    POLYGON("Polygon"),
    
    MULTIPOLYGON("MultiPolygon"),
    
    GEOMETRY("Geometry"),
    
    RASTER("Raster");

    private String value;

    GeometryTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static GeometryTypeEnum fromValue(String text) {
      for (GeometryTypeEnum b : GeometryTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<GeometryTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final GeometryTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public GeometryTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return GeometryTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("geometryType")
  private GeometryTypeEnum geometryType = null;

  @SerializedName("layerDefault")
  private Boolean layerDefault = null;

  @SerializedName("author")
  private String author = null;

  @SerializedName("attribution")
  private String attribution = null;

  @SerializedName("canEditAttributes")
  private Boolean canEditAttributes = null;

  @SerializedName("canEditSpatial")
  private Boolean canEditSpatial = null;

  /**
   * Specify whether this layer is public or private
   */
  @JsonAdapter(DestTypeEnum.Adapter.class)
  public enum DestTypeEnum {
    PRIVATE("private"),
    
    PUBLIC("public");

    private String value;

    DestTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DestTypeEnum fromValue(String text) {
      for (DestTypeEnum b : DestTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DestTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DestTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DestTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return DestTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("destType")
  private DestTypeEnum destType = null;

  @SerializedName("gsConnectionId")
  private Long gsConnectionId = null;

  public Layer layerId(Long layerId) {
    this.layerId = layerId;
    return this;
  }

   /**
   * Layer unique 1map id number - Primary Key (Note: This id is Unique within Base Layers and Unique within Other Layers)
   * @return layerId
  **/
  @ApiModelProperty(value = "Layer unique 1map id number - Primary Key (Note: This id is Unique within Base Layers and Unique within Other Layers)")
  public Long getLayerId() {
    return layerId;
  }

  public void setLayerId(Long layerId) {
    this.layerId = layerId;
  }

  public Layer layerType(LayerTypeEnum layerType) {
    this.layerType = layerType;
    return this;
  }

   /**
   * Layer Type - (vector or raster &#x3D; Basic Layers, Rest &#x3D; Base Layers)
   * @return layerType
  **/
  @ApiModelProperty(value = "Layer Type - (vector or raster = Basic Layers, Rest = Base Layers)")
  public LayerTypeEnum getLayerType() {
    return layerType;
  }

  public void setLayerType(LayerTypeEnum layerType) {
    this.layerType = layerType;
  }

  public Layer layerCaption(String layerCaption) {
    this.layerCaption = layerCaption;
    return this;
  }

   /**
   * Layer Caption
   * @return layerCaption
  **/
  @ApiModelProperty(value = "Layer Caption")
  public String getLayerCaption() {
    return layerCaption;
  }

  public void setLayerCaption(String layerCaption) {
    this.layerCaption = layerCaption;
  }

  public Layer layerDescription(String layerDescription) {
    this.layerDescription = layerDescription;
    return this;
  }

   /**
   * Layer&#39;s description
   * @return layerDescription
  **/
  @ApiModelProperty(value = "Layer's description")
  public String getLayerDescription() {
    return layerDescription;
  }

  public void setLayerDescription(String layerDescription) {
    this.layerDescription = layerDescription;
  }

  public Layer primaryField(String primaryField) {
    this.primaryField = primaryField;
    return this;
  }

   /**
   * The name of the primary field for this layer
   * @return primaryField
  **/
  @ApiModelProperty(value = "The name of the primary field for this layer")
  public String getPrimaryField() {
    return primaryField;
  }

  public void setPrimaryField(String primaryField) {
    this.primaryField = primaryField;
  }

  public Layer searchCaption(String searchCaption) {
    this.searchCaption = searchCaption;
    return this;
  }

   /**
   * The caption to display for the general search, ie. Street Address
   * @return searchCaption
  **/
  @ApiModelProperty(value = "The caption to display for the general search, ie. Street Address")
  public String getSearchCaption() {
    return searchCaption;
  }

  public void setSearchCaption(String searchCaption) {
    this.searchCaption = searchCaption;
  }

  public Layer isBaseLayer(Boolean isBaseLayer) {
    this.isBaseLayer = isBaseLayer;
    return this;
  }

   /**
   * Specifies whether this layer is a Base Layer or not
   * @return isBaseLayer
  **/
  @ApiModelProperty(value = "Specifies whether this layer is a Base Layer or not")
  public Boolean getIsBaseLayer() {
    return isBaseLayer;
  }

  public void setIsBaseLayer(Boolean isBaseLayer) {
    this.isBaseLayer = isBaseLayer;
  }

  public Layer visibility(Boolean visibility) {
    this.visibility = visibility;
    return this;
  }

   /**
   * Specifies whether this layer is displayed by defult or not
   * @return visibility
  **/
  @ApiModelProperty(value = "Specifies whether this layer is displayed by defult or not")
  public Boolean getVisibility() {
    return visibility;
  }

  public void setVisibility(Boolean visibility) {
    this.visibility = visibility;
  }

  public Layer opacity(Double opacity) {
    this.opacity = opacity;
    return this;
  }

   /**
   * Specifies the default opacity for this layer when displayed.  Values can range from 0 to 1
   * @return opacity
  **/
  @ApiModelProperty(value = "Specifies the default opacity for this layer when displayed.  Values can range from 0 to 1")
  public Double getOpacity() {
    return opacity;
  }

  public void setOpacity(Double opacity) {
    this.opacity = opacity;
  }

  public Layer minScale(Integer minScale) {
    this.minScale = minScale;
    return this;
  }

   /**
   * Specifies the default minimum scale between 0 and 524,288,000
   * @return minScale
  **/
  @ApiModelProperty(value = "Specifies the default minimum scale between 0 and 524,288,000")
  public Integer getMinScale() {
    return minScale;
  }

  public void setMinScale(Integer minScale) {
    this.minScale = minScale;
  }

  public Layer maxScale(Integer maxScale) {
    this.maxScale = maxScale;
    return this;
  }

   /**
   * Specifies the default maximum scale between 0 and 524,288,000
   * @return maxScale
  **/
  @ApiModelProperty(value = "Specifies the default maximum scale between 0 and 524,288,000")
  public Integer getMaxScale() {
    return maxScale;
  }

  public void setMaxScale(Integer maxScale) {
    this.maxScale = maxScale;
  }

  public Layer layerOrder(Integer layerOrder) {
    this.layerOrder = layerOrder;
    return this;
  }

   /**
   * Specifies the default z-order for the spesific layer
   * @return layerOrder
  **/
  @ApiModelProperty(value = "Specifies the default z-order for the spesific layer")
  public Integer getLayerOrder() {
    return layerOrder;
  }

  public void setLayerOrder(Integer layerOrder) {
    this.layerOrder = layerOrder;
  }

  public Layer layerGroup(String layerGroup) {
    this.layerGroup = layerGroup;
    return this;
  }

   /**
   * Specifies the group the layer belongs to.  Handy if you want to show your layers in group format.
   * @return layerGroup
  **/
  @ApiModelProperty(value = "Specifies the group the layer belongs to.  Handy if you want to show your layers in group format.")
  public String getLayerGroup() {
    return layerGroup;
  }

  public void setLayerGroup(String layerGroup) {
    this.layerGroup = layerGroup;
  }

  public Layer drawCache(Boolean drawCache) {
    this.drawCache = drawCache;
    return this;
  }

   /**
   * Specifies whether this layer is fetched from the Server&#39;s cache or not.  Normally live/editable layers will not use the cache.
   * @return drawCache
  **/
  @ApiModelProperty(value = "Specifies whether this layer is fetched from the Server's cache or not.  Normally live/editable layers will not use the cache.")
  public Boolean getDrawCache() {
    return drawCache;
  }

  public void setDrawCache(Boolean drawCache) {
    this.drawCache = drawCache;
  }

  public Layer layerStyle(String layerStyle) {
    this.layerStyle = layerStyle;
    return this;
  }

   /**
   * Specifies the default style that the layer uses to draw
   * @return layerStyle
  **/
  @ApiModelProperty(value = "Specifies the default style that the layer uses to draw")
  public String getLayerStyle() {
    return layerStyle;
  }

  public void setLayerStyle(String layerStyle) {
    this.layerStyle = layerStyle;
  }

  public Layer geometryType(GeometryTypeEnum geometryType) {
    this.geometryType = geometryType;
    return this;
  }

   /**
   * Specifies the type of geometry - (If layerType &#x3D; vector then one of Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, Geometry else If layerType &#x3D; raster then Raster.
   * @return geometryType
  **/
  @ApiModelProperty(value = "Specifies the type of geometry - (If layerType = vector then one of Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon, Geometry else If layerType = raster then Raster.")
  public GeometryTypeEnum getGeometryType() {
    return geometryType;
  }

  public void setGeometryType(GeometryTypeEnum geometryType) {
    this.geometryType = geometryType;
  }

  public Layer layerDefault(Boolean layerDefault) {
    this.layerDefault = layerDefault;
    return this;
  }

   /**
   * If the layer is a base layer, then specifies whether this layer is the default base layer.  If the layer is not a base layer, then specifies whether this layer is the deault active layer (Layer that the user interact with)
   * @return layerDefault
  **/
  @ApiModelProperty(value = "If the layer is a base layer, then specifies whether this layer is the default base layer.  If the layer is not a base layer, then specifies whether this layer is the deault active layer (Layer that the user interact with)")
  public Boolean getLayerDefault() {
    return layerDefault;
  }

  public void setLayerDefault(Boolean layerDefault) {
    this.layerDefault = layerDefault;
  }

  public Layer author(String author) {
    this.author = author;
    return this;
  }

   /**
   * The autor of the layer - User who created/uploaded the layer
   * @return author
  **/
  @ApiModelProperty(value = "The autor of the layer - User who created/uploaded the layer")
  public String getAuthor() {
    return author;
  }

  public void setAuthor(String author) {
    this.author = author;
  }

  public Layer attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

   /**
   * Copyright/Info attribution to be displayed on the specified layer
   * @return attribution
  **/
  @ApiModelProperty(value = "Copyright/Info attribution to be displayed on the specified layer")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public Layer canEditAttributes(Boolean canEditAttributes) {
    this.canEditAttributes = canEditAttributes;
    return this;
  }

   /**
   * Specify whether this layer&#39;s attributes can be edited (Only applicable if the layerType &#x3D; &#39;vector&#39;)
   * @return canEditAttributes
  **/
  @ApiModelProperty(value = "Specify whether this layer's attributes can be edited (Only applicable if the layerType = 'vector')")
  public Boolean getCanEditAttributes() {
    return canEditAttributes;
  }

  public void setCanEditAttributes(Boolean canEditAttributes) {
    this.canEditAttributes = canEditAttributes;
  }

  public Layer canEditSpatial(Boolean canEditSpatial) {
    this.canEditSpatial = canEditSpatial;
    return this;
  }

   /**
   * Specify whether this layer&#39;s spatial geometry can be edited (Only applicable if the layerType &#x3D; &#39;vector&#39;)
   * @return canEditSpatial
  **/
  @ApiModelProperty(value = "Specify whether this layer's spatial geometry can be edited (Only applicable if the layerType = 'vector')")
  public Boolean getCanEditSpatial() {
    return canEditSpatial;
  }

  public void setCanEditSpatial(Boolean canEditSpatial) {
    this.canEditSpatial = canEditSpatial;
  }

  public Layer destType(DestTypeEnum destType) {
    this.destType = destType;
    return this;
  }

   /**
   * Specify whether this layer is public or private
   * @return destType
  **/
  @ApiModelProperty(value = "Specify whether this layer is public or private")
  public DestTypeEnum getDestType() {
    return destType;
  }

  public void setDestType(DestTypeEnum destType) {
    this.destType = destType;
  }

  public Layer gsConnectionId(Long gsConnectionId) {
    this.gsConnectionId = gsConnectionId;
    return this;
  }

   /**
   * Used internally
   * @return gsConnectionId
  **/
  @ApiModelProperty(value = "Used internally")
  public Long getGsConnectionId() {
    return gsConnectionId;
  }

  public void setGsConnectionId(Long gsConnectionId) {
    this.gsConnectionId = gsConnectionId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Layer layer = (Layer) o;
    return Objects.equals(this.layerId, layer.layerId) &&
        Objects.equals(this.layerType, layer.layerType) &&
        Objects.equals(this.layerCaption, layer.layerCaption) &&
        Objects.equals(this.layerDescription, layer.layerDescription) &&
        Objects.equals(this.primaryField, layer.primaryField) &&
        Objects.equals(this.searchCaption, layer.searchCaption) &&
        Objects.equals(this.isBaseLayer, layer.isBaseLayer) &&
        Objects.equals(this.visibility, layer.visibility) &&
        Objects.equals(this.opacity, layer.opacity) &&
        Objects.equals(this.minScale, layer.minScale) &&
        Objects.equals(this.maxScale, layer.maxScale) &&
        Objects.equals(this.layerOrder, layer.layerOrder) &&
        Objects.equals(this.layerGroup, layer.layerGroup) &&
        Objects.equals(this.drawCache, layer.drawCache) &&
        Objects.equals(this.layerStyle, layer.layerStyle) &&
        Objects.equals(this.geometryType, layer.geometryType) &&
        Objects.equals(this.layerDefault, layer.layerDefault) &&
        Objects.equals(this.author, layer.author) &&
        Objects.equals(this.attribution, layer.attribution) &&
        Objects.equals(this.canEditAttributes, layer.canEditAttributes) &&
        Objects.equals(this.canEditSpatial, layer.canEditSpatial) &&
        Objects.equals(this.destType, layer.destType) &&
        Objects.equals(this.gsConnectionId, layer.gsConnectionId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(layerId, layerType, layerCaption, layerDescription, primaryField, searchCaption, isBaseLayer, visibility, opacity, minScale, maxScale, layerOrder, layerGroup, drawCache, layerStyle, geometryType, layerDefault, author, attribution, canEditAttributes, canEditSpatial, destType, gsConnectionId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Layer {\n");
    
    sb.append("    layerId: ").append(toIndentedString(layerId)).append("\n");
    sb.append("    layerType: ").append(toIndentedString(layerType)).append("\n");
    sb.append("    layerCaption: ").append(toIndentedString(layerCaption)).append("\n");
    sb.append("    layerDescription: ").append(toIndentedString(layerDescription)).append("\n");
    sb.append("    primaryField: ").append(toIndentedString(primaryField)).append("\n");
    sb.append("    searchCaption: ").append(toIndentedString(searchCaption)).append("\n");
    sb.append("    isBaseLayer: ").append(toIndentedString(isBaseLayer)).append("\n");
    sb.append("    visibility: ").append(toIndentedString(visibility)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    minScale: ").append(toIndentedString(minScale)).append("\n");
    sb.append("    maxScale: ").append(toIndentedString(maxScale)).append("\n");
    sb.append("    layerOrder: ").append(toIndentedString(layerOrder)).append("\n");
    sb.append("    layerGroup: ").append(toIndentedString(layerGroup)).append("\n");
    sb.append("    drawCache: ").append(toIndentedString(drawCache)).append("\n");
    sb.append("    layerStyle: ").append(toIndentedString(layerStyle)).append("\n");
    sb.append("    geometryType: ").append(toIndentedString(geometryType)).append("\n");
    sb.append("    layerDefault: ").append(toIndentedString(layerDefault)).append("\n");
    sb.append("    author: ").append(toIndentedString(author)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    canEditAttributes: ").append(toIndentedString(canEditAttributes)).append("\n");
    sb.append("    canEditSpatial: ").append(toIndentedString(canEditSpatial)).append("\n");
    sb.append("    destType: ").append(toIndentedString(destType)).append("\n");
    sb.append("    gsConnectionId: ").append(toIndentedString(gsConnectionId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

