/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.BoundingBox;
import java.io.IOException;

/**
 * These properties are related to a Land Parcel.
 */
@ApiModel(description = "These properties are related to a Land Parcel.")

public class LandParcelProperties {
  @SerializedName("ervenId")
  private Long ervenId = null;

  @SerializedName("sourceName")
  private String sourceName = null;

  @SerializedName("sourceKey")
  private String sourceKey = null;

  /**
   * ERF or MUN
   */
  @JsonAdapter(FeaLayerEnum.Adapter.class)
  public enum FeaLayerEnum {
    ERF("ERF"),
    
    MUN("MUN");

    private String value;

    FeaLayerEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FeaLayerEnum fromValue(String text) {
      for (FeaLayerEnum b : FeaLayerEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<FeaLayerEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FeaLayerEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FeaLayerEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return FeaLayerEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("feaLayer")
  private FeaLayerEnum feaLayer = null;

  /**
   * Parcel Type
   */
  @JsonAdapter(ParcelTypeEnum.Adapter.class)
  public enum ParcelTypeEnum {
    E("E"),
    
    EPR("EPR"),
    
    F("F"),
    
    FP("FP"),
    
    H("H"),
    
    PK("PK"),
    
    PKP("PKP"),
    
    SIE("SIE"),
    
    STP("STP"),
    
    STR("STR"),
    
    URB("URB"),
    
    USL("USL");

    private String value;

    ParcelTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ParcelTypeEnum fromValue(String text) {
      for (ParcelTypeEnum b : ParcelTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ParcelTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ParcelTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ParcelTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return ParcelTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("parcelType")
  private ParcelTypeEnum parcelType = null;

  @SerializedName("feaLabel")
  private String feaLabel = null;

  @SerializedName("allotmentNo")
  private String allotmentNo = null;

  @SerializedName("standNo")
  private String standNo = null;

  @SerializedName("portionNo")
  private String portionNo = null;

  @SerializedName("lisKey")
  private String lisKey = null;

  @SerializedName("suburb")
  private String suburb = null;

  @SerializedName("city")
  private String city = null;

  @SerializedName("postalCode")
  private String postalCode = null;

  @SerializedName("longitude")
  private Double longitude = null;

  @SerializedName("latitude")
  private Double latitude = null;

  /**
   * Life Cycle
   */
  @JsonAdapter(LifeCycleEnum.Adapter.class)
  public enum LifeCycleEnum {
    APPROVED("APPROVED"),
    
    DELETED("DELETED"),
    
    HISTORY("HISTORY"),
    
    REGISTERED("REGISTERED"),
    
    SECTIONAL_SCHEME("SECTIONAL SCHEME"),
    
    SG_APPROVED("SG APPROVED"),
    
    UNKNOWN("UNKNOWN"),
    
    WITHDRAWN("WITHDRAWN");

    private String value;

    LifeCycleEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static LifeCycleEnum fromValue(String text) {
      for (LifeCycleEnum b : LifeCycleEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<LifeCycleEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final LifeCycleEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public LifeCycleEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return LifeCycleEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("lifeCycle")
  private LifeCycleEnum lifeCycle = null;

  @SerializedName("noOfDeedsRecords")
  private Long noOfDeedsRecords = null;

  @SerializedName("bbox")
  private BoundingBox bbox = null;

  public LandParcelProperties ervenId(Long ervenId) {
    this.ervenId = ervenId;
    return this;
  }

   /**
   * 1map Erven Primary Id.
   * @return ervenId
  **/
  @ApiModelProperty(example = "7489666", value = "1map Erven Primary Id.")
  public Long getErvenId() {
    return ervenId;
  }

  public void setErvenId(Long ervenId) {
    this.ervenId = ervenId;
  }

  public LandParcelProperties sourceName(String sourceName) {
    this.sourceName = sourceName;
    return this;
  }

   /**
   * 1map Erven Source.
   * @return sourceName
  **/
  @ApiModelProperty(example = "SG Western Cape", value = "1map Erven Source.")
  public String getSourceName() {
    return sourceName;
  }

  public void setSourceName(String sourceName) {
    this.sourceName = sourceName;
  }

  public LandParcelProperties sourceKey(String sourceKey) {
    this.sourceKey = sourceKey;
    return this;
  }

   /**
   * 1map Erven Source Key.
   * @return sourceKey
  **/
  @ApiModelProperty(example = "", value = "1map Erven Source Key.")
  public String getSourceKey() {
    return sourceKey;
  }

  public void setSourceKey(String sourceKey) {
    this.sourceKey = sourceKey;
  }

  public LandParcelProperties feaLayer(FeaLayerEnum feaLayer) {
    this.feaLayer = feaLayer;
    return this;
  }

   /**
   * ERF or MUN
   * @return feaLayer
  **/
  @ApiModelProperty(example = "ERF", value = "ERF or MUN")
  public FeaLayerEnum getFeaLayer() {
    return feaLayer;
  }

  public void setFeaLayer(FeaLayerEnum feaLayer) {
    this.feaLayer = feaLayer;
  }

  public LandParcelProperties parcelType(ParcelTypeEnum parcelType) {
    this.parcelType = parcelType;
    return this;
  }

   /**
   * Parcel Type
   * @return parcelType
  **/
  @ApiModelProperty(example = "E", value = "Parcel Type")
  public ParcelTypeEnum getParcelType() {
    return parcelType;
  }

  public void setParcelType(ParcelTypeEnum parcelType) {
    this.parcelType = parcelType;
  }

  public LandParcelProperties feaLabel(String feaLabel) {
    this.feaLabel = feaLabel;
    return this;
  }

   /**
   * 1map Erven Feature Label.
   * @return feaLabel
  **/
  @ApiModelProperty(example = "6836", value = "1map Erven Feature Label.")
  public String getFeaLabel() {
    return feaLabel;
  }

  public void setFeaLabel(String feaLabel) {
    this.feaLabel = feaLabel;
  }

  public LandParcelProperties allotmentNo(String allotmentNo) {
    this.allotmentNo = allotmentNo;
    return this;
  }

   /**
   * Allotment Number
   * @return allotmentNo
  **/
  @ApiModelProperty(example = "C0550010", value = "Allotment Number")
  public String getAllotmentNo() {
    return allotmentNo;
  }

  public void setAllotmentNo(String allotmentNo) {
    this.allotmentNo = allotmentNo;
  }

  public LandParcelProperties standNo(String standNo) {
    this.standNo = standNo;
    return this;
  }

   /**
   * Stand Number
   * @return standNo
  **/
  @ApiModelProperty(example = "00006836", value = "Stand Number")
  public String getStandNo() {
    return standNo;
  }

  public void setStandNo(String standNo) {
    this.standNo = standNo;
  }

  public LandParcelProperties portionNo(String portionNo) {
    this.portionNo = portionNo;
    return this;
  }

   /**
   * Portion Number
   * @return portionNo
  **/
  @ApiModelProperty(example = "00000", value = "Portion Number")
  public String getPortionNo() {
    return portionNo;
  }

  public void setPortionNo(String portionNo) {
    this.portionNo = portionNo;
  }

  public LandParcelProperties lisKey(String lisKey) {
    this.lisKey = lisKey;
    return this;
  }

   /**
   * LIS Key
   * @return lisKey
  **/
  @ApiModelProperty(example = "C05500100000683600000", value = "LIS Key")
  public String getLisKey() {
    return lisKey;
  }

  public void setLisKey(String lisKey) {
    this.lisKey = lisKey;
  }

  public LandParcelProperties suburb(String suburb) {
    this.suburb = suburb;
    return this;
  }

   /**
   * Suburb the erf belongs to
   * @return suburb
  **/
  @ApiModelProperty(example = "NUWE UITSIG", value = "Suburb the erf belongs to")
  public String getSuburb() {
    return suburb;
  }

  public void setSuburb(String suburb) {
    this.suburb = suburb;
  }

  public LandParcelProperties city(String city) {
    this.city = city;
    return this;
  }

   /**
   * Town/City the erf belongs to
   * @return city
  **/
  @ApiModelProperty(example = "WELLINGTON", value = "Town/City the erf belongs to")
  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  public LandParcelProperties postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal Code the erf belongs to
   * @return postalCode
  **/
  @ApiModelProperty(example = "7655", value = "Postal Code the erf belongs to")
  public String getPostalCode() {
    return postalCode;
  }

  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }

  public LandParcelProperties longitude(Double longitude) {
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude - Center of Parcel
   * @return longitude
  **/
  @ApiModelProperty(example = "19.010855", value = "Longitude - Center of Parcel")
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public LandParcelProperties latitude(Double latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude - Center of Parcel
   * @return latitude
  **/
  @ApiModelProperty(example = "-33.654131", value = "Latitude - Center of Parcel")
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public LandParcelProperties lifeCycle(LifeCycleEnum lifeCycle) {
    this.lifeCycle = lifeCycle;
    return this;
  }

   /**
   * Life Cycle
   * @return lifeCycle
  **/
  @ApiModelProperty(example = "REGISTERED", value = "Life Cycle")
  public LifeCycleEnum getLifeCycle() {
    return lifeCycle;
  }

  public void setLifeCycle(LifeCycleEnum lifeCycle) {
    this.lifeCycle = lifeCycle;
  }

  public LandParcelProperties noOfDeedsRecords(Long noOfDeedsRecords) {
    this.noOfDeedsRecords = noOfDeedsRecords;
    return this;
  }

   /**
   * Number of Deeds records linked to this parcel
   * @return noOfDeedsRecords
  **/
  @ApiModelProperty(example = "1", value = "Number of Deeds records linked to this parcel")
  public Long getNoOfDeedsRecords() {
    return noOfDeedsRecords;
  }

  public void setNoOfDeedsRecords(Long noOfDeedsRecords) {
    this.noOfDeedsRecords = noOfDeedsRecords;
  }

  public LandParcelProperties bbox(BoundingBox bbox) {
    this.bbox = bbox;
    return this;
  }

   /**
   * The Bounding Box/Area of the individual feature/record
   * @return bbox
  **/
  @ApiModelProperty(value = "The Bounding Box/Area of the individual feature/record")
  public BoundingBox getBbox() {
    return bbox;
  }

  public void setBbox(BoundingBox bbox) {
    this.bbox = bbox;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LandParcelProperties landParcelProperties = (LandParcelProperties) o;
    return Objects.equals(this.ervenId, landParcelProperties.ervenId) &&
        Objects.equals(this.sourceName, landParcelProperties.sourceName) &&
        Objects.equals(this.sourceKey, landParcelProperties.sourceKey) &&
        Objects.equals(this.feaLayer, landParcelProperties.feaLayer) &&
        Objects.equals(this.parcelType, landParcelProperties.parcelType) &&
        Objects.equals(this.feaLabel, landParcelProperties.feaLabel) &&
        Objects.equals(this.allotmentNo, landParcelProperties.allotmentNo) &&
        Objects.equals(this.standNo, landParcelProperties.standNo) &&
        Objects.equals(this.portionNo, landParcelProperties.portionNo) &&
        Objects.equals(this.lisKey, landParcelProperties.lisKey) &&
        Objects.equals(this.suburb, landParcelProperties.suburb) &&
        Objects.equals(this.city, landParcelProperties.city) &&
        Objects.equals(this.postalCode, landParcelProperties.postalCode) &&
        Objects.equals(this.longitude, landParcelProperties.longitude) &&
        Objects.equals(this.latitude, landParcelProperties.latitude) &&
        Objects.equals(this.lifeCycle, landParcelProperties.lifeCycle) &&
        Objects.equals(this.noOfDeedsRecords, landParcelProperties.noOfDeedsRecords) &&
        Objects.equals(this.bbox, landParcelProperties.bbox);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ervenId, sourceName, sourceKey, feaLayer, parcelType, feaLabel, allotmentNo, standNo, portionNo, lisKey, suburb, city, postalCode, longitude, latitude, lifeCycle, noOfDeedsRecords, bbox);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LandParcelProperties {\n");
    
    sb.append("    ervenId: ").append(toIndentedString(ervenId)).append("\n");
    sb.append("    sourceName: ").append(toIndentedString(sourceName)).append("\n");
    sb.append("    sourceKey: ").append(toIndentedString(sourceKey)).append("\n");
    sb.append("    feaLayer: ").append(toIndentedString(feaLayer)).append("\n");
    sb.append("    parcelType: ").append(toIndentedString(parcelType)).append("\n");
    sb.append("    feaLabel: ").append(toIndentedString(feaLabel)).append("\n");
    sb.append("    allotmentNo: ").append(toIndentedString(allotmentNo)).append("\n");
    sb.append("    standNo: ").append(toIndentedString(standNo)).append("\n");
    sb.append("    portionNo: ").append(toIndentedString(portionNo)).append("\n");
    sb.append("    lisKey: ").append(toIndentedString(lisKey)).append("\n");
    sb.append("    suburb: ").append(toIndentedString(suburb)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    lifeCycle: ").append(toIndentedString(lifeCycle)).append("\n");
    sb.append("    noOfDeedsRecords: ").append(toIndentedString(noOfDeedsRecords)).append("\n");
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

