/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Info regarding the selected Sort Order Index
 */
@ApiModel(description = "Info regarding the selected Sort Order Index")

public class Index {
  @SerializedName("indexId")
  private Long indexId = null;

  @SerializedName("indexCaption")
  private String indexCaption = null;

  @SerializedName("indexDescription")
  private String indexDescription = null;

  @SerializedName("indexDefault")
  private Boolean indexDefault = null;

  public Index indexId(Long indexId) {
    this.indexId = indexId;
    return this;
  }

   /**
   * Sort Order Index unique 1map id number - Primary Key
   * @return indexId
  **/
  @ApiModelProperty(value = "Sort Order Index unique 1map id number - Primary Key")
  public Long getIndexId() {
    return indexId;
  }

  public void setIndexId(Long indexId) {
    this.indexId = indexId;
  }

  public Index indexCaption(String indexCaption) {
    this.indexCaption = indexCaption;
    return this;
  }

   /**
   * Sort Order Index Caption
   * @return indexCaption
  **/
  @ApiModelProperty(value = "Sort Order Index Caption")
  public String getIndexCaption() {
    return indexCaption;
  }

  public void setIndexCaption(String indexCaption) {
    this.indexCaption = indexCaption;
  }

  public Index indexDescription(String indexDescription) {
    this.indexDescription = indexDescription;
    return this;
  }

   /**
   * Sort Order Index&#39;s description
   * @return indexDescription
  **/
  @ApiModelProperty(value = "Sort Order Index's description")
  public String getIndexDescription() {
    return indexDescription;
  }

  public void setIndexDescription(String indexDescription) {
    this.indexDescription = indexDescription;
  }

  public Index indexDefault(Boolean indexDefault) {
    this.indexDefault = indexDefault;
    return this;
  }

   /**
   * Specify whether this Sort Order Index is the default
   * @return indexDefault
  **/
  @ApiModelProperty(value = "Specify whether this Sort Order Index is the default")
  public Boolean getIndexDefault() {
    return indexDefault;
  }

  public void setIndexDefault(Boolean indexDefault) {
    this.indexDefault = indexDefault;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Index index = (Index) o;
    return Objects.equals(this.indexId, index.indexId) &&
        Objects.equals(this.indexCaption, index.indexCaption) &&
        Objects.equals(this.indexDescription, index.indexDescription) &&
        Objects.equals(this.indexDefault, index.indexDefault);
  }

  @Override
  public int hashCode() {
    return Objects.hash(indexId, indexCaption, indexDescription, indexDefault);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Index {\n");
    
    sb.append("    indexId: ").append(toIndentedString(indexId)).append("\n");
    sb.append("    indexCaption: ").append(toIndentedString(indexCaption)).append("\n");
    sb.append("    indexDescription: ").append(toIndentedString(indexDescription)).append("\n");
    sb.append("    indexDefault: ").append(toIndentedString(indexDefault)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

