/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Info regarding the selected field
 */
@ApiModel(description = "Info regarding the selected field")

public class Field {
  @SerializedName("fieldId")
  private Long fieldId = null;

  @SerializedName("fieldName")
  private String fieldName = null;

  @SerializedName("fieldCaption")
  private String fieldCaption = null;

  @SerializedName("fieldDescription")
  private String fieldDescription = null;

  @SerializedName("fieldOrder")
  private Integer fieldOrder = null;

  /**
   * Field Type
   */
  @JsonAdapter(FieldTypeEnum.Adapter.class)
  public enum FieldTypeEnum {
    BARCODE("barcode"),
    
    BOOLEAN("boolean"),
    
    BPCHAR("bpchar"),
    
    BYTEA("bytea"),
    
    COLOR("color"),
    
    DATE("date"),
    
    DEVICE_ID("device_id"),
    
    DOUBLE("double"),
    
    GML_GEOMETRYPROPERTYTYPE("gml:GeometryPropertyType"),
    
    GPS_LAT("gps_lat"),
    
    GPS_LON("gps_lon"),
    
    GPS_PREC("gps_prec"),
    
    INT2("int2"),
    
    LONG("long"),
    
    MONEY("money"),
    
    PHOTO("photo"),
    
    STRING("string"),
    
    TEXT("text"),
    
    TIMESTAMP("timestamp"),
    
    TIMESTAMPTZ("timestamptz"),
    
    TSVECTOR("tsvector"),
    
    USER_EMAIL("user_email");

    private String value;

    FieldTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static FieldTypeEnum fromValue(String text) {
      for (FieldTypeEnum b : FieldTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<FieldTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final FieldTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public FieldTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return FieldTypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("fieldType")
  private FieldTypeEnum fieldType = null;

  @SerializedName("fieldSize")
  private Integer fieldSize = null;

  @SerializedName("fieldDecimals")
  private Integer fieldDecimals = null;

  @SerializedName("visible")
  private Boolean visible = null;

  @SerializedName("searchable")
  private Boolean searchable = null;

  @SerializedName("editable")
  private Boolean editable = null;

  @SerializedName("exportable")
  private Boolean exportable = null;

  @SerializedName("minOccurs")
  private Integer minOccurs = null;

  @SerializedName("maxOccurs")
  private Integer maxOccurs = null;

  @SerializedName("nillable")
  private Boolean nillable = null;

  public Field fieldId(Long fieldId) {
    this.fieldId = fieldId;
    return this;
  }

   /**
   * Field unique 1map id number - Primary Key
   * @return fieldId
  **/
  @ApiModelProperty(value = "Field unique 1map id number - Primary Key")
  public Long getFieldId() {
    return fieldId;
  }

  public void setFieldId(Long fieldId) {
    this.fieldId = fieldId;
  }

  public Field fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

   /**
   * Field Name
   * @return fieldName
  **/
  @ApiModelProperty(value = "Field Name")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  public Field fieldCaption(String fieldCaption) {
    this.fieldCaption = fieldCaption;
    return this;
  }

   /**
   * Field Caption
   * @return fieldCaption
  **/
  @ApiModelProperty(value = "Field Caption")
  public String getFieldCaption() {
    return fieldCaption;
  }

  public void setFieldCaption(String fieldCaption) {
    this.fieldCaption = fieldCaption;
  }

  public Field fieldDescription(String fieldDescription) {
    this.fieldDescription = fieldDescription;
    return this;
  }

   /**
   * Field description
   * @return fieldDescription
  **/
  @ApiModelProperty(value = "Field description")
  public String getFieldDescription() {
    return fieldDescription;
  }

  public void setFieldDescription(String fieldDescription) {
    this.fieldDescription = fieldDescription;
  }

  public Field fieldOrder(Integer fieldOrder) {
    this.fieldOrder = fieldOrder;
    return this;
  }

   /**
   * Field display order
   * @return fieldOrder
  **/
  @ApiModelProperty(value = "Field display order")
  public Integer getFieldOrder() {
    return fieldOrder;
  }

  public void setFieldOrder(Integer fieldOrder) {
    this.fieldOrder = fieldOrder;
  }

  public Field fieldType(FieldTypeEnum fieldType) {
    this.fieldType = fieldType;
    return this;
  }

   /**
   * Field Type
   * @return fieldType
  **/
  @ApiModelProperty(value = "Field Type")
  public FieldTypeEnum getFieldType() {
    return fieldType;
  }

  public void setFieldType(FieldTypeEnum fieldType) {
    this.fieldType = fieldType;
  }

  public Field fieldSize(Integer fieldSize) {
    this.fieldSize = fieldSize;
    return this;
  }

   /**
   * Field Size (0 &#x3D; Unlimited)
   * @return fieldSize
  **/
  @ApiModelProperty(value = "Field Size (0 = Unlimited)")
  public Integer getFieldSize() {
    return fieldSize;
  }

  public void setFieldSize(Integer fieldSize) {
    this.fieldSize = fieldSize;
  }

  public Field fieldDecimals(Integer fieldDecimals) {
    this.fieldDecimals = fieldDecimals;
    return this;
  }

   /**
   * Field Decimals (Only applicable for double, money, etc)
   * @return fieldDecimals
  **/
  @ApiModelProperty(value = "Field Decimals (Only applicable for double, money, etc)")
  public Integer getFieldDecimals() {
    return fieldDecimals;
  }

  public void setFieldDecimals(Integer fieldDecimals) {
    this.fieldDecimals = fieldDecimals;
  }

  public Field visible(Boolean visible) {
    this.visible = visible;
    return this;
  }

   /**
   * Is this field visible
   * @return visible
  **/
  @ApiModelProperty(value = "Is this field visible")
  public Boolean getVisible() {
    return visible;
  }

  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  public Field searchable(Boolean searchable) {
    this.searchable = searchable;
    return this;
  }

   /**
   * Can this field be used for searches
   * @return searchable
  **/
  @ApiModelProperty(value = "Can this field be used for searches")
  public Boolean getSearchable() {
    return searchable;
  }

  public void setSearchable(Boolean searchable) {
    this.searchable = searchable;
  }

  public Field editable(Boolean editable) {
    this.editable = editable;
    return this;
  }

   /**
   * Is this field value editable
   * @return editable
  **/
  @ApiModelProperty(value = "Is this field value editable")
  public Boolean getEditable() {
    return editable;
  }

  public void setEditable(Boolean editable) {
    this.editable = editable;
  }

  public Field exportable(Boolean exportable) {
    this.exportable = exportable;
    return this;
  }

   /**
   * Is this field exportable
   * @return exportable
  **/
  @ApiModelProperty(value = "Is this field exportable")
  public Boolean getExportable() {
    return exportable;
  }

  public void setExportable(Boolean exportable) {
    this.exportable = exportable;
  }

  public Field minOccurs(Integer minOccurs) {
    this.minOccurs = minOccurs;
    return this;
  }

   /**
   * 
   * @return minOccurs
  **/
  @ApiModelProperty(value = "")
  public Integer getMinOccurs() {
    return minOccurs;
  }

  public void setMinOccurs(Integer minOccurs) {
    this.minOccurs = minOccurs;
  }

  public Field maxOccurs(Integer maxOccurs) {
    this.maxOccurs = maxOccurs;
    return this;
  }

   /**
   * 
   * @return maxOccurs
  **/
  @ApiModelProperty(value = "")
  public Integer getMaxOccurs() {
    return maxOccurs;
  }

  public void setMaxOccurs(Integer maxOccurs) {
    this.maxOccurs = maxOccurs;
  }

  public Field nillable(Boolean nillable) {
    this.nillable = nillable;
    return this;
  }

   /**
   * true &#x3D; Can contain blank, false &#x3D; Cannot contain blank (required)
   * @return nillable
  **/
  @ApiModelProperty(value = "true = Can contain blank, false = Cannot contain blank (required)")
  public Boolean getNillable() {
    return nillable;
  }

  public void setNillable(Boolean nillable) {
    this.nillable = nillable;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Field field = (Field) o;
    return Objects.equals(this.fieldId, field.fieldId) &&
        Objects.equals(this.fieldName, field.fieldName) &&
        Objects.equals(this.fieldCaption, field.fieldCaption) &&
        Objects.equals(this.fieldDescription, field.fieldDescription) &&
        Objects.equals(this.fieldOrder, field.fieldOrder) &&
        Objects.equals(this.fieldType, field.fieldType) &&
        Objects.equals(this.fieldSize, field.fieldSize) &&
        Objects.equals(this.fieldDecimals, field.fieldDecimals) &&
        Objects.equals(this.visible, field.visible) &&
        Objects.equals(this.searchable, field.searchable) &&
        Objects.equals(this.editable, field.editable) &&
        Objects.equals(this.exportable, field.exportable) &&
        Objects.equals(this.minOccurs, field.minOccurs) &&
        Objects.equals(this.maxOccurs, field.maxOccurs) &&
        Objects.equals(this.nillable, field.nillable);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldId, fieldName, fieldCaption, fieldDescription, fieldOrder, fieldType, fieldSize, fieldDecimals, visible, searchable, editable, exportable, minOccurs, maxOccurs, nillable);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Field {\n");
    
    sb.append("    fieldId: ").append(toIndentedString(fieldId)).append("\n");
    sb.append("    fieldName: ").append(toIndentedString(fieldName)).append("\n");
    sb.append("    fieldCaption: ").append(toIndentedString(fieldCaption)).append("\n");
    sb.append("    fieldDescription: ").append(toIndentedString(fieldDescription)).append("\n");
    sb.append("    fieldOrder: ").append(toIndentedString(fieldOrder)).append("\n");
    sb.append("    fieldType: ").append(toIndentedString(fieldType)).append("\n");
    sb.append("    fieldSize: ").append(toIndentedString(fieldSize)).append("\n");
    sb.append("    fieldDecimals: ").append(toIndentedString(fieldDecimals)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("    searchable: ").append(toIndentedString(searchable)).append("\n");
    sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
    sb.append("    exportable: ").append(toIndentedString(exportable)).append("\n");
    sb.append("    minOccurs: ").append(toIndentedString(minOccurs)).append("\n");
    sb.append("    maxOccurs: ").append(toIndentedString(maxOccurs)).append("\n");
    sb.append("    nillable: ").append(toIndentedString(nillable)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

