/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;

import com.github.filosganga.geogson.gson.GeometryAdapterFactory;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.AttachmentsCollection;
import io.swagger.client.model.FeatureWithoutAttachmentsProperties;
import com.github.filosganga.geogson.model.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * FeatureWithAttachments
 */

public class FeatureWithAttachments {
  /**
   * Always Feature
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    FEATURE("Feature");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("id")
  private String id = null;

  @SerializedName("geometry")
  private Geometry geometry = null;

  @SerializedName("geometryName")
  private String geometryName = null;

  @SerializedName("properties")
  private FeatureWithoutAttachmentsProperties properties = null;

  @SerializedName("attachments")
  private List<AttachmentsCollection> attachments = null;

  public FeatureWithAttachments type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Always Feature
   * @return type
  **/
  @ApiModelProperty(example = "Feature", value = "Always Feature")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public FeatureWithAttachments id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Feature unique id - Not used when adding new feature
   * @return id
  **/
  @ApiModelProperty(example = "quidity:Erven.7489666", value = "Feature unique id - Not used when adding new feature")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public FeatureWithAttachments geometry(Geometry geometry) {
    this.geometry = geometry;
    return this;
  }

   /**
   * The geometry
   * @return geometry
  **/
  @ApiModelProperty(value = "The geometry")
  public Geometry getGeometry() {
    return geometry;
  }

  public void setGeometry(Geometry geometry) {
    this.geometry = geometry;
  }

  public FeatureWithAttachments geometryName(String geometryName) {
    this.geometryName = geometryName;
    return this;
  }

   /**
   * The field name of the geometry
   * @return geometryName
  **/
  @ApiModelProperty(example = "the_geom", value = "The field name of the geometry")
  public String getGeometryName() {
    return geometryName;
  }

  public void setGeometryName(String geometryName) {
    this.geometryName = geometryName;
  }

  public FeatureWithAttachments properties(FeatureWithoutAttachmentsProperties properties) {
    this.properties = properties;
    return this;
  }

   /**
   * Get properties
   * @return properties
  **/
  @ApiModelProperty(value = "")
  public FeatureWithoutAttachmentsProperties getProperties() {
    return properties;
  }

  public void setProperties(FeatureWithoutAttachmentsProperties properties) {
    this.properties = properties;
  }

  public FeatureWithAttachments attachments(List<AttachmentsCollection> attachments) {
    this.attachments = attachments;
    return this;
  }

  public FeatureWithAttachments addAttachmentsItem(AttachmentsCollection attachmentsItem) {
    if (this.attachments == null) {
      this.attachments = new ArrayList<AttachmentsCollection>();
    }
    this.attachments.add(attachmentsItem);
    return this;
  }

   /**
   * Get attachments
   * @return attachments
  **/
  @ApiModelProperty(value = "")
  public List<AttachmentsCollection> getAttachments() {
    return attachments;
  }

  public void setAttachments(List<AttachmentsCollection> attachments) {
    this.attachments = attachments;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FeatureWithAttachments featureWithAttachments = (FeatureWithAttachments) o;
    return Objects.equals(this.type, featureWithAttachments.type) &&
        Objects.equals(this.id, featureWithAttachments.id) &&
        Objects.equals(this.geometry, featureWithAttachments.geometry) &&
        Objects.equals(this.geometryName, featureWithAttachments.geometryName) &&
        Objects.equals(this.properties, featureWithAttachments.properties) &&
        Objects.equals(this.attachments, featureWithAttachments.attachments);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, id, geometry, geometryName, properties, attachments);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FeatureWithAttachments {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    geometry: ").append(toIndentedString(geometry)).append("\n");
    sb.append("    geometryName: ").append(toIndentedString(geometryName)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    attachments: ").append(toIndentedString(attachments)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

